FUNCTION edi_decompress, comp_data
; CLUSTER II IDL Function
;
; Abstract: inflate compressed EDI data
;
; Created by: Mark Chutter, UNH
; July  1, 1999
;
; Modified:
; Nov. 19, 1999 MWC Updated documentation
; Apr. 11, 2003 MWC changed x to xu
;
; Calling Interface:
; comp_data   int (i) the compressed data
; decomp_data int (i/o) the decompressed data
;
; Return Value:
; decomp_value - the decompressed value
;
; Affected Variables:
;
; Description:
; edi_decompress inflates compressed EDI data from BCI32 data and
; BM1 Pacmo 0 channels 2 and 3.

decomp_data = 0L

IF (comp_data LT '40'xu) THEN decomp_data = comp_data $
ELSE IF ((comp_data GT '40'xu) AND (comp_data LT '60'xu)) THEN $
  decomp_data = '40'xu + ((comp_data - '40'xu) * '2'xu) $
ELSE IF ((comp_data GT '60'xu) AND (comp_data LT '80'xu)) THEN $
  decomp_data = '80'xu + ((comp_data - '60'xu) * '4'xu) $
ELSE IF ((comp_data GT '80'xu) AND (comp_data LT 'A0'xu)) THEN $
  decomp_data = '100'xu + ((comp_data - '80'xu) * '8'xu) $
ELSE IF ((comp_data GT 'A0'xu) AND (comp_data LT 'C0'xu)) THEN $
  decomp_data = '200'xu + ((comp_data - 'A0'xu) * '10'xu) $
ELSE IF ((comp_data GT 'C0'xu) AND (comp_data LT 'E0'xu)) THEN $
  decomp_data = '400'xu + ((comp_data - 'C0'xu) * '20'xu) $
ELSE IF ((comp_data GT 'E0'xu) AND (comp_data LT 'FF'xu)) THEN $
  decomp_data = '800'xu + ((comp_data - 'E0'xu) * '40'xu) $
ELSE IF (comp_data EQ 'FF'xu) THEN $
  decomp_data = '1000'xu

return, decomp_data
END

