FUNCTION bm3_fill, packet, packet_number, packet_time
; CLUSTER II IDL Function
;
; Abstract: fill an EDI bm3 data structure
;
; Created by: Mark Chutter, UNH 
; Jul. 16, 1999
;
; Modified:
; Aug.  9, 1999 MWC changed error field to status
; Oct. 19, 1999 MWC used common block for structure definitions
; June 13, 2000 MWC added lonarr for memory addresses; removed shdr
;                   which is not meaningful in mem dump
; Sep. 25, 2000 MWC added check to make sure packet was big enough to
;                   be BM3 because Hiroshi and I found a bogus packet
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; July 16, 2001 MWC added check of status from edi_header_fill; it used
;                   to be true that the status from the EDI header was
;                   always 1
; Jan. 14, 2002 MWC added sc_pick_amb_geos_struct
; July  8, 2002 MWC removed 5 from valid science mode check
; Feb. 24, 2003 MWC added dmp_table and ms_bci
;
; Calling Interface:
; packet        bytarr    (i) EDI science packet
; packet_number long      (i) EDI packet number
; packet_time   lonarr(2) (i) time of EDI packet
;
; Return Value:
; A sc_pick_ebm3_struct structure is returned.  If the status field is
; less than 1, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; bm3_fill fills a sc_pick_ebm3_struct data structure.
;This is not a user level function.

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

@pick_const

BM3_SIZE = 23188
MEM_DUMP_LOC = 72
MEM_DUMP_SIZE = 11278 ;size in words
status = 0
valid = 0

bm3 = sc_pick_ebm3_struct
bm3.status = 1

size_check = n_elements(packet)
IF size_check NE BM3_SIZE THEN BEGIN
    bm3.status = INVALID_EDI_DATA
    return, bm3
ENDIF

; fill the header
hdr = edi_header_fill(packet, packet_number, packet_time)
IF hdr.status LT 0 THEN BEGIN
    bm3.status = hdr.status
    return, bm3
ENDIF

; make sure the packet is burst mode 3
IF (hdr.sub_mode NE 7) THEN BEGIN
    bm3.status = WRONG_TM_MODE
    return, bm3
ENDIF

; check for valid science mode
IF ((hdr.science_mode NE '1'x) AND $
    (hdr.science_mode NE '2'x) AND $
;    (hdr.science_mode NE '5'x) AND $
    (hdr.science_mode NE '8'x) AND $
    (hdr.science_mode NE 'c'x) AND $
    (hdr.science_mode NE 'd'x) AND $
    (hdr.science_mode NE '11'x) AND $
    (hdr.science_mode NE '13'x)) THEN BEGIN
    bm3.status = INVALID_SCIENCE_MODE
    return, bm3
ENDIF

bm3.hdr = hdr

bm3.dmp_table = packet[14]
bm3.ms_bci = packet[18]

; this is a little screwy because they are stored as longs so swapping
; bytes while reading raw data files does not work; non memory dump
; files are word addressed
FOR i = 0, 15 DO BEGIN
    bm3.dmp_addr[i] = $
      ulong(packet[4*i+11]) * '10000'xul + $
      ulong(packet[4*i+8]) * '100'xul + $
      ulong(packet[4*i+9])
;      ulong(packet[4*i+10]) ;this contains flags
ENDFOR

FOR i = 0, MEM_DUMP_SIZE-1 DO bm3.mem_dmp[i] = $
  packet[2*i+MEM_DUMP_LOC] * '100'x + $
  packet[2*i+MEM_DUMP_LOC+1]

return, bm3
END
