FUNCTION bm1_pacmo0_fill, packet, hdr, dfgm, amb_geos, sc_id
; CLUSTER II IDL Function
;
; Abstract: fill an EDI nm1_pacmo0 data structure
;
; Created by: Mark Chutter, UNH 
; June 29, 1999
;
; Modified:
; Aug.  9, 1999 MWC changed error field to status
; Oct. 19, 1999 MWC used common block for structure definitions
;                   removed bci32_buf
; Nov. 21, 1999 MWC updated comments
; June  7, 2000 MWC the diagnostic FGM flag is copied on board as a
;                   byte so just look at the low byte; replaced FOR loops
; June 15, 2000 MWC added checks to make sure there is data before
;                   trying to fill
; July 12, 2000 MWC fixed chan2_3_cnt error message
; July 20, 2000 MWC added dfgm_range
; Aug.  3, 2000 MWC fixed byte order of long words
; Aug. 16, 2000 MWC added mem_dmp now that it might actually be used
;                   and added dfgm_addr
; Aug. 17, 2000 MWC added chan3_comp arg to bm1_pacmo0_fill; changed
;                   how channel 2 and 3 data are filled; fixed
;                   chan4_addr
; Aug. 25, 2000 MWC the compressed data should be unsigned
; Aug. 30, 2000 MWC return negative status if data counts are bad
;                   rather than just printing a waring message
; Sep. 26, 2000 MWC changed byte order of bcomp_0, and channel
;                   addresses
; Oct.  2, 2000 MWC looks like changing the byte order was not the solution
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; Jan. 14, 2002 MWC added sc_pick_amb_geos_struct
; Jan. 16, 2001 MWC added ambient GEOS
; Feb.  8, 2002 MWC energy and Bz_gz bytes were swapped; added amb
;                   GEOS time tag
; Mar. 11, 2002 MWC had the shift wrong on the perp bit in Amb Geos
; July 16, 2002 MWC phi and theta in Ambient GEOS are now floats
; Oct. 23, 2002 MWC now use dealias_ag_time_tag to get ambient GEOS times
; Oct. 24, 2002 MWC now hdr gets passed from bm1_fill
; Nov. 12, 2002 MWC check status from dealias_ag_time_tag
; Nov.  3, 2004 MWC adjusted ambient time by 1/256 second
; Dec. 17, 2004 MWC added a check for direction flips in ambient
; Feb. 22, 2005 MWC added sc_id to nm1_pacmo0_fill and added check for
;                   time when perp bit was not properly set for
;                   ambient geos
; Apr. 11, 2005 MWC The comments say I changed to using
;                   dealias_ag_time_tag, but I think that was a lie
; May  10, 2005 MWC D1 on SC3 started having a much lower response
;                   than D2 in 2005 intermittently.  If the average
;                   counts for D1 in a TMR are less than 1/5 than D2,
;                   the counts for D1 are set to a big negative
;                   number.
; May  25, 2005 MWC Rather than trying to determine intervals using
;                   the method above, Hans provided a list of
;                   intervals where dropouts occur.  The problem seems
;                   to have gone after a restart.
; Jul. 15, 2005 MWC D1 on SC2 had a strange response from June 27
;                   until July 1.  Data for this interval has been set
;                   to -999
;
; Calling Interface:
; packet        bytarr (i) EDI science packet
; chan2_comp    byte   (i) If 0, channel 2 data is not compressed
; chan3_comp    byte   (i) If 0, channel 3 data is not compressed
; dfgm          int    (i) flag to show whether mode is Diagnositc FGM
;
; Return Value:
; A sc_pick_bpacmo0_struct structure is returned.  If the status field is
; less than 1, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; bm1_pacmo0_fill fills a burst mode 1, pacmo 0 data structure.  It
; is not a user level function.

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

@pick_const

MEM_DUMP_SIZE = 143
MEM_DUMP_OFFSET = 40
CHAN2_ADDR_OFFSET = 326
CHAN3_ADDR_OFFSET = 330
CHAN2_3_TIMETAG_OFFSET = 334
CHAN2_3_CNT_OFFSET = 336
CHAN2_3_DATA_OFFSET = 338
NUMBER_CHAN4_DATA = 660
CHAN4_ADDR_OFFSET = 5616
CHAN4_TIMETAG_OFFSET = 5620
CHAN4_CNT_OFFSET = 5622
CHAN4_DATA_OFFSET = 5624
DFGM_DATA_FLAG_OFFSET = 327
DFGM_RANGE_OFFSET = 328
DFGM_TIME_TAG_OFFSET = 334
DFGM_TIME_TAG_OFFSET = 334
DFGM_CNT_OFFSET = 336
DFGM_DATA_OFFSET = 338
DFGM_DATA_SIZE = 10
AMB_GEOS_TIME_TAG_OFFSET = 334
AMB_GEOS_DATA_SIZE = 10
AMB_GEOS_CNT_OFFSET = 336
AMB_GEOS_DATA_OFFSET = 338
AMB_GEOS_RAM_OFFSET = 0
AMB_GEOS_ADDR_OFFSET = 40

chan2_comp = hdr.chan2_comp
chan3_comp = hdr.chan3_comp 
pacmo0 = sc_pick_bpacmo0_struct
pacmo0.status = 1

; If the mode is Diagnostic FGM, the data is packed differently.
IF (dfgm EQ 1) THEN BEGIN

    pacmo0.data_flag = byte(packet[DFGM_DATA_FLAG_OFFSET])
    pacmo0.dfgm_range =  fix(packet[DFGM_RANGE_OFFSET]) * '100'x + $
      fix(packet[DFGM_RANGE_OFFSET+1])
    pacmo0.dfgm_time_tag = long(packet[DFGM_TIME_TAG_OFFSET]) * '100'xL + $
      long(packet[DFGM_TIME_TAG_OFFSET+1])
    pacmo0.dfgm_count = fix(packet[DFGM_CNT_OFFSET]) * '100'x + $
      fix(packet[DFGM_CNT_OFFSET+1])

    IF pacmo0.dfgm_count GT 0 THEN BEGIN
        index = indgen(pacmo0.dfgm_count)
        offset = index * DFGM_DATA_SIZE + DFGM_DATA_OFFSET
        
        pacmo0.dfgm[index].b_z = fix(packet[offset[index]]) * '100'x + $
          fix(packet[offset[index]+1])
        pacmo0.dfgm[index].bcomp = fix(packet[offset[index]+2]) * '100'x + $
          fix(packet[offset[index]+3])
        pacmo0.dfgm[index].acc = fix(packet[offset[index]+4]) * '100'x + $
          fix(packet[offset[index]+5])
        pacmo0.dfgm[index].bcomp_0 = $
          long(packet[offset[index]+8]) * '1000000'xL + $
          long(packet[offset[index]+9]) * '10000'xL + $
          long(packet[offset[index]+6]) * '100'xL + $
          long(packet[offset[index]+7])
    ENDIF

ENDIF ELSE IF amb_geos EQ 1 THEN BEGIN 
    IF hdr.science_mode NE '15'x THEN BEGIN
        pacmo0.status = INVALID_EDI_DATA
        return, pacmo0
    ENDIF
    pacmo0.amb_geos_time_tag = $
      long(packet[AMB_GEOS_TIME_TAG_OFFSET]) * '100'xL + $
      long(packet[AMB_GEOS_TIME_TAG_OFFSET+1])

    time_tag_TMR = long(packet[8]) * '100'xL + long(packet[9])
    pacmo0.amb_geos_count = fix(packet[AMB_GEOS_CNT_OFFSET]) * '100'x + $
      fix(packet[AMB_GEOS_CNT_OFFSET+1])

    IF pacmo0.amb_geos_count GT 0 THEN BEGIN
        dealias_ag_time_tag, hdr, time_tag_TMR, pacmo0.amb_geos_time_tag, $
          btime, sc_id, status
        IF status LT 0 THEN BEGIN
            pacmo0.status = INVALID_EDI_DATA
            return, pacmo0
        ENDIF
        packet_time_d = double(btime[0]) + $
           double(btime[1]) * 1.D-6
        time_index = dindgen(pacmo0.amb_geos_count)
        index = indgen(pacmo0.amb_geos_count)
        pacmo0.amb_geos[index].time = packet_time_d + $
          (time_index * 4. - 2.) / 512.

        index = indgen(pacmo0.amb_geos_count)
        offset = index * AMB_GEOS_DATA_SIZE + AMB_GEOS_DATA_OFFSET
        pacmo0.amb_geos[index].theta = float(packet[offset[index]])*0.703125
        pacmo0.amb_geos[index].phi = float(packet[offset[index]+1])*2.8125
        pacmo0.amb_geos[index].energy = fix(packet[offset[index]+2])
        pacmo0.amb_geos[index].bz_gz = fix(packet[offset[index]+3] AND '01'x)
        pacmo0.amb_geos[index].b_perp = $
          ishft(fix(packet[offset[index]+3] AND '02'x), -1)
;a flag bit in TM was used for 2 functions from Oct. 2004 to
;Feb. 2005 in "perp" orbits.  The following if statements set the perp
;bit for this time range:
        IF (hdr.packet_time[0] GE 1098620891L AND $
            hdr.packet_time[0] LT 1098826151L) OR $
           (hdr.packet_time[0] GE 1099853650L AND $
            hdr.packet_time[0] LT 1100058850L) OR $
           (hdr.packet_time[0] GE 1100469910L AND $
            hdr.packet_time[0] LT 1100674990L) OR $
           (hdr.packet_time[0] GE 1100880850L AND $
            hdr.packet_time[0] LT 1101086110L) OR $
           (hdr.packet_time[0] GE 1101497230L AND $
            hdr.packet_time[0] LT 1101702310L) OR $
           (hdr.packet_time[0] GE 1102113490L AND $
            hdr.packet_time[0] LT 1102318690L) OR $
           (hdr.packet_time[0] GE 1102729810L AND $
            hdr.packet_time[0] LT 1102934830L) OR $
           (hdr.packet_time[0] GE 1103346190L AND $
            hdr.packet_time[0] LT 1103551450L) OR $
           (hdr.packet_time[0] GE 1103962510L AND $
            hdr.packet_time[0] LT 1104167590L) OR $
           (hdr.packet_time[0] GE 1104578890L AND $
            hdr.packet_time[0] LT 1104784090L) OR $
           (hdr.packet_time[0] GE 1105195210L AND $
            hdr.packet_time[0] LT 1105400290L) OR $
           (hdr.packet_time[0] GE 1105811830L AND $
            hdr.packet_time[0] LT 1106017030L) OR $
           (hdr.packet_time[0] GE 1106428150L AND $
            hdr.packet_time[0] LT 1106633350L) OR $
           (hdr.packet_time[0] GE 1107044710L AND $
            hdr.packet_time[0] LT 1107249960L) OR $
           (hdr.packet_time[0] GE 1107661150L AND $
            hdr.packet_time[0] LT 1107866350L) OR $
           (hdr.packet_time[0] GE 1108277950L AND $
            hdr.packet_time[0] LT 1108483090L) THEN $
          pacmo0.amb_geos[index].b_perp = 1

        pacmo0.amb_geos[index].flip = $
          ishft(fix(packet[offset[index]+3] AND '08'x), -3)
        pacmo0.amb_geos[index].zperp = fix(packet[offset[index]+4])
        pacmo0.amb_geos[index].yperp = fix(packet[offset[index]+5])
        pacmo0.amb_geos[index].data29_1 = $
          fix(packet[offset[index]+6]) * '100'x + $
          fix(packet[offset[index]+7])
        pacmo0.amb_geos[index].data29_2 = $
          fix(packet[offset[index]+8]) * '100'x + $
          fix(packet[offset[index]+9])

;On SC3 detector 1 started having a much lower response than detector
;2 on startup in 2005.
;start of dropout period   duration    comments
;-----------------------   --------    ---------------------------
;2005-03-23 17:00          36 min      starts at startup from quiescent
;2005-04-14 13:15          19 hrs      no cmds associated
;2005-04-19 14:50          10 min      starts at startup from standby
;2005-04-21 23:55          29 hrs      starts at startup from standby
;2005-04-26 13:30           7 hrs      ends at startup from standby
;2005-04-29 02:45          19 hrs      ends somewhere in WW
;2005-05-01 13:50          28 hrs      ends somewhere in WW
;2005-05-03 09:40         ~34 hrs      ends somewhere in WW
;2005-05-05 14:00          18.5 hrs    ends at startup form standby
;response of D2, the counts will be set to -999

        IF sc_id EQ 3 AND $
          (hdr.packet_time[0] GE 1111597200L AND $
           hdr.packet_time[0] LT 1111599360L) OR $
          (hdr.packet_time[0] GE 1113484500L AND $
           hdr.packet_time[0] LT 1113552900L) OR $
          (hdr.packet_time[0] GE 1113922200L AND $
           hdr.packet_time[0] LT 1113922800L) OR $
          (hdr.packet_time[0] GE 1114127700L AND $
           hdr.packet_time[0] LT 1114232100L) OR $
          (hdr.packet_time[0] GE 1114522200L AND $
           hdr.packet_time[0] LT 1114547400L) OR $
          (hdr.packet_time[0] GE 1114742700L AND $
           hdr.packet_time[0] LT 1114811100L) OR $
          (hdr.packet_time[0] GE 1114955400L AND $
           hdr.packet_time[0] LT 1115056200L) OR $
          (hdr.packet_time[0] GE 1115113200L AND $
           hdr.packet_time[0] LT 1115235600L) OR $
          (hdr.packet_time[0] GE 1115301600L AND $
           hdr.packet_time[0] LT 1115368200L) THEN $
          pacmo0.amb_geos[index].data29_1 = -999

;SC2 had a strange behavior from June 27, 2005 @17:00 to July 1, 2005
;@ 4:00.  Counts for D1 will be set to -999
        IF sc_id EQ 2 AND $
          (hdr.packet_time[0] GE 1119891600L AND $
           hdr.packet_time[0] LT 1120190400L) THEN $
          pacmo0.amb_geos[index].data29_1 = -999

    ENDIF
;    index = indgen(4)
;    offset = index * 2 + AMB_GEOS_RAM_OFFSET
;    pacmo0.RAM_init[index] = uint(packet[offset[index]]) * '100'x + $
;      uint(packet[offset[index]+1])
    index = indgen(8)
    offset = index * 4 + AMB_GEOS_ADDR_OFFSET
    pacmo0.addresses[index] = ulong(packet[offset[index]+2]) * '1000000'xUL + $
      ulong(packet[offset[index]+3]) * '10000'xUL + $
      ulong(packet[offset[index]]) * '100'xUL + $
      ulong(packet[offset[index]+1])
ENDIF ELSE BEGIN 

    FOR i = 0, MEM_DUMP_SIZE-1 DO $
      pacmo0.mem_dmp[i] = fix(packet[MEM_DUMP_OFFSET]) + $
      fix(packet[MEM_DUMP_OFFSET+1])

    pacmo0.chan2_addr = $
      long(packet[CHAN2_ADDR_OFFSET+2]) * '1000000'xL + $
      long(packet[CHAN2_ADDR_OFFSET+3]) * '10000'xL + $
      long(packet[CHAN2_ADDR_OFFSET]) * '100'xL + $
      long(packet[CHAN2_ADDR_OFFSET+1])
    pacmo0.chan3_addr = $
      long(packet[CHAN3_ADDR_OFFSET+2]) * '1000000'xL + $
      long(packet[CHAN3_ADDR_OFFSET+3]) * '10000'xL + $
      long(packet[CHAN3_ADDR_OFFSET]) * '100'xL + $
      long(packet[CHAN3_ADDR_OFFSET+1])
    pacmo0.chan2_3_timetag = $
      long(packet[CHAN2_3_TIMETAG_OFFSET]) * '100'xL + $
      long(packet[CHAN2_3_TIMETAG_OFFSET+1])
    pacmo0.chan2_3_cnt = long(packet[CHAN2_3_CNT_OFFSET]) * '100'xL + $
      long(packet[CHAN2_3_CNT_OFFSET+1])
    
    IF ((pacmo0.chan2_3_cnt GT 2639) OR (pacmo0.chan2_3_cnt LT 0)) THEN BEGIN
        pacmo0.status = INVALID_EDI_DATA
        return, pacmo0
    ENDIF
    
    IF pacmo0.chan2_3_cnt GT 0 THEN BEGIN
;store chan 2 and 3 data into all of these structures even if they aren't used
;this still has not been tested
        index = indgen(pacmo0.chan2_3_cnt)
        offset = CHAN2_3_DATA_OFFSET+2*index
        pacmo0.chan2_data[index] = fix(packet[offset[index]])
        pacmo0.chan2_comp_data = uint(packet[offset[index]])
        pacmo0.chan3_data[index] = fix(packet[offset[index]+1])
        pacmo0.chan3_comp_data = uint(packet[offset[index]+1])
        pacmo0.chan2_3_data[index] = pacmo0.chan2_data[index] * '100'x + $
          pacmo0.chan3_data[index]
    ENDIF
    IF (chan2_comp GT 0) THEN BEGIN
        decomp_data = new_decompress(pacmo0.chan2_comp_data)
        pacmo0.chan2_decomp_data = decomp_data
    ENDIF

    IF (chan3_comp GT 0) THEN BEGIN
        decomp_data = new_decompress(pacmo0.chan3_comp_data)
        pacmo0.chan3_decomp_data = decomp_data
    ENDIF

    pacmo0.chan4_addr = $
      long(packet[CHAN4_ADDR_OFFSET+2]) * '1000000'xL + $
      long(packet[CHAN4_ADDR_OFFSET+3]) * '10000'xL + $
      long(packet[CHAN4_ADDR_OFFSET]) * '100'xL + $
      long(packet[CHAN4_ADDR_OFFSET+1])
    pacmo0.chan4_timetag = $
      fix(packet[CHAN4_TIMETAG_OFFSET]) * '100'x + $
      fix(packet[CHAN4_TIMETAG_OFFSET+1])
    pacmo0.chan4_cnt = $
      fix(packet[CHAN4_CNT_OFFSET]) * '100'x + $
      fix(packet[CHAN4_CNT_OFFSET+1])
    
    IF ((pacmo0.chan4_cnt GT NUMBER_CHAN4_DATA) OR $
        (pacmo0.chan4_cnt LT 0)) THEN BEGIN
        pacmo0.status = INVALID_EDI_DATA
        return, pacmo0
    ENDIF
    
    IF pacmo0.chan4_cnt GT 0 THEN BEGIN
        index = indgen(pacmo0.chan4_cnt)
        offset = CHAN4_DATA_OFFSET+2*index
        pacmo0.chan4_data[index] = fix(packet[offset[index]]) * '100'x + $
          fix(packet[offset[index]+1])
    ENDIF

ENDELSE

return, pacmo0
END


