; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; $Id: readfgmcalfile.pro,v 1.2 2004/03/11 11:51:51 hav Exp $
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

@myfread.pro

; ============================================================================
  FUNCTION ReadFgmCalFile, sc, ymd
; ============================================================================
; Read data for sensor S01 from daily calibration file and returns
; the offsets and matrix coefficients for FGM ranges 2,3,4,5
; ****************************************************************************

@paths.inc

  ; make file name and read file
  ; ----------------------------
  fn = 'C' + strtrim(sc,2) + '_' + ymd + '_V*.fgmcal'

  filename = findfile(FGM_CAL_DIR+fn, count=cnt)

  if cnt eq 0 then begin
     message, 'Could not find calibration file ' + fn, /cont
     retall
  endif else if cnt gt 1 then begin
     print, 'Found several files. Using last: ' + filename[cnt-1]
  endif

  lines = myfread(filename[cnt-1], '', '')
  N_LINES=n_elements(lines)


  ; set up return structure
  ; -----------------------
  rng_t = { mtx:fltarr(3,3), offs:fltarr(3) }
  ret = replicate(rng_t, 4) ; 0-3 corresponds to ranges 2,3,4,5

  ; now parse the file and extract the data
  ; ---------------------------------------
  s1_cnt = 0
  for i=0L,N_LINES-1 do begin

     split = strsplit(lines[i], /extract)

     case split[n_elements(split)-1] of
        'S1_01' : ret.offs[0] = float(split[0:3])
        'S1_02' : ret.offs[1] = float(split[0:3])
        'S1_03' : ret.offs[2] = float(split[0:3])

        'S1_11' : ret.mtx[0,0] = float(split[0:3])
        'S1_12' : ret.mtx[0,1] = float(split[0:3])
        'S1_13' : ret.mtx[0,2] = float(split[0:3])
        'S1_21' : ret.mtx[1,0] = float(split[0:3])
        'S1_22' : ret.mtx[1,1] = float(split[0:3])
        'S1_23' : ret.mtx[1,2] = float(split[0:3])
        'S1_31' : ret.mtx[2,0] = float(split[0:3])
        'S1_32' : ret.mtx[2,1] = float(split[0:3])
        'S1_33' : ret.mtx[2,2] = float(split[0:3])
        else    : begin
           ; do nothing
           s1_cnt = s1_cnt - 1
        end
     endcase

     s1_cnt = s1_cnt + 1

  endfor

  if s1_cnt ne 12 then begin
     message, '12 elements expected. Found ' + strtrim(s1_cnt,2), /cont
     retall
  endif

  return, ret

END
