pro whatech, data1,erg,nmchip,base, rmax,yestof

common ep_envar_con_cb

;This routine uses a set of beam measurements to compute an upper limit, rmax, 
;for the drift step and to decide what technique should be applied in order to
;compute a drift vector and a gyrotime from this set.
;This decision is transmitted with the parameter yestof:
;yestof = 1	triangulation plus ToF analysis
;yestof = 0	pure triangulation 
;yestof =10	pure triangulation with single runners only
;yestof =-1	reject the set of measurements
;Input parameters:
;data1(0,k) = gun ID (1 or 2) for beam k
;data1(1,k) = quality of beam k, as determined by on-board software
;data1(2,k) = gun X position for beam k
;data1(3,k) = gun Y position for beam k
;data1(4,k) = firing angle of beam k
;data1(5,k) = time of flight of beam k
;data1(6,k) = order of beam k (single runner or double, triple, ...)
;erg = beam energy in keV (the same for all beams)
;nmchip = product n*m for chip length (the same for all beams)
;base = spacecraft diameter in meters
;This routine changes data1(1,*). Its output values are as follows:
;data1(1,k) = 0.    if beam k shall be used for triangulation and ToF analysis
;data1(1,k) = 1.    if beam k shall only be used for triangulation
;                                                        T. M. Bauer 16-08-2000

mm = n_elements(data1(0,*))
qual=fix(reform(data1(1,*)))
qual = 0. * (qual ge 2) + 1. * (qual lt 2)
data1(1,*) = qual
xg=reform(data1(2,*))
yg=reform(data1(3,*))

;pp_control  alpha=reform(data1(4,*))*!pi/180
alpha=reform(data1(4,*))*pp_deg2rad

tof=reform(data1(5,*))
beamord=fix(reform(data1(6,*)))

;pp_control  vb = sqrt(erg*2*1e3*1.60219e-19/9.10953e-31) * 1e-6
vb = sqrt(erg*2*1e3*pp_eV2joule/pp_emass_mks) * 1e-6

;The error of the beam firing angle is assumed to be 1 degree:
;Now controlled by the pp_control.pro include file

;pp_control  acfir= 1.*!pi/180
acfir= pp_acfir_rad

;The triangulation point of a pair of beams has a relative error in distance 
;of 1/3 (1/9) if the angle between both beams equals 4.2 (13.) times acfir.
;Triangulation is considered as well bahaved if there is at least one beam pair
;with an angle difference exceeding 4.2*acfir and the average angle difference 
;exceeds 2.1*acfir.
;The error of a ToF is assumed to be the chip length divided by 8:

;pp_control  actof= nmchip*2.^(-23)/8.d0*1e6
actof= nmchip*2.^(-23)/pp_actof_con*1e6

;Thus a ToF difference has the error sqrt(2)*actof.
;ToF analysis is considered as well behaved if the average ToF difference of
;valid beam pairs exceeds sqrt(2)*actof.
;In the regime where both triangulation and ToF analysis are well behaved
;a pure triangulation is preferred if the average angle difference of beam
;pairs exceeds 6.5*acfir.

sumqual= intarr(mm,mm)
diftof = fltarr(mm,mm)
difalp = fltarr(mm,mm)
tribas = fltarr(mm,mm)
for im = 0, mm-1 do begin
	sumqual(*,im)= qual + qual(im)
	diftof(*,im) = abs (tof - tof(im))
	difalp(*,im) = abs (alpha - alpha(im))
	tribas(*,im) = abs((xg-xg(im))*sin(alpha) - (yg-yg(im))*cos(alpha))
  ;tribas(j,k) is the baseline (perpendicular to beam j) of beam pair j,k.
endfor
difalp = difalp*(difalp lt !pi)+(2*!pi-difalp)*(difalp ge !pi)
tofpair = where(difalp gt !pi/2 and sumqual eq 0)
if tofpair(0) ne -1 then begin
  ntofpair = n_elements(tofpair)

;pp_control    goodtof = total(diftof(tofpair))/ntofpair gt 1.41421*actof
  goodtof = total(diftof(tofpair))/ntofpair gt pp_tof_tdiff_thresh*actof

endif else begin
  goodtof = 0b
endelse
difalp = difalp*(difalp lt !pi/2)+(!pi-difalp)*(difalp ge !pi/2)

;pp_control  tripair = where(difalp gt 4.2*acfir)
tripair = where(difalp gt pp_tri_ang_thresh_1)

;pp_control  goodtri = total(difalp)/mm/(mm-1) gt 2.1*acfir and tripair(0) ne -1
goodtri = total(difalp)/mm/(mm-1) gt pp_tri_ang_thresh_2 and tripair(0) ne -1

;pp_control  goodtri2= total(difalp)/mm/(mm-1) gt 6.5*acfir
goodtri2= total(difalp)/mm/(mm-1) gt pp_tri_ang_thresh_3

allknown = total(where(beamord eq 0)) eq -1 
rmax = base
if goodtri then begin
  tribas = tribas(tripair) / tan(difalp(tripair)+1e-4)
  ;tribas(j,k) is roughly the distance to the triangulation point of pair j,k.
  rmax = rmax + max(tribas)
endif
if goodtof then rmaxtof = vb * max(diftof(tofpair)) / 2

;pp_control  if goodtof and goodtri then wrongtof = (rmaxtof gt
;3*rmax) else wrongtof = 0b
if goodtof and goodtri then wrongtof = (rmaxtof gt pp_rmax_con*rmax) else wrongtof = 0b

if not goodtri and not goodtof then begin
  yestof = -1
  return
endif else begin
  if not goodtof then begin
    if goodtri2 then begin 
      yestof = 0
    endif else begin
      yestof = 10
    endelse
  endif else begin
    if goodtri2 and not allknown then begin 
      yestof = 0 
    endif else begin
      if wrongtof then begin
        yestof = 0
      endif else begin
        yestof = 1
        rmax = rmax > rmaxtof
      endelse
    endelse
  endelse
endelse

end
