PRO TRANSYS, x1,x2,x3,x4,x5,x6

;new call with DS as structure:
;       PRO TRANSYS,  DS, OUTSYS,  OUTFORM
;                 with DS as structure
;                      {ds_struct, vect:[0.d0,0.d0.0.d0], sys, form, rcode}
;old call:
;       PRO TRANSYS,  X,SYS,FORM,RCODE,OUTSYS,OUTFORM

;
;*
;* Revision
;* 01 Sep 1998  reset OUTSYS if output is in geodetic coordinates
;*
;

 
   type = size(x1)
    if( n_params() eq 3 ) then begin               ;new call
;	print,'transys new call sequence' 

	          if( type(2) ne 8 ) then begin           ; additional test
	                print,'transys: first parameter must be a structure'
			stop
		  endif
	; trim/upercase character-strings
		DS = x1
	       	DS.sys    = strupcase(strtrim(DS.sys,2))
	       	DS.form     = strupcase(strtrim(DS.form,2))
	       	outsys   = strupcase(strtrim(x2,2))
		outform  = strupcase(strtrim(x3,2))

     endif else if (n_params() eq 6) then begin         ;old call
;   		print,'transys old call sequence' 
		DS = {ds_struct, vect:[0.d0,0.d0,0.d0], sys:'',form:'',rcode:0}
		DS.vect    = x1
	       	DS.sys  = strupcase(strtrim(x2,2))
	       	DS.form    = strupcase(strtrim(x3,2))
		DS.rcode   = x4
		outsys     = x5
		outform    = x6		

     endif else begin
	print,'transys: no legal call sequence'
	stop
     endelse


;C Transform an arbitrary vector to any other arbitrary system

       outgeod = 0		;logical idl 0->false

;C Check for input in geodetic coordinates and, if found, convert
;C to geocentric polar
       if (DS.sys eq 'GEOD') then    geod2geo, DS

;C Check for output in geodetic coordinates and, if found, set values
;C so that TRANCART converts to geocentric and GEO2GEOD is applied.
       if (outsys eq 'GEOD') then begin
         outsys = 'GEOC'
         outgeod = 1          ;for IDL: 1->true   0->false
       endif

;C Make sure input is Cartesian, then transform to the new system. 
       mkcart, DS
       trancart, DS,outsys

;C Convert output to Polar if required        
       if (outform eq 'PO') then    mkpolar, DS

;C Convert output to geodetic if required 
       if (outgeod) then begin
            geo2geod,  DS
            outsys = 'GEOD'
       endif

;restore call sequence
    if( n_params() eq 3 ) then begin               ;new call
		x1 = DS
	       	x2 = outsys 
		x3 = outform 
     endif else if (n_params() eq 6) then begin         ;old call
		x1 = DS.vect   
	       	x2 = DS.sys  
	       	x3 = DS.form  
		x4 = DS.rcode
		x5 = outsys  
		x6 = outform    
     endif 

       return


END

