function sigma_angle, bz, gz

;This returns the angular width in the b_perp plane as a function of detector
;coordinates bz and gz. These are the normalized z components of the magnetic
;field and gun firing direction. This function is only an approximation to the exact
;form. It assumes a rectangular beam and solves for the projection of that
;rectangular shape onto the b_perp plane which is the angular width of relevance.
;The beam is assumed to vary from [1 x 1] at theta=0 to [4 x 0.5] at theta = 90
;where the coordinates are [theta width x phi width].
;C. Kletzing Feb, 2001.

theta = acos(gz)*!radeg
sigdelph = 1 - (0.5*(theta/90.))
sigdelth = (1 + (3.*theta/90.))*sin( acos(bz)*( 1-(gz/sqrt(1-bz^2)) ) )
sigma=sqrt( sigdelph^2 + sigdelth^2 )
return, sigma
end