pro poorman_tof, nmchip, erg, data1, extra, outstruc, keyplot4=keyplot4

common ep_envar_con_cb

; NOTE: ALL OF THE BEAMS HERE ARE ASSUMED TO BE SINGLE-RUNNERS!  ANY
; DIFFERENCES IN TOFS ARE ASSUMED TO BE BECAUSE OF THE TOWARD/AWAY
; DEPENDENCE AND NOT BECAUSE OF MULTI-RUNNER DEPENDENCE!!!

outstruc.status = 0

sigfir= 1.*!pi/180		;error of the beam firing direction
actof = nmchip*2.^(-23)/pp_actof_con*1e6
vb = sqrt(erg*2*1e3*pp_eV2joule/pp_emass_mks) * 1e-6 ; meters/microsec
mm_in = n_elements(data1(0,*))
gunid_in = fix(reform(data1(0,*)))
out_in = fix(reform(data1(1,*)))
xg_in = reform(data1(2,*))
yg_in = reform(data1(3,*))
alpha_in = reform(data1(4,*))*!pi/180
tof_in = reform(data1(5,*))

dfilt = where(out_in eq 0 and extra.maxchan eq 7)
if (dfilt(0) eq -1) then begin
;    message, 'No out=0, maxchan=7 beams', /cont
    outstruc.status = -1
    return
endif

if (n_elements(dfilt) lt 6) then begin
;    message, 'Not enough out=0, maxchan=7 beams for statistics', /cont
    outstruc.status = -2
    return
endif

xg = xg_in(dfilt)
yg = yg_in(dfilt)
alpha = alpha_in(dfilt)
tof = tof_in(dfilt)
gunid = gunid_in(dfilt)
btime = extra.btime(dfilt)
maxchan = extra.maxchan(dfilt)
gdotb = extra.gdotb(dfilt)
mm = n_elements(dfilt)

sig_deltof = sqrt(2.)*actof

ep_calc_parallelism, alpha, atemp, mean_fangle, sdev_fangle
ep_calc_bestphi, alpha, sigfir, pd

; Define xd and yd using this 'bestphi'
rd = 100                        ; This has 100m length (much larger than the triangulation base of a few meters) because we want the towards/away assigments to be correct
xd = rd*cos(pd)
yd = rd*sin(pd)

; How far away in angle is each beam from this 'best' direction?
adiff = abs(alpha-pd)
adiff = adiff*(adiff lt !pi)+(2.*!pi-adiff)*(adiff ge !pi)
adiff = adiff*(adiff lt !pi/2.)+(!pi-adiff)*(adiff ge !pi/2.)
adiff = adiff*!radeg

;HERE HERE - THIS assignment (toaw) will be wrong if the coarse grid
;phi is wrong by 180 degrees, which is very possible in this
;regime...The largest deltof (determined from the difference of the
;towards average minus the away average) should be associated with the
;true direction since the toward beams are supposed to have higher
;values than the away beams.

edi_setcolors, cs
toaw = intarr(mm)
colorid = intarr(mm)
out = intarr(mm) + 2            ; All outliers to begin with
for im = 0, mm-1 do begin
    dely= yd -yg(im)
    delx= xd -xg(im)
    dalp= atan(dely,delx)
    dalp= abs(dalp-alpha(im))
    dalp= dalp*(dalp lt !pi)+(2*!pi-dalp)*(dalp ge !pi)
    toaw(im)= 1 *(dalp lt !pi/2) $ ;toward beam
      - 1 *(dalp ge !pi/2)      ;away beam
    colorid(im) = cs.cyan*(dalp lt !pi/2) $ ;toward beam
      + cs.magenta*(dalp ge !pi/2) ;away beam
endfor

; Flip the vector by 180 degrees and do assigment again - 
; NOTE: You can't assume that the towards/away assignment of the
; 180-degree flipped case is the complement of the above case!!!!
; This for sure doesn't work when the drift step magnitude is on the
; order of the virtual spacecraft size!!!!  I checked this!!!!  It
; does work when the drift step is well beyond the gun orbit...
pd = spherical_polar_phi(xd,yd)
pd_180 = pd + !pi
rd = sqrt(xd^2+yd^2)
xd_180 = rd*cos(pd_180)
yd_180 = rd*sin(pd_180)
toaw_180 = intarr(mm)
colorid_180 = intarr(mm)
out_180 = intarr(mm) + 2        ; all outliers to begin with
for im = 0, mm-1 do begin
    dely= yd_180 -yg(im)
    delx= xd_180 -xg(im)
    dalp= atan(dely,delx)
    dalp= abs(dalp-alpha(im))
    dalp= dalp*(dalp lt !pi)+(2*!pi-dalp)*(dalp ge !pi)
    toaw_180(im)= 1 *(dalp lt !pi/2) $ ;toward beam
      - 1 *(dalp ge !pi/2)      ;away beam
    colorid_180(im) = cs.cyan*(dalp lt !pi/2) $ ;toward beam
      + cs.magenta*(dalp ge !pi/2) ;away beam
endfor

normok = 0
id_to = where(toaw eq 1)
if (n_elements(id_to) ge 2) then begin
    tof_to_mean_all = mean(tof(id_to))
    tof_to_sdev_all = stddev(tof(id_to))
    igd = where(abs(tof(id_to)-tof_to_mean_all) le tof_to_sdev_all) ; 68%, conservative
    if (igd(0) ne -1) then begin
        colorid(id_to(igd)) = cs.blue ; outlier color removed
        out(id_to(igd)) = 0     ; outlier status removed
        tof_to_mean = mean(tof(id_to(igd)))
        tof_to_sdev = stddev(tof(id_to(igd)))
    endif else begin
        goto, try_flip
    endelse
endif else begin
    goto, try_flip
endelse
id_aw = where(toaw eq -1)
if (n_elements(id_aw) ge 2) then begin
    tof_aw_mean_all = mean(tof(id_aw))
    tof_aw_sdev_all = stddev(tof(id_aw))
    igd = where(abs(tof(id_aw)-tof_aw_mean_all) le tof_aw_sdev_all) ; 68%, conservative
    if (igd(0) ne -1) then begin
        colorid(id_aw(igd)) = cs.red ; outlier color removed
        out(id_aw(igd)) = 0     ; outlier status removed
        tof_aw_mean = mean(tof(id_aw(igd)))
        tof_aw_sdev = stddev(tof(id_aw(igd)))
    endif else begin
        goto, try_flip
    endelse
endif else begin
    goto, try_flip
endelse
deltof = tof_to_mean - tof_aw_mean
deltof_sigma = sqrt(tof_to_sdev^2 + tof_aw_sdev^2)
normok = 1

try_flip:
flipok = 0
id_to_180 = where(toaw_180 eq 1)
if (n_elements(id_to_180) ge 2) then begin
    tof_to_mean_180_all = mean(tof(id_to_180))
    tof_to_sdev_180_all = stddev(tof(id_to_180))
    igd = where(abs(tof(id_to_180)-tof_to_mean_180_all) le tof_to_sdev_180_all)
    if (igd(0) ne -1) then begin
        colorid_180(id_to_180(igd)) = cs.blue ; outlier color removed
        out_180(id_to_180(igd)) = 0 ; outlier status removed
        tof_to_mean_180 = mean(tof(id_to_180(igd)))
        tof_to_sdev_180 = stddev(tof(id_to_180(igd)))
    endif else begin
        if (normok) then begin
            goto, flipout
        endif else begin
            outstruc.status = -6
            return
        endelse
    endelse
endif else begin
    if (normok) then begin
        goto, flipout
    endif else begin
        outstruc.status = -3
        return
    endelse
endelse
id_aw_180 = where(toaw_180 eq -1)
if (n_elements(id_aw_180) ge 2) then begin
    tof_aw_mean_180_all = mean(tof(id_aw_180))
    tof_aw_sdev_180_all = stddev(tof(id_aw_180))
    igd = where(abs(tof(id_aw_180)-tof_aw_mean_180_all) le tof_aw_sdev_180_all)
    if (igd(0) ne -1) then begin
        colorid_180(id_aw_180(igd)) = cs.red ; outlier color removed
        out_180(id_aw_180(igd)) = 0 ; outlier status removed
        tof_aw_mean_180 = mean(tof(id_aw_180(igd)))
        tof_aw_sdev_180 = stddev(tof(id_aw_180(igd)))
    endif else begin
        if (normok) then begin
            goto, flipout
        endif else begin
            outstruc.status = -7
            return
        endelse
    endelse
endif else begin
    if (normok) then begin
        goto, flipout
    endif else begin
        outstruc.status = -4
        return
    endelse
endelse
deltof_180 = tof_to_mean_180 - tof_aw_mean_180
deltof_sigma_180 = sqrt(tof_to_sdev_180^2 + tof_aw_sdev_180^2)
flipok = 1

flipout:

if (normok and flipok) then begin
    if (deltof gt deltof_180) then begin
;        message, '180 flip not necessary', /cont
    endif else begin
;        message, '180 flip necessary', /cont
        id_to = id_to_180
        id_aw = id_aw_180
        colorid = colorid_180
        out = out_180
        toaw = toaw_180
        tof_to_mean = tof_to_mean_180
        tof_to_sdev = tof_to_sdev_180
        tof_aw_mean = tof_aw_mean_180
        tof_aw_sdev = tof_aw_sdev_180
        tof_to_mean_all = tof_to_mean_180_all
        tof_to_sdev_all = tof_to_sdev_180_all
        tof_aw_mean_all = tof_aw_mean_180_all
        tof_aw_sdev_all = tof_aw_sdev_180_all
        deltof = deltof_180
        deltof_sigma = deltof_sigma_180
        xd = xd_180
        yd = yd_180
    endelse
endif else if (normok and not flipok) then begin
;    message, 'Normal case, flip failed', /cont
endif else begin
;    message, 'Flip case, normal case failed', /cont
    id_to = id_to_180
    id_aw = id_aw_180
    colorid = colorid_180
    out = out_180
    toaw = toaw_180
    tof_to_mean = tof_to_mean_180
    tof_to_sdev = tof_to_sdev_180
    tof_aw_mean = tof_aw_mean_180
    tof_aw_sdev = tof_aw_sdev_180
    tof_to_mean_all = tof_to_mean_180_all
    tof_to_sdev_all = tof_to_sdev_180_all
    tof_aw_mean_all = tof_aw_mean_180_all
    tof_aw_sdev_all = tof_aw_sdev_180_all
    deltof = deltof_180
    deltof_sigma = deltof_sigma_180
    xd = xd_180
    yd = yd_180
endelse

if (deltof lt 0.) then begin
;    message, 'deltof lt 0', /cont
    outstruc.status = -5
    return
endif

bmag = sqrt(extra.bx_scs^2+extra.by_scs^2+extra.bz_scs^2)
bmag_cgs = bmag*1e-9*1e+4
tgyro = 2.*!pi*9.1e-28*3e+10/(4.8e-10*bmag_cgs)*1e6 ; microsecs
;if (tgyro lt tof_aw_mean or tgyro gt tof_to_mean) then begin
;    message, 'Tgyro from B not inbetween', /cont
;    return
;endif

;OUTPUT--OUTPUT--OUTPUT--OUTPUT--
rd = deltof*vb/2.               ; meters
tg = (tof_to_mean+tof_aw_mean)/2. ; microseconds
edi6 = [rd,pp_rfill,pd*180/!pi,pp_rfill,tg,pp_rfill]

ep_calculate_dp, edi6, extra.bpp2scs, extra.gei2gse, extra.scs2gse, $
  extra.bx_scs, extra.by_scs, extra.bz_scs, $
  extra.scnum, extra.mit70, extra.att_orb_hpath, extra.flip, $
  d_bpp, d_scs, d_gse, $
  v_bpp, v_scs, v_gse, $
  e_bpp, e_scs, e_gse, $
  v_gse_nocorr=v_gse_nocorr, $
  e_gse_nocorr=e_gse_nocorr, $
  vsc_gse=vsc_gse, b_gse=b_gse

outstruc.status = 1
outstruc.edi6 = edi6
outstruc.d_scs=d_scs
outstruc.v_scs=v_scs
outstruc.e_scs=e_scs
outstruc.d_gse=d_gse
outstruc.v_gse=v_gse
outstruc.e_gse=e_gse
outstruc.v_gse_nocorr=v_gse_nocorr
outstruc.e_gse_nocorr=e_gse_nocorr
outstruc.vsc_gse=vsc_gse
outstruc.b_gse=b_gse
outstruc.out(dfilt) = out
outstruc.toaw(dfilt) = toaw
outstruc.mean_fangle=mean_fangle
outstruc.sdev_fangle=sdev_fangle
outstruc.tof_to_mean=tof_to_mean
outstruc.tof_to_sdev=tof_to_sdev
outstruc.tof_aw_mean=tof_aw_mean
outstruc.tof_aw_sdev=tof_aw_sdev
outstruc.tof_to_mean_all=tof_to_mean_all
outstruc.tof_to_sdev_all=tof_to_sdev_all
outstruc.tof_aw_mean_all=tof_aw_mean_all
outstruc.tof_aw_sdev_all=tof_aw_sdev_all
outstruc.deltof=deltof
outstruc.deltof_sigma=deltof_sigma
outstruc.tgyro_from_b=tgyro

if not keyword_set(keyplot4) then return

; Plottting ==============================================
window, 6, xs=640,ys=960
!p.multi = [0,2,3,0,0]
yr = [min([min(tof),tgyro]),max([max(tof),tgyro])]
ylen=yr(1)-yr(0)
yr = [yr(0)-.1*ylen,yr(1)+.1*ylen]
xdat = (btime-extra.lb)
!p.color = cs.black
!p.background = cs.white

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Plot the beams
beam_plot, mm, xg, yg, alpha, out, gunid, colorid, $
  xd, yd, siz=20, title='Spin Start: '+extra.lbstr
outs = norm_axis([.1,.3])
xyouts, outs(0), outs(1), 'SC: '+extra.scnum+'!cn: '+string(extra.n,'(i2.2)')+'!cm: '+string(extra.m,'(i2.2)')+'!c"BEST" Angle: '+string(pd*!radeg,'(f5.1)')

; Vectors used to calculate sdev_fangle
xfoot = fltarr(mm)
yfoot = fltarr(mm)
xhead = 1.*cos(atemp)
yhead = 1.*sin(atemp)
plot, [0],[0], /nodata, xrange=[-1,1], yrange=[-1,1]
for ii=0,mm-1 do begin
    arrow, xfoot(ii), yfoot(ii), xhead(ii), yhead(ii), /data, color=colorid(ii)
endfor
oplot, !x.crange, [0,0], line=2
oplot, [0,0], !y.crange, line=2
oplot, !x.crange, sin(mean_fangle)/cos(mean_fangle)*!x.crange, line=2, color=cs.green
outs = norm_axis([.5,.3])
xyouts, outs(0), outs(1), 'MEAN of Angles: '+string(mean_fangle*!radeg,'(f5.1)')+'!cSTDDEV of Angles: '+string(sdev_fangle*!radeg,'(f5.1)'), align=.5

; Plot all of the tofs - With pre-outlier-removal stats overlayed
plot, xdat, tof, /nodata, yrange=yr, ystyle=1, $
  ytitle='ToF [microsec]', xtitle='Beam time, sec since spin start'

polyfill, [!x.crange(0),!x.crange(0),!x.crange(1),!x.crange(1)], $
  [tof_aw_mean_all-tof_aw_sdev_all,tof_aw_mean_all+tof_aw_sdev_all,tof_aw_mean_all+tof_aw_sdev_all,tof_aw_mean_all-tof_aw_sdev_all], color=cs.grey80, /fill

polyfill, [!x.crange(0),!x.crange(0),!x.crange(1),!x.crange(1)], $
  [tof_to_mean_all-tof_to_sdev_all,tof_to_mean_all+tof_to_sdev_all,tof_to_mean_all+tof_to_sdev_all,tof_to_mean_all-tof_to_sdev_all], color=cs.grey80, /fill

errplot, xdat, tof-actof, tof+actof

for ii=0,n_elements(id_aw)-1 do begin
    oplot, [xdat(id_aw(ii))], [tof(id_aw(ii))], $
      color=colorid(id_aw(ii)), psym=8-gunid(id_aw(ii))
endfor
oplot, !x.crange, [tof_aw_mean_all,tof_aw_mean_all], color=cs.red

for ii=0,n_elements(id_to)-1 do begin
    oplot, [xdat(id_to(ii))], [tof(id_to(ii))], $
      color=colorid(id_to(ii)), psym=8-gunid(id_to(ii))
endfor
oplot, !x.crange, [tof_to_mean_all,tof_to_mean_all], color=cs.blue

oplot, !x.crange, [tgyro,tgyro], line=3, color=cs.orange

; Plot all of the tofs - With post-outlier-removal stats overlayed
plot, xdat, tof, /nodata, yrange=yr, ystyle=1, $
  ytitle='ToF [microsec]', xtitle='Beam time, sec since spin start'

polyfill, [!x.crange(0),!x.crange(0),!x.crange(1),!x.crange(1)], $
  [tof_aw_mean-tof_aw_sdev,tof_aw_mean+tof_aw_sdev,tof_aw_mean+tof_aw_sdev,tof_aw_mean-tof_aw_sdev], color=cs.grey80, /fill

polyfill, [!x.crange(0),!x.crange(0),!x.crange(1),!x.crange(1)], $
  [tof_to_mean-tof_to_sdev,tof_to_mean+tof_to_sdev,tof_to_mean+tof_to_sdev,tof_to_mean-tof_to_sdev], color=cs.grey80, /fill

errplot, xdat, tof-actof, tof+actof

for ii=0,n_elements(id_aw)-1 do begin
    oplot, [xdat(id_aw(ii))], [tof(id_aw(ii))], $
      color=colorid(id_aw(ii)), psym=8-gunid(id_aw(ii))
endfor
oplot, !x.crange, [tof_aw_mean,tof_aw_mean], color=cs.red

for ii=0,n_elements(id_to)-1 do begin
    oplot, [xdat(id_to(ii))], [tof(id_to(ii))], $
      color=colorid(id_to(ii)), psym=8-gunid(id_to(ii))
endfor
oplot, !x.crange, [tof_to_mean,tof_to_mean], color=cs.blue

oplot, !x.crange, [tgyro,tgyro], line=3, color=cs.orange

; ToF bi-population dependence on degree of parallelism (of the beams)
plot, adiff, tof, /nodata, yrange=yr, ystyle=1, $
  ytitle='ToF [microsec]', xtitle='Angle from green line'
for ii=0,n_elements(id_aw)-1 do begin
    oplot, [adiff(id_aw(ii))], [tof(id_aw(ii))], $
      color=colorid(id_aw(ii)), psym=8-gunid(id_aw(ii))
endfor
for ii=0,n_elements(id_to)-1 do begin
    oplot, [adiff(id_to(ii))], [tof(id_to(ii))], $
      color=colorid(id_to(ii)), psym=8-gunid(id_to(ii))
endfor

goto, skip_maxchan
; ToF bi-population dependence on maxchan
xrange = [min(maxchan),max(maxchan)]
xrange = [xrange(0)-1,xrange(1)+1]
plot, maxchan, tof, /nodata, yrange=yr, ystyle=1, xrange=xrange, $
  ytitle='ToF [microsec]', xtitle='maxchan'
for ii=0,n_elements(id_aw)-1 do begin
    oplot, [maxchan(id_aw(ii))], [tof(id_aw(ii))], $
      color=colorid(id_aw(ii)), psym=8-gunid(id_aw(ii))
endfor
for ii=0,n_elements(id_to)-1 do begin
    oplot, [maxchan(id_to(ii))], [tof(id_to(ii))], $
      color=colorid(id_to(ii)), psym=8-gunid(id_to(ii))
endfor
skip_maxchan:

goto, skip_gdotb
; ToF bi-population dependence on gdotb
plot, abs(90.-gdotb), tof, /nodata, yrange=yr, ystyle=1, $
  ytitle='ToF [microsec]', xtitle='abs(90-gdotb)'
for ii=0,n_elements(id_aw)-1 do begin
    oplot, [abs(90.-gdotb(id_aw(ii)))], [tof(id_aw(ii))], $
      color=colorid(id_aw(ii)), psym=8-gunid(id_aw(ii))
endfor
for ii=0,n_elements(id_to)-1 do begin
    oplot, [abs(90.-gdotb(id_to(ii)))], [tof(id_to(ii))], $
      color=colorid(id_to(ii)), psym=8-gunid(id_to(ii))
endfor
skip_gdotb:
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
goto, skip_question
res = ''
read, res, prompt='Want a hardcopy? '
if (res eq 'y') then begin
    
    res = ''
    read, res, prompt='Name for ps file: '
    psname = res
    set_plot, 'PS'
    device, file=psname
    device, /color, bits=8
    device, /portrait,xs=3.,ys=9.,/inches,xoff=1.,yoff=1.
    
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
    plot, [0],[0], /nodata
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

    time_stamp_edi, label=psname

    device, /close_file
    set_plot, 'X'
endif
skip_question:

return
end

