;+
; NAME: norm_axis.pro
; Given normalized coordinates, return the coordinates on the
; current plot's axes.  The motivation for this procedure was to
; make a way that annotations could be printed within a plot having
; unknown axes.  We might be missing the simple and obvious way to 
; do this, and if you know it please call us. 
;
; Usage:  result = norm_axis([xnorm,ynorm]) 
;
; Written by: Jeremy Faden, University of Iowa. 
;             jbf@space-theory.physics.uiowa.edu
;-

function norm_axis, n_coord
  return=fltarr(2)
  return(0)=!x.crange(0)+(!x.crange(1)-!x.crange(0))*n_coord(0)
  return(1)=!y.crange(0)+(!y.crange(1)-!y.crange(0))*n_coord(1)
  
  return, return
end
