
PRO  MULTMTX,  X,C

;C Multiply vector X by matrix C to obtain new vector X        
	
; fortran version             c(row,col)
;       y = dblarr(3)
;       for  j = 0,2 do begin
;         y(j) = x(0)*c(0,j) + x(1)*c(1,j) + x(2)*c(2,j)
;       endfor
;       x(*) = y(*)

;IDL version using # operator
          z = x#c               ; c  (col,row)
;                               ; z  dblarr(1,3)
          x(0) = z(0,0)  &  x(1) = z(0,1)  &  x(2) = z(0,2)  ; reform vector
                                                             ; x dblarr(3)

       return

END
