      FUNCTION MJDSEC_TO_CCSDS(MJD,SEC_IN)
***********************************************************************
*                                    
* *CLUSTER-JSOC PROJECT - OBSERVATION PLANNING SUB-SYSTEM - RAL
*
* *FUNCTION MJDSEC_TO_CCSDS - CONVERT TO CSDS TIME CODE - VERSION 1.2
*
* *PROJECT REFERENCE    - ADD 2.2.1 - General purpose library function
*
* *LANGUAGE   -Fortran-90 
*
* *PURPOSE    -Convert Modified Julian Date and seconds in day into a 
*              CCSDS ASCII Time Code A (to one second resolution), e.g.
*              1995-02-25T18:08:00Z
*
* *ARGUMENTS  -MJD             /I    -enter Modified Julian Date
*             -SEC_IN          /I    -enter seconds in day
*             -MJDSEC_TO_CCSDS /C*   -returns CCSDS ASCII Time Code A
*
* *METHOD     -1. Convert MJD to calendar date using algorithm
*              devised by MAH. This algorithm inverts the 
*              standard calendar date to MJD algorithm. Details
*              were determined by trial and error using spreadsheet
*              makedate.wk4. (NOTE: an error in the original algorithm
*              was found during testing. This was fixed in the upgrade
*              from v1.1 to v1.2 - see below).
*              2. Convert seconds in day to hours, minutes and
*              seconds by simple computation.
*              3. Prepare CCSDS time code as character string via
*              internal write.
*
*              Note that the use of two integers MJD and seconds in day
*              is the internal standard through which times are 
*              manipulated in JSOC planning software.
*
*              Note also that we use the standard form of MJD, i.e. days
*              from 00:00 UTC on 17 November 1858, as described in 
*              reference works on astronomy. This is related to MJD2000
*              (as used by ESOC) by MJD = MJD2000 + 51544 
*
*              This function is valid for all dates between 1 March 1900
*              and 28 February 2100.
*
* *WRITTEN BY -M.A.Hapgood  DRAL UK Version 1.1  February 1995    
* *UPDATED BY -M.A.Hapgood  CLRC UK 1.1 to  1.2  May      1995    
*              (fixed bug in conversion of MJD to Year, Month and Day)
*
***********************************************************************
      IMPLICIT NONE
      INTEGER YEAR,MONTH,DAY,OFFSET,HOUR,MINS,SECS,MJD,IWORK,SEC_IN
      CHARACTER MJDSEC_TO_CCSDS*20
C Calculate trial value of year       
      IWORK=MJD+679019
      YEAR=INT(FLOAT(IWORK)/365.25)
C Calculate residual OFFSET. If too low, revise year value
      OFFSET=IWORK-INT(365.25*FLOAT(YEAR))       
      IF (OFFSET.LT.123) YEAR=YEAR-1
C Calculate new residual, then month and day
      OFFSET=IWORK-INT(365.25*YEAR)
**********************************************************************
* Bug fix. Version 1.1 gets 3 days of the year wrong - the 31st days of
* January, March and August come out as the 0th days of February, April
* and September. This is a rounding problem which is removed by replacing
* the divisor 30.6 by 30.60001 below. Solution confirmed by testing with
* spreadsheet makedate.wk4.
***********************************************************************
      MONTH=INT(FLOAT(OFFSET)/30.60001)               
      DAY=OFFSET-INT(MONTH*30.6)
C Adjust year and month as needed
      IF (MONTH.GT.13) THEN
        YEAR=YEAR+1
        MONTH=MONTH-13
      ELSE
        MONTH=MONTH-1
      ENDIF
C Break seconds in day into hours, minutes and seconds
      MINS=INT(FLOAT(SEC_IN)/60.0)
      SECS=SEC_IN-60*MINS
      HOUR=INT(FLOAT(MINS)/60.0)
      MINS=MINS-60*HOUR
C Write CCSDS code to buffer MJDSEC_TO_CCSDS       
      WRITE(MJDSEC_TO_CCSDS,1000) YEAR,MONTH,DAY,HOUR,MINS,SECS
 1000 FORMAT(I4,'-',I2.2,'-',I2.2,'T',I2.2,2(':',I2.2),'Z')
      END
