;C GENERAL NOTE. In this software vectors are specified
;C in general way by the following data structure.
;C
;C  X(3) - real*4 1D array with three elements contains numeric values
;C  SYS  - char*4 specifies the coordinate system
;C  FORM - char*3 specifies the form of the coordinate system
;C
;C Allowed value of SYS are
;C
;C    GEOC = geographic (geocentric)
;C    GEOD = geographic (geodetic)
;C     GSE = geocentric solar ecliptic
;C     GSM = geocentric solar magnetospheric
;C      SM = solar magnetic
;C     GEI = geocentric inertial
;C     MAG = geomagnetic (dipole)
;C     CGM = corrected geomagnetic
;C     HAE = heliospheric aries ecliptic
;C     HEE = heliospheric earth ecliptic
;C    HEEQ = heliospheric earth equatorial
;C    GSEQ = geocentric solar equatorial
;C
;C Allowed values of FORM are
;C
;C      PO = polar 
;C      CA = cartesian
;C
;C Note for geodetic FORM must be PO. All other systems may be PO or CA.
;C
;C Allowed values of X(3) are as follows (latitude, longitude and local
;C time are held in radians):
;C
;C * for generalised cartesian 
;C   X(1) = X coordinate
;C   X(2) = Y coordinate
;C   X(3) = Z coordinate
;C
;C * for generalised polar
;C   X(1) = latitude  (+ North)
;C   X(2) = longitude (+ East)
;C   X(3) = magnitude
;C
;C * for geodetic
;C   X(1) = latitude  (+ North)
;C   X(2) = longitude (+ East)
;C   X(3) = height above geoid in kilometres
;C   Note that that for conversions to/from geodetic it is assumed
;C   that the other systems are in units of Earth radii
;C
;C


PRO MAKET,  T,NTERMS,LTERMS

;C Calculate the transformation matrix T defined by the sequence
;C of rotations specified in LTERMS. 
;C
;C Each transformation is broken down into sequence of simple
;C rotations, which are specified by a series of values in integer
;C array LTERMS. There are twelve different types of rotation which
;C are specified by the integers 1 to 12 as shown below. An inverse
;C rotation is specified by adding a negative sign. NTERMS gives the
;C number of values to be used in LTERMS.
;C
;C 1.  Greenwich Sideral Time      
;C 2.  Solar Longitude             
;C 3.  Obliquity of the ecliptic   
;C 4.  Rotation from GSE to GSM    
;C 5.  Dipole tilt (GSM to SM)     
;C 6.  Latitude of the dipole pole 
;C 7.  Longitude of the dipole pole
;C 8.  Ascending node of solar equator
;C 9.  Inclination of solar equator
;C 10. Solar longitude of Earth   
;C 11. Solar latitude of Earth    
;C 12. XY inversion  
;C
;C For example, a transformation from geographic to GSE requires
;C 3 rotations: an inverse of 1 followed by 3 then 2. Thus NTERMS = 3
;C and LTERMS = -1 3 2 0 0 0 0
;C

       s = dblarr(3,3)  

;C If NTERMS is zero, there is no transformation, so make a unit
;C matrix
       if (nterms eq 0) then begin
          unitmtx, T
          ;C If NTERMS is positive, calculate the transformation matrix         
       endif else if (nterms gt 0) then begin
          ;C Extract first rotation code, identify rotation angle and axis, then
          ;C calculate its transformation matrix T.
          i     = lterms(0 )
          angle = getangle(i)
          axis  = getaxis(i)
          makemtx, angle,axis,T
;         prt_matrix,t ,'0'
          ;C If there is more than one rotation, extract each rotation code, 
          ;C identify its angle and axis, then calculate its transformation 
          ;C matrix S and finally multiply it with the existing transformation
          ;C matrix T. Put the result in T and repeat as necessary. At end T
          ;C is the required matrix.
          if (nterms gt 1) then begin 
             for j = 1,nterms-1 do begin
                i     = lterms(j)
                angle = getangle(i)
                axis  = getaxis(i)
                makemtx, angle,axis,s
                multmtx2,  T,s
;               prt_matrix,t,'i'
             endfor
          endif
       ;C If NTERMS < 0 something's wrong so stop          ???kzm
       endif else begin
         stop 
       endelse


       return
       END
