; =============================================================================
  FUNCTION GyroUnitVector_, Bvector
; =============================================================================
; EQ-S / Cluster : calculate a gyro-coordinate unit vector (x,y) from a
; magnetic field vector (both expressed in cartesian coordinates)
; The magnetic field vector must be given as an array [Bx,By,Bz], where each 
; component can itself be an array
; The resulting vector will be returned as [xgyro,ygyro], where 
;     xgyro = [xg_x,xg_y,xg_z]
;     ygyro = [yg_x,yg_y,yg_z]
; *****************************************************************************

dim  = n_elements(Bvector) / 3

if 3*dim ne n_elements(Bvector) then begin
   print, 'GyroUnitVector_() : passed vector size is incompatible with a '
   print, '                    3-D vector'
;  SHOWCALLSTACK
endif

Bx = Bvector(0:dim-1)
By = Bvector(dim:2*dim-1)
Bz = Bvector(2*dim:3*dim-1)

; use an arbitrary but fixed vector as reference direction
; Sx=0.0  & Sy = cos(0.5)  & Sz = sin(0.5)
  Sx=0.0  & Sy = 1.0  & Sz = 0.0

; gyro coordinates xgyro = S x B , ygyro = B x xgyro
  xg_x = Sy*Bz - Sz*By
  xg_y = Sz*Bx - Sx*Bz
  xg_z = Sx*By - Sy*Bx


  yg_x = By*xg_z - Bz*xg_y
  yg_y = Bz*xg_x - Bx*xg_z
  yg_z = Bx*xg_y - By*xg_x


; normalize
  xgn = sqrt(xg_x^2 + xg_y^2 + xg_z^2)
  xg_x = xg_x / xgn
  xg_y = xg_y / xgn
  xg_z = xg_z / xgn

  ygn = sqrt(yg_x^2 + yg_y^2 + yg_z^2)
  yg_x = yg_x / ygn
  yg_y = yg_y / ygn
  yg_z = yg_z / ygn
  
  return, [xg_x,xg_y,xg_z, yg_x,yg_y,yg_z]

END
