; =============================================================================
  FUNCTION GyroComponents_, vector, gyrov
; =============================================================================
; EQ-S / Cluster : calculate components of a 3D vector along the two 
; components of a gyro-coordinate unit vector (all expressed in cartesian 
; coordinates)
; The input vector must be given as an array [x,y,z], where each 
; component can itself be an array
; the gyro unit vector pair must be given as an array 
; [xg_x,xg_y,xg_z, yg_x,yg_y, yg_z] (as returned by GyroUnitVector_() )
;
; The resulting components will be returned as 
;     rvect = [rx,ry]
; *****************************************************************************

dim  = n_elements(vector) / 3
dimg = n_elements(gyrov) / 6

if 3*dim ne n_elements(vector) then begin
   print, 'GyroComponents_() : passed vector size is incompatible with a '
   print, '                    3-D vector'
;  SHOWCALLSTACK
endif else if 6*dimg ne n_elements(gyrov) then begin
   print, 'GyroComponents_() : passed vector size is incompatible with a '
   print, '                    6-D vector'
;  SHOWCALLSTACK
endif

if dim ne dimg then begin
   print, 'GyroComponents_() : array dimensions of passed vectors are '
   print, 'incompatible ', dim, dimg
;  SHOWCALLSTACK
endif

x = indgen(dim)  &  y = x + dim  &  z = x + 2*dim

xg_x = x 
xg_y = y
xg_z = z

yg_x = x + 3*dim
yg_y = x + 4*dim
yg_z = x + 5*dim

rx =   vector(x) * gyrov(xg_x) $
     + vector(y) * gyrov(xg_y) $
     + vector(z) * gyrov(xg_z)

ry =   vector(x) * gyrov(yg_x) $
     + vector(y) * gyrov(yg_y) $
     + vector(z) * gyrov(yg_z)


return, [rx,ry]

END
