	PRO  GSMGSE,  PSI,MU,LAT,LONG


;C Calculate rotation angles PSI and MU between GSE and GSM, and between
;C GSM and SM, coordinates respectively.

       q = dblarr(3)    & t = dblarr(3,3)  & lterms = intarr(20)              


;C Define the dipole axis as a unit vector Q in geographic
;C coordinates

       rlat = lat*PI(0)/180.d0
       rlong = long*PI(0)/180.d0
       q(0) = cos(rlat)*cos(rlong)
       q(1) = cos(rlat)*sin(rlong)
       q(2) = sin(rlat)

;C Define and calculate transformation matrix T from geographic to
;C GSE coordinates by way of GEI.
       lterms(0) = -1
       lterms(1) = 3
       lterms(2) = 2
       maket,  t,3,lterms

;C Apply matrix T to vector Q to get a new unit vector describing
;C the dipole axis in GSE coordinates.
       multmtx,  q,t

;C Derive angles PSI and MU from vector Q
       psi = atan(q(1)/q(2))*180.d0/PI(0)
       mu  = atan(q(0)/sqrt(q(1)*q(1) + q(2)*q(2)))*180.d0/PI(0)
;C        

       return


END
