function allocate_color, Red, Green, Blue, $
                         name=name, reset=reset, identify=idname
;  allocate_color is still a little buggy.  Needs work...

;+
; NAME: allocate_color
;
; PURPOSE: allocate color from colortable
;
; CALLING SEQUENCE: i= allocate_color( R, G, B )
;
; INPUTS:
;     R,G,B  integers between 0 and 255
;
; OUTPUTS:
;     allocated index number, where color was stored.
;
; KEYWORD PARAMETERS:
;     name=''    name this color (to access by reference later)
;     /reset     resets internal state (and deallocates all colors)
;     identify=''  find the named color and check its validity
;
; COMMON BLOCKS:
;     common allocate_color_data, ct
;
; SIDE EFFECTS:
;     affects IDL colortable
;
; PROCEDURE:
;     initialize state if necessary.  find first available color.
;     tvlct, /get.  change the color, tvlct, "/set".
;
; EXAMPLE:
;     i= allocate_color( 255, 255, 0, color='my_yellow' )
;     plot, findgen(30), color=get_color_index('my_yellow')
;
; MODIFICATION HISTORY:
;     written,  Dec 7, 1998 jbf
;-

  common allocate_color_data, ct             ; colortable, header info
  if n_elements( ct ) eq 0 then begin
      tvlct, /get, red, green, blue
      ct1= { free:1, $          ; is this color free
             name:'', $         ; what is its names
             R:0, G:0, B:0, $   ; RGB values (used to test validity of ct)
             colorset:-1, $     ; what set is it a part of?
             colorset_idx:-1 $  ; what is its index within the set
           }
      ct= replicate( ct1, !d.table_size )
      ct(0).free=0
      ct(!p.color<(!d.table_size-1)).free=0
      ct.r= red
      ct.g= green
      ct.b= blue
      std_names=['black', 'red', 'green', 'yellow', 'blue', $
                 'magenta', 'cyan', 'white','grey','gray','orange', 'purple' ]
      for i=0,n_elements(std_names)-1 do begin
          idx= get_color_index(std_names(i),closeness=c)
          if c lt 0.5 then begin
              ct(idx).free=0
              ct(idx).name=std_names(i)
              ct(idx).colorset=10 ; Crayola colors              
          endif
      endfor
      r= where(ct(*).colorset eq 10,count) 
      if r(0) ne -1 then $
        ct(r).colorset_idx=indgen(count)
  endif
  
  if n_elements( idname ) gt 0 then begin ; find and verify the color
      name= idname
      r= where( ct(*).name eq name )
      if r(0) eq -1 then begin
          message, 'Named color not found.', /cont
          return, -1
      endif else begin
          i=r(0)
          tvlct, /get, Red, Green, Blue
          if ( ct(i).R eq Red(i) ) and ( ct(i).G eq Green(i) ) and $
            ( ct(i).B eq Blue(i) ) then begin
              return, i
          endif else begin
              message, 'colortable modified by another code.', /cont
              return, -1
          endelse
      endelse
  endif

  available= where( ct.free, count )

  is_array= (size(red))(0) gt 0
  if count ge n_elements(red) then begin
      a1= available(indgen(n_elements(red)))
      tvlct, /get, r1, g1, b1
      r1(a1)= Red
      g1(a1)= Green
      b1(a1)= Blue
      tvlct, r1, g1, b1
      ct(a1).free=0
      ct(a1).R= Red & ct(a1).G= Green & ct(a1).B= Blue
      if n_elements(name) ne 0 then ct(a1).name=name
  endif else begin
      a1= -1
  endelse
  if is_array then $
    return, a1 $
  else $
    return, a1(0)
end

function get_color_index, arg1, arg2, arg3, closeness=closeness, $
                          hsv=hsv, rgb=rgb_out
;+
; NAME: get_color_index
;
; PURPOSE:
;  finds closest color to specified R, G, B.  If only arg1
;  is specified, then translate color name to RGB first.
;
; CALLING SEQUENCE:
;   r= get_color_index(<color_string>)
;   r= get_color_index(R,G,B)
;
; INPUTS:
;   <color_string>= [ 'black'|'red'|'green'|'yellow'|'blue'|
;                     'magenta'|'cyan'|'white'|'grey'|'gray'|'orange' ]
;
; EXAMPLE CALL:
;    r= get_color_index('red')
;    r= get_color_index(255,255,0)
;-
   rgb= not keyword_set( hsv )

   allocate=0

   if n_params() gt 1 then begin
       red= arg1
       green= arg2
       blue= arg3
   endif else begin
       names= [ 'black', 'red', 'green', 'yellow', 'blue', $
                'magenta', 'cyan', 'white','grey','gray','orange', 'purple' ]
       rs= [ [ 0,1,0,1,0,1,0,1,.8,.8 ] * 255, 255, 88 ]
       gs= [ [ 0,0,1,1,0,0,1,1,.8,.8 ] * 255, 170, 0 ]
       bs= [ [ 0,0,0,0,1,1,1,1,.8,.8 ] * 255, 0, 132 ]

       name= strlowcase(arg1)
       r= (where( name eq names ))(0)
       if r(0) eq -1 then begin
           i= allocate_color( identify=name )
           return, i
       endif else begin
           red= rs(r)
           green= gs(r)
           blue= bs(r)
       endelse
       rgb=1
   endelse

   if keyword_set( rgb_out ) then begin
   	   return, red + 256L*green + 256L*256L*blue
   endif

   if rgb then begin
       color_convert, red, green, blue, h,s,v, /rgb_hsv
   endif

   tvlct, r, g, b, /get

   color_convert, r, g, b, HH, SS, VV, /rgb_hsv

;   h= (float(r-red))^2 + (float(g-green))^2 + (float(b-blue))^2

   angle= abs( float(HH-h) )
   r= where( angle gt 180 )
   if r(0) ne -1 then angle(r)= 360.-angle(r)

   dist2= (angle/180.)^2 + float(SS-s)^2 + float(VV-v)^2

   min= sqrt( min( dist2, imin ) )

   if min gt 0.5 then begin
       if allocate then begin
           message, 'Allocating color ', /cont
           imin2= allocate_color( red, green, blue, name=name )
           if imin2 ne -1 then begin
               imin=imin2
               min=0
           endif else begin
               message, 'color could not be allocated.', /cont
           endelse
       endif else begin
           message, 'Warning: No close colors found.', /cont
       endelse
   endif

   closeness= min
   return, imin
end


