PRO  GEO2GEOD, DS

print,'geo2geod',ds
;*
;* Revision
;* 01 Sep 1998 change 'PO' to ' PO' in IF statement
;*
;C Convert geocentric polar coordinates to geodetic coordinates :
;C (i) convert geocentric latitude to geodetic (ii) longitude is
;C unchanged, (iii) convert radial distance in Earth radii to 
;C height above geoid in kilometres

       w = dblarr(3)
       vect = dblarr(3)

;C Convert geodetic latitude to geocentric, convert height above geoid
;C in kilometres to radial distance in Earth radii
       if ((DS.sys eq 'GEOC') and (DS.form eq 'PO')) then begin
	   vect = DS.vect
           copyx, vect,w
           vect(0) = w(0) + (3.37d-3)*sin(2.d0*w(0))
           vect(1) = w(1)
           vect(2) = (w(2) - 0.99832707d0 - 0.00167644d0*cos(2.d0*w(0))) *6378.14d0
           DS.vect = vect
           DS.sys = 'GEOD'
           DS.rcode = 0
       endif else begin
           DS.rcode = 2
       endelse
;C
       return



END
