pro extract_aux_data_diag, nbeam_max, nspin_max, $ ; IN
                           date, $ ; 'YYYYMMDD', IN
                           fname, $ ; path+filename, IN
                           stat=stat_out, nobeam=nobeam

common extract_aux_diag_cblock, data_descrip_str, data
common extract_aux_diag_cblock_internal, cfname, cnobeam

stat_out=0                      ; Fail

nobeam = keyword_set(nobeam)

if n_elements(cfname) eq 0 then goto, readit
if (fname ne cfname) then goto, readit
if (nobeam ne cnobeam) then goto, readit
goto, skip_readit

;==========================================================
readit:

message, 'Reading '+fname, /cont

openr, unit, fname, /get_lun

dum = ''
for i=0,6 do readf, unit, dum

readf, unit, dum
nmeth = fix(strtrim(dum,2))

readf, unit, dum
data_descrip_str = dum

readf, unit, dum

date_vax = date2datevax(date)
pick_cvt_str_sec, date_vax+' 00:00:00.000000', t70mn ; midnight
t70_midnight = double(t70mn(0)) + double(t70mn(1))/1d6

if (not nobeam) then begin
    ead_meth_struct = {ead_meth_struct, $
                       status:0, $
                       comptime:0., $
                       yestof_in:0, $
                       yestof_out:0, $
                       edi6:fltarr(6), $
                       rchi2:0., $
                       out:intarr(nbeam_max), $
                       bestord:intarr(nbeam_max), $
                       toaw:intarr(nbeam_max), $
                       d_scs:fltarr(3), $
                       v_scs:fltarr(3), $
                       e_scs:fltarr(3), $
                       mean_fangle:0., $
                       sdev_fangle:0., $
                       tof_to_mean:0., $
                       tof_to_sdev:0., $
                       tof_aw_mean:0., $
                       tof_aw_sdev:0., $
                       tof_to_mean_all:0., $
                       tof_to_sdev_all:0., $
                       tof_aw_mean_all:0., $
                       tof_aw_sdev_all:0., $
                       deltof:0., $
                       deltof_sigma:0., $
                       tgyro_from_b:0.}
    meth_struct = replicate(ead_meth_struct, nmeth)
    ead_data_struct = {ead_data_struct, $
                       lbstr:'', $
                       rbstr:'', $
                       t_ssm:0., $
                       tspin_sec:0., $
                       tmid:'', $
                       bx_scs:0., $
                       by_scs:0., $
                       bz_scs:0., $
                       bv1:0., $
                       bv2:0., $
                       nnn:0, $
                       mm:0, $
                       yestof_whatech:0, $
                       ct:0, $
                       nbeam:0, $
                       erg:0., $
                       gunid:intarr(nbeam_max), $
                       xg:fltarr(nbeam_max), $
                       yg:fltarr(nbeam_max), $
                       alpha:fltarr(nbeam_max), $
                       tof:fltarr(nbeam_max), $
                       atime:dblarr(nbeam_max), $
                       btime:dblarr(nbeam_max), $
                       gdotb:fltarr(nbeam_max), $
                       maxchan:intarr(nbeam_max), $
                       meth:meth_struct}
    data = replicate(ead_data_struct, nspin_max)
endif else begin
    ead_meth_struct_nobeam = {ead_meth_struct_nobeam, $
                              status:0, $
                              comptime:0., $
                              yestof_in:0, $
                              yestof_out:0, $
                              edi6:fltarr(6), $
                              rchi2:0., $
                              d_scs:fltarr(3), $
                              v_scs:fltarr(3), $
                              e_scs:fltarr(3), $
                              mean_fangle:0., $
                              sdev_fangle:0., $
                              tof_to_mean:0., $
                              tof_to_sdev:0., $
                              tof_aw_mean:0., $
                              tof_aw_sdev:0., $
                              tof_to_mean_all:0., $
                              tof_to_sdev_all:0., $
                              tof_aw_mean_all:0., $
                              tof_aw_sdev_all:0., $
                              deltof:0., $
                              deltof_sigma:0., $
                              tgyro_from_b:0.}
    meth_struct = replicate(ead_meth_struct_nobeam, nmeth)
    ead_data_struct_nobeam = {ead_data_struct_nobeam, $
                              lbstr:'', $
                              rbstr:'', $
                              t_ssm:0., $
                              tspin_sec:0., $
                              tmid:'', $
                              bx_scs:0., $
                              by_scs:0., $
                              bz_scs:0., $
                              bv1:0., $
                              bv2:0., $
                              nnn:0, $
                              mm:0, $
                              yestof_whatech:0, $
                              ct:0, $
                              nbeam:0, $
                              erg:0., $
                              meth:meth_struct}
    data = replicate(ead_data_struct_nobeam, nspin_max)
endelse

ii = -1L
while not eof(unit) do begin
    dum = ''
    lbstr = ''
    rbstr = ''
    bx_scs = 0.
    by_scs = 0.
    bz_scs = 0.
    bv1 = 0.
    bv2 = 0.
    nnn = 0
    mm = 0
    yestof_whatech = 0
    ct = 0
    nbeam = 0
    erg = 0.
    
    readf, unit, dum
    reads, dum, lbstr, rbstr, bx_scs, by_scs, bz_scs, bv1, bv2, $
      nnn, mm, yestof_whatech, ct, nbeam, erg, $
      format= $
      '(2(a27,1x),5(e13.6,1x),3(i3,1x),i1,1x,i3,1x,f3.1)'
    
    ii = ii + 1
    data(ii).lbstr = lbstr
    data(ii).rbstr = rbstr
    
; Construct more useful time arrays
    pick_cvt_str_sec, data(ii).lbstr, spin_start
    pick_cvt_str_sec, data(ii).rbstr, spin_stop
    spin_start = double(spin_start(0)) + double(spin_start(1))/1d6
    spin_stop = double(spin_stop(0)) + double(spin_stop(1))/1d6
    data(ii).tspin_sec = spin_stop - spin_start
    spin_mid = (spin_start + spin_stop)/2.d0
    data(ii).t_ssm = spin_mid - t70_midnight
    spin_mid = [long(spin_mid),long( (spin_mid-long(spin_mid))*1d6 )]
    pick_cvt_sec_vax, spin_mid, midstr
    data(ii).tmid = midstr

    data(ii).bx_scs = bx_scs
    data(ii).by_scs = by_scs
    data(ii).bz_scs = bz_scs
    data(ii).bv1 = bv1
    data(ii).bv2 = bv2
    data(ii).nnn = nnn
    data(ii).mm = mm
    data(ii).yestof_whatech = yestof_whatech
    data(ii).ct = ct
    data(ii).nbeam = nbeam
    data(ii).erg = erg
;======================================================    
    nbstr = strtrim(nbeam,2)
    gunid = intarr(nbeam)
    xg = fltarr(nbeam)
    yg = fltarr(nbeam)
    alpha = fltarr(nbeam)
    tof = fltarr(nbeam)
    atime = dblarr(nbeam)
    btime = dblarr(nbeam)
    gdotb = fltarr(nbeam)
    maxchan = intarr(nbeam)
    readf, unit, dum
    reads, dum, gunid, xg, yg, alpha, tof, $
      atime, btime, gdotb, maxchan, $
      format= '('+ $
      nbstr+'(i1,1x),'+nbstr+'(e13.6,1x),'+nbstr+ $
      '(e13.6,1x),'+nbstr+'(e13.6,1x),'+nbstr+'(e13.6,1x),'+ $
      nbstr+'(d20.13,1x),'+nbstr+'(d20.13,1x),'+ $
      nbstr+'(e13.6,1x),'+nbstr+'(i2,1x))'    

    if (not nobeam) then begin
        data(ii).gunid(0:nbeam-1) = gunid
        data(ii).xg(0:nbeam-1) = xg
        data(ii).yg(0:nbeam-1) = yg
        data(ii).alpha(0:nbeam-1) = alpha
        data(ii).tof(0:nbeam-1) = tof
        data(ii).atime(0:nbeam-1) = atime
        data(ii).btime(0:nbeam-1) = btime
        data(ii).gdotb(0:nbeam-1) = gdotb
        data(ii).maxchan(0:nbeam-1) = maxchan
    endif
    
;===========================================================
    
    for imeth=0,nmeth-1 do begin
        status = 0
        comptime = 0.
        yestof_in = 0
        yestof_out = 0
        edi6 = fltarr(6)
        rchi2 = 0.
        toaw = intarr(nbeam)
        out = intarr(nbeam)
        bestord = intarr(nbeam)
        d_scs = fltarr(3)
        v_scs = fltarr(3)
        e_scs = fltarr(3)
        mean_fangle = 0.
        sdev_fangle = 0.
        tof_to_mean = 0.
        tof_to_sdev = 0.
        tof_aw_mean = 0.
        tof_to_mean_all = 0.
        tof_to_sdev_all = 0.
        tof_aw_mean_all = 0.
        tof_aw_sdev_all = 0.
        deltof = 0.
        deltof_sigma = 0.
        tgyro_from_b = 0.
        
        readf, unit, dum
        reads, dum, status, comptime, yestof_in, yestof_out, edi6, rchi2, toaw, out, bestord, d_scs, v_scs, e_scs, mean_fangle, sdev_fangle, tof_to_mean, tof_to_sdev, tof_aw_mean, tof_aw_sdev, tof_to_mean_all, tof_to_sdev_all, tof_aw_mean_all, tof_aw_sdev_all, deltof, deltof_sigma, tgyro_from_b, $
          format=$
          '(i3,1x,e13.6,1x,2(i3,1x),6(e13.6,1x),e13.6,1x,'+$
          nbstr+'(i3,1x),'+nbstr+'(i3,1x),'+nbstr+'(i3,1x),'+$
          '3(e13.6,1x),3(e13.6,1x),3(e13.6,1x),13(e13.6,1x))'
        
        data(ii).meth(imeth).status = status
        data(ii).meth(imeth).comptime = comptime
        data(ii).meth(imeth).yestof_in = yestof_in
        data(ii).meth(imeth).yestof_out = yestof_out
        data(ii).meth(imeth).edi6 = edi6
        data(ii).meth(imeth).rchi2 = rchi2

        if (not nobeam) then begin
            data(ii).meth(imeth).toaw(0:nbeam-1) = toaw
            data(ii).meth(imeth).out(0:nbeam-1) = out
            data(ii).meth(imeth).bestord(0:nbeam-1) = bestord
        endif

        data(ii).meth(imeth).d_scs = d_scs
        data(ii).meth(imeth).v_scs = v_scs
        data(ii).meth(imeth).e_scs = e_scs
        data(ii).meth(imeth).mean_fangle = mean_fangle
        data(ii).meth(imeth).sdev_fangle = sdev_fangle
        data(ii).meth(imeth).tof_to_mean = tof_to_mean
        data(ii).meth(imeth).tof_to_sdev = tof_to_sdev
        data(ii).meth(imeth).tof_aw_mean = tof_aw_mean
        data(ii).meth(imeth).tof_aw_sdev = tof_aw_sdev
        data(ii).meth(imeth).tof_to_mean_all = tof_to_mean_all
        data(ii).meth(imeth).tof_to_sdev_all = tof_to_sdev_all
        data(ii).meth(imeth).tof_aw_mean_all = tof_aw_mean_all
        data(ii).meth(imeth).tof_aw_sdev_all = tof_aw_sdev_all
        data(ii).meth(imeth).deltof = deltof
        data(ii).meth(imeth).deltof_sigma = deltof_sigma
        data(ii).meth(imeth).tgyro_from_b = tgyro_from_b
    endfor

endwhile
free_lun, unit
data = data(0:ii)
cfname = fname
cnobeam = nobeam
;==================================================================
;==================================================================
skip_readit:

stat_out = 1

return
end
