function ep_timeanom_check, sn

common ep_envar_con_cb
; Filter out timing anomolies because the
; atimes for these cases are not valid.

pacmo_str = string(sn.hdr.pacmo,'(i1)')
estat = execute('pdata=sn.pacmo'+pacmo_str) ; Packet data

tpack = double(sn.hdr.packet_time(0)) + $
  double(sn.hdr.packet_time(1))/1d6
tatime = double(pdata.data(0).atime(0)) + $
  double(pdata.data(0).atime(1))/1d6

if ( (tpack - tatime lt pp_ptime_atime_offset-1.d0) or $
     (tpack - tatime gt pp_ptime_atime_offset+1.d0) ) then return, 0

return, 1
end
