function ep_submo_tmmo_check, sn

submo_map = [ ['01','LR'], $
              ['02','LR'], $
              ['03','LR'], $
              ['04','UK'], $
              ['05','HR'], $
              ['06','HR'], $
              ['07','HR'] ]

telmo_map = [ ['00','HK'], $
              ['02','LR'], $
              ['03','HR'], $
              ['40','HK'], $
              ['42','LR'], $
              ['43','HR'], $
              ['f0','HK'], $
              ['f2','LR'], $
              ['f3','HR'], $
              ['4f','HK'], $
              ['e2','LR'], $
              ['e3','HR'], $
              ['ff','NA'] ]

submo_hexstr = string(sn.hdr.sub_mode,form='(z2.2)')
telmo_hexstr = string(sn.data_stream,form='(z2.2)')

imap = where(submo_map(0,*) eq submo_hexstr)
if (imap(0) eq -1) then submo_ratestr = 'UK' else $
  submo_ratestr = submo_map(1,imap(0))

imap = where(telmo_map(0,*) eq telmo_hexstr)
if (imap(0) eq -1) then telmo_ratestr = 'UK' else $
  telmo_ratestr = telmo_map(1,imap(0))

if (submo_ratestr eq telmo_ratestr) then $
  submo_tmmo_ok = 1 else submo_tmmo_ok = 0

return, submo_tmmo_ok
end
