function ep_rotate_handler, vtype_in, v, vtype_out, $
                            satgse, gsegsm, satgei, geigse, $
                            magsm=magsm, smgse=smgse, geocgse=geocgse


; NOTE: All rotation matricies have been constructed so that the first
; index is the 'row' index, and the second index is the 'column'
; index, i.e., M(irow,icol) so that to use them:
;       v_rotated(i) = M(i,k)*v(k) (in Einstein notation).
; I know this doesn't lend itself easily to using the IDL matrix
; operators, but I didn't figure this out until afterwards...

case vtype_in of
    'geoc':begin
        case vtype_out of
            'gse':begin
                vout = [total(geocgse(0,*)*v,/double), $
                        total(geocgse(1,*)*v,/double), $
                        total(geocgse(2,*)*v,/double)]
            end
        endcase
    end
    'gei':begin
        case vtype_out of
            'gei':vout=v
            'scs':begin
                geisat = transpose(satgei)
                vout = [total(geisat(0,*)*v,/double), $
                        total(geisat(1,*)*v,/double), $
                        total(geisat(2,*)*v,/double)]
            end
            'gse':begin
                vout = [total(geigse(0,*)*v,/double), $
                        total(geigse(1,*)*v,/double), $
                        total(geigse(2,*)*v,/double)]
            end
            'gsm':begin
                geigsm = geigse##gsegsm ; =gsegsm*geigse=geigse##gsegsm
                vout = [total(geigsm(0,*)*v,/double), $
                        total(geigsm(1,*)*v,/double), $
                        total(geigsm(2,*)*v,/double)]
            end
        endcase
    end
    'scs':begin
        case vtype_out of
            'gei':begin
                vout = [total(satgei(0,*)*v,/double), $
                        total(satgei(1,*)*v,/double), $
                        total(satgei(2,*)*v,/double)]
            end
            'scs':vout=v
            'gse':begin
                vout = [total(satgse(0,*)*v,/double), $
                        total(satgse(1,*)*v,/double), $
                        total(satgse(2,*)*v,/double)]
            end
            'gsm':begin
                satgsm = satgse##gsegsm ; =gsegsm*satgse=satgse##gsegsm
                vout = [total(satgsm(0,*)*v,/double), $
                        total(satgsm(1,*)*v,/double), $
                        total(satgsm(2,*)*v,/double)]
            end
        endcase
    end
    'gse':begin
        case vtype_out of
            'gei':begin
                gsegei = transpose(geigse) ; Inverse=Transpose
                vout = [total(gsegei(0,*)*v,/double), $
                        total(gsegei(1,*)*v,/double), $
                        total(gsegei(2,*)*v,/double)]
            end
            'scs':begin
                gsesat = transpose(satgse) ; Inverse=Transpose
                vout = [total(gsesat(0,*)*v,/double), $
                        total(gsesat(1,*)*v,/double), $
                        total(gsesat(2,*)*v,/double)]
            end
            'gse':vout=v
            'gsm':begin
                vout = [total(gsegsm(0,*)*v,/double), $
                        total(gsegsm(1,*)*v,/double), $
                        total(gsegsm(2,*)*v,/double)]
            end
            'sm':begin
                m = invert(smgse, s, /double)
                if (s ne 0) then message, 'Inversion failure'
                vout = [total(m(0,*)*v,/double), $
                        total(m(1,*)*v,/double), $
                        total(m(2,*)*v,/double)]
            end
            'mag':begin
                m = invert(smgse, s, /double)
                if (s ne 0) then message, 'Inversion failure'
                vo = [total(m(0,*)*v,/double), $
                      total(m(1,*)*v,/double), $
                      total(m(2,*)*v,/double)]
                m = invert(magsm, s, /double)
                if (s ne 0) then message, 'Inversion failure'
                vout = [total(m(0,*)*vo,/double), $
                        total(m(1,*)*vo,/double), $
                        total(m(2,*)*vo,/double)]
            end
            
        endcase
    end
    'gsm':begin
        case vtype_out of
            'gei':begin
                gsmgse = transpose(gsegsm)
                gsegei = transpose(geigse)
                gsmgei = gsmgse##gsegei ; =gsegei*gsmgse=gsmgse##gsegei
                vout = [total(gsmgei(0,*)*v,/double), $
                        total(gsmgei(1,*)*v,/double), $
                        total(gsmgei(2,*)*v,/double)]
            end
            'scs':begin
                gsmgse = transpose(gsegsm)
                gsesat = transpose(satgse)
                gsmsat = gsmgse##gsesat ; =gsesat*gsmgse=gsmgse##gsesat
                vout = [total(gsmsat(0,*)*v,/double), $
                        total(gsmsat(1,*)*v,/double), $
                        total(gsmsat(2,*)*v,/double)]
            end
            'gse':begin
                gsmgse = transpose(gsegsm)
                vout = [total(gsmgse(0,*)*v,/double), $
                        total(gsmgse(1,*)*v,/double), $
                        total(gsmgse(2,*)*v,/double)]
            end
            'gsm':vout=v
        endcase
    end
    'mag':begin
        case vtype_out of
            'sm':begin
                vout = [total(magsm(0,*)*v,/double), $
                        total(magsm(1,*)*v,/double), $
                        total(magsm(2,*)*v,/double)]
            end
            else:message, 'Rotation matrix not defined'
        endcase
    end
    'sm':begin
        case vtype_out of
            'gse':begin
                vout = [total(smgse(0,*)*v,/double), $
                        total(smgse(1,*)*v,/double), $
                        total(smgse(2,*)*v,/double)]
            end
            else:message, 'Rotation matrix not defined'
        endcase
    end
endcase

return, vout
end
