pro ep_prep_runest, tof, st, ctype, nc, mc, gdu, qual, id, id1, id2, status

common edi_piso_onehour_common, btime1,btime2,atime0,atime1,t1,t1m2,VAX1,VAY1,VAX2,VAY2,I1,I2,SQ1,SQ2,E_INDEX,NNN,mm,code_type,sob,limhi,limlo,cnum,inmodstr,mxch1,mxch2

common ep_envar_con_cb

;    tof =                       ; time of flight in micro-s
;    st =                        ; beamtime in seconds since 1.1.1970
;    ctype =                     ; correlator code type (0=short)
;    nc =                        ; correlator n (1,2,4,8,16,32,64)
;    mc =                        ; correlator m (16,8,4,2 )
;    gdu =                       ; Gun/Det-Unit #
;    qual =                      ; beam quality (1,2, or 3)

ntot = n_elements(btime1)
status = 0                      ; Fail
tof_scale = 1.e3/59.6046	; convert (by dividing) tof in 59.6-ns to tof in mics (NOS)

id1 = where(btime1 ne pp_rfill and $ ; Filter on DET1 quantities
            sq1 ge pp_qual_min and $ ; NOTE: qual=1 is OK here! Hans' routines can handle it.
            mxch1 eq 7)

id2 = where(btime2 ne pp_rfill and $ ; Filter on DET2 quantities
            sq2 ge pp_qual_min and $ ; NOTE: qual=1 is OK here! Hans' routines can handle it.
            mxch2 eq 7)

tof = 0.
st = 0.d0
ctype = 0
nc = 0
mc = 0
gdu = 0
qual = 0
id = -1L

if (id2(0) ne -1) then begin    ; Det2/Gun1
    id2 = id2(sort(btime2(id2))) ; This MUST be sorted here, 
                                ;  or ep_analyze_runest.pro will be
                                ;  screwed up...
    tof = [tof,(t1(id2) - t1m2(id2))/tof_scale]
    st = [st,btime2(id2)]
    ctype = [ctype,code_type(id2)]
    nc = [nc,nnn(id2)]
    mc = [mc,mm(id2)]
    gdu = [gdu,make_array(n_elements(id2),/int,value=1)]
    qual = [qual,sq2(id2)]
    id = [id,id2+ntot]          ; To ensure uniqueness, add ntot
endif

if (id1(0) ne -1) then begin    ; Det1/Gun2
    id1 = id1(sort(btime1(id1)))
    tof = [tof,t1(id1)/tof_scale]
    st = [st,btime1(id1)]
    ctype = [ctype,code_type(id1)]
    nc = [nc,nnn(id1)]
    mc = [mc,mm(id1)]
    gdu = [gdu,make_array(n_elements(id1),/int,value=2)]
    qual = [qual,sq1(id1)]
    id = [id,id1]
endif

n = n_elements(tof)
if (n gt 1) then begin
    status = 1                  ; Success
    tof = tof(1:n-1)
    st = st(1:n-1)
    ctype = ctype(1:n-1)
    nc = nc(1:n-1)
    mc = mc(1:n-1)
    gdu = gdu(1:n-1)
    qual = qual(1:n-1)
    id = id(1:n-1)
endif

return
end
