pro ep_prep_iff_data_write, ep_out, sout, bv2, bmag_nT

common ep_envar_con_cb

sout.status = ep_out.status
sout.method = ep_out.method
sout.out(0:n_elements(ep_out.out)-1) = ep_out.out
sout.class(0:n_elements(ep_out.class)-1) = ep_out.class
sout.used(0:n_elements(ep_out.used)-1) = ep_out.used

if (sout.status le 9) then begin ; Successful
    
    sout.v_out = ep_out.v_gse
    sout.e_out = ep_out.e_gse
    sout.e_out2 = ep_out.e_scs_earthframe
    sout.e_out3 = ep_out.e_dsi_scframe
    sout.e_out4 = ep_out.e_dsi_earthframe
    sout.drift_step = ep_out.d
    sout.nbeam_usd = ep_out.nbeam_usd
    sout.d_error_inertial = ep_out.magd_error_inertial
    sout.phi_error_inertial = ep_out.phid_error_inertial
    
    if (ep_out.method eq 0) then begin ; TRI
        sout.rchi2 = ep_out.rchi2_FG 
        sout.sbyte5 = long(ep_out.derr2/ep_out.d*100.) < 254 ; Byte-type
        sout.sbyte6 = long(ep_out.perr2) < 254 ; Byte-type
    endif else begin            ; TOF
        sout.rchi2 = -1.
        sout.sbyte5 = long(ep_out.derr/ep_out.d*100.) < 254 ; Byte-type
        sout.sbyte6 = long(ep_out.perr3) < 254 ; Byte-type
    endelse
    
; S-byte 0, Quality
    
    if (pp_qual_assign_meth eq 0) then begin
        
        ep_assign_quality_0, ep_out, sout
        
    endif else begin
; Triangulation -----------------------------------------
        if (ep_out.method eq 0) then begin
            
;010325        if (sout.rchi2 gt 20 or $
;010325            sout.sbyte5 gt 100 or $
;010325            bv2 gt 2e-3 or $
;010325            bmag_nT lt 50) then $
;010325          sout.sbyte0 = 0 else $ ; 'BAD'
;010325          if (sout.rchi2 lt 5 and $
;010325              sout.sbyte5 lt 30 and $
;010325              bv2 le 2e-3 and $
;010325              bmag_nT ge 50) then $
;010325          sout.sbyte0 = 2 else $ ; 'GOOD'
;010325          sout.sbyte0 = 1       ; 'CAUTION'
            
            if (sout.rchi2 gt 20 or $
                sout.sbyte5 gt 100) then $
              sout.sbyte0 = 0 else $ ; 'BAD'
              if (sout.rchi2 lt 5 and $
                  sout.sbyte5 lt 30) then $
              sout.sbyte0 = 2 else $ ; 'GOOD'
              sout.sbyte0 = 1   ; 'CAUTION'
            
; Poorman's ToF -----------------------------------------
        endif else if (ep_out.method eq 1) then begin
            
;010325        if (sout.sbyte5 gt 100 or $
;010325            bv2 gt 2e-3 or $
;010325            bmag_nT lt 50) then $
;010325          sout.sbyte0 = 0 else $ ; 'BAD'
;010325          if (sout.sbyte5 lt 30 and $
;010325              bv2 le 2e-3 and $
;010325              bmag_nT ge 50) then $
;010325          sout.sbyte0 = 2 else $ ; 'GOOD'
;010325          sout.sbyte0 = 1       ; 'CAUTION'
            
            if (sout.sbyte5 gt 100) then $
              sout.sbyte0 = 0 else $ ; 'BAD'
              if (sout.sbyte5 lt 30) then $
              sout.sbyte0 = 2 else $ ; 'GOOD'
              sout.sbyte0 = 1   ; 'CAUTION'
            
; Simultan or Richman's ToF ------------------------------------------
        endif else begin        ; method=2 is SMT, method=3 is RMT
            
;010325        if (sout.sbyte5 gt 100 or $
;010325            bv2 gt 2e-3) then $
;010325          sout.sbyte0 = 0 else $ ; 'BAD'
;010325          if (sout.sbyte5 lt 30 and $
;010325              bv2 le 2e-3) then $
;010325          sout.sbyte0 = 2 else $ ; 'GOOD'
;010325          sout.sbyte0 = 1       ; 'CAUTION'
            
            if (sout.sbyte5 gt 100) then $
              sout.sbyte0 = 0 else $ ; 'BAD'
              if (sout.sbyte5 lt 30) then $
              sout.sbyte0 = 2 else $ ; 'GOOD'
              sout.sbyte0 = 1   ; 'CAUTION'
        endelse
        
    endelse
    
; S-byte 1 and S-byte 2 are defined in edi_piso.pro
    
; S-byte 3
;
; If Bits 0-4 aren't set, then pp_method = 0 -- Forced TRI
; Bit 0 set if pp_method = 1 -- TRI/PMT/SMT examined - Logic Chain 1
; Bit 1 set if pp_method = 2 -- Forced TOF
; Bit 2 set if pp_method = 3 -- TRI/PMT/SMT examined - Logic Chain 2
; Bit 3 set if pp_method = 4 -- TRI/PMT/SMT examined - Logic Chain 3
; Bit 4 set if pp_method = 5 -- Forced SMT
; Bit 0 and Bit 1 set if pp_method = 6 -- Forced PMT/SMT (SMT result
;                                         preferred)
; Bit 0 and Bit 2 set if pp_method = 7 -- TRI/RMT examined
; Bit 0 and Bit 3 set if pp_method = 8 -- Forced RMT
; Bit 0 and Bit 4 set if pp_method = 9 -- Both methods forced
;
; If Bits 5-6 aren't set, then method used in the end was Triangulation (TRI)
; Bit 5 set if method used in the end was Poorman's ToF (PMT)
; Bit 6 set if method used in the end was Simultan ToF (SMT)
; Bit 5 and 6 set if method used in the end was Richman's ToF (RMT)
;
; Bit 7:  Not set = No 180-degree ambiguity in drift step
;         Set     = 180-degree ambiguity exists
    
    sum = 0
    if (pp_method eq 1) then sum = sum + 1
    if (pp_method eq 2) then sum = sum + 2
    if (pp_method eq 3) then sum = sum + 4
    if (pp_method eq 4) then sum = sum + 8
    if (pp_method eq 5) then sum = sum + 16
    if (pp_method eq 6) then sum = sum + 1 + 2
    if (pp_method eq 7) then sum = sum + 1 + 4
    if (pp_method eq 8) then sum = sum + 1 + 8
    if (pp_method eq 9) then sum = sum + 1 + 16

    if (ep_out.method eq 1) then sum = sum + 32 ; PMT method used
    if (ep_out.method eq 2) then sum = sum + 64 ; SMT method used
    if (ep_out.method eq 3) then sum = sum + 32 + 64 ; RMT method used
   
    if (ep_out.ambig_180) then sum = sum + 128 ; 180-degree ambiguity

    sout.sbyte3 = sum
    
; S-byte 4 = Percentage of Triangulation outliers - Which is useful
;                                                   information not
;                                                   only for TRI!  The
;                                                   other methods have
;                                                   this type of
;                                                   outlier removal
;                                                   also (except RMT)

    ntot = n_elements(ep_out.out)
    nid = where(ep_out.out eq 2) ; Triangulation outliers
    if (nid(0) ne -1) then $
      sout.sbyte4 = long(n_elements(nid)/float(ntot)*100.) else $
      sout.sbyte4 = 0
    
endif

return
end
