pro ep_param_errors_orig, rd, $
                          yestof, rarr, parr, tarr, ibest, $
                          pd, resop, $
                          tg, resot, $
                          farr, garr, fgchi, $
                          nr, np, nt, $
                          rderr, pderr, tgerr ; OUT
                          
rmin= rarr(0,0,0)
rmax= rarr(nr-1,0,0)
pmin= parr(0,0,0)
pmax= parr(0,np-1,0)
tmin= tarr(0,0,0)
tmax= tarr(0,0,nt-1)

irbest= ibest mod nr
ipbest= (ibest-irbest)/nr mod np
itbest= (ibest-irbest-ipbest*nr)/nr/np

if rd eq rmin or rd eq rmax then begin
    yestof = -5
    return
endif else begin
    rderr = (rarr(ibest+1) - rd)/2
endelse
if pd eq pmin or pd eq pmax then begin
    yestof = -6
    return
endif else begin
    pderr = resop/2
endelse
if yestof then begin
    if tg eq tmin or tg eq tmax then begin
        yestof = -7
        return
    endif else begin
        tgerr = resot/2
    endelse
endif else begin
    tgerr = -1e9
endelse

conlevel = 1.

; Define the surface to use to estimate the errors in driftstep
; magnitude and angle (and tgyro if ToF is on)
surf = farr+garr
surfmin = fgchi

confid = where(surf-surfmin le conlevel)
confidf = where(surf(*,*,itbest)-surfmin le conlevel)
rderr = max([max(rarr(confid))-rd, rd-min(rarr(confid)), rderr])
pderr = max([max(parr(confid))-pd, pd-min(parr(confid)), pderr])

if rmax-rd ge rd-rmin then begin
    chi = min( surf(nr-1,*,*) ) - surfmin
    if chi lt conlevel then rderr = (rmax-rd) / sqrt(chi)
endif else begin
    chi = min( surf(   0,*,*) ) - surfmin
    if chi lt conlevel then rderr = (rd-rmin) / sqrt(chi)
endelse
if pmax-pd ge pd-pmin then begin
    chi = min( surf(*,np-1,*) ) - surfmin
    if chi lt conlevel then pderr = (pmax-pd) / sqrt(chi)
endif else begin
    chi = min( surf(*,   0,*) ) - surfmin
    if chi lt conlevel then pderr = (pd-pmin) / sqrt(chi)
endelse
if yestof then begin
    confidg=where(surf-surfmin le conlevel and parr eq pd)
    tgerr= max( [max(tarr(confid))-tg, tg-min(tarr(confid)), tgerr] )
    if tmax-tg ge tg-tmin then begin
        chi = min( surf(*,*,nt-1) ) - surfmin
        if chi lt conlevel then tgerr = (tmax-tg) / sqrt(chi)
    endif else begin
        chi = min( surf(*,*,   0) ) - surfmin
        if chi lt conlevel then tgerr = (tg-tmin) / sqrt(chi)
    endelse
endif

return
end


