function rot_matrix_x, psi

sipsi = sin(double(psi) * !dpi/180.d0)
copsi = cos(double(psi) * !dpi/180.d0)
matrix = dblarr(3,3)
matrix(0,0) = 1.0
matrix(0,1) = 0.0
matrix(0,2) = 0.0
matrix(1,0) = 0.0
matrix(1,1) = copsi
matrix(1,2) = sipsi
matrix(2,0) = 0.0
matrix(2,1) = - sipsi
matrix(2,2) = copsi

return, matrix
end
;===========================================================
function rot_matrix_y, psi

sipsi = sin(double(psi) * !dpi/180.d0)
copsi = cos(double(psi) * !dpi/180.d0)
matrix = dblarr(3,3)
matrix(0,0) = copsi
matrix(0,1) = 0.0
matrix(0,2) = sipsi
matrix(1,0) = 0.0
matrix(1,1) = 1.0
matrix(1,2) = 0.0
matrix(2,0) = - sipsi
matrix(2,1) = 0.0
matrix(2,2) = copsi

return, matrix
end
;===========================================================
function rot_matrix_z, psi

sipsi = sin(double(psi) * !dpi/180.d0)
copsi = cos(double(psi) * !dpi/180.d0)
matrix = dblarr(3,3)
matrix(0,0) = copsi
matrix(0,1) = sipsi
matrix(0,2) = 0.0
matrix(1,0) = - sipsi
matrix(1,1) = copsi
matrix(1,2) = 0.0
matrix(2,0) = 0.0
matrix(2,1) = 0.0
matrix(2,2) = 1.0

return, matrix
end
;===========================================================
pro ep_get_haprotmat, year, mon, day, hour, minute, sec, $
                      rasc, decl, ierr, $
                      satgse=satgse, satgei=satgei, $
                      geigse=geigse, gsegsm=gsegsm, $
                      magsm=magsm, smgse=smgse, $
                      geocgse=geocgse


imjd = mjd(year, mon, day)      ; mjd.f s/w M.Hapgood
dhour = float(hour) + (float(minute) + sec/60. ) /60.0

ierr = 0L
lui = 10L
rcd = 0L
startct, lui, rcd
if (rcd eq 1000) then begin
    print, 'CLUSTRAN_DIR not defined'
    ierr = rcd
    goto, out
endif else if (rcd ne 0) then begin
    print, 'open/read statment failure for file TERMS2.DAT', rcd
    ierr = 10
    goto, out     
endif

calangle, imjd,dhour,rcd
if (rcd ne 0) then begin
    print, 'error on exit of subroutine calangle: ', rcd
    ierr = 20
    goto, out
endif

; Get the transformation matrix geoc to gse
in_sys = 'GEOC'
out_sys = 'GSE'
maktran, in_sys, out_sys, res_mat
geocgse = transpose(res_mat)    ; My own storage preference...

;     Get the transformation matrix gse to gsm
in_sys  = 'GSE'
out_sys = 'GSM'
maktran, in_sys, out_sys, res_mat
gsegsm = transpose(res_mat)     ; My own storage preference...

;     Get the transformation matrix gei to gse
in_sys  = 'GEI'
out_sys = 'GSE'
maktran, in_sys, out_sys, res_mat
geigse = transpose(res_mat)     ; My own storage preference...

;     Get the transformation matrix mag to sm
in_sys = 'MAG'
out_sys = 'SM'
maktran, in_sys, out_sys, res_mat
magsm = transpose(res_mat)      ; My own storage preference...

;     Get the transformation matrix sm to gse
in_sys = 'SM'
out_sys = 'GSE'
maktran, in_sys, out_sys, res_mat
smgse = transpose(res_mat)      ; My own storage preference...

;     Get the inverse of matrix gei to gse
in_sys  = 'GSE'
out_sys = 'GEI'
maktran,  in_sys, out_sys, res_mat
geigse_1 = transpose(res_mat)   ; My own storage preference...

v1 = [1.0, 0.0, 0.0]

rm1 = rot_matrix_z(90.0 - rasc)
rm2 = rot_matrix_x(90.0 - decl)
mt1 = rot_matrix_x(decl - 90.0)
mt2 = rot_matrix_z(rasc - 90.0)
mt3 = mt2##mt1                  ; Note: mt3 = mt1*mt2 = mt2##mt1
mt2 = geigse_1##mt3             ; Note: mt2 = mt3*geigse_1 = geigse_1##mt3
v2 = v1##mt2                    ; Note: v2 = mt2*v1 = v1##mt2
theta = acos(v2(0)/sqrt(v2(0)*v2(0) + v2(1)*v2(1)))* 180.0 / !pi
if (v2(1) le 0.0) then begin
    theta = 360.0 - theta
endif
rm3 = rot_matrix_z(-1.*theta)
mt1 = rm2##rm1                  ; Note: mt1 = rm1*rm2 = rm2##rm1
satgei = rm3##mt1               ; Note: satgei = mt1*rm3 = rm3##mt1
satgse = satgei##geigse         ; Note: satgse = geigse*satgei = satgei##geigse

out:

return
end
