function ep_extract_spaux_data, date, scnum, $
                                t_epoch, t_ssm, $
                                vgse_ref, pgse_ref, prel_gse, $
                                pgse, spinvec_lat_gse, spinvec_long_gse, $
                                gse2gsm_rotangle, dp_tilt, path, $
                                dr_min=dr_min, dr_max=dr_max

scnum = string(scnum,'(i1.1)')
f = findfile(path+'/CL_SP_AUX_'+date+'_V??.cdf')
if (f(0) eq '') then begin
    message, 'CL_SP_AUX CDF file not found for this date: '+path+'/cl_sp_aux_'+date+'_v??.cdf', /cont
    return, 0
endif else fname = f(n_elements(f)-1)

id = cdf_open(fname)
cdf_control, id, var='Epoch__CL_SP_AUX', get_var_info=r
nrec = r.maxrec+1

; Time records
cdf_varget, id, 'Epoch__CL_SP_AUX', t_epoch, rec_start=0, rec_count=nrec
t_epoch = reform(t_epoch)
year = long(strmid(date,0,4))
month = long(strmid(date,4,2))
day = long(strmid(date,6,2))
cdf_epoch, epoch_midnight, year, month, day, 0, 0, 0, 0, /compute_epoch
t_ssm = reform((t_epoch - epoch_midnight)/1000.d0) ; ssm

; Minimum relative SC distance
cdf_varget, id, 'sc_dr_min__CL_SP_AUX', dr_min, $
  rec_start=0, rec_count=nrec
dr_min = reform(dr_min)

; Maximum relative SC distance
cdf_varget, id, 'sc_dr_max__CL_SP_AUX', dr_max, $
  rec_start=0, rec_count=nrec
dr_max = reform(dr_max)

; Velocity in GSE of reference spacecraft, km/s
cdf_varget, id, 'sc_v_xyz_gse__CL_SP_AUX', vgse_ref, $
  rec_start=0, rec_count=nrec

; Position in GSE of reference spacecraft, km
cdf_varget, id, 'sc_r_xyz_gse__CL_SP_AUX', pgse_ref, $
  rec_start=0, rec_count=nrec

; Position in GSE of SC relative to the reference spacecraft, km
cdf_varget, id, 'sc_dr'+scnum+'_xyz_gse__CL_SP_AUX', pgse_rel, $
  rec_start=0, rec_count=nrec
prel_gse = pgse_rel

; Position in GSE of SC, km
pgse = pgse_ref + pgse_rel

; Spin-vector latitude of SC in GSE, [-90,90] degrees, angle from
; ecliptic plane
cdf_varget, id, 'sc_at'+scnum+'_lat__CL_SP_AUX', spinvec_lat_gse, $
  rec_start=0, rec_count=nrec
spinvec_lat_gse = reform(spinvec_lat_gse)

; Spin-vector longitude of SC in GSE, [0,360] degrees, angle from x in
; x-y GSE plane
cdf_varget, id, 'sc_at'+scnum+'_long__CL_SP_AUX', spinvec_long_gse, $
  rec_start=0, rec_count=nrec
spinvec_long_gse = reform(spinvec_long_gse)

; Rotation angle from GSE to GSM, [-90,90] degrees, positive from +z
; towards +y
cdf_varget, id, 'gse_gsm__CL_SP_AUX', gse2gsm_rotangle, $
  rec_start=0, rec_count=nrec
gse2gsm_rotangle = reform(gse2gsm_rotangle)

; Dipole tilt in GSM z-x plane , [-90,90] degrees, positive from +z
; towards +x
cdf_varget, id, 'dipole_tilt__CL_SP_AUX', dp_tilt, $
  rec_start=0, rec_count=nrec
dp_tilt = reform(dp_tilt)

cdf_close, id
    
return, 1
end
