function ep_extract_att, sc_number, t70_in, declin, rascen, hpath

common ep_extract_att_cb, saved_declin, saved_rascen, saved_tstart, saved_tend

; t70_in can be a scalar or a 1-d array, and must be in
; PICK-recognized t70 units:  
;              Decimal seconds since 01-Jan-1970 00:00:00.000

; declin and rascen which are returned are in GEI coordinates.

; SATT history file naming:
; /nfs/cl1/att_orb/satt.cl[1,2,3,4]

; SATT auxilliary file naming (e.g. for SC #N):
; /data7/gcdc/rdda/clusterN/aux_N/YYMMDDga.nvN
;               n = # of CD-ROM
;               v = Version of CD-ROM

ntime = n_elements(t70_in)
sztime = size(t70_in)
if (sztime(0) eq 0) then begin
    t70_start = t70_in
    t70_end = t70_in
endif else begin
    t70_start = t70_in(0)
    t70_end = t70_in(ntime-1)
endelse

; CHECK THE COMMON BLOCK FIRST!!!!
nsaved = n_elements(saved_declin)
for isave=0,nsaved-1 do begin
    if ( (t70_start ge saved_tstart(isave)) and  $
         (t70_end le saved_tend(isave)) ) then begin
        
        if (sztime(0) eq 0) then begin
            declin = saved_declin(isave)
            rascen = saved_rascen(isave)
        endif else begin
            declin = make_array(ntime,/float,value=saved_declin(isave))
            rascen = make_array(ntime,/float,value=saved_rascen(isave))
        endelse
        
        return, 1
    endif
endfor

satt_format = '((i2,1x),(a1,1x),(a20,1x),(a20,1x),(f6.2,1x),(f6.2,1x),(f9.6,1x),(f7.3,1x),3(f5.1,1x),(f5.2,1x),(f5.2,1x),(a20))'

dum = ''
;01 R 2000-08-20T01:21:10Z 2000-08-22T04:00:01Z  70.98 -65.98 15.141621 333.926 761.6  -0.2   0.1  0.00  0.05 2000-08-25T09:15:11Z
;01 R 2003-04-13T14:36:15Z 2003-04-28T14:36:15Z 103.67 -64.81 14.950856 333.932 759.4  -0.1   0.1 -0.01  0.06 2003-04-14T09:11:58Z
scid = 0
type = ''
stime = ''
etime = ''
ras = 0.
dec = 0.
rate = 0.
phase = 0.
com1 = 0.
com2 = 0.
com3 = 0.
a1 = 0.
a2 = 0.
gtime = ''

; Initialization
t70_s = t70_end & tstring_s = ''
t70_e = t70_start & tstring_e = ''
dec = -1e31 & ras = -1e31

;openr, unit, '/nfs/cl1/att_orb/satt.cl'+sc_number, /get_lun
openr, unit, hpath+'/satt.cl'+sc_number, /get_lun

while not eof(unit) do begin
    
; Save everybody before the next read
    t70_s_save = t70_s & tstring_s_save = tstring_s
    t70_e_save = t70_e & tstring_e_save = tstring_e
    dec_save = dec & ras_save = ras

;===================================================================
;===================================================================
; Read the next line
    readf, unit, dum
    reads, dum, scid, type, stime, etime, ras, dec, rate, phase, $
      com1, com2, com3, a1, a2, gtime, format=satt_format

; Valid interval start time
    tstring_s = $
      date2datevax(strmid(stime,0,4)+strmid(stime,5,2)+strmid(stime,8,2)) + $
      ' ' + strmid(stime,11,8)+'.000'
    pick_cvt_str_sec, tstring_s, t70
    t70_s = double(t70(0)) + double(t70(1))/1d6 ; decimal t70
    
; Valid interval end time
    tstring_e = $
      date2datevax(strmid(etime,0,4)+strmid(etime,5,2)+strmid(etime,8,2)) + $
      ' ' + strmid(etime,11,8)+'.000'
    pick_cvt_str_sec, tstring_e, t70
    t70_e = double(t70(0)) + double(t70(1))/1d6 ; decimal t70

;    print, 't70_s: ', ep_time_handler(t70_s,'t70','vax_string')
;    print, 't70_e: ', ep_time_handler(t70_e,'t70','vax_string')
;===================================================================
;===================================================================

; Check if we need to continue reading
    if (t70_s ge t70_start) then begin ; Gone one too far, check the save set
        
;        print, 't70_start: ', ep_time_handler(t70_start,'t70','vax_string')
;        print, 't70_s: ',  ep_time_handler(t70_s,'t70','vax_string')

        if (t70_s_save le t70_start) then begin
            
            if (t70_e_save ge t70_end) then begin
                free_lun, unit
;                message, $
;                  'One GEI spin-vector found: ', /cont
;                message, tstring_s_save+' - '+tstring_e_save, /cont
                if (sztime(0) eq 0) then begin
                    declin = dec_save
                    rascen = ras_save
                endif else begin
                    declin = make_array(ntime,/float,value=dec_save)
                    rascen = make_array(ntime,/float,value=ras_save)
                endelse
                saved_declin = dec_save
                saved_rascen = ras_save
                saved_tstart = t70_s_save
                saved_tend = t70_e_save
                return, 1
            endif else begin
                if (t70_e ge t70_end) then begin
                    free_lun, unit
;                    message, $
;                      'Two GEI spin-vectors found: ', /cont
;                    message, tstring_s_save+' - '+tstring_e_save, /cont
;                    message, tstring_s+' - '+tstring_e, /cont
                    
                    t70_s_all = [t70_s_save,t70_s]
                    t70_e_all = [t70_e_save,t70_e]
                    dec_all = [dec_save,dec]
                    ras_all = [ras_save,ras]
                    
                    declin = make_array(ntime,/float,value=-1e31)
                    rascen = make_array(ntime,/float,value=-1e31)
                    
                    for ii=0,n_elements(t70_s_all)-1 do begin
                        id = where(t70_in ge t70_s_all(ii) and $
                                   t70_in lt t70_e_all(ii))
                        if (id(0) ne -1) then begin
                            declin(id) = dec_all(ii)
                            rascen(id) = ras_all(ii)
                        endif
                    endfor
                    saved_declin =  [dec_save,dec]
                    saved_rascen = [ras_save,ras]
                    saved_tstart = [t70_s_save,t70_s]
                    saved_tend = [t70_e_save,t70_e]

                    return, 1
                endif else begin
;                    message, $
;                      'More than 2 GEI spin-vectors found: ', /cont
;                    message, tstring_s_save+' - '+tstring_e_save, /cont
;                    message, tstring_s+' - '+tstring_e, /cont
                    
                    t70_s_all = [t70_s_save,t70_s]
                    t70_e_all = [t70_e_save,t70_e]
                    dec_all = [dec_save,dec]
                    ras_all = [ras_save,ras]
                    
                    while (not eof(unit) and $
                           (t70_e lt t70_end)) do begin
                        
;===================================================================
;===================================================================
; Read the next line
                        readf, unit, dum
                        reads, dum, scid, type, stime, etime, $
                          ras, dec, rate, phase, $
                          com1, com2, com3, a1, a2, gtime, format=satt_format
                        
; Valid interval start time
                        tstring_s = date2datevax(strmid(stime,0,4)+ $
                                                 strmid(stime,5,2)+ $
                                                 strmid(stime,8,2)) + $
                          ' ' + strmid(stime,11,8)+'.000'
                        pick_cvt_str_sec, tstring_s, t70
                        t70_s = double(t70(0)) + $
                          double(t70(1))/1d6 ; decimal t70
                        
; Valid interval end time
                        tstring_e = date2datevax(strmid(etime,0,4)+ $
                                                 strmid(etime,5,2)+ $
                                                 strmid(etime,8,2)) + $
                          ' ' + strmid(etime,11,8)+'.000'
                        pick_cvt_str_sec, tstring_e, t70
                        t70_e = double(t70(0)) + $
                          double(t70(1))/1d6 ; decimal t70
;===================================================================
;===================================================================
;                        message, tstring_s+' - '+tstring_e, /cont
                        
                        t70_s_all = [t70_s_all,t70_s]
                        t70_e_all = [t70_e_all,t70_e]
                        dec_all = [dec_all,dec]
                        ras_all = [ras_all,ras]
                        
                    endwhile
                    free_lun, unit
                    
; Check to see that the eof wasn't reached before t70_end was exceeded
                    if (t70_e lt t70_end) then begin
                        message, 'Time interval requested not fully described by the SATT history files: FAIL', /cont
                        return, 0
                    endif else begin
                        declin = make_array(ntime,/float,value=-1e31)
                        rascen = make_array(ntime,/float,value=-1e31)
                        
                        for ii=0,n_elements(t70_s_all)-1 do begin
                            id = where(t70_in ge t70_s_all(ii) and $
                                       t70_in lt t70_e_all(ii))
                            if (id(0) ne -1) then begin
                                declin(id) = dec_all(ii)
                                rascen(id) = ras_all(ii)
                            endif
                        endfor

                        saved_declin =  dec_all
                        saved_rascen = ras_all
                        saved_tstart = t70_s_all
                        saved_tend = t70_e_all

                        return, 1

                    endelse
                    
                endelse
            endelse
            
        endif

    endif
    
endwhile

free_lun, unit

;===================================================================
; Check for the possibility that you have read the LAST record, and
; this is the one you need (code above assumes that you always
; overshoot, and then go back.  This was an oversight.)
;===================================================================
if (t70_s le t70_start) then begin            
    
    if (t70_e ge t70_end) then begin
        
        if (sztime(0) eq 0) then begin
            declin = dec
            rascen = ras
        endif else begin
            declin = make_array(ntime,/float,value=dec)
            rascen = make_array(ntime,/float,value=ras)
        endelse
        saved_declin = dec
        saved_rascen = ras
        saved_tstart = t70_s
        saved_tend = t70_e
        return, 1
        
    endif else begin
        message, 'Time interval requested not fully described by the SATT history files: FAIL', /cont
        return, 0
    endelse
    
endif    

; Not even the last record?  Ok, then I can't return any information
message, 'Time interval requested not fully described by the SATT history files: FAIL', /cont
return, 0

end
