#-------------------------------------------------------
# Source the paths for this machine
source ${EP_CODE_PATH}/ep_${EDI_PISO_MACHINE}_paths.csh

#-------------------------------------------------------
# Set difference map (don't change).
setenv EDI_PISO_DM DM03

#-------------------------------------------------------
# Set to write to the IFFALL file every hour instead of every spin (default)
setenv EDI_PISO_IFF_HOURLY 0

#-------------------------------------------------------
# Must set whether or not you want to save the FGM files
setenv EDI_PISO_FGM_SAVE 1

#-------------------------------------------------------
# Diagnostics keywords (run-time plots, for PPQ)
setenv EDI_PISO_KEYPLOT3 0
setenv EDI_PISO_KEYPLOT4 0

#-------------------------------------------------------
# Must set whether or not you want to write the aux file
setenv EDI_PISO_WRITE_AUX 1

#-------------------------------------------------------
# Must set whether or not you want to write the archive CDF file
setenv EDI_PISO_WRITE_CDF 1

#-------------------------------------------------------
# IFF file name - If set, the IFFALL filename will have the
# same form as the AUX, PSTAT and LOG filenames. Otherwise it
# has the standardized name used by the GCDC
setenv EDI_PISO_LONG_IFFNAME 1

#-------------------------------------------------------
# PP-Plus file name - If set, the PP-Plus filename will have the
# same form as the AUX, PSTAT and LOG filenames. Otherwise it
# has the standardized name used by the GCDC
setenv EDI_PISO_LONG_PPPLUSNAME 1

#-------------------------------------------------------
# Set various EDI_PISO control parameters.
# First load all of the defaults.  If you want to change
# any of them, just do so where indicated below.
# All of the control parameters are documented in:
#             ${EDI_PISO_DM}_DEF.txt
source ${EP_CODE_PATH}/edi_piso_pp_defaults.csh

#-------------------------------------------------------
# Change any of the environment variables here:
# e.g. :
#        setenv pp_nchunk 2

#setenv pp_edidsi_inertial_out 1

#-------------------------------------------------------
# Setting the 'finfo' (file information) and 
# 'tinfo' (time information) variable arrays:
#
# 3 POSSIBLE finfo FORMS:
#    cl2_2000-10-05t15_54_00z.nsd
#    cl2_2000-10-05t15_54_00z.bsd
#    cl2_2000-10-05t00_00_00z.msf
#
# NOTE: For the 'nsd' and 'bsd' types, finfo
#       specifies the exact file to be used.  For the 'msf'
#       type, the '00_00_00' is just a place holder and is
#       not used for anything.
#
#       For either case, you must additionally specify
#       'tinfo' (start and end time string, see below)
#       It has the form HH_MM_SS-HH_MM_SS. It must be set for
#       every file listed in the 'finfo' variable.
#
#       If you want to use all of the data in the file, 
#       (for example if you don't know the time range
#       available within the file) just set tinfo to ALL.
#-------------------------------------------------------

# Quality assignment test cases
set tinfo = (12_00_00-16_00_00 22_00_00-24_00_00 11_00_00-12_00_00 18_30_00-23_00_00 07_00_00-24_00_00)
set finfo = (cl1_2001-03-09t00_00_00z.msf cl3_2001-07-04t00_00_00z.msf cl3_2001-08-13t00_00_00z.msf cl3_2001-09-12t00_00_00z.msf cl3_2001-09-22t00_00_00z.msf)

set tinfo = (07_04_12-07_04_20)
set finfo = (cl3_2001-09-22t00_00_00z.msf)

set tinfo = (13_00_00-13_05_00)
set finfo = (cl1_2001-10-09t00_00_00z.msf)

#set tinfo = (23_00_00-24_00_00)
#set finfo = (cl3_2001-10-09t00_00_00z.msf)

#set tinfo = (03_00_00-03_05_00)
#set finfo = (cl3_2001-10-09t00_00_00z.msf)

set tinfo = (ALL)
set finfo = (cl1_2002-03-12t00_00_00z.msf)

# One-detector test
set tinfo = (04_30_00-05_37_00)
set finfo = (cl1_2002-09-20t00_00_00z.msf)

# ep_hav_sorter.pro problem
#set tinfo = (08_12_00-09_00_00)
#set finfo = (cl1_2002-06-27t00_00_00z.msf)

# MSF paths test
set tinfo = (ALL)
set finfo = (cl1_2001-05-30t00_00_00z.msf)

# 7th bit of SOB test
set tinfo = (ALL)
set finfo = (cl3_2001-08-16t00_00_00z.msf)

# One-detector test
set tinfo = (04_30_00-05_37_00)
set finfo = (cl1_2002-09-20t00_00_00z.msf)

set tinfo = (ALL)
set finfo = (cl1_2003-04-14t00_00_00z.msf)

# EDI/EFW Comparison paper
set tinfo = (12_00_00-24_00_00)
set finfo = (cl3_2001-02-13t00_00_00z.msf)

# Ground software changes/diagnostics
set tinfo = (07_20_25-07_25_00)
set finfo = (cl1_2001-03-05t00_00_00z.msf)

set tinfo = (20_00_00-22_00_00 09_00_00-11_00_00 06_00_00-09_00_00 06_30_00-08_30_00 ALL)
set finfo = (cl3_2001-02-13t00_00_00z.msf cl3_2002-03-23t00_00_00z.msf cl1_2001-03-05t00_00_00z.msf cl3_2002-04-13t00_00_00z.msf cl3_2001-07-04t00_00_00z.msf)

set tinfo = (20_00_00-22_00_00)
set finfo = (cl3_2001-02-13t00_00_00z.msf)

set tinfo = (07_20_00-07_25_00)
set finfo = (cl1_2001-03-05t00_00_00z.msf)

set tinfo = (07_12_00-07_18_00)
set finfo = (cl3_2001-03-05t00_00_00z.msf)

set tinfo = (07_12_00-07_18_00)
set finfo = (cl1_2001-03-05t00_00_00z.msf)

set tinfo = (00_05_00-00_10_00)
set finfo = (cl1_2001-03-05t00_00_00z.msf)

set tinfo = (06_30_00-08_30_00)
set finfo = (cl3_2002-04-13t00_00_00z.msf)

set tinfo = (08_05_04-08_30_00)
set finfo = (cl1_2001-03-05t00_00_00z.msf)

set tinfo = (22_00_00-23_00_00)
set finfo = (cl3_2001-03-21t00_00_00z.msf)

#set tinfo = (22_24_12-22_24_32)
#set finfo = (cl3_2001-03-21t00_00_00z.msf)

set tinfo = (22_48_00-22_50_00)
set finfo = (cl3_2001-03-21t00_00_00z.msf)

set tinfo = (22_00_00-23_00_00)
set finfo = (cl3_2001-03-21t00_00_00z.msf)

set tinfo = (22_00_05-23_00_00)
set finfo = (cl3_2001-03-21t00_00_00z.msf)

set tinfo = (22_00_10-22_00_20)
set finfo = (cl3_2001-03-21t00_00_00z.msf)


# HAV/GEP Orleans cases

set tinfo = (06_00_00-16_00_00 20_00_00-24_00_00 09_00_00-14_00_00 07_00_00-12_00_00 06_00_00-09_00_00 ALL ALL 12_00_00-24_00_00 05_00_00-24_00_00 07_00_00-15_00_00 07_00_00-15_00_00)

set finfo = (cl3_2002-07-01t00_00_00z.msf cl3_2001-03-04t00_00_00z.msf cl2_2002-03-30t00_00_00z.msf cl3_2002-03-23t00_00_00z.msf cl1_2001-03-05t00_00_00z.msf cl2_2001-07-04t00_00_00z.msf cl3_2001-07-04t00_00_00z.msf cl3_2001-09-23t00_00_00z.msf cl3_2001-10-09t00_00_00z.msf cl2_2002-04-13t00_00_00z.msf cl3_2002-04-13t00_00_00z.msf)

set tinfo = (05_30_00-08_30_00)
set finfo = (cl3_2002-04-13t00_00_00z.msf)

set tinfo = (02_05_00-03_05_00)
set finfo = (cl1_2001-07-14t00_00_00z.msf)

set tinfo = (ALL)
set finfo = (cl2_2003-10-29t00_00_00z.msf)

set tinfo = (11_10_00-11_17_00)
set finfo = (cl3_2003-04-17t00_00_00z.msf)

#set tinfo = (02_10_00-02_30_00)
#set finfo = (cl1_2001-07-14t00_00_00z.msf)

set tinfo = (00_00_00-01_00_00)
set finfo = (cl1_2001-02-26t00_00_00z.msf)

set tinfo = (00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 00_00_00-00_10_00 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59 23_50_00-23_59_59)

set finfo = (cl1_2001-02-26t00_00_00z.msf cl1_2001-08-06t00_00_00z.msf cl1_2001-09-12t00_00_00z.msf cl1_2001-10-18t00_00_00z.msf cl1_2001-11-21t00_00_00z.msf cl1_2001-12-21t00_00_00z.msf cl1_2002-02-11t00_00_00z.msf cl1_2002-03-09t00_00_00z.msf cl1_2002-07-09t00_00_00z.msf cl1_2003-07-13t00_00_00z.msf cl1_2003-07-14t00_00_00z.msf cl1_2003-08-06t00_00_00z.msf cl1_2003-08-07t00_00_00z.msf cl1_2004-02-08t00_00_00z.msf cl2_2001-02-26t00_00_00z.msf cl2_2001-08-13t00_00_00z.msf cl2_2001-09-25t00_00_00z.msf cl2_2001-09-28t00_00_00z.msf cl2_2001-11-13t00_00_00z.msf cl2_2001-11-21t00_00_00z.msf cl2_2002-02-11t00_00_00z.msf cl2_2002-03-09t00_00_00z.msf cl3_2001-02-26t00_00_00z.msf cl3_2001-08-06t00_00_00z.msf cl3_2001-09-25t00_00_00z.msf cl3_2001-11-13t00_00_00z.msf cl3_2002-02-11t00_00_00z.msf cl3_2002-07-09t00_00_00z.msf cl3_2002-09-01t00_00_00z.msf cl3_2004-02-08t00_00_00z.msf cl1_2001-02-26t00_00_00z.msf cl1_2001-08-06t00_00_00z.msf cl1_2001-09-12t00_00_00z.msf cl1_2001-10-18t00_00_00z.msf cl1_2001-11-21t00_00_00z.msf cl1_2001-12-21t00_00_00z.msf cl1_2002-02-11t00_00_00z.msf cl1_2002-03-09t00_00_00z.msf cl1_2002-07-09t00_00_00z.msf cl1_2003-07-13t00_00_00z.msf cl1_2003-07-14t00_00_00z.msf cl1_2003-08-06t00_00_00z.msf cl1_2003-08-07t00_00_00z.msf cl1_2004-02-08t00_00_00z.msf cl2_2001-02-26t00_00_00z.msf cl2_2001-08-13t00_00_00z.msf cl2_2001-09-25t00_00_00z.msf cl2_2001-09-28t00_00_00z.msf cl2_2001-11-13t00_00_00z.msf cl2_2001-11-21t00_00_00z.msf cl2_2002-02-11t00_00_00z.msf cl2_2002-03-09t00_00_00z.msf cl3_2001-02-26t00_00_00z.msf cl3_2001-08-06t00_00_00z.msf cl3_2001-09-25t00_00_00z.msf cl3_2001-11-13t00_00_00z.msf cl3_2002-02-11t00_00_00z.msf cl3_2002-07-09t00_00_00z.msf cl3_2002-09-01t00_00_00z.msf cl3_2004-02-08t00_00_00z.msf)

# 3 New HAV RunEst test
set tinfo = (11_12_00-11_15_00)
set finfo = (cl3_2003-04-17t00_00_00z.msf)

# 2005 test
set tinfo = (05_00_00-05_05_00 17_00_00-17_05_00)
set finfo = (cl1_2005-01-01t00_00_00z.msf cl3_2005-01-17t00_00_00z.msf)

exit
