pro ep_assign_winner, ieindex, saveit, $ ; IN
                      iwin, ilos, ifail ; OUT

; iwin is an index to be used for the saveit array
; i.e. the winning results are within saveit(iwin)
; iwin = -1 means that there is no winner (i.e. results had failure
; status). ilos and ifail are also to be used for the saveit array.

common ep_envar_con_cb

if (ieindex eq 0) then begin    ; 1keV
    if (pp_method ne 9) then begin
        if (saveit(0).status le 9) then iwin = 0 else iwin = -1
        ilos = -1               ; No competition
        ifail = 0               ; Only used if iwin = -1
        return
    endif else begin
        i1 = 0
        i2 = 1
    endelse
endif else begin                ; 0.5keV
    if (pp_method ne 9) then begin
        if (saveit(2).status le 9) then iwin = 2 else iwin = -1
        ilos = -1               ; No competition
        ifail = 2               ; Only used if iwin = -1
        return
    endif else begin
        i1 = 2
        i2 = 3
    endelse
endelse

if (saveit(i1).status gt 9 and saveit(i2).status gt 9) then begin
    iwin = -1
    ilos = -1
    ifail = i1                  ; Just pick one, doesn't matter (only for pstat)
endif else if (saveit(i1).status le 9 and saveit(i2).status gt 9) then begin
    iwin = i1
    ilos = -1
    ifail = -1                  ; Won't be used
endif else if (saveit(i1).status gt 9 and saveit(i2).status le 9) then begin
    iwin = i2
    ilos = -1
    ifail = -1                  ; Won't be used
endif else begin                ; Combat
    
    inds = [i1,i2]
    
    if (saveit(i1).sbyte0 ne saveit(i2).sbyte0) then begin
; No inter-quality fighting, better quality (sbyte0) wins hands down
        qualwin = max([saveit(i1).sbyte0,saveit(i2).sbyte0], i)
        iwin = inds(i)
        if (iwin eq i1) then ilos = i2 else ilos = i1
    endif else begin            ; May the bestarg win :)
; Lowest fractional error on drift step (sbyte5) wins
        dfracwin = min([saveit(i1).sbyte5,saveit(i2).sbyte5], i)
        iwin = inds(i)
        if (iwin eq i1) then ilos = i2 else ilos = i1
    endelse

    ifail = -1                  ; Won't be used

endelse

return
end
