pro edi_piso_write_spec_header, spec_unit, finfo

printf,spec_unit, '==================================================='
printf,spec_unit, "EDI_PISO software output for Brett Austin's spectrogram plots"
printf,spec_unit, 'Date created: '+systime()
printf,spec_unit, 'EDI_PISO software version: '
printf,spec_unit, 'EDI PICK software version: '
printf,spec_unit, 'RAW EDI DATA: '+finfo.raw_name
printf,spec_unit, 'SPIN-AVERAGED FGM DATA: '+finfo.mag_name
printf,spec_unit
printf,spec_unit
printf,spec_unit, 'VARIABLES ON ONE LINE: '
printf,spec_unit, 'SPIN START TIME, SPIN STOP TIME, TARGET_X [meters,GYRO], TARGET_Y [meters,GYRO]'
printf,spec_unit
printf,spec_unit
printf,spec_unit, 'FORMAT STATEMENT: '
printf,spec_unit, "format='(2(a27,2x),2(e13.6,2x)'"
printf,spec_unit
printf,spec_unit
printf,spec_unit, 'NOTES:'
printf,spec_unit, '         1) TARGET_X is in meters and the GYRO coordinate system'
printf,spec_unit, '         2) TARGET_Y is in meters and the GYRO coordinate system'
printf,spec_unit, '         3) The "GYRO" coordinates are as follows:'
printf,spec_unit, '                Z_GYRO = B_hat'
printf,spec_unit, '                X_GYRO = [0,1,0] cross Z_GYRO'
printf,spec_unit, '                Y_GYRO = Z_GYRO cross X_GYRO'
printf,spec_unit, '==================================================='


return
end
