function edi_piso_file_info, finfo, sc_number=sc_number

common ep_envar_con_cb

; Get the environment variables defined by the GCDC
date = getenv('EDI_PISO_PRODUCTION_DATE')
sc_number = getenv('EDI_PISO_SC_NUMBER')
iff_dir = getenv('GDC_OUT_DIR')
aux_dir = getenv('EDI_PISO_AUX_OUT')
log_dir = getenv('EDI_PISO_LOG_OUT')
cdf_dir = getenv('EDI_PISO_CDF_OUT')
pstat_dir = getenv('EDI_PISO_PSTAT_OUT')
config = getenv('EDI_PISO_CONFIG')
tstring = getenv('EDI_PISO_TSTRING')
fname = getenv('EDI_PISO_FNAME')
sname = getenv('EDI_PISO_SNAME')
mag_file = getenv('EDI_PISO_FGM_OUT')
tinfo = getenv('EDI_PISO_TINFO')
ncstr = string(pp_nchunk,'(i1.1)')
filename_root = getenv('EDI_PISO_FILENAME_ROOT')
if (filename_root eq 'auto') then auto=1 else auto=0

; Compare the actual versus default 'pp' control variables, and
; construct the 'DMNN' string for the aux and log filenames
ep_pp_comp, epdm_str

; Change the 'tstring' variable if the tinfo variable is set to a
; specific time.
if (tinfo ne 'ALL') then tstring = strmid(tinfo,0,8)

; Get rid of the underscores in the tstring
res = strsplit(tstring,'_',/extract)
tstring = res(0)+res(1)+res(2)

; Define the output file info structure
finfo = {date:'', $
         date_vax:'', $
         raw_name:'', $
         suf_name:'', $
         mag_name:'', $
         aux_name:'', $
         cdf_name:'', $
         ediefw_name:'', $
         edidsi_name:'', $
         edidsi_inertial_name:'', $
         pstat_name:'', $
         log_name:'', $
         log_unit:0, $
         iff_name:'', $
         config:''}

finfo.config = config
finfo.date = date

; Define the file head and file tail for: log, aux, files
if (auto) then begin
    fhead = aux_dir+'/'+date+'_'+sc_number+'_'+tstring+'_'+pp_rcs_snapshot_name+'_'+epdm_str
    fhead_log = log_dir+'/'+date+'_'+sc_number+'_'+tstring+'_'+pp_rcs_snapshot_name+'_'+epdm_str
    fhead_iff = iff_dir+'/'+date+'_'+sc_number+'_'+tstring+'_'+pp_rcs_snapshot_name+'_'+epdm_str
    fhead_pstat = pstat_dir+'/'+date+'_'+sc_number+'_'+tstring+'_'+pp_rcs_snapshot_name+'_'+epdm_str
    fhead_cdf = cdf_dir+'/'+date+'_'+sc_number+'_'+tstring+'_'+pp_rcs_snapshot_name+'_'+epdm_str
    
    ftail = config
    ftail = 'd'
endif else begin
    fhead = aux_dir+'/'+filename_root
    fhead_log = log_dir+'/'+filename_root
    fhead_iff = iff_dir+'/'+filename_root
    fhead_pstat = pstat_dir+'/'+filename_root
    fhead_cdf = cdf_dir+'/'+filename_root
    ftail = ''
endelse

; Open the log file
if (auto) then finfo.log_name = fhead_log+'_log.'+ftail else $
  finfo.log_name = fhead_log+'.log'
openw, lunit, finfo.log_name, /get_lun
finfo.log_unit = lunit

finfo.date_vax = date2datevax(date)
finfo.raw_name = fname
finfo.suf_name = sname
finfo.mag_name = mag_file
if (auto) then finfo.aux_name = fhead+'_aux.'+ftail else $
  finfo.aux_name = fhead+'.aux'
if (auto) then finfo.ediefw_name = fhead+'_ediefw.'+ftail else $
  finfo.ediefw_name = fhead+'.ediefw'
if (auto) then finfo.edidsi_name = fhead+'_edidsi.'+ftail else $
  finfo.edidsi_name = fhead+'.edidsi'
if (auto) then finfo.edidsi_inertial_name = fhead+'_edidsi_inertial.'+ftail else $
  finfo.edidsi_inertial_name = fhead+'.edidsi_inertial'
if (auto) then finfo.pstat_name = fhead_pstat+'_pstat.'+ftail else $
  finfo.pstat_name = fhead_pstat+'.pstat'

; IFF file naming
if (auto) then begin
    if (not pp_long_iffname) then begin
        if (pp_nchunk ne 1) then $
          finfo.iff_name = iff_dir+'/C'+sc_number+'_PP_EDI_'+date+'_'+ $
          ncstr+'.IFFALL' $
        else $
          finfo.iff_name = iff_dir+'/C'+sc_number+'_PP_EDI_'+date+'.IFFALL'
    endif else begin
        finfo.iff_name = fhead_iff+'_iffall.'+ftail
    endelse
endif else begin
    finfo.iff_name = fhead_iff+'.iffall'
endelse

; PP-Plus file naming
if (auto) then begin
    if (not pp_long_ppplusname) then begin
        if (pp_nchunk ne 1) then $
          finfo.cdf_name = cdf_dir+'/C'+sc_number+'_PPP_EDI_'+date+'_'+ $
          ncstr+'_V00' $        ; No extension, skeletoncdf does this
        else $
          finfo.cdf_name = cdf_dir+'/C'+sc_number+'_PPP_EDI_'+date+'_V00'
    endif else begin
        finfo.cdf_name = fhead_cdf+'_PPP'
    endelse
endif else begin
    finfo.cdf_name = fhead_cdf+'_PPP'
endelse

printf, finfo.log_unit, 'Successful file information extraction: '
printf, finfo.log_unit, 'date    :    '+finfo.date
printf, finfo.log_unit, 'date_vax:    '+finfo.date_vax
printf, finfo.log_unit, 'raw_name:    '+finfo.raw_name
printf, finfo.log_unit, 'suf_name:    '+finfo.suf_name
printf, finfo.log_unit, 'mag_name:    '+finfo.mag_name
printf, finfo.log_unit, 'aux_name:    '+finfo.aux_name
printf, finfo.log_unit, 'cdf_name:    '+finfo.cdf_name
printf, finfo.log_unit, 'ediefw_name: '+finfo.ediefw_name
printf, finfo.log_unit, 'edidsi_name: '+finfo.edidsi_name
printf, finfo.log_unit, 'edidsi_inertial_name: '+finfo.edidsi_inertial_name
printf, finfo.log_unit, 'pstat_name:  '+finfo.pstat_name
printf, finfo.log_unit, 'log_name:    '+finfo.log_name
printf, finfo.log_unit, 'log_unit:    ',finfo.log_unit
printf, finfo.log_unit, 'iff_name:    '+finfo.iff_name
printf, finfo.log_unit, 'config:      '+finfo.config

return, 1
end
