
DO NOT USE THIS SCRIPT...PLEASE USE ep_run.csh
PPQ, August 29th, 2001



#! /usr/bin/csh  
# -vx

#-------------------------------------------------------
# Set various control parameters
# (These were taken out of pp_control.pro because the
#  user might want to change these parameters without
#  having to change any of the EDI_PISO IDL code.  Those
#  parameters still in pp_control.pro should not be
#  changed by the user.)

setenv pp_gunid 0               # Allows user to specify which gun
                                # to use in the analysis:
                                #    0 = Both Guns
                                #    1 = Gun 1
                                #    2 = Gun 2

setenv pp_nbeam_min 4           # Minimum # of beams allowed
                                # in the bestarg analysis

setenv pp_qual_min 2            # only use data of this quality or higher

setenv pp_maxorder 5            # bestarg will only consider beam orders 
                                # up to and including this value

setenv pp_maxchan_min 6         # bestarg will only consider beams
                                # with maxchan >= pp_maxchan_min

setenv pp_maxchan_max 8         # bestarg will only consider beams
                                # with maxchan <= pp_maxchan_max

setenv pp_outlier_removal 0     # if 1, bestarg will perform removal
                                # of those beams statistically determined
                                # to be outliers

setenv pp_cg_phires 3.0         # Resolution of coarse grid in phi, degrees
setenv pp_fg_phires 1.0         # Resolution of fine grid in phi, degrees

setenv pp_acfir 1.0             # Uncertainty of the beam firing angle, degrees
setenv pp_actof_con 8.d0        # What the chip length is divided
                                # by in order to construct the error
                                # in the time of flight, i.e.
                                # actof = nmchip*2^(-23)/pp_actof_con*1e6,
                                # microsec.

#-------------------------------------------------------
# Set the # of 'chunks' you want the spin to be
# divided into:
#      EDI_PISO_NCHUNK = 1    4 sec. resolution
#                      = 2    2 sec. resolution
#                      = 4    1 sec. resolution

setenv EDI_PISO_NCHUNK 1

# NOTE: An IFF file will only be produced for EDI_PISO_NCHUNK = 1

#-------------------------------------------------------
# Set whether or not you want the Poorman's ToF to run
# as well as the Bestarg Triangulation only.
#      EDI_PISO_POORMAN_TOF_TOO = 0  Bestarg Tri. only
#                               = 1  Bestarg Tri. + PMT

setenv EDI_PISO_POORMAN_TOF_TOO 0

#-------------------------------------------------------
# Set the official, nominal phase offset for Cluster 
# spin interval definition as defined in the document
# "Spin Timings and Offsets for Cluster Prime Parameters"
# by Schwarz and Daly, DS-QMW-TN-0007, 1996
#         OFFSET = 75/1024 * 360 degrees
# Note: EDI_PISO software assumes that the FGM software that
# produces the spin-averaged magnetic field file uses this
# exact offset also!!!  If this number ever changes, check to
# make sure the FGM code changes it's value also!!!

setenv EDI_PISO_OFFSET 26.3671875
#-------------------------------------------------------


#-------------------------------------------------------
# Setting the 'finfo' (file information) and 
# 'tinfo' (time information) variable arrays:
#
# 3 POSSIBLE finfo FORMS:
#    cl2_2000-10-05t15_54_00z.nsd
#    cl2_2000-10-05t15_54_00z.bsd
#    cl2_2000-10-05t00_00_00z.msf
#
# NOTE: The first 28 characters for the 'nsd'
#       and 'bsd' types (i.e. cl2_2000-10-05t15_54_00z.nsd)
#       specify the exact file to be used.  For the 'msf'
#       type, the '00_00_00' is just a place holder and is
#       not used for anything.
#
#       For either case, you must additionally specify
#       'tinfo' (start and end time string, see below)
#       It has the form HH_MM_SS-HH_MM_SS. It must be set for
#       every file listed in the 'finfo' variable.
#
#       If you want to use all of the data in the file, 
#       (for example if you don't know the time range
#       available within the file) just set tinfo to ALL.
#-------------------------------------------------------
set tinfo = (17_00_00-17_10_00)
set finfo = (cl1_2001-02-23t00_00_00z.msf)

@ j = 0
foreach i ($finfo)

    @ j++

    setenv EDI_PISO_SC_NUMBER `echo $i | cut -c3-3`
    setenv EDI_PISO_TSTRING `echo $i | cut -c16-23`
    setenv EDI_PISO_TINFO $tinfo[${j}]
    
    set year = `echo $i | cut -c5-8`
    set month = `echo $i | cut -c10-11`
    set day = `echo $i | cut -c13-14`
    setenv EDI_PISO_PRODUCTION_DATE ${year}${month}${day}

    set ftype = `echo $i | cut -c26-28`

    setenv GDC_RDDA_ROOT /nfs/cl1/ # ${GDC_RDDA_ROOT}/rdda/cluster?/...
    setenv GDC_OUT_DIR ./iff_data/
    setenv EDI_PISO_AUX_OUT ./aux_data/

    if ("$ftype" == "msf") then
        set date_lite = `echo $EDI_PISO_PRODUCTION_DATE | cut -c3-8`

#--------------------------------------------------------------------------
# NOTE: This next line is written for the mpecl which must access the 
# msf data through an nfs mount to the cl1...Below this line I have
# written the path for the nominal case.  Uncomment this line if you need to.

	set msf_path = /nfs/cl1/msf_data/
#	set msf_path = ${GDC_RDDA_ROOT}/rdda/cluster${EDI_PISO_SC_NUMBER}/
#--------------------------------------------------------------------------

        set files = `ls -1 ${msf_path}/msf_${EDI_PISO_SC_NUMBER}/${date_lite}em.??${EDI_PISO_SC_NUMBER}`

        if ("${#files}" == "0") then
	    echo "MSF file not found"
	    goto next_file
	else
	    setenv EDI_PISO_FNAME $files[${#files}]
	    setenv EDI_PISO_SNAME msf
	    setenv EDI_PISO_CONFIG mpecl_msf
	endif

    else
        set ftp_fname = `echo $i | cut -c1-28`
	set ftp_path = /data2/hav/sc${EDI_PISO_SC_NUMBER}/

        set files = `ls -1 ${ftp_path}/${ftp_fname}`

        if ("${#files}" == "0") then
	    echo "FTP file not found"
	    goto next_file
	else
	    setenv EDI_PISO_FNAME $files[${#files}]
	    setenv EDI_PISO_SNAME ftp
	    setenv EDI_PISO_CONFIG mpecl_ftp
	endif
    endif

#================================================
# Create the spin-averaged FGM data file
#================================================
    setenv EDI_PISO_ATT_ORB_PATH /nfs/cl1/att_orb/
    setenv EDI_PISO_FGM_ROOT /home/eg/
    setenv EDI_PISO_FGM_OUT ./fgm_data/C${EDI_PISO_SC_NUMBER}_${EDI_PISO_PRODUCTION_DATE}_FGM_SCS_SPINRES.txt
    if (-r ${EDI_PISO_FGM_OUT}) then
        echo 'FGM file already exists'
    else
        /usr/local/bin/bash -c "./ep_prod_fgm.bash"
        if (-r ${EDI_PISO_FGM_OUT}) then
            echo 'FGM file created'
        else
            echo 'Problem creating FGM file'
            goto next_file
        endif
    endif

    idl edi_piso_wrapper

    echo "============================================"
    echo $EDI_PISO_OFFSET
    echo $EDI_PISO_PRODUCTION_DATE
    echo $EDI_PISO_SC_NUMBER
    echo $GDC_RDDA_ROOT
    echo $GDC_OUT_DIR
    echo $EDI_PISO_FGM_OUT
    echo $EDI_PISO_AUX_OUT
    echo $EDI_PISO_CONFIG
    echo $EDI_PISO_ATT_ORB_PATH
    echo $EDI_PISO_FGM_ROOT
    echo $EDI_PISO_FNAME
    echo $EDI_PISO_SNAME
    echo $EDI_PISO_TSTRING
    echo $EDI_PISO_TINFO

    next_file:

end

exit
