function div2_ctime, x, y

	; Calculates the mid-value between x(sec, microsec) and y(sec, microsec),
	;   i.e.:   z(sec, micsec) = (x(sec, microsec) + y(sec, microsec))/2
	; where x and y are ASSUMED to be equally dimensioned lonarr(2,*)
	; also allowed: x = arr(2,*), y = arr(2) 
        ; FURTHER ASSUMPTION: 0 le input-microsec le 999999
        ; ERROR: possible (intrinsic) uncertainty of +/- 0.5 microsec
	;
        ; return, z with microsec overflow properly handled

; (c) mfo@mpe.mpg.de, 25 Aug 2000 - based on the "sub_ctime.pro" by Mark Chutter

sx = size(x) & sy = size(y)

if(sx(0) EQ 1) then begin
   xstr='000000'
   strput,xstr,string(x(1),f="(I6.6)")     ; conversion of x(1) in microsecs
   x(1)=LONG(xstr)
 endif else for i=0,sx(2)-1 do begin
     xstr='000000'
     strput,xstr,string(x(1,i),f="(I6.6)") ; conversion of x(1,*) in microsecs
     x(1,i)=LONG(xstr)
endfor
         
if(sy(0) EQ 1) then begin
   yy = lonarr(sx(1),sx(2))
   yy(0,*) = y(0)
   yy(1,*) = y(1)
   ystr='000000'
   strput,ystr,string(y(1),f="(I6.6)")     ; conversion of y(1) in microsecs
   y(1)=LONG(ystr)
 endif else begin 
   yy = y
   for i=0,sy(2)-1 do begin
     ystr='000000'
     strput,ystr,string(y(1,i),f="(I6.6)") ; conversion of y(1,*) in microsecs
     y(1,i)=LONG(ystr)
   endfor
endelse
         
z =  x + yy

odd = where((z(0,*) mod 2) EQ 1,cnt)

if (cnt GT 0) then z(0,odd) = z(0,odd) - 1L
                   z(0,*)   = z(0,*)/2L
                   z(1,*)   = z(1,*)/2L
if (cnt GT 0) then z(1,odd) = z(1,odd) + 500000L

over = where(z(1,*) ge 1000000, c_o)
if (c_o GT 0) then begin
   z(0,over) = z(0,over) + 1L
   z(1,over) = z(1,over) - 1000000L
endif

return, z
end	
