pro chisurf_plot, mm, xg, yg, alpha, out, gunid, maxorder, bestord, $ ; IN
                  tri_ok, $     ; IN
                  chisurf, xsurf, ysurf, $ ; IN
                  xd, yd, rd, pd, $ ; IN
                  rchi2, $      ; IN
                  conlevel, inside, rderr, pderr, $ ; IN
                  conlevel_info, conlevel_xy, $ ; OUT
                  init=init, last=last, siz=siz, $
                  conlevel_color=conlevel_color, $
                  info_in=info_in, xy_in=xy_in, color_in=color_in, title=title, $
                  oplot_x=oplot_x, oplot_y=oplot_y

if (keyword_set(init)) then begin
    !p.multi = [0,2,1]          ; !p.multi = [0,2,2,0,1]
    os = 600
    if !d.name eq 'X' then window,1,xs=os*2.,ys=os
endif

edi_setcolors, cs
!p.background = cs.white
!p.color = cs.black
!y.omargin = [3,5]

; Create the [x], [y] footprints for polyfilling the
; target error swath
rmin = rd - rderr > 0.
rmax = rd + rderr
amin = pd - pderr
amax = pd + pderr

n = 100

slp = (rmax - rmin) / float(n-1)
r1 = slp*findgen(n) + rmin
a1 = make_array(n,/float,value=amax)

slp = (amin - amax) / float(n-1)
a2 = slp*findgen(n) + amax
r2 = make_array(n,/float,value=rmax)

slp = (rmin - rmax) / float(n-1)
r3 = slp*findgen(n) + rmax
a3 = make_array(n,/float,value=amin)

slp = (amax - amin) / float(n-1)
a4 = slp*findgen(n) + amin
r4 = make_array(n,/float,value=rmin)

eswathx_gyro = [r1*cos(a1),r2*cos(a2),r3*cos(a3),r4*cos(a4)]
eswathy_gyro = [r1*sin(a1),r2*sin(a2),r3*sin(a3),r4*sin(a4)]

if (n_elements(siz) ne 0) then begin
    if (siz ne 0) then begin
        xrange = [-siz,siz]
        yrange = [-siz,siz]
    endif else begin
        xmin = min([min(eswathx_gyro),min(xsurf)])
        xmax = max([max(eswathx_gyro),max(xsurf)])
        xmid = (xmax+xmin)/2.
        ymin = min([min(eswathy_gyro),min(ysurf)])
        ymax = max([max(eswathy_gyro),max(ysurf)])
        ymid = (ymax+ymin)/2.
        
        xlen = xmax-xmin
        ylen = ymax-ymin
        maxlen = max([xlen,ylen])
        maxlen = maxlen*1.1
        
        xrange = [xmid-maxlen/2.,xmid+maxlen/2.]
        yrange = [ymid-maxlen/2.,ymid+maxlen/2.]
    endelse
endif else begin
    
    xmin = min([min(eswathx_gyro),min(xsurf)])
    xmax = max([max(eswathx_gyro),max(xsurf)])
    xmid = (xmax+xmin)/2.
    ymin = min([min(eswathy_gyro),min(ysurf)])
    ymax = max([max(eswathy_gyro),max(ysurf)])
    ymid = (ymax+ymin)/2.
    
    xlen = xmax-xmin
    ylen = ymax-ymin
    maxlen = max([xlen,ylen])
    maxlen = maxlen*1.1
    
    xrange = [xmid-maxlen/2.,xmid+maxlen/2.]
    yrange = [ymid-maxlen/2.,ymid+maxlen/2.]

endelse



;******************************************************************
;contour plot combined likelihood function
;******************************************************************
xdtit='X='+strcompress(string(format='(f9.3)',xd),/remove_all)
ydtit='Y='+strcompress(string(format='(f9.3)',yd),/remove_all)

chisurfmin = min(chisurf)
contour,(chisurf-chisurfmin),$
  xsurf,ysurf,xra=xrange,yra=yrange,$
  xsty=1,ysty=1,nlevels=10,xtit=xdtit,ytit=ydtit,$
  title= title, /nodata

polyfill, eswathx_gyro, eswathy_gyro, color=cs.grey80, /data

contour,(chisurf-chisurfmin),$
  xsurf,ysurf,xra=xrange,yra=yrange,$
  xsty=1,ysty=1,nlevels=10,xtit=xdtit,ytit=ydtit,$
  title= title, /nodata, /overplot

contour,(chisurf-chisurfmin),$
  xsurf,ysurf,nlevels=10,/overplot, $
  c_labels=make_array(10,/long,value=0), levels=findgen(10)+conlevel+1

if n_elements(conlevel_color) ne 0 then istat=execute('color=cs.'+conlevel_color) else color=cs.red
contour,(chisurf-chisurfmin), $
  xsurf,ysurf,nlevels=1,/overplot, $
  level=[conlevel], c_colors=[color], c_labels=[0]

if (n_elements(oplot_x) ne 0) then begin
    for i=0,n_elements(oplot_x)-1 do begin
        oplot, [oplot_x(i)], [oplot_y(i)], psym=7-i, symsize=1.5, color=cs.orange, $
          thick=2
    endfor
endif

; Return this contour information
contour,(chisurf-chisurfmin), $
  xsurf,ysurf,nlevels=1, /overplot, $
  level=[conlevel], c_colors=[color], c_labels=[0], $
  PATH_XY=conlevel_xy, PATH_INFO=conlevel_info, /path_data_coords

;FOR I = 0, (N_ELEMENTS(conlevel_info) - 1 ) DO BEGIN
;    S = [INDGEN(conlevel_info(I).N), 0]
;    PLOTS, conlevel_xy(*,conlevel_info(i).OFFSET + S ), color=cs.green
;ENDFOR

if n_elements(info_in) ne 0 then begin
    istat=execute('color=cs.'+color_in)
    FOR I = 0, (N_ELEMENTS(info_in) - 1 ) DO BEGIN
        S = [INDGEN(info_in(I).N), 0]
        PLOTS, xy_in(*,info_in(I).OFFSET + S ), color=color
    ENDFOR
endif

outs = norm_axis([.1,.9])
xyouts, outs(0), outs(1), 'R = '+strtrim(rd,2)

oplot,	[0],[0],psym=1
;oplot,	xrange,[yd,yd],linestyle=0
;oplot,	[xd,xd],yrange,linestyle=0
oplot, xsurf, ysurf, psym=3
oplot, xsurf(inside), ysurf(inside), psym=3, color=color
usersym, [-1,-1,1,1], [-1,1,1,-1], color=cs.black, /fill
oplot, [xd],[yd], psym=8, symsize=.75


;******************************************************************
;draw firing directions and a symbol at each gun location
;thick lines point to the target consistent with the respective tof
;******************************************************************
runner = lonarr(maxorder)
for im=0,mm-1 do begin
    if (tri_ok(im) eq 1) then runner(bestord(im)-1) = runner(bestord(im)-1) + 1
endfor
text5 = strcompress(runner(0),/remove_all)
for order= 2,maxorder do begin
    text5 = text5+', '+strcompress(runner(order-1),/remove_all)
endfor

plot,	[0],[0],psym=1,xra=xrange,yra=yrange,$
  xsty=1,ysty=1,xtit=xdtit,ytit=ydtit,title='Runner types: '+text5, /nodata
;oplot,	xrange,[yd,yd],linestyle=1
;oplot,	[xd,xd],yrange,linestyle=1

polyfill, eswathx_gyro, eswathy_gyro, color=cs.grey80, /data
oplot, xsurf, ysurf, psym=3

xx=xrange
for im = 0, mm-1 do begin
    if tri_ok(im) eq 1 then begin
        oplot,[xg(im)],[yg(im)],psym=8-gunid(im)
        yy=tan(alpha(im)+1e-4)*(xx-xg(im))+yg(im)
        oplot,xx,yy,thick=0.01
    endif
endfor
usersym, [-1,-1,1,1], [-1,1,1,-1], color=cs.black, /fill
oplot, [xd],[yd], psym=8, symsize=.75

return
end

