PRO  CALC_ANGLE_CCSDS, TIME_TAG,SUB_STATUS


;***********************************************************************
;*                                    
;* *CLUSTER-JSOC PROJECT  - OBSERVATION PLANNING SUB-SYSTEM - RAL
;*
;* *SUBROUTINE CALC_ANGLE_CCSDS - CALCULATE ROTATION ANGLES - VERSION 1.1
;*
;* *PROJECT REFERENCE     - ADD 2.2.1 - general library routine     
;*
;* *LANGUAGE   -Fortran-90 
;*
;* *PURPOSE    -Calculate all rotation angles used in the Clustran
;*              coordinate transformation library for a time specified
;*              in the form of CCSDS ASCII Time Code A, e.g.
;*              1995-03-04T17:35:00Z
;*
;* *ARGUMENTS  -TIME_TAG       /C20 - enter time of interest in CCSDS 
;*                                    ASCII time code A format
;*             -SUB_STATUS     /I   - status code (non-zero if
;*                                    TIME_TAG is outside range of
;*                                    available field models used
;*                                    specify position of dipole axis)
;*
;* *SUBROUTINES-CCSDS_TO_MJDSEC,CALANGLE
;*
;* *METHOD     -Convert time from CCSDS format to MJD and seconds in
;*              day using planning sub-system library routine
;*              CCSDS_TO_MJDSEC. Then convert seconds to hours by
;*              simple arithmetic. Finally pass time (MJD and hours
;*              of day) to the Clustran interface routine CALANGLE.
;*              This calculates the values of all angles used in
;*              Clustran - for the time of interest.
;*
;* *WRITTEN BY -M.A.Hapgood  DRAL UK Version 1.1  March 1995    
;*
;***********************************************************************

;* Convert time tag to MJD and seconds in day using planning
;* library routine. Then convert seconds to hours
       ccsds_to_mjdsec, time_tag,mjd,sec
       hours=float(sec)/3600.0


* Pass time to Clustran interface routine      
       calangle, mjd,hours,sub_status

END
