pro beam_plot, mm, xg, yg, alpha, out, gunid, colorid, $
               xd, yd, $
               siz=siz,title=title

xrange=[-siz,siz]
yrange=[-siz,siz]

;******************************************************************
;draw firing directions and a symbol at each gun location
;******************************************************************

plot, [0],[0],psym=1,xra=xrange,yra=yrange,$
  xsty=1,ysty=1, /nodata,xtitle='X_gyro', ytitle='Y_gyro',title=title

xx=xrange
for im = 0, mm-1 do begin
    if out(im) le 1 then begin
        oplot,[xg(im)],[yg(im)],psym=8-gunid(im),color=colorid(im)
        yy=tan(alpha(im)+1e-4)*(xx-xg(im))+yg(im)
        oplot,xx,yy,color=colorid(im)
    endif
endfor

; S/C center
usersym, [-1,-1,1,1], [-1,1,1,-1], /fill
oplot, [0],[0], psym=8, symsize=.75

; Bestarg line to indicate phi only (no r-info)
edi_setcolors, cs
oplot, !x.crange, yd/xd*!x.crange,line=3,color=cs.green

return
end

