; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; $Id: wwutil.pro,v 1.18 2005/10/19 18:09:09 hav Exp $
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

@getcluhdr.pro
@getfgmrange.pro

; ============================================================================
  FUNCTION GetQs, d_struct, en=en
; ============================================================================
; d_struct : array of WW data structures
; ****************************************************************************

   engy = d_struct.en

   if keyword_set(en) then begin
      message, 'GetQs(): keyword <en> present :'+ strtrim(en,2), /cont
      if en ne 500 and en ne 1000 then begin
         message, 'en must be 500 or 1000.', /cont
         retall
      endif else begin
         if en eq 500 then en = 1 else en = 0
      endelse
   endif else begin
      message, 'GetQs(): both energies selected.', /cont
      en = 0
      engy = intarr(n_elements(engy)) ; set energy to zero to get both energies
   endelse

   q1is0   = where(d_struct.q1 eq 0 and engy eq en)
   q1is1   = where(d_struct.q1 eq 1 and engy eq en)
   q1is2   = where(d_struct.q1 eq 2 and engy eq en)
   q1is3   = where(d_struct.q1 eq 3 and engy eq en)

   q1is2_6 = where(d_struct.q1 eq 2 and d_struct.mch1 eq 6 and engy eq en)
   q1is2_7 = where(d_struct.q1 eq 2 and d_struct.mch1 eq 7 and engy eq en)
   q1is2_8 = where(d_struct.q1 eq 2 and d_struct.mch1 eq 8 and engy eq en)
   q1is2_n678 = where(d_struct.q1 eq 2 and engy eq en and $
                      (d_struct.mch1 lt 6  or d_struct.mch1 gt 8) )
   q1is3_6 = where(d_struct.q1 eq 3 and d_struct.mch1 eq 6 and engy eq en)
   q1is3_7 = where(d_struct.q1 eq 3 and d_struct.mch1 eq 7 and engy eq en)
   q1is3_8 = where(d_struct.q1 eq 3 and d_struct.mch1 eq 8 and engy eq en)
   q1is3_n678 = where(d_struct.q1 eq 3 and engy eq en and $
                      (d_struct.mch1 lt 6  or d_struct.mch1 gt 8) )


   q2is0   = where(d_struct.q2 eq 0 and engy eq en)
   q2is1   = where(d_struct.q2 eq 1 and engy eq en)
   q2is2   = where(d_struct.q2 eq 2 and engy eq en)
   q2is3   = where(d_struct.q2 eq 3 and engy eq en)

   q2is2_6 = where(d_struct.q2 eq 2 and d_struct.mch2 eq 6 and engy eq en)
   q2is2_7 = where(d_struct.q2 eq 2 and d_struct.mch2 eq 7 and engy eq en)
   q2is2_8 = where(d_struct.q2 eq 2 and d_struct.mch2 eq 8 and engy eq en)
   q2is2_n678 = where(d_struct.q2 eq 2 and engy eq en and $
                      (d_struct.mch2 lt 6  or d_struct.mch2 gt 8) )
   q2is3_6 = where(d_struct.q2 eq 3 and d_struct.mch2 eq 6 and engy eq en)
   q2is3_7 = where(d_struct.q2 eq 3 and d_struct.mch2 eq 7 and engy eq en)
   q2is3_8 = where(d_struct.q2 eq 3 and d_struct.mch2 eq 8 and engy eq en)
   q2is3_n678 = where(d_struct.q2 eq 3 and engy eq en and $
                      (d_struct.mch2 lt 6  or d_struct.mch2 gt 8) )


   qs = { q1is0:q1is0, q1is1:q1is1, q1is2:q1is2, q1is3:q1is3, $
          q1is2_6:q1is2_6, q1is2_7:q1is2_7, $
          q1is2_8:q1is2_8, q1is2_n678:q1is2_n678, $
          q1is3_6:q1is3_6, q1is3_7:q1is3_7, $
          q1is3_8:q1is3_8, q1is3_n678:q1is3_n678, $
          q2is0:q2is0, q2is1:q2is1, q2is2:q2is2, q2is3:q2is3, $
          q2is2_6:q2is2_6, q2is2_7:q2is2_7, $
          q2is2_8:q2is2_8, q2is2_n678:q2is2_n678, $
          q2is3_6:q2is3_6, q2is3_7:q2is3_7, $
          q2is3_8:q2is3_8, q2is3_n678:q2is3_n678 }

   return, qs


END

; ============================================================================
  FUNCTION SetFramesperStruct, submo, pacmo
; ============================================================================

   if submo ge 1 and submo le 3 and pacmo eq 1 then fr_per_st = 256 $
   else if submo ge 1 and submo le 3 and pacmo eq 5 then fr_per_st = 512 $
   else if submo eq 5 and pacmo eq 1 then fr_per_st =  64 $
   else begin
      print, 'invalid submo/pacmo : ', submo, pacmo
      retall
   endelse

   return, fr_per_st

END

; ============================================================================
  PRO ExtractMode, modestr, modid, submo, pacmo
; ============================================================================

   modid = fix(strmid(modestr, 0, 2))
   submo = fix(strmid(modestr, 3, 2))
   pacmo = fix(strmid(modestr, 6, 2))

END

; ============================================================================
  PRO AddBciCorr, dt1, dt2, wwc_data, fr_per_st, subpack
; ============================================================================
; add BCI and GDU frame correction to WW data time tags
; ****************************************************************************

   ; Detector 1 (Gun 2)
   ; ------------------
   if wwc_data.q1 eq 0 then begin
      dt1 = dt1 - (fr_per_st+16)
   endif else begin
      dt1 = dt1 - 16*(wwc_data.bci_idx1+1)

      ; frame correction
      if subpack eq 1 then begin ; NM1PM1
         print, 'submo=pacmo=1 ? Can WWCONV read this format ?'
         retall
         ; formula would be : add (3+8*frame_index) to dt
      endif else begin
         dt1 = dt1 + 4*wwc_data.fr_idx1
      endelse
   endelse

   ; Detector 2 (Gun 1)
   ; ------------------
   if wwc_data.q2 eq 0 then begin
      dt2 = dt2 - (fr_per_st+16)
   endif else begin
      dt2 = dt2 - 16*(wwc_data.bci_idx2+1)

      ; frame correction
      if subpack eq 1 then begin ; NM1PM1
         print, 'submo=pacmo=1 ? Can WWCONV read this format ?'
         retall
         ; formula would be : add (3+8*frame_index) to dt
      endif else begin
         dt2 = dt2 + 4*wwc_data.fr_idx2
      endelse
   endelse

END


; ============================================================================
  FUNCTION MakeFileName,  scid, year, month, day,  cdds=cdds
; ============================================================================
; Here, the keyword cdds should (if set) be one of
;    .hkd   .shk   .nsd   .bsd   .?sd
; ****************************************************************************

  if keyword_set(cdds) then begin ; CDDS file

     fn = string(format = '("cl",I1,"_",I4,"-",I2.2,"-",I2.2)', $
                 scid, year, month, day) + cdds


  endif else begin ; MSF file

     fn = string(format='(3(i2.2))', year-2000, month, day) + 'em.*'

  endelse

  return,  fn

END



; ============================================================================
  FUNCTION MakeDataPath,  scid,  year,  month,  day, cdds=cdds
; ============================================================================

@paths.inc


  if keyword_set(cdds) then begin

      fnpath = CDDS_DIR + 'sc' + strtrim(scid,2) + '/'

  endif else begin

      fnpath = MSF_DIR
      fnpath = fnpath + 'msf_'
      scstr = strtrim(scid,2)
      for i=0,n_elements(fnpath)-1 do fnpath[i] = fnpath[i] + scstr ; it's unclear why this has to be done, but I ran into a problem in edihk.pro when simply saying <fnpath=fnpath+scstr> here (it rendered a one element string array)
      fnpath = fnpath + '/'

  endelse

  return, fnpath

END


; ============================================================================
  FUNCTION GetFileName, scid, year, month, day, ymd=ymd, $
                        cdds=cdds, latest=latest, $
                        debug = debug
; ============================================================================
; Here, the keyword cdds should (if set) be one of
;    .hkd   .shk   .nsd   .bsd   .?sd
; ****************************************************************************

   if keyword_set(debug) then debug = 1 else debug = 0

   if keyword_set(ymd) then begin
       year  = fix(strmid(ymd,0,4))
       month = fix(strmid(ymd,5,2))
       day   = fix(strmid(ymd,8,2))
   endif

   fnpath   = MakeDataPath(scid, year, month, day, cdds=cdds)
   fnfilter = MakeFileName(scid, year, month, day, cdds=cdds)

   if debug then message, 'Number of search paths : ' + strtrim(n_elements(fnpath),2), /cont

   tot_fn_cnt = 0
   for i=0,n_elements(fnpath)-1 do begin
      if debug then message, 'searching in path ' + fnpath[i], /cont
      fn_list = file_search(fnpath[i]+fnfilter, count=fn_cnt)
      if fn_cnt eq 0 then continue
      if tot_fn_cnt eq 0 then tot_fn_list = fn_list $
      else tot_fn_list = [ tot_fn_list, fn_list ]
      tot_fn_cnt = tot_fn_cnt + fn_cnt
   endfor

   if tot_fn_cnt eq 0 then begin
      msg = 'no file(s) found matching ' + fnfilter
      if keyword_set(debug) then message, msg, /cont
      return, { status:1, msg:msg }
   endif

   if tot_fn_cnt eq 1 then return, { status:0, msg:'', filename:tot_fn_list[0] }

   ; we have found more than one file
   ; --------------------------------
   sortindex=sort(tot_fn_list)
   tot_fn_list = tot_fn_list[sortindex]

   if keyword_set(latest) then begin
      message,  'found ' + strtrim(tot_fn_cnt,2) + ' candidates', /cont
      message, 'using latest', /cont
      mysel = tot_fn_cnt-1
   endif else begin
      if keyword_set(cdds) then begin ; return all filenames if CDDS (nsd + bsd)
         return, { status:0, msg:'ok', filename:tot_fn_list }
      endif
      message,  'found ' + strtrim(tot_fn_cnt,2) + ' candidates', /cont
      for i = 0, tot_fn_cnt-1 do print,  i, '  ',  tot_fn_list[i]
      print,  'Please select:'
      mysel =  0
      read,  mysel
      if mysel ge tot_fn_cnt or mysel lt 0 then begin
          print,  'Invalid input ! using latest file!'
          mysel = tot_fn_cnt-1
      endif
   endelse

   return,  { status:0,  msg:'ok',  filename:tot_fn_list[mysel] }

 END


; ============================================================================
  FUNCTION ReadData, filename, prototype, offset, debug = debug
; ============================================================================

   if not keyword_set(debug) then debug = 0 else debug = 1

   openr, fp, filename, /get_lun
   mystat = fstat(fp)
   nrecs = (mystat.size-offset) / n_tags(prototype, /length)
   if debug then begin
      message, 'file size is <' + strtrim(mystat.size, 2) + '> bytes.', /cont
      message, 'size of prototype : ' +strtrim( n_tags(prototype, /length), 2), /cont
      message, 'number of records: ' + strtrim( nrecs,2) , /cont
   endif

   if nrecs le 0 then begin
      free_lun, fp
      return, { status:1, msg:'no data' }
   endif

   data = replicate( prototype, nrecs)
   data1 = assoc(fp, data, offset)
   data = data1(0)
   free_lun, fp

   return, { status:0, msg:'ok', data:data }

END



; ============================================================================
  FUNCTION FillGaps, sarr, xarr=xarr, eps=eps, debug=debug, quiet=quiet
; ============================================================================
; This routine can be used to fill in gaps in spin center times and
; sun reference pulse data
;
; Parameters
;     sarr   array of structures having two elements (hdr and data) and
;            optionally some more elements
;
; Keywords
;     xarr   a named variable which, on return, will contain the indices
;            of the inserted data points
;     eps    optional max relative deviation for identifying gaps
;
; ****************************************************************************

  if not keyword_set(eps) then eps = 0.025
  if not keyword_set(debug) then debug = 0 else debug = 1
  if not keyword_set(quiet) then quiet = 0 else quiet = 1

  xarr = -1L


  ; check if there are gaps
  ; ------------------------------------
  NN    = n_elements(sarr.data)
  if NN lt 4 then begin
     if debug then message, 'Not enough points', /cont
     return, sarr
  endif

  delta = sarr.data[1:NN-1].ct - sarr.data[0:NN-2].ct
  if NN eq 2 then med = delta[0] else med   = median(delta)
  x     = where( abs(delta - med)/med gt eps, NGAPS )

  ; insert missing pulses
  ; ----------------------
  if NGAPS eq 0 then begin
     if debug then message, 'no gaps detected', /cont
     return, sarr
  endif

  if debug then begin
     message, 'Detected ' + strtrim(NGAPS,2) + ' gaps in data', /cont
     print, 'Attempting to fix...'
     print, 'Original data size : ', NN
  endif


  newdata = sarr.data[0]      ; initialize (to be discarded finally)

  ; loop through all gaps
  ; ---------------------
  ins_cnt = 0
  for i=0L,NGAPS-1 do begin

      gap = delta[x[i]]                       ; gap width in seconds
      NIV   = long( gap / med  +  0.5 )       ; corresponding number of intervals

      ; copy the good pulses prior to the gap
      if i eq 0 then left = 0 else left = x[i-1]+1
      right = x[i]
      newdata = [ newdata, sarr.data[left:right] ]



      eps_actual = abs( gap - NIV*med ) / med
      if eps_actual gt eps then begin
          print, 'cannot handle this gap! (' + strtrim(gap,2) + ')'
          print, 'left  side of gap : ' + clutimeval2str(sarr.data[right].ct)
          print, 'right side of gap : ' + clutimeval2str(sarr.data[right+1].ct)
          print, 'NIV       = ', NIV
          print, 'median    = ', med
          print, 'eps_actual= ', eps_actual
          gmod = gap mod med
          if gmod gt med/2 then gmod = gmod - med
          print, 'gap mod tspin : ', gmod
          print, 'relative error : ', gmod/NIV
          print, 'Leaving gap untouched!!!'
          continue
      endif else if debug then begin
          print, 'left  side of gap : ' + clutimeval2str(sarr.data[right].ct)
          print, 'right side of gap : ' + clutimeval2str(sarr.data[right+1].ct)
      endif

      ins_cnt = ins_cnt + NIV-1               ; keep track of number of inserted data

      ; now insert n-1 new pulses
      increment = gap / NIV
      ins = replicate( sarr.data[0], NIV-1 )
      ins.ct    = sarr.data[right].ct + ( findgen(NIV-1) + 1 ) * increment

      NTMP = n_elements(newdata)
      newdata = [ newdata, ins ]
      xarr = [ xarr, lindgen(n_elements(ins))+NTMP ]

      if debug then begin
          print, 'inserted the following pulses:'
          for j=0,NIV-2 do print, clutimeval2str(ins[j].ct)
      endif

  endfor

  ; add trailing data and remove initial dummy element
  ; --------------------------------------------------
  newdata = [ newdata, sarr.data[x[NGAPS-1]+1 : NN-1] ]
  newdata = newdata[1:n_elements(newdata)-1]

  if not quiet then print, 'number of inserted pulses : ', ins_cnt
  if debug then begin
     print, 'number of elements finally : ', n_elements(newdata)
     if n_elements(xarr) gt 1 then begin
        xarr = xarr[1:n_elements(xarr)-1] - 1  ; must subtract one because indices shift
                                                ; when the first element of newdata is removed
        print, 'inserted pulses:'
        for i=0,n_elements(xarr)-1 do $
           print, CluTimeVal2Str(newdata[xarr[i]].ct)
     endif
  endif

  ; copy hdr and opt fields from initial structure
  ; -------------------------------------------------
  st_members = strjoin(tag_names(sarr), ' ')
  if strpos(st_members, 'OPT') ge 0 then $
    new_sarr = { hdr:sarr.hdr, opt:sarr.opt, data:newdata } $
  else $
    new_sarr = { hdr:sarr.hdr, data:newdata }


  return, new_sarr


END

; ============================================================================
  FUNCTION ExtractWWdata, ds, n_sel=n_sel, ctype=ctype, $
                              fgmrng=fgmrng, tmmode=tmmode, $
                              debug=debug
; ============================================================================

  if ds.hdr.status eq 1 then return, ds

  if not keyword_set(debug) then debug = 0

  ; select data with certain correlator n values
  ; --------------------------------------------
  if keyword_set(n_sel) then begin
     if debug then print, 'selecting data according to specified n'
     x_sel = [ -1L ]
     for i = 0,n_elements(n_sel)-1 do begin
        x = where(ds.data.nc eq n_sel[i], cnt)
        if cnt gt 0 then x_sel = [ x_sel, x ]
     endfor
     if n_elements(x_sel) eq 1 then $
        return, { hdr:GetCluHdr(1, 'no EDI WW data left after n selection!', $
                                sc_id=ds.hdr.sc_id) }
     x_sel = x_sel[1:n_elements(x_sel)-1]
     out = { hdr:ds.hdr, data:ds.data[x_sel] }
  endif

  ; select data with short or long code
  ; -----------------------------------
  if keyword_set(ctype) then begin
     if debug then print, 'selecting data according to specified code type'
     x_sel = [ -1L ]
     if ctype eq 's' then cmpval = 0 else if ctype eq 'l' then cmpval = 1 $
     else begin
        message, 'bad value for keyword ctype (s,l allowed): ' + strtrim(ctype,2), /cont
        retall
     endelse
     x = where(ds.data.ctype eq cmpval, cnt)
     if cnt gt 0 then x_sel = [ x_sel, x ]
     if debug then print, 'found ' + strtrim(cnt,2) + ' beam(s) with ctype = ' + $
                          strtrim(cmpval,2)
     if n_elements(x_sel) eq 1 then $
        return, { hdr:GetCluHdr(1, 'no EDI WW data left after ctype selection!', $
                                sc_id=ds.hdr.sc_id) }
     x_sel = x_sel[1:n_elements(x_sel)-1]
     out = { hdr:ds.hdr, data:ds.data[x_sel] }
  endif

  ; select data within certain FGM ranges
  ; -------------------------------------
  if keyword_set(fgmrng) then begin
     if debug then print, 'selecting data within specified FGM range(s)'
     x_sel = [ -1L ]
     ctr = [min(ds.data.ct),max(ds.data.ct)]
     fgminfo = GetFgmRange(ds.hdr.sc_id, ctr, debug=debug)
     if fgminfo.status ne 0 then begin
        return, { hdr:GetCluHdr(1, fgminfo.msg, sc_id=ds.hdr.sc_id) }
     endif
     for i=0,n_elements(fgmrng)-1 do begin
        x = where(fgminfo.data.range eq fgmrng[i], cnt)
        for j=0,cnt-1 do begin
           xin = where(ds.data.ct ge fgminfo.data[x[j]].ct_beg and $
                       ds.data.ct lt fgminfo.data[x[j]].ct_end, cnt_in)
           if cnt_in gt 0 then x_sel = [ x_sel, xin ]
        endfor
     endfor
     if n_elements(x_sel) eq 1 then $
        return, { hdr:GetCluHdr(1, 'no EDI WW data within specified FGM range(s)!', $
                                sc_id=ds.hdr.sc_id) }
     x_sel = x_sel[1:n_elements(x_sel)-1]
     out = { hdr:ds.hdr, data:ds.data[x_sel] }
  endif

  return, out

END
