/* EDITM.H  ---> constants, macros, type definitions and  */
/*               function prototypes                      */



/******************* SOME CONSTANTS *****************************************/

#define NM1   0
#define NM2   1
#define NM3   2
#define BM1   3
#define BM2   4
#define BM3   5

#define SCS_HDR_SZ     64
#define PKTSZ_HK       90
#define PKTSZ_NM      980
#define PKTSZ_BM1    6944
#define PKTSZ_BM2     992
#define PKTSZ_BM3   23188
#define MAX         PKTSZ_HK + PKTSZ_BM3


#define MAXWIDTH 110
#define P_CAT    0
#define P_END    1
#define P_OBAR   2
#define P_CBAR   3
#define P_DIBAR  4
#define P_SIBAR  5
#define P_BLANK  6


/******************* TYPE DEFINITIONS ***************************************/

typedef struct {
   char version, fgm;             /*  0, 1            */
   char date[10], time[10];       /*  2 - 11, 12 - 21 */
   long size;                     /* 22 - 25          */
   char mode, instrument;         /* 26, 27           */
   char crtl_82c54[6];            /* 28 - 33          */
   int  init_82c54[6];            /* 34 - 45          */
   int  loc[6];                   /* 46 - 57          */
   char extra[6];                 /* 58 - 63          */
} scs_hdr_t;


typedef short edi_tm_hdr_t[4];


typedef union
{
   struct
   {
      short hdr1[4], hdr2[32], data[454];
   } memdmp;

   struct
   {
      short hdr1[4], hdr2[16], ch0addr, ch0tt, ch0num, ch0data[415],
            ch1addr[2], ch1tt, ch1num, ch1data[42], spare[6];
   } pm0;

   struct
   {
      short hdr1[4], hdr2[16], tt, num, data[405], ixlo[41], ixhi[21], spare;
   } pm1;

   struct
   {
      short hdr1[4], hdr2[16], tt, offset[4], data[448], spare1[6], trail[4], spare2[7];
   } pm2;

   struct
   {
      short hdr1[4], hdr2[16], tt, num, data[410], spare[58];
   } pm5;

} nmx_t;


typedef union {
   struct {
      short hdr1[4], hdr2[16], unknown[143];
      long ch2addr, ch3addr;
      short ch23tt, ch23num, ch23data[2639];
      long ch4addr;
      short ch4tt, ch4num, ch4data[660];
      } pm0;
   struct {
      short hdr1[4], hdr2[16], tt, num, data[3300], spare[150];
      } pm1;
   } bm1_t;


typedef union {
      nmx_t nmx;
      bm1_t bm1;
      } sci_t;

typedef short hk_t[45];   /* 90 bytes of hk */

typedef struct {
   double ct1, ct2;
   float th1, ph1, th2, ph2;
   float tof1, tof2, dtof;
   short e, n, q1, q2;
   short d14_1, d15_1, d14_2, d15_2;
   short maxaddr1, maxaddr2;
   short bci_idx1, frm_idx1, bci_idx2, frm_idx2;
   short m, ovfl_t1, ovfl_t2, ovfl_dt;
} bm1_conv_t;

typedef struct {
   double ct1, ct2;
   float th1, ph1, th2, ph2;
   float tof1, tof2, dtof;
   short e, n, q1, q2;
   short d14_1, d15_1, d14_2, d15_2;
   short maxaddr1, maxaddr2;
   short bci_idx1, frm_idx1, bci_idx2, frm_idx2;
   short m, ovfl_t1, ovfl_t2, ovfl_dt;
   short ctype;
}  ww_conv_t;

typedef struct {
   short stcnt;             /* structure count */
   short gd;                /* gun-detector pair  ( 12 or 21 ) */
   double ct;               /* absolute time tag in t70 format */
   float th, ph;            /* gun firing directions */
   float tof;               /* time of flight */
   short e, n, m, q;        /* energy, correlator n,m,  quality */
   short mch, d14, d15;     /* max channel address, DATA14, DATA15 */
   short ctype, ovfl;       /* code type (short/long), tof overflow flag */
   short bci_idx, frm_idx;  /* time tag information */
} ww_conv2_t;

typedef struct {
   float th1, ph1, th2, ph2;
   float tof1, tof2, dtof;
   short e, n, q1, q2, ix_lo1, ix_lo2, ix_hi1, ix_hi2;
   short m, ovfl_t1, ovfl_t2, ovfl_dt;
  } nm1_pm1_conv_t;


typedef struct {
   short stcnt;
   double ct;
   float th, ph;
   short en, dirflg;
   short zprp, yprp;
   short cnt1, cnt2;
   } ag_conv_t;

/******************* FUNCTION PROTOTYPES ***************************************/

/* EDITM.C */

short GetPacketSize(FILE *infp);
long  GetMaxPacketNum(FILE *infp);
void  ReadPacket(FILE *infp, long packetnum);
void  DisplayPacket(FILE *infp);
void  CreateOutputFile(FILE *infp, char *infn);
float CalcPhi(float gxn, float gyn);
void  PrintMsg(void);
void  PrintSecondHeader(void);
void  ConvertVxVy(float vx, float vy, float *php, float *thp);
void  ConvertToF(short tof1_int, short dtof_int, float *tof1, float *dtof);
void  EdiPrt(int action, ...);

/* EDI_DSPL.C */

void Display_HK(void);
void ExtractBm1Data(bm1_conv_t* p, short i, short submo);
void ExtractNm1Pm1Data(nm1_pm1_conv_t* p, short i);


