; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; $Id: constants.inc,v 1.7 2004/10/13 16:23:59 hav Exp $
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

OPT_DTA = 1
OPT_DTB = 2
OPT_DTTGA = 3
OPT_DTTGB = 4

DATATYPE_WW   = 0
DATATYPE_SHDR = 1
DATATYPE_HK   = 2
DATATYPE_SRP  = 3
DATATYPE_AG   = 4 ; ambient GEOS

DATASOURCE_MSF  = 0
DATASOURCE_RDM  = 1
DATASOURCE_CDDS = 2


YMD_FMT  = '(I4.4,"-",I2.2,"-",I2.2)'


; Default Values
; --------------
DEFAULT_MAXORDER = 6
DEFAULT_SMOOTH   = 5
DEFAULT_ECONF    = 90
DEFAULT_ISTEP    = 1.0
DEFAULT_IWIDTH   = 3.0
DEFAULT_PROCESSING_OPTION = OPT_DTTGA

; Mathematical Constants
; ----------------------
DPI = 3.141592653589793d  ; PI in double precision
DEG2RAD = !PI/180
RAD2DEG = 180/!PI


; Physics Constants (pc_...)
; -----------------
pc_echarge = 1.60217733d-19 ; elementary charge (in Coulomb)
pc_me0     = 9.1093897d-31  ; electron rest mass (in kg)
pc_c       = 2.99793d8      ; speed of light (in m/s)


BTG_CONV = 3.5723875d4 ; 2*pi*m / e (convert B in nT to Tg in us,
                       ;             and vice versa)
                       ; this formula uses the electron rest mass


; derived quantities for 1keV / 500eV electron energy
; ---------------------------------------------------
pc_me_1kev  = pc_me0 / 0.99804688d ; mass of a 1keV electron
pc_me_500ev = pc_me0 / 0.99902248d ; mass of a 500eV electron

BTG_CONV_1KEV  = 3.5793785d4
BTG_CONV_500EV = 3.5758831d4



MU0  = 4 * !PI * 1.d-7 ; Vs/Am
EPS0 = 8.854d-12       ; As/Vm
KBOLTZMANN = 1.38d-23  ; J/K

VE_1KEV  = 18727.9 ; km/s

                   ; using c = 2.99793d8
                   ;       me = 9.1093897d-31
                   ;       e  = 1.60217733d-19
                   ;       Ek = e * 1.e3 ( 1kev kinetic energy)
                   ;
                   ;                             me       ^2
                   ; and v = c * SQRT [ 1 - (------------)   ]
                   ;                          me + Ek/c^2


EARTH_RADIUS_KM = 6370.

SW_PREFETCH = [ -20000., 0 ]

MY_FILL_VAL = -1.e31
MY_FILL_VAL_CMP = MY_FILL_VAL + 1.0e-5


