PRO ambient_electron_cdf, file_path, date, sc_id

;ambient_electron_cdf.pro
;
;Created: Mark Chutter, UNH
;Sep. 14, 2005
;
;Modified:
;Jan. 18, 2006 MWC added option for detector 1 look directions in GSE
;Mar. 30, 2006 MWC added check to see if there is any data (check
;                  srt_out) before trying to find GSE look direction
;Aug.  7, 2006 MWC added some CDF attributes and created version number
;July  5, 2007 MWC changed example and attitude/orbit path
;July 19, 2007 MWC put in check for a srp of 0., which happens quite
;                  rarely, but really confused the output
;Nov. 27, 2007 MWC removed extraneous code before submission to CAA
;
;Calling Interface:
;file_path   char    (i)     file path to parent directory of data
;date        char    (i)     date of the form: 'YYYYMMDD'
;sc_id       int     (i)     spacecraft id
;
;Keywords:
;
;Description:
;ambient_electron_cdf creates a CDF file for the Cluster Active
;Archive with counts per seconds and angles for the requested time
;interval.  The counts per second are uncalibrated.
;
;Example:
;ambient_electron_cdf, '/nfs/cluster/', '20050125', 2

check_dot_product = 0
write_gse = 1
gse_string = ''

software_version =  '1.01'
cdf_version = '_v04.cdf'
;cdf_version = '_v0x.cdf'
fill_val = -32768
out_dir = '/nfs/cluster3/amb_GEOS_CDF'
sc_str = strcompress(string(sc_id), /remove_all)
month_array  = ["Jan","Feb","Mar","Apr","May","Jun",$
                "Jul","Aug","Sep","Oct","Nov","Dec"]

year = strmid(date, 0, 4)
month = strmid(date, 4, 2)
day = strmid(date, 6, 2)
hh = 0
mm = 0
ss = 0
start_date = day + '-' + month_array[month-1] + '-' + year
start_str = start_date + ' 00:00:00'

pick_cvt_str_sec, start_date + ' 00:00:00.000', midnight_t70_L
midnight_t70 = double(midnight_t70_L[0])

;get the ambient electron data from EDI merged science files
pick_cvt_str_sec, start_str, start_time
start_time_d = double(start_time[0]) + double(start_time[1]) * 1.D-6
end_time = start_time[0] + 86400L

f_type = 'msf'

find_edi_files, f_type, file_path, start_date, 'msf', n_sc, $
                sci_files, sc_id = sc_str

pick_close
pick_init, f_type, sci_files[0]
s = pickst_sc(pid, start_str, stat, /get_hk_data)

;look for mode changes, skip first packet after mode change
last_science_mode = s.hdr.science_mode
last_sub_mode = s.hdr.sub_mode
last_pacmo = s.hdr.pacmo
last_energy = s.hk.enrgy

cdf_epoch, epoch_ref, 1970, 1, 1, hh, mm, ss, 0, /compute_epoch
cdf_name = out_dir + '/C' + sc_str + '_CP_EDI_AE_' + gse_string + $
           date + cdf_version
print, cdf_name
id = cdf_create(cdf_name, /clobber, /single_file)

dummy = cdf_attcreate(id,  'TITLE')
cdf_control, id, attribute = 'TITLE', get_ATTR_INFO = ginfo
cdf_attput, id, dummy, ginfo.numgentries, 'Ambient Electron Counts' 
dummy = cdf_attcreate(id,  'Generated_by')
cdf_control, id, attribute = 'Generated_by', get_ATTR_INFO = ginfo
cdf_attput, id, dummy, ginfo.numgentries, 'Mark Chutter'
spawn,  'date', date_stamp
dummy = cdf_attcreate(id,  'Generation_date')
cdf_control, id, attribute = 'Generation_date', get_ATTR_INFO = ginfo
cdf_attput, id, dummy, ginfo.numgentries, date_stamp[0]
dummy = cdf_attcreate(id,  'Software_version')
cdf_control, id, attribute = 'Software_version', get_ATTR_INFO = ginfo
cdf_attput, id, dummy, ginfo.numgentries, $
            'ambient_electron_cdf.pro ' + software_version
dummy = cdf_attcreate(id,  'Descriptor')
cdf_control, id, attribute = 'Descriptor', get_ATTR_INFO = ginfo
cdf_attput, id, dummy, ginfo.numgentries, 'EDI>Electron Drift Instrument' 
dummy = cdf_attcreate(id,  'Inst_mode')
cdf_control, id, attribute = 'Inst_mode', get_ATTR_INFO = ginfo
cdf_attput, id, dummy, ginfo.numgentries, 'Ambient Mode'


data_count = 0
IF s.status GT 0 THEN BEGIN
    WHILE s.status GT 0 AND $
      s.hdr.packet_time[0] LT end_time[0] DO BEGIN

        pick_cvt_sec_vax, s.hdr.packet_time, data_time

        IF s.hdr.science_mode EQ '15'x AND $
          s.hdr.science_mode EQ last_science_mode AND $
          s.hdr.sub_mode EQ last_sub_mode AND $
          s.hdr.pacmo EQ last_pacmo AND $
          s.hk.enrgy EQ last_energy THEN BEGIN

            w_nonzero = where(s.pacmo0.amb_geos.data29_1 NE 0. OR $
                              s.pacmo0.amb_geos.data29_2 NE 0. OR $
                              s.pacmo0.amb_geos.theta NE 0. AND $
                              s.pacmo0.amb_geos.flip NE 1, nonzero_count)
            IF nonzero_count GT 0 THEN BEGIN

                time = s.pacmo0.amb_geos[w_nonzero].time
                b_perp = s.pacmo0.amb_geos[w_nonzero].b_perp
                bz_gz = s.pacmo0.amb_geos[w_nonzero].bz_gz
                data29_1 = s.pacmo0.amb_geos[w_nonzero].data29_1
                data29_2 = s.pacmo0.amb_geos[w_nonzero].data29_2
                theta_index = byte(s.pacmo0.amb_geos[w_nonzero].theta / $
                                   0.703125)
                phi_index = byte(s.pacmo0.amb_geos[w_nonzero].phi / 2.8125)

                theta = s.pacmo0.amb_geos[w_nonzero].theta
                ;phi in TM is gun firing from GDU 2
                ;convert to d1 look direction is d1 coordinates
                ph_d1 = 180 - s.pacmo0.amb_geos[w_nonzero].phi

                srt = double(s.srt[0]) + double(s.srt[1]) * 1.D-6
                srt1 = double(s.srt1[0]) + double(s.srt1[1]) * 1.D-6

;On SC3 detector 1 started having a much lower response than detector
;2 on startup in 2005.  When the response over a TMR for D1 is 1/5 the
;response of D2, the counts will be set to -32768
                IF sc_id EQ 3 AND mean(data29_1) LT 0 THEN BEGIN
                    SC3_low_d1 = 1
                    data29_1[*] = -32768
                ENDIF

;If srt is 0., it is likely that there has been a data gap.  I toss
;the first packet.
                IF srt GT 1.D9 THEN BEGIN
                    ;store the Sun Reference Times so angles can be despun
                    IF n_elements(srt_out) EQ 0 THEN BEGIN
                        srt_out = srt
                    ENDIF ELSE BEGIN
                        srt_out = [srt_out, srt]
                    ENDELSE
                    ;store srt1 if it is nonzero
                    IF srt1 GT 0.D THEN srt_out = [srt_out, srt1]

                    ;store angles
                    IF n_elements(theta_out) EQ 0 THEN BEGIN
                        time_out = time
                        ph_d1_out = ph_d1
                        theta_out = theta
                    ENDIF ELSE BEGIN
                        time_out = [time_out, time]
                        ph_d1_out = [ph_d1_out, ph_d1]
                        theta_out = [theta_out, theta]
                    ENDELSE
                    
                    status_byte = bytarr(n_elements(theta_index))
                    IF s.hk.enrgy EQ 0 THEN $
                      status_byte = status_byte + 1B ;1 KeV
                    IF s.hk.submo EQ 5 THEN $
                      status_byte = status_byte + 2B ;BM
                    
                    
                    cdf_ag_times = time * 1000.D + epoch_ref
                    IF data_count EQ 0 THEN BEGIN
                        time_name = 'Epoch__C' + sc_str + '_EDI_AE'
                        edi_epoch = cdf_varcreate(id, time_name, $
                                                  NUMELEM = nonzero_count, $
                                                  /cdf_epoch)
                        cdf_varput, id, edi_epoch, cdf_ag_times, $
                          count = nonzero_count
                        
                        var_status = 'AE_status_CL' + sc_str
                        amb = cdf_varcreate(id, var_status, [1], $
                                            NUMELEM = nonzero_count, $
                                            /cdf_uint1)
                        cdf_varput, id, var_status, status_byte, /zvariable
                        
                        var_theta_index = 'AE_theta_CL' + sc_str
                        amb = cdf_varcreate(id, var_theta_index, [1], $
                                            NUMELEM = nonzero_count, $
                                            /cdf_uint1)
                        cdf_varput, id, var_theta_index, theta_index, $
                          /zvariable
                        
                        var_phi_index = 'AE_phi_CL' + sc_str + '_D1'
                        amb = cdf_varcreate(id, var_phi_index, [1], $
                                            NUMELEM = nonzero_count, $
                                            /cdf_uint1)
                        cdf_varput, id, var_phi_index, phi_index, /zvariable
                    ENDIF ELSE BEGIN
                        cdf_varput, id, edi_epoch, cdf_ag_times, $
                          rec_start = data_count
                        cdf_varput, id, var_status, status_byte, $
                          rec_start = data_count, /zvariable
                        cdf_varput, id, var_theta_index, theta_index, $
                          rec_start = data_count, /zvariable
                        cdf_varput, id, var_phi_index, phi_index, $
                          rec_start = data_count, /zvariable
                    ENDELSE


                    ;perpendicular counts
                    d1_90 = data29_1
                    d1_90[*] = fill_val
                    d2_90 = data29_2
                    d2_90[*] = fill_val
                    w = where(b_perp GT 0, count)
                    IF count GT 0 THEN BEGIN
                        d1_90[w] = data29_1[w]
                        d2_90[w] = data29_2[w]
                    ENDIF
                    IF data_count EQ 0 THEN BEGIN
                        var_1_90 = 'AE_counts_CL' + sc_str + '_GDU1_PA_90'
                        amb = cdf_varcreate(id, var_1_90, [1], $
                                            NUMELEM = nonzero_count, /cdf_int2)
                        cdf_varput, id, var_1_90, d1_90, /zvariable
                        var_2_90 = 'AE_counts_CL' + sc_str + '_GDU2_PA_90'
                        amb = cdf_varcreate(id, var_2_90, [1], $
                                            NUMELEM = nonzero_count, /cdf_int2)
                        cdf_varput, id, var_2_90, d2_90, /zvariable
                    ENDIF ELSE BEGIN
                        cdf_varput, id, var_1_90, d1_90, $
                          rec_start = data_count, /zvariable
                        cdf_varput, id, var_2_90, d2_90, $
                          rec_start = data_count, /zvariable
                    ENDELSE

                    ;g1z fires in Bz direction:
                    ;det 2 has 0 PA (_2_ quantities)
                    ;det 1 has 180 PA (_1_ quantities)
                    d1_180 = data29_1
                    d1_180[*] = fill_val
                    d2_0 = data29_2
                    d2_0[*] = fill_val
                    w = where(bz_gz EQ 1 AND $
                              b_perp EQ 0, count)
                    IF count GT 0 THEN BEGIN
                        d1_180[w] = data29_1[w]
                        d2_0[w] = data29_2[w]
                    ENDIF
                    IF data_count EQ 0 THEN BEGIN
                        var_1_180 = 'AE_counts_CL' + sc_str + '_GDU1_PA_180'
                        amb = cdf_varcreate(id, var_1_180, [1], $
                                            NUMELEM = nonzero_count, /cdf_int2)
                        cdf_varput, id, var_1_180, d1_180, /zvariable
                        var_2_0 = 'AE_counts_CL' + sc_str + '_GDU2_PA_0'
                        amb = cdf_varcreate(id, var_2_0, [1], $
                                            NUMELEM = nonzero_count, /cdf_int2)
                        cdf_varput, id, var_2_0, d2_0, /zvariable
                    ENDIF ELSE BEGIN
                        cdf_varput, id, var_1_180, d1_180, $
                          rec_start = data_count, /zvariable
                        cdf_varput, id, var_2_0, d2_0, $
                          rec_start = data_count, /zvariable
                    ENDELSE


                    ;det 2 has 180 PA (_2_ quantities)
                    ;det 1 has 0 PA (_1_ quantities)
                    d1_0 = data29_1
                    d1_0[*] = fill_val
                    d2_180 = data29_2
                    d2_180[*] = fill_val
                    w = where(bz_gz EQ 0 AND $
                              b_perp EQ 0 AND $
                              time GT 0.D, count)
                    IF count GT 0 THEN BEGIN
                        d1_0[w] = data29_1[w]
                        d2_180[w] = data29_2[w]
                    ENDIF
                    IF data_count EQ 0 THEN BEGIN
                        var_1_0 = 'AE_counts_CL' + sc_str + '_GDU1_PA_0'
                        amb = cdf_varcreate(id, var_1_0, [1], $
                                            NUMELEM = nonzero_count, /cdf_int2)
                        cdf_varput, id, var_1_0, d1_0, /zvariable
                        var_2_180 = 'AE_counts_CL' + sc_str + '_GDU2_PA_180'
                        amb = cdf_varcreate(id, var_2_180, [1], $
                                            NUMELEM = nonzero_count, /cdf_int2)
                        cdf_varput, id, var_2_180, d2_180, /zvariable
                    ENDIF ELSE BEGIN
                        cdf_varput, id, var_1_0, d1_0, $
                          rec_start = data_count, /zvariable
                        cdf_varput, id, var_2_180, d2_180, $
                          rec_start = data_count, /zvariable
                    ENDELSE
                    
                    data_count = data_count + nonzero_count

                ENDIF

            ENDIF
            
        ENDIF

        last_science_mode = s.hdr.science_mode
        last_sub_mode = s.hdr.sub_mode
        last_pacmo = s.hdr.pacmo
        last_energy = s.hk.enrgy

        s = picka_sc(pid, stat, /get_hk_data)
    ENDWHILE
ENDIF

IF data_count EQ 0 THEN BEGIN
    cdf_close, id
    spawn, 'rm ' + cdf_name
    return
ENDIF

IF n_elements(srt_out) GT 1 AND $
  write_gse EQ 1 THEN BEGIN
    ;despin the gun firing angles and convert to GSE
    pp_att_orb_hpath = '/nfs/cluster/orbit/'
    phase0 = 296.2d0*!dtor
    ;add fake SRTs so that the for loop does not go out of bounds
    n_spin = n_elements(srt_out)
    last_spin = srt_out[n_spin-1] - srt_out[n_spin-2]
    srt_out = [srt_out, $
               srt_out[n_spin-1] + last_spin, $
               srt_out[n_spin-1] + 2. * last_spin, $
               srt_out[n_spin-1] + 3. * last_spin]
    data_count_gse = 0
    FOR i_spin = 0, n_elements(srt_out)-2 DO BEGIN
        
        spin_period = (srt_out[i_spin+1] - srt_out[i_spin])
        half_spin_period = spin_period / 2.
        omega = 2.D0*!dpi / spin_period
        
        w_spin = where(time_out GE srt_out[i_spin] AND $
                       time_out LT srt_out[i_spin+1], spin_count)
        IF spin_count GT 0 THEN BEGIN
            ddtime = time_out[w_spin] - srt_out[i_spin]
            phase = omega * ddtime
            cos_wt1 = cos(phase - phase0)
            sin_wt1 = sin(phase - phase0)
            
            d1th = theta_out[w_spin]
            d1ph = ph_d1_out[w_spin]
            
            ;beam 1 look direction in d1 coord
            ;x=spin axis, z=radial outward through d1
            d1x = sin(d1th*!dtor) * cos(d1ph*!dtor)
            d1y = sin(d1th*!dtor) * sin(d1ph*!dtor)
            d1z = cos(d1th*!dtor) ; y=z ^ x
            
            ;look directions in inertial frame
            d1y_inertial =  d1y * cos_wt1 - d1z * sin_wt1
            d1z_inertial =  d1y * sin_wt1 + d1z * cos_wt1
            
            ;switch coordinate system to SCS:
            ;negate y; swap x and z
            d1y_scs_tmp = -d1y_inertial
            d1x_scs_tmp =  d1z_inertial
            d1z_scs_tmp =  d1x
            
            mid_t70 = srt_out[i_spin] + half_spin_period
            att_stat = ep_extract_att(sc_str, mid_t70, decl, rasc, $
                                      pp_att_orb_hpath)
            
            t_ssm = mid_t70 - midnight_t70
            hour = fix(t_ssm / 3600.)
            minute = fix((t_ssm - hour * 3600.)/60.)
            sec = fix(t_ssm -  hour * 3600. - minute * 60.)
            ep_get_haprotmat, long(year), long(month), long(day), $
                              hour, minute, sec, $
                              rasc, decl, ierr, $
                              satgse = scs_to_gse
            
            IF (ierr NE 0) THEN print, 'Haprotmat extraction unsuccessful: '
            
            d1_scs_tmp = [[d1x_scs_tmp], [d1y_scs_tmp], [d1z_scs_tmp]]
            d1_gse = transpose(scs_to_gse) ## d1_scs_tmp
            
            GSE_angle_count = n_elements(d1x_gse_tmp)
            IF data_count_gse EQ 0 THEN BEGIN
                var_d1 = 'AE_D1_GSE_CL' + sc_str
                amb = cdf_varcreate(id, var_d1, [1], dim = [3], $
                                    NUMELEM = spin_count, /cdf_float)
                cdf_varput, id, var_d1, transpose(d1_gse), /zvariable
            ENDIF ELSE BEGIN
                cdf_varput, id, var_d1, transpose(d1_gse), $
                            rec_start = data_count_gse, /zvariable
            ENDELSE
            data_count_gse = data_count_gse + spin_count
            
            IF check_dot_product EQ 1 THEN BEGIN
                
                IF n_elements(d1x_scs) LT 1 THEN BEGIN
                    d1x_scs = d1x_scs_tmp
                    d1y_scs = d1y_scs_tmp
                    d1z_scs = d1z_scs_tmp
                ENDIF ELSE BEGIN
                    d1x_scs = [d1x_scs, d1x_scs_tmp]
                    d1y_scs = [d1y_scs, d1y_scs_tmp]
                    d1z_scs = [d1z_scs, d1z_scs_tmp]
                ENDELSE
                
                IF n_elements(d1x_gse) LT 1 THEN BEGIN
                    d1x_gse = d1_gse[*, 0]
                    d1y_gse = d1_gse[*, 1]
                    d1z_gse = d1_gse[*, 2]
                ENDIF ELSE BEGIN
                    d1x_gse = [d1x_gse, d1_gse[*, 0]]
                    d1y_gse = [d1y_gse, d1_gse[*, 1]]
                    d1z_gse = [d1z_gse, d1_gse[*, 2]]
                ENDELSE
            ENDIF
        ENDIF
    ENDFOR

    dummy = cdf_attcreate(id, 'Frame', /variable)
    cdf_attput, id, 'Frame', var_d1, 'vector>gse_xyz'

IF data_count NE data_count_gse THEN stop
;print, data_count, data_count_gse

ENDIF

pick_close
cdf_close, id

END

