
/* $Id: debug.h,v 1.1 2001/09/26 14:07:15 simond Exp $ */

#include <stdio.h>
#include <ted.h>

/* {{{ (TMF)     TM File Results read/write ... */

typedef struct {
  FILE *file;
  unsigned char *pkt;
  TED_STATUS status;
} TMF;

/* }}} */
/* {{{ (PATCH)   SIS - CCS Science patch results */

/* ESA TM time patch results */
typedef struct {
  TED_STATUS status;		/* PATCh TED status */
  unsigned char *hki;		/* HK input packet */
  unsigned char *sci;		/* SC input packet */
  unsigned char *pko;		/* PATCHED TED  */
} PATCH;

/* }}} */
/* {{{ (CONV)    packet conversion results */

typedef struct {
  unsigned char *pki;		/* input packet */
  unsigned char *pko;		/* output packet */
  TED_STATUS status;		/* conversion TED status */
} CONV;

/* }}} */
/* {{{ (DEBUG)   file processing input results */

typedef struct {
  int debug;			/* the debugging level */
  char *hki;			/* HK input filename */
  char *sci;			/* SC input filename */
  char *hko;			/* HK output filename */
  char *sco;			/* SC output filename */
  TED_SPACECRAFT scid;		/* spacecraft identifier */
  TED_TRANSMISSION stream;	/* the source of the data */
  TED_QUALITY tcal;		/* the accuracy of the time */
  TED_GROUND gsid;		/* the ground segment that received the data */
} DEBUG;

/* }}} */
/* {{{ (RESULTS) packet conversion cycle results  */

typedef struct {
  DEBUG debug;			/* i/p params to proc_stub */

  TMF sci;			/* SC input results */
  TMF hki;			/* HK input results */

  PATCH patch;			/* ESA TM SC time patch results */

  CONV sc;			/* SC conversion results */
  CONV hk;			/* HK conversion results */

  TMF sco;			/* SC output results */
  TMF hko;			/* HK output results */

} RESULTS;

/* }}} */

/* {{{ external interface */

#ifndef THIS_IS_CONVERT_DRIVE_STUB

extern void drive_stub_dump (RESULTS *res);
extern void DebugInit (RESULTS *res);
#endif

/* }}} */

/* Local variables: */
/* folded-file: t */
/* end: */


