
/* $Id: debug.c,v 1.1 2001/09/26 14:07:15 simond Exp $ */

#define THIS_IS_CONVERT_DRIVE_STUB

#include <debug.h>
#include <convert.h>

/* {{{ dump PACKET structure */

#define DUMP_PACKET_BLOCK_SIZE 20

void debug_dump_packet (FILE *stream,unsigned char *packet)
{
  if (stream == NULL) {
    fprintf (stderr,"debug_dump_packet stream arg error\n");
    return;
  }

  if (packet == NULL) {
    fprintf (stream,"debug_dump_packet no packet found\n");
    return;
  }

  {
    int index = 0;

    for (index=0;index < DUMP_PACKET_BLOCK_SIZE; index++) {
      if (packet[index] < 0x10)
	fprintf (stream,"0");
      fprintf (stream,"%x ",packet[index]);
    }
  }
  fprintf (stream,"\n");
}

/* }}} */
/* {{{ dump TMF    structure */

void debug_tmf_dump (FILE *stream,
		     char indent[],
		     char title[],
		     TMF tmf)
{
  char str[256];
  fprintf (stream,"%s%s\n",indent,title);
  fprintf (stream,"%s\ttmf.pkt -> ",indent);
  debug_dump_packet (stream,tmf.pkt);
  fprintf (stream,"%s\ttmf.status -> %s\n",indent,ted_status_symbol (tmf.status));
}

/* }}} */
/* {{{ dump PATCH  structure */

void debug_patch_dump (FILE *stream,
		       char indent[],
		       char title[],
		       PATCH patch)
{
  fprintf (stream,"%s%s\n",indent,title);

  fprintf (stream,"%s\tpatch.status -> %s\n",
	   indent,
	   ted_status_symbol (patch.status));

  fprintf (stream,"%s\tpatch.hki -> ",indent);
  debug_dump_packet (stream,patch.hki);

  fprintf (stream,"%s\tpatch.sci -> ",indent);
  debug_dump_packet (stream,patch.sci);

  fprintf (stream,"%s\tpatch.pko -> ",indent);
  debug_dump_packet (stream,patch.pko);
}

/* }}} */
/* {{{ dump CONV   structure */

void debug_conv_dump (FILE *stream,
		       char indent[],
		       char title[],
		       CONV conv)
{
  fprintf (stream,"%s%s\n",indent,title);

  fprintf (stream,"%s\tconv.pki -> ",indent);
  debug_dump_packet (stream,conv.pki);

  fprintf (stream,"%s\tconv.pko -> ",indent);
  debug_dump_packet (stream,conv.pko);

  fprintf (stream,"%s\tconv.status -> %s\n",indent,ted_status_symbol(conv.status));

}

/* }}} */
/* {{{ dump DEBUG  structure */

void debug_debug_dump (FILE *stream,
		       char indent[],
		       char title[],
		       DEBUG debug)
{
  fprintf (stream,"%s%s\n",indent,title);

  fprintf (stream,"%s\tdebug.debug -> %d\n",indent,debug.debug);
  fprintf (stream,"%s\tdebug.hki -> %s\n",indent,debug.hki);
  fprintf (stream,"%s\tdebug.sci -> %s\n",indent,debug.sci);
  fprintf (stream,"%s\tdebug.hko -> %s\n",indent,debug.hko);
  fprintf (stream,"%s\tdebug.sco -> %s\n",indent,debug.sco);

  fprintf (stream,"%s\tdebug.scid -> %s\n",indent, ted_scid_symbol (debug.scid));
  fprintf (stream,"%s\tdebug.stream -> %s\n",
	   indent,
	   ted_transmission_symbol (debug.stream));
  fprintf (stream,"%s\tdebug.tcal -> %s\n",indent,ted_quality_symbol (debug.tcal));
  fprintf (stream,"%s\tdebug.gsid -> %s\n",indent,ted_ground_symbol (debug.gsid));
}

/* }}} */
/* {{{ dump RESULT structure */

void drive_stub_dump (RESULTS *res)
{
  fprintf (stderr,"Results Report\n");
  fprintf (stderr,"\n");

  debug_debug_dump (stderr,"\t","Debug Information: ",res->debug);
  fprintf (stderr,"\n");

  debug_tmf_dump (stderr,"\t","SC input results: ",res->sci);
  fprintf (stderr,"\n");
  debug_tmf_dump (stderr,"\t","HK input results: ",res->hki);
  fprintf (stderr,"\n");

  debug_patch_dump (stderr,"\t","PATCH results: ",res->patch);
  fprintf (stderr,"\n");

  debug_conv_dump (stderr,"\t","CONV SC results: ",res->sc);
  fprintf (stderr,"\n");
  debug_conv_dump (stderr,"\t","CONV HK results: ",res->hk);
  fprintf (stderr,"\n");

  debug_tmf_dump (stderr,"\t","SC output results: ",res->sco);
  fprintf (stderr,"\n");
  debug_tmf_dump (stderr,"\t","HK output results: ",res->hko);
  fprintf (stderr,"\n");
}

/* }}} */
/* {{{ init        structure */

void DebugInit (RESULTS *res)
{
  if (res == NULL)
    return;

#define RES_NO_FILE "file not defined"

  res->debug.debug = -1;
  res->debug.hki    = RES_NO_FILE;
  res->debug.sci    = RES_NO_FILE;
  res->debug.hko    = RES_NO_FILE;
  res->debug.sco    = RES_NO_FILE;
  res->debug.scid   = CLUSTER_1;
  res->debug.stream = TED_TRANSMISSION_RECALLPLAYBACK;
  res->debug.tcal   = TED_QUALITY_EXTRAPOLATED;
  res->debug.gsid   = TED_GROUND_ODENWALD;

  res->sci.file     = NULL;
  res->sci.pkt      = NULL;
  res->sci.status   = TED_UNIMPLEMENTED;

  res->hki.file     = NULL;
  res->hki.pkt      = NULL;
  res->hki.status   = TED_UNIMPLEMENTED;

  res->patch.status = TED_UNIMPLEMENTED;
  res->patch.hki    = NULL;
  res->patch.sci    = NULL;
  res->patch.pko    = NULL;

  res->sc.pki       = NULL;
  res->sc.pko       = NULL;
  res->sc.status    = TED_UNIMPLEMENTED;

  res->hk.pki       = NULL;
  res->hk.pko       = NULL;
  res->hk.status    = TED_UNIMPLEMENTED;

  res->sco.file     = NULL;
  res->sco.pkt      = NULL;
  res->sco.status   = TED_UNIMPLEMENTED;
}

/* }}} */


/* Local variables: */
/* folded-file: t */
/* end: */

