 
/**
 * $Id: show.c,v 1.1 2001/09/26 14:07:03 simond Exp $
 */

#define _show_c
#include <show.h>
#include <dsd.h>

#define TRUE 1
#define FALSE 0

#define DUMMY 0

void ddsp_show_header(packet)
     char *packet;
{
  TED_TIME scet;

  scet.day = ddsp_day(packet);
  scet.ms = ddsp_msec(packet);
  scet.us = ddsp_usec(packet);

  fprintf(stderr, "%-24s%s\n", "SCET", CCSDSToString(&scet));
  fprintf(stderr, "%-24s%s\n", name_ddsp_source, text_ddsp_source(ddsp_source(packet)));
  fprintf(stderr, "%-24s%d\n", name_ddsp_length, ddsp_length(packet));
  fprintf(stderr, "%-24s%s\n", name_ddsp_ground, text_ddsp_ground(ddsp_ground(packet)));
  fprintf(stderr, "%-24s%s\n", name_ddsp_spacecraft, text_ddsp_spacecraft(ddsp_spacecraft(packet)));
  fprintf(stderr, "%-24s%s\n", name_ddsp_stream, text_ddsp_stream(ddsp_stream(packet)));
  fprintf(stderr, "%-24s%s\n", name_ddsp_quality, text_ddsp_quality(ddsp_quality(packet)));
  fprintf(stderr, "%-24s%d\n", "ASID", ddsp_sequence(packet));
}

/* {{{ void dsdheader_txt (BYTE *,FILE *) */

void
dsdheader_txt(
BYTE *header,
FILE *p_FILE
)
{
  fprintf(p_FILE, "%-14s%s\n", "Version",
	 VersionToString(dsd_version(header), dsd_revision(header),
			 dsd_patch(header), dsd_userpatch(header)));
  fprintf(p_FILE, "%-14s%s\n", name_dsd_spacecraft, text_ddsp_spacecraft(dsd_spacecraft(header)));
  fprintf(p_FILE, "%-14s%s\n", name_dsd_ground, text_ddsp_ground(dsd_ground(header)));
  fprintf(p_FILE, "%-14s%s\n", name_dsd_source, text_minipd_source(dsd_source(header)));
  fprintf(p_FILE, "%-14s", name_dsd_dw);
  if (dsd_dw(header) & TED_DSD_DW_NOHK) fprintf(p_FILE, "NOHK ");
  if (dsd_dw(header) & TED_DSD_DW_TRUNC) fprintf(p_FILE, "TRUNC ");
  if (dsd_dw(header) & TED_DSD_DW_HKTIMESAME) fprintf(p_FILE, "HKTIMESAME ");
  if (dsd_dw(header) & TED_DSD_DW_HKEXTRAPOLATED) fprintf(p_FILE, "HKEXTRAPOLATED ");
  if (dsd_dw(header) & TED_DSD_DW_HKCONTINGENCY) fprintf(p_FILE, "HKCONTINGENCY ");
  if (dsd_dw(header) & TED_DSD_DW_NOHKTIME) fprintf(p_FILE, "NOHKTIME ");
  /*
  if (dsd_dw(header) & TED_DSD_DW_EW5PRCTLNONZERO) fprintf(p_FILE, "EW5PRCTLNONZERO ");
  if (dsd_dw(header) & TED_DSD_DW_EW5SSOFFTEST) fprintf(p_FILE, "EW5SSOFFTEST ");
  */
  if (dsd_dw(header) & TED_DSD_DW_HKTCOR_CORRECTED) fprintf(p_FILE, "HKTCOR_CORRECTED ");

  if (dsd_dw(header) == 0) fprintf(p_FILE, "-");
  fprintf(p_FILE, "\n");
  fprintf(p_FILE, "%-14s%d\n", name_dsd_length, dsd_length(header));
  if (dsd_dw(header) & TED_DSD_DW_NOHKTIME)
    fprintf(p_FILE, "%-14s%s\n", "Timestamp", "(undefined)");
  else {
    fprintf(p_FILE, "%-14s%04d-%02d-%02dT%02d:%02d:%02d.%03d%03dZ\n", "Timestamp",
	   dsd_year(header) + 1900, dsd_month(header),
	   dsd_day(header), dsd_hour(header),
	   dsd_min(header), dsd_sec(header),
	   dsd_msec(header), dsd_usec(header));
  }
  fprintf(p_FILE, "%-14s%d\n", name_dsd_dwpcount, dsd_dwpcount(header));
  fprintf(p_FILE, "%-14s%d\n", name_dsd_obdhmod8, dsd_obdhmod8(header));
  fprintf(p_FILE, "%-14s%d\n", name_dsd_udef0, dsd_udef0(header));
  fprintf(p_FILE, "%-14s%d\n", name_dsd_udef1, dsd_udef1(header));
}

/* }}} */
/* {{{ void dsdheader_xml (BYTE *,FILE *) */

void
dsdheader_xml(
BYTE *header,
FILE *p_FILE
)
{
  fprintf(p_FILE,
	  "\n<dsd-header");
  fprintf(p_FILE,
	  "\n     version=\"%s\"",
	  VersionToString(dsd_version(header),
			  dsd_revision(header),
			  dsd_patch(header),
			  dsd_userpatch(header)));
  fprintf(p_FILE,
	  "\n     spacecraft=\"%s\"",
	  text_ddsp_spacecraft(dsd_spacecraft(header)));
  fprintf(p_FILE,
	  "\n     ground=\"%s\"",
	  text_ddsp_ground(dsd_ground(header)));
  fprintf(p_FILE,
	  "\n     source=\"%s\"",
	  text_minipd_source(dsd_source(header)));
  if (dsd_dw(header) & TED_DSD_DW_NOHK)
    fprintf(p_FILE,
	    "\n     nohk=\"1\"");
  if (dsd_dw(header) & TED_DSD_DW_TRUNC)
    fprintf(p_FILE,
	    "\n     trunc=\"1\"");
  if (dsd_dw(header) & TED_DSD_DW_HKTIMESAME)
    fprintf(p_FILE,
	    "\n     hktimesame=\"1\"");
  if (dsd_dw(header) & TED_DSD_DW_HKEXTRAPOLATED)
    fprintf(p_FILE,
	    "\n     hkextrapolated=\"1\"");
  if (dsd_dw(header) & TED_DSD_DW_HKCONTINGENCY)
    fprintf(p_FILE,
	    "\n     hkcontingency=\"1\"");
  if (dsd_dw(header) & TED_DSD_DW_NOHKTIME)
    fprintf(p_FILE,
	    "\n     nohktime=\"1\"");
  /*
  if (dsd_dw(header) & TED_DSD_DW_EW5PRCTLNONZERO)
    fprintf(p_FILE,
	    "\n     ew5prctlnonzero=\"1\"");
  if (dsd_dw(header) & TED_DSD_DW_EW5SSOFFTEST)
    fprintf(p_FILE,
	    "\n     ew5ssofftest=\"1\"");
  */
  fprintf(p_FILE,
	    "\n     length=\"%d\"",
	  dsd_length(header));
  if ((dsd_dw(header) & TED_DSD_DW_NOHKTIME) == 0)
    fprintf(p_FILE,
	    "\n     timestamp=\"%04d-%02d-%02dT%02d:%02d:%02d.%03d%03dZ\"",
	    dsd_year(header) + 1900,
	    dsd_month(header),
	    dsd_day(header),
	    dsd_hour(header),
	    dsd_min(header),
	    dsd_sec(header),
	    dsd_msec(header),
	    dsd_usec(header));
  fprintf(p_FILE,
	  "\n     mcc=\"%d\"",
	  dsd_dwpcount(header));
  fprintf(p_FILE,
	  "\n     rpc8=\"%d\"",
	  dsd_obdhmod8(header));
  fprintf(p_FILE,
	  "\n     udef0=\"%d\"",
	  dsd_udef0(header));
  fprintf(p_FILE,
	  "\n     udef1=\"%d\"",
	  dsd_udef1(header));
  fprintf(p_FILE,
	  "/>");

}

/* }}} */
/* {{{ void dsdheader_show(char *) */

void
dsdheader_show(
char *header
)
{
  dsdheader_txt((BYTE *)header,stderr);
}

/* }}} */
/* {{{ void minipd_txt    (BYTE *,FILE *) */

void
minipd_txt(
BYTE *mp,
FILE *p_FILE
)
{
  fprintf(p_FILE, "%-14s%d\n", "Length", minipd_length(mp));
  fprintf(p_FILE, "%-14s%s\n", "Source", text_minipd_source(minipd_source(mp)));
  fprintf(p_FILE, "%-14s%s\n", "Type", text_minipd_type(minipd_type(mp)));
  switch (minipd_type(mp)) {
  case minipd_type_single:
  case minipd_type_first:
    fprintf(p_FILE, "%-14s%d/%d\n", "UDEF1/UDEF0", minipd_count(mp) & 2 >> 1,
	   minipd_count(mp) & 1);
    break;
  case minipd_type_middle:
  case minipd_type_last:
    fprintf(p_FILE, "%-14s%d\n", "Count", minipd_count(mp));
    break;
  }
}

/* }}} */
/* {{{ void minipd_show   (char *) */

void
minipd_show(
char *mp
)
{
  minipd_txt((BYTE *)mp,stderr);
}

/* }}} */

void dsditems_show(TED_DSD_ITEMS *items)
{
  fprintf(stderr, "%-14s%s\n", "Version",
	 VersionToString(items->version, items->revision,
			 items->patch, items->userpatch));
  fprintf(stderr, "%-14s%s\n", "SPACECRAFT", text_ddsp_spacecraft(items->spacecraft));
  fprintf(stderr, "%-14s%s\n", "GROUND", text_ddsp_ground(items->ground));
  fprintf(stderr, "%-14s%s\n", "SOURCE", text_minipd_source(items->source));
  fprintf(stderr, "%-14s", "DW");
  if (items->dw & TED_DSD_DW_NOHK) fprintf(stderr, "NOHK ");
  if (items->dw & TED_DSD_DW_TRUNC) fprintf(stderr, "TRUNC ");
  if (items->dw & TED_DSD_DW_HKTIMESAME) fprintf(stderr, "HKTIMESAME ");
  if (items->dw & TED_DSD_DW_HKEXTRAPOLATED) fprintf(stderr, "HKEXTRAPOLATED ");
  if (items->dw & TED_DSD_DW_HKCONTINGENCY) fprintf(stderr, "HKCONTINGENCY ");
  if (items->dw & TED_DSD_DW_NOHKTIME) fprintf(stderr, "NOHKTIME ");
  /*
  if (items->dw & TED_DSD_DW_EW5PRCTLNONZERO) fprintf(stderr, "EW5PRCTLNONZERO ");
  if (items->dw & TED_DSD_DW_EW5SSOFFTEST) fprintf(stderr, "EW5SSOFFTEST ");
  */
  if (items->dw & TED_DSD_DW_HKTCOR_CORRECTED) fprintf(stderr, "HKTCOR_CORRECTED ");
  if (items->dw == 0) fprintf(stderr, "-");
  fprintf(stderr, "\n");
  fprintf(stderr, "%-14s%d\n", "LENGTH", items->length);

  if (items->dw & TED_DSD_DW_NOHKTIME)
    fprintf(stderr, "%-14s%s\n", "Timestamp", "(undefined)");
  else {
    fprintf(stderr, "%-14s%04d-%02d-%02dT%02d:%02d:%02d.%03d%03dZ\n", "Timestamp",
	   items->year + 1900, items->month,
	   items->day, items->hour,
	   items->min, items->sec,
	   items->msec, items->usec);
  }

  fprintf(stderr, "%-14s%d\n", "DWPCOUNT", items->dwpcount);
  fprintf(stderr, "%-14s%d\n", "OBDHMOD8", items->obdhmod8);
  fprintf(stderr, "%-14s%d\n", "UDEF0", items->udef0);
  fprintf(stderr, "%-14s%d\n", "UDEF1", items->udef1);
}

/* Local variables: */
/* folded-file: t */
/* end: */
