
/**
 * $Id: misc.c,v 1.1 2001/09/26 14:07:01 simond Exp $
 */

#define  _misc_c
#include <misc.h>

/* {{{ TED_TIME *    UnixToCCSDS(time_t) */

TED_TIME *UnixToCCSDS(time_t seconds)
{
  static TED_TIME ccsds;

  seconds += 378691200;	/* Epoch 1/1/58 */

  ccsds.day = seconds / 86400;
  ccsds.ms = (seconds % 86400) * 1000;
  ccsds.us = 0;
  
  return &ccsds;
}

/* }}} */
/* {{{ time_t *      CCSDSToUnix(TED_TIME *) */

time_t *CCSDSToUnix(TED_TIME *ccsds)
{
  static time_t seconds;

  seconds = ccsds->day * 86400;
  seconds += ccsds->ms / 1000;

  seconds -= 378691200;	/* Epoch 1/1/70 */

  return &seconds;
}

/* }}} */
/* {{{ char *      CCSDSToString(TED_TIME *) */

char *CCSDSToString(TED_TIME *ccsds)
{
  static char string[50];

  strftime(string, 50, "%Y-%m-%dT%H:%M:%S.", gmtime(CCSDSToUnix(ccsds)));
  sprintf(string+strlen(string), "%03d%03dZ", ccsds->ms-1000*(ccsds->ms/1000), ccsds->us);

  return string;
}

/* }}} */
/* {{{ TED_TIME *  PacketToCCSDS(char *) */

TED_TIME *
PacketToCCSDS(
BYTE *packet
)
{
  static TED_TIME ccsds;
      
  ccsds.day = ddsp_day(packet);
  ccsds.ms = ddsp_msec(packet);
  ccsds.us = ddsp_usec(packet);
  
  return &ccsds;
}

/* }}} */
/* {{{ void          show_buffer(char *buffer, int length) */

void show_buffer(char *buffer, int length)
{
  int i;
  printf("Buffer (%d bytes %d words):\n", length, length/2);
  for (i = 0; i < length; i++)
    printf("[%02d] = %02x\n", i, buffer[i]);
}

/* }}} */
/* {{{ char *     StatusToString(TED_STATUS status) */

char *StatusToString(TED_STATUS status)
{
  static char *strings[] = {
    "TED_OK",
    "TED_UNIMPLEMENTED",
    "TED_MEMORY",
    "TED_READ_SIZE",
    "TED_READ_EARLIER",
    "TED_READ_WRONGTYPE",
    "TED_READ_EOF",
    "TED_READ_FILE",
    "TED_UNPACK_SPACECRAFT",
    "TED_UNPACK_DIAGEND",
    "TED_UNPACK_FATAL",
    "TED_UNPACK_WRONGTYPE",
    "TED_CONVERT_SOURCEINVALID",
    "TED_CONVERT_SPACECRAFTINVALID",
    "TED_CONVERT_SPACECRAFTMATCH",
    "TED_CONVERT_STREAMINVALID",
    "TED_CONVERT_GROUNDINVALID",
    "TED_CONVERT_CHANNELTYPE_MATCH",
    "TED_CONVERT_QUALITYINVALID",
    "TED_CONVERT_SEQUENCEINVALID",
    "TED_CONVERT_DDSP_WRITE_HEADER_ERR",
    "TED_CONVERT_DDSP_WRITE_DATA_ERR",
    "TED_CONVERT_TMP_WRITE_HEADER_ERR",
    "TED_CONVERT_TMP_WRITE_DATA_ERR",
    "TED_CONVERT_TOOLONG",
    "TED_CONVERT_WRONGVERSION",
    "TED_CONVERT_WRONGTYPE",
    "TED_CONVERT_SEGWRONG",
    "TED_CONVERT_APIDINVALID",
    "TED_CONVERT_FLAGWRONG",
    "TED_CONVERT_PFIELDWRONG",
    "TED_DSD_DEFINITIONSETINVALID",
    "TED_NOTINITIALISED"
  };
  if (status < TED_OK || status > TED_NOTINITIALISED)
    return "?";
  else
    return strings[status];
}

/* }}} */
/* {{{ char * DiagnosticToString(TED_UNPACK_DIAG *) */

char *DiagnosticToString(TED_UNPACK_DIAG *diagnostic)
{
  static char *strings[] = {
    "DDSSOURCEINVALID",
    "DDSSPACECRAFTINVALID",
    "DDSSPACECRAFTMATCH",
    "DDSSTREAMINVALID",
    "DDSGROUNDINVALID",
    "DDSCHANNELTYPEMATCH",
    "DDSQUALITYINVALID",
    "DDSSEQUENCEINVALID",
    "DDSSPACECRAFTWRONG",
    "DDSDATATYPEWRONG",
    "DDSTIMESAME",
    "HKLENGTHWRONG",
    "HKEW5MOTAGINVALID",
    "HKEW5MOTAGMATCH",
    "DATALENGTHWRONG",
    "MPTRUNCATED",
    "MPSOURCEINVALID",
    "MPSOURCEWRONG",
    "MPCOUNTWRONG",
    "MPLENGTHEXTENDS",
    "MPMIDDLEFOUND",
    "SPTOOLONG",
	"HKTCORERROR",
    "MPLENGTHZERO"
  };
  static char string[100];

  if (diagnostic->code < TED_DIAG_DDSSOURCEINVALID || diagnostic->code > TED_DIAG_MPLENGTHZERO)
    return "?";
  else {
    sprintf(string, "%s %05d/%08d/%03d %s", CCSDSToString(&diagnostic->time),
	    diagnostic->time.day, diagnostic->time.ms,
	    diagnostic->time.us, strings[diagnostic->code]);
    if (diagnostic->details) {
      strcat(string, " ");
      strcat(string, diagnostic->details);
    }
    return string;
  }
}

/* }}} */
/* {{{ int    ParseRCSSYMREVNAME(char *, rcssymrevinfo **) */

int ParseRCSSYMREVNAME(char *rcssymrevname, rcssymrevinfo **info)
{
  static rcssymrevinfo my_info;
  static char item[101];

  my_info.item = item;
  *info = &my_info;
  
  if (sscanf(rcssymrevname, "%[^-]-v%ur%up%u", my_info.item, &my_info.version,
	     &my_info.revision, &my_info.patch) == 4)
    return 0;
  else
    return 1;
}

/* }}} */
/* {{{ char *    VersionToString(int,int,int,int) */

char *VersionToString(int version, int revision, int patch, int userpatch)
{
  static char string[40];

  sprintf(string, "Version %d.%d", version, revision);
  if (patch) sprintf(string + strlen(string), " Patch %d", patch);
  if (userpatch) sprintf(string + strlen(string), " (User Patch %d)", userpatch);
  return string;
}

/* }}} */

/* Local variables: */
/* folded-file: t */
/* end: */
