
/***
 * $Id: hktim.h,v 1.1 2001/09/26 14:06:59 simond Exp $
 */

/* Taken from TED 2.4.4, modified for use in TED 2.4.3x and 2.5 */

#ifndef _hktim_h
#define _hktim_h

#include <stdio.h>
#include "ddsp.h"

/* {{{ STATUS */

enum HKTIM_STATUS
{
  HKTIM_STATUS_OK,
  HKTIM_STATUS_MEMORY
};
typedef enum HKTIM_STATUS HKTIM_STATUS;

/* }}} */
/* {{{ HKTIM_MODE */

enum HKTIM_MODE
{
  HKTIM_MODE_ALWAYS_ZERO = 0,
  HKTIM_MODE_ALWAYS_VALID = 1,
  HKTIM_MODE_EXTRAPOLATION = 2,
  HKTIM_MODE_RUNNING_AVERAGE = 3
};
typedef enum HKTIM_MODE     HKTIM_MODE;
typedef enum HKTIM_MODE TED_HKTIM_MODE;

/* }}} */

struct HKTIM {
  HKTIM_MODE m_SSOFF_MODE;
  HKTIM_MODE m_MCLK_MODE;

  double m_EW5SSOFF_ERROR;
  double m_EW5SSOFF_FINAL;

  int    m_EW5SSOFF_DELTA;
  double m_EW5SSOFF_DELTA_AV;

  int    m_EW5SSOFF;
  int    m_EW5SSOFF_INVALID;

  int    m_EW5SSOFF_1;
  /* int    m_EW5SSOFF_VALID_1; */

  int    m_EW5SSOFF_2;
  /* int    m_EW5SSOFF_VALID_2; */

  int    m_EW5SSOFF_AV;
  int    m_EW5SSOFF_AV_VALID;

  int    m_EW5RSCNT;
  int    m_EW5RSCNT_DELTA;
  int    m_EW5RSCNT_1;
  int    m_EW5RSCNT_2;
  int    m_EW5RSCNT_LAST;

  SCET  *m_SCET;
  double m_dSCET;
  double m_dSCET_LAST;

  double m_MCLK_FREQ;

  int m_EW5SSVAL;
};
typedef struct HKTIM HKTIM;
typedef struct HKTIM TED_HKTIM;

#ifndef _hktim_c
extern char * hktim_status_text(int);
extern char * hktim_mode_text(int);
extern int    hktim_init    (HKTIM **);
extern int    hktim_update  (HKTIM *,DDSP *);
extern void   hktim_show    (HKTIM *,FILE *);
extern int    hktim_get_mode(HKTIM *);
extern void   hktim_set_mode(HKTIM *,HKTIM_MODE);
extern double hktim_get_mcfreq (HKTIM *);
extern void   hktim_set_mcfreq (HKTIM *, double freq);
extern int    hktim_final   (HKTIM **);
#endif
#endif

/* Local variables: */
/* folded-file: t */
/* end: */





