

/****
 * $Id: hktim.c,v 1.1 2001/09/26 14:06:58 simond Exp $
 */

/* Taken from TED 2.4.4, modified for use in TED 2.4.3x, and 2.5 */

#include "hktim.h"
#include "hkmacros.h"
#include <stdio.h>
#include <math.h>

#define EW5SSOFF_AV_VALID_MAX 3          /* Maximum value of the delta average valid counter */
#define EW5SSOFF_MAX_VALID 950           /* EW5SSOFF always invalid if greater than this */
#define EW5SSOFF_MIN_INVALID 220         /* EW5SSOFF always valid if less than this */
                                         /* Between above values valid if EW5SSVAL is zero */
#define EW5SSOFF_MAX_ERROR 110.0         /* Maximum error allowed in EW5SSOFF running average */

HKTIM_MODE c_SSOFF_MODE = HKTIM_MODE_ALWAYS_VALID;
/* HKTIM_MODE c_MCLK_MODE = HKTIM_MODE_ALWAYS_VALID; */

/* {{{ field_info hktim_status_info[] = { */

field_info hktim_status_info[] = {
  HKTIM_STATUS_OK,	"HKTIM_STATUS_OK",
  HKTIM_STATUS_MEMORY,	"HKTIM_STATUS_MEMORY",
  0,NULL
};

/* }}} */
/* {{{ char *     hktim_status_text   (int) */

char *hktim_status_text(int p_int)
{
  return get_desc(hktim_status_info,p_int);
}

/* }}} */
/* {{{ field_info hktim_mode_info[] = { */

field_info hktim_mode_info[] = {
  HKTIM_MODE_ALWAYS_ZERO,	"HKTIM_MODE_ALWAYS_ZERO",
  HKTIM_MODE_ALWAYS_VALID,	"HKTIM_MODE_ALWAYS_VALID",
  HKTIM_MODE_EXTRAPOLATION,	"HKTIM_MODE_EXTRAPOLATION",
  HKTIM_MODE_RUNNING_AVERAGE,	"HKTIM_MODE_RUNNING_AVERAGE",
  0,NULL
};

/* }}} */
/* {{{ char *     hktim_mode_to_string(int) */

char *
hktim_mode_to_string(
int p_int
)
{
  return get_desc(hktim_mode_info,p_int);
}

/* }}} */
/* {{{ bool       hktim_cal_invalid   (HKTIM *,unsigned char *) */

int hktim_cal_invalid(unsigned char *p_Pkt)
{
  if (hkblock_EW5SSVAL(p_Pkt) && (hkblock_EW5SSOFF(p_Pkt) > EW5SSOFF_MIN_INVALID)) return TRUE;
  if (hkblock_EW5SSOFF(p_Pkt) > EW5SSOFF_MAX_VALID)                                return TRUE;
  return FALSE;
}

/* }}} */

/* {{{ int        hktim_get_mode      (HKTIM *) */

int hktim_get_mode(HKTIM *this)
{
  if (this != NULL) return this->m_SSOFF_MODE;
  return c_SSOFF_MODE;
}

/* }}} */
/* {{{ void       hktim_set_mode      (HKTIM *,HKTIM_MODE) */

void hktim_set_mode(HKTIM *this,HKTIM_MODE mode)
{
  if (this != NULL)
    this->m_SSOFF_MODE = mode;
  else
    c_SSOFF_MODE = mode;
}

/* }}} */

/* {{{ int        hktim_get_ssoff_mode(HKTIM *) */

int hktim_get_ssoff_mode(HKTIM *this)
{
  if (this != NULL) return this->m_SSOFF_MODE;
  return c_SSOFF_MODE;
}

/* }}} */
/* {{{ void       hktim_set_ssoff_mode(HKTIM *,HKTIM_MODE) */

void hktim_set_ssoff_mode(HKTIM *this,HKTIM_MODE mode)
{
  if (this != NULL)
    this->m_SSOFF_MODE = mode;
  else
    c_SSOFF_MODE = mode;
}

/* }}} */


/* {{{ int        hktim_init          (HKTIM **,HKTIM_MODE) */

int
hktim_init(
HKTIM **p_this
)
{
  int l_ERROR = FALSE;
  HKTIM *this = NULL;
  this = malloc(sizeof(HKTIM));
  if (this == NULL) {
    *p_this = NULL;
    return (HKTIM_STATUS_MEMORY);
  }

  this->m_EW5SSOFF_FINAL = 0.0;
  this->m_EW5SSOFF_ERROR = 0.0;
  this->m_EW5SSOFF   = 0;
  this->m_EW5SSOFF_1 = 0;
  this->m_EW5SSOFF_2 = 0;
  this->m_EW5SSOFF_INVALID   = TRUE;
  /*
  this->m_EW5SSOFF_VALID_1 = FALSE;
  this->m_EW5SSOFF_VALID_2 = FALSE;
*/
  this->m_EW5RSCNT_DELTA = 0;
  this->m_EW5RSCNT   = 0;
  this->m_EW5RSCNT_1 = 0;
  this->m_EW5RSCNT_2 = 0;
  this->m_EW5RSCNT_LAST = 0;

  this->m_MCLK_FREQ = 900.0;

  /* if (scet_final(&(this->m_SCET))     != DDSP_STATUS_OK) l_ERROR = TRUE; */
  if (scet_init(&(this->m_SCET))      != DDSP_STATUS_OK) l_ERROR = TRUE;
  if (l_ERROR == TRUE) {
    hktim_final(&this);
    *p_this = NULL;
    return (HKTIM_STATUS_MEMORY);
  }
  this->m_dSCET = 0.0;
  this->m_dSCET_LAST = 0.0;
      
  this->m_EW5SSOFF_DELTA_AV = 0.0;
  this->m_EW5SSOFF_AV_VALID = 0;
  this->m_EW5SSVAL = 0;

  this->m_SSOFF_MODE = c_SSOFF_MODE;

  *p_this = this;
  return (HKTIM_STATUS_OK);
}

/* }}} */

/* {{{ int        hktim_final         (HKTIM *) */

int
hktim_final(
HKTIM **p_this
)
{
  HKTIM *this = *p_this;
  if (this != NULL)
    {
      scet_final(&(this->m_SCET));
      free(this);
      *p_this = NULL;
    }
  return (HKTIM_STATUS_OK);
}

/* }}} */
/* {{{ void       hktim_update        (HKTIM *,DDSP *) */

int
hktim_update(
HKTIM *this,
DDSP *p_DDSP
)
{
  int mode_used;
  double delta_scet;

  unsigned char *p_Pkt = ddsp_get_data(p_DDSP);

  if (this == NULL) return -1;
  if (p_DDSP == NULL) return -1;

  /* Extract params from HK frame */
  this->m_EW5RSCNT  = hkblock_EW5RSCNT(p_Pkt);
  this->m_EW5SSOFF = hkblock_EW5SSOFF(p_Pkt);
  this->m_EW5SSVAL = hkblock_EW5SSVAL(p_Pkt);
  this->m_EW5SSOFF_INVALID = hktim_cal_invalid(p_Pkt);

  /* Get SCET for Master Clock frequency */
  scet_get_ddsp (this->m_SCET, p_DDSP);
  scet_to_double (this->m_SCET,&(this->m_dSCET));

  /* If missing HK frame must flag averages and previous counts as invalid */
  delta_scet = this->m_dSCET - this->m_dSCET_LAST;
  if (this->m_EW5RSCNT - this->m_EW5RSCNT_LAST != 1 ||
	  delta_scet < 5.0 || delta_scet > 5.3) {
	  this->m_EW5SSOFF_AV_VALID = 0;
	  this->m_EW5RSCNT_1 = 0;
	  this->m_EW5RSCNT_2 = 0;
  }

  /* Compute deltas */
  this->m_EW5SSOFF_DELTA = this->m_EW5SSOFF_1 - this->m_EW5SSOFF_2;
  if (this->m_EW5SSOFF_DELTA >  555) this->m_EW5SSOFF_DELTA -= 1111;
  if (this->m_EW5SSOFF_DELTA < -555) this->m_EW5SSOFF_DELTA += 1111;
  this->m_EW5RSCNT_DELTA = this->m_EW5RSCNT_1  - this->m_EW5RSCNT_2;
  
  /* Average offset delta becomes valid, or may be updated, once for each two
   concecutive HK frames with valid EW5SSOFF parameters */
  if (this->m_EW5RSCNT_DELTA == 1 && this->m_EW5RSCNT == this->m_EW5RSCNT_1 + 1) {
	  if (this->m_EW5SSOFF_AV_VALID) {
		  /* Try initialising only here - update as part of running average calculation.
	    this->m_EW5SSOFF_DELTA_AV += 0.1 * (this->m_EW5SSOFF_DELTA - this->m_EW5SSOFF_DELTA_AV);
		*/
	  }
	  else {
	    this->m_EW5SSOFF_DELTA_AV = this->m_EW5SSOFF_DELTA;
	    this->m_EW5SSOFF_AV_VALID = 1;
	  }
	}

  mode_used = 0;
  switch (this->m_SSOFF_MODE) {

    case HKTIM_MODE_RUNNING_AVERAGE:
    /* Do running average offset using valid input */
	if (this->m_EW5SSOFF_AV_VALID > 0) {
	  this->m_EW5SSOFF_FINAL += this->m_EW5SSOFF_DELTA_AV;
	  this->m_EW5SSOFF_ERROR = (double) this->m_EW5SSOFF - this->m_EW5SSOFF_FINAL;
	  while (this->m_EW5SSOFF_ERROR >  555.5)  this->m_EW5SSOFF_ERROR -= 1111.0;
	  while (this->m_EW5SSOFF_ERROR < -555.5)  this->m_EW5SSOFF_ERROR += 1111.0;
	  if (!this->m_EW5SSOFF_INVALID) {
		if (fabs (this->m_EW5SSOFF_ERROR) < EW5SSOFF_MAX_ERROR) {
	      this->m_EW5SSOFF_FINAL    += 0.1 * this->m_EW5SSOFF_ERROR;
          this->m_EW5SSOFF_DELTA_AV += 0.1 * this->m_EW5SSOFF_ERROR;
		  if (this->m_EW5SSOFF_AV_VALID < EW5SSOFF_AV_VALID_MAX) this->m_EW5SSOFF_AV_VALID += 1;
		}
		else this->m_EW5SSOFF_AV_VALID -= 1;
	  }
	  if (this->m_EW5SSOFF > 220) {
	    if (this->m_EW5SSOFF_FINAL < 110.0)   this->m_EW5SSOFF_FINAL += 1111.0;
	    if (this->m_EW5SSOFF_FINAL > 1221.0)  this->m_EW5SSOFF_FINAL -= 1111.0;
	  }
	  else {
	    if (this->m_EW5SSOFF_FINAL < -110.0)  this->m_EW5SSOFF_FINAL += 1111.0;
	    if (this->m_EW5SSOFF_FINAL > 1001.0)  this->m_EW5SSOFF_FINAL -= 1111.0;
	  }
	  mode_used = HKTIM_MODE_RUNNING_AVERAGE;
	  break;
	}
	/* Else (ie. average not valid) fall back on extrapolation. */

	case HKTIM_MODE_EXTRAPOLATION:
    /* If invalid replace by extrapolation */

	if (this->m_EW5SSOFF_INVALID && this->m_EW5RSCNT_DELTA > 0 && this->m_EW5RSCNT_DELTA <= 4) {
	  this->m_EW5SSOFF_FINAL = this->m_EW5SSOFF_1 + 
		  this->m_EW5SSOFF_DELTA * (this->m_EW5RSCNT - this->m_EW5RSCNT_1) / this->m_EW5RSCNT_DELTA;
      /* This offset should always be > 220; measured offset would be valid
         otherwise. If less than zero should be wrapped upwards. Make decision
         point halfway between; ie. wrap upwards if less than 110. Only wrap
         down if this produces a value > 110; ie. if calculated offset > 1236. */
	  if (this->m_EW5SSOFF_FINAL < 110.0)  this->m_EW5SSOFF_FINAL += 1111.0;
	  if (this->m_EW5SSOFF_FINAL > 1221.0) this->m_EW5SSOFF_FINAL -= 1111.0;
      mode_used = HKTIM_MODE_EXTRAPOLATION;
	  break;
	}
    /* Else (ie. not invalid or count_delta out of range) fall back on 'always valid'. */

    case HKTIM_MODE_ALWAYS_VALID:
    /* Assume SSoffset always valid */

    this->m_EW5SSOFF_FINAL = (double)this->m_EW5SSOFF;
	if (!this->m_EW5SSOFF_INVALID) mode_used = HKTIM_MODE_ALWAYS_VALID;
    break;

    case HKTIM_MODE_ALWAYS_ZERO:
    /* Assume always zero */
    this->m_EW5SSOFF_FINAL = 0.0;
	break;

  }  /* End of switch */


  /* In running average modes, update master clock frequency */
  switch (this->m_SSOFF_MODE) {

    case HKTIM_MODE_RUNNING_AVERAGE:
    if (this->m_EW5SSOFF_AV_VALID > 0) this->m_MCLK_FREQ = 4637.0 / 
	      (5.15222168 + this->m_EW5SSOFF_DELTA_AV * 0.000001);
  }
  
  /* Update previous *valid* counts and offsets for next time */
  if (!this->m_EW5SSOFF_INVALID) {
    this->m_EW5RSCNT_2  = this->m_EW5RSCNT_1;
    this->m_EW5RSCNT_1  = this->m_EW5RSCNT;
    this->m_EW5SSOFF_2  = this->m_EW5SSOFF_1;
    this->m_EW5SSOFF_1  = this->m_EW5SSOFF;
  }

  /* Update last count and SCET for next time */
  this->m_EW5RSCNT_LAST = this->m_EW5RSCNT;
  this->m_dSCET_LAST    = this->m_dSCET;
  
  /* In extrapolated or averaged modes, clamp result in valid range */
  switch (this->m_SSOFF_MODE) {

    case HKTIM_MODE_RUNNING_AVERAGE:
	case HKTIM_MODE_EXTRAPOLATION:

    if (this->m_EW5SSOFF_FINAL > 1111)    this->m_EW5SSOFF_FINAL = 1111;
    if (this->m_EW5SSOFF_FINAL < 0)       this->m_EW5SSOFF_FINAL = 0;
  }
  
  /* Put final offset back in HK packet */
  put_hkblock_EW5SSOFF(p_Pkt,(long)(this->m_EW5SSOFF_FINAL + 0.5));
  put_hkblock_EW5SSVAL(p_Pkt,0);

  /* Put mode used in HK packet so we can get it for diagnositic word */
  put_hkblock_EW5SSMOD(p_Pkt,mode_used);

  return mode_used;
}

double hktim_get_mcfreq (HKTIM *this)
{
	if (this != NULL) return this->m_MCLK_FREQ;
	return 900.0;
}

void   hktim_set_mcfreq (HKTIM *this, double freq)
{
	if (this != NULL) this->m_MCLK_FREQ = freq;
}

/* }}} */
/* {{{ void       hktim_show          (HKTIM *,FILE *) */

void
hktim_show(
HKTIM *this,
FILE *p_FILE
)
{
  fprintf(p_FILE,"\n<hktim>");
  fprintf(p_FILE,"\n<ew5ssval         =\"%d\"/>",      this->m_EW5SSVAL);
  fprintf(p_FILE,"\n<ew5ssoff         =\"%d\"/>",      this->m_EW5SSOFF);
  fprintf(p_FILE,"\n<ew5rscnt         =\"%d\"/>",      this->m_EW5RSCNT);
  fprintf(p_FILE,"\n<ew5ssoff-mode raw=\"%d\" text=\"%s\"/>",this->m_SSOFF_MODE,hktim_mode_to_string(this->m_SSOFF_MODE));
  fprintf(p_FILE,"\n<ew5ssoff-delta   =\"%d\"/>",      this->m_EW5SSOFF_DELTA);
  fprintf(p_FILE,"\n<ew5rscnt-delta   =\"%d\"/>",      this->m_EW5RSCNT_DELTA);
  fprintf(p_FILE,"\n<ew5ssoff-invalid =\"%d\"/>",      this->m_EW5SSOFF_INVALID);
  fprintf(p_FILE,"\n<ew5ssoff-error value=\"%lf\"/>",  this->m_EW5SSOFF_ERROR);
  fprintf(p_FILE,"\n<final-offset   value=\"%lf\"/>",  this->m_EW5SSOFF_FINAL);
  fprintf(p_FILE,"\n<average-offset-delta=\"%lf\"/>",  this->m_EW5SSOFF_DELTA_AV);
  fprintf(p_FILE,"\n<average-valid=\"%d\"/>",          this->m_EW5SSOFF_AV_VALID);
  fprintf(p_FILE,"\n<master clock frequency=\"%lf\"/>",this->m_MCLK_FREQ);
  fprintf(p_FILE,"\n<ew5rscnt-1       =\"%d\"/>",      this->m_EW5RSCNT_1);
  fprintf(p_FILE,"\n<ew5rscnt-2       =\"%d\"/>",      this->m_EW5RSCNT_2);
  fprintf(p_FILE,"\n<ew5ssoff-1       =\"%d\"/>",      this->m_EW5SSOFF_1);
  fprintf(p_FILE,"\n<ew5ssoff-2       =\"%d\"/>",      this->m_EW5SSOFF_2);
  fprintf(p_FILE,"\n</hktim>");
}

/* }}} */

/* Local variables: */
/* folded-file: t */
/* end: */
