 
/**
 * $Id: hkext.c,v 1.1 2001/09/26 14:06:53 simond Exp $
 */

#define _hkext_c

#include <ted.h>
#include <tedsys.h>
#include <hkextp.h>
#include <hkext.h>

#define CL_WEC_TED_150

#define new(a)	(a *)malloc(sizeof(a))

/* {{{ hkextractSymbolAttrib */

HkextractStatus
hkextractSymbolAttrib(
HkextractSymbol *pSymbol,
HkextractSymbolAttrib a,
HkextractSymbolAttribRes *res
)
{
  if (pSymbol == NULL)
    return HkextractStatusGetAttribArgs;;

  if (res == NULL)
    return HkextractStatusGetAttribRes;

  switch (a) {
  case HkextractSymbolAttribName:
    res->a = HkextractSymbolAttribName;
    res->v.Type = HkextractSymbolTypeText;
    res->v.hkextractSymbolValue_u.Text = pSymbol->Name;
    return HkextractStatusOk;
  case HkextractSymbolAttribType:
    res->a = HkextractSymbolAttribType;
    res->v.Type = HkextractSymbolTypeInteger;
    res->v.hkextractSymbolValue_u.Integer = pSymbol->Value.Type;
    return  HkextractStatusOk;
  case HkextractSymbolAttribValue:
    {
      HkextractSymbolAttribRes res1;
      HkextractStatus status;
      int type;
      status = hkextractSymbolAttrib(pSymbol,
				       HkextractSymbolAttribType,
				       &res1);
      if (status != HkextractStatusOk)
	return status;

      type = res1.v.hkextractSymbolValue_u.Integer;
      res->a = HkextractSymbolAttribValue;
      switch (type) {

      case HkextractSymbolTypeInteger:
	res->v.Type = HkextractSymbolTypeInteger;
	res->v.hkextractSymbolValue_u.Integer =
	  pSymbol->Value.hkextractSymbolValue_u.Integer;
	return HkextractStatusOk;

      case HkextractSymbolTypeReal:
	res->v.Type = HkextractSymbolTypeReal;
	res->v.hkextractSymbolValue_u.Real =
	  pSymbol->Value.hkextractSymbolValue_u.Real;
	return HkextractStatusOk;

      case HkextractSymbolTypeText:
	res->v.Type = HkextractSymbolTypeText;
	res->v.hkextractSymbolValue_u.Text =
	  pSymbol->Value.hkextractSymbolValue_u.Text;
	return HkextractStatusOk;

      case HkextractSymbolTypeTable:
	res->v.Type = HkextractSymbolTypeTable;
	res->v.hkextractSymbolValue_u.Table =
	  pSymbol->Value.hkextractSymbolValue_u.Table;
	return HkextractStatusOk;

      default:
	res->v.Type = HkextractSymbolTypeUndefined;
      }
      break;
    }
    break;

  default:
    res->a = HkextractSymbolAttribUndefined;
    return HkextractStatusOk;
  }
}

/* }}} */

/* {{{ hkextractSymbolName */

char *
hkextractSymbolName(
HkextractSymbol *pSymbol
)
{
  if (pSymbol)
    return pSymbol->Name;
  else
    return NULL;
}

/* }}} */
/* {{{ hkextractSymbolType */

HkextractSymbolType
hkextractSymbolType(
HkextractSymbol *pSymbol
)
{
  if (pSymbol != NULL)
    return pSymbol->Value.Type;
  else
    return HkextractSymbolTypeUndefined;
}

/* }}} */
/* {{{ hkextractSymbolTextVal */

HkextractStatus
hkextractSymbolTextVal(
HkextractSymbol *pSymbol,
char **pText
)
{
  HkextractSymbolAttribRes res;
  int status;

  if (pSymbol != NULL)
    if (pSymbol->Value.Type = HkextractSymbolTypeText) {
      status = hkextractSymbolAttrib(pSymbol,HkextractSymbolAttribValue,&res);
      if (status == HkextractStatusOk)
	*pText = res.v.hkextractSymbolValue_u.Text;
      return HkextractStatusOk;
    }
  return HkextractStatusGetAttribSymbol;
}

/* }}} */
/* {{{ hkextractSymbolRealVal */

HkextractStatus
hkextractSymbolRealVal(
HkextractSymbol *pSymbol,
double *pReal
)
{
  HkextractSymbolAttribRes res;
  int status;

  if (pSymbol != NULL)
    if (pSymbol->Value.Type = HkextractSymbolTypeReal) {
      status = hkextractSymbolAttrib(pSymbol,HkextractSymbolAttribValue,&res);
      if (status == HkextractStatusOk)
	*pReal = res.v.hkextractSymbolValue_u.Real;
      return status;
    }
  return HkextractStatusGetAttribSymbol;
}

/* }}} */
/* {{{ hkextractSymbolIntVal */

HkextractStatus
hkextractSymbolIntVal(
HkextractSymbol *pSymbol,
long *pInt
)
{
  HkextractSymbolAttribRes res;
  int status;

  if (pSymbol != NULL)
    if (pSymbol->Value.Type = HkextractSymbolTypeInteger) {
      status = hkextractSymbolAttrib(pSymbol,HkextractSymbolAttribValue,&res);
      if (status == HkextractStatusOk)
	*pInt = res.v.hkextractSymbolValue_u.Integer;
      return status;
    }
  return HkextractStatusGetAttribSymbol;
}

/* }}} */
/* {{{ hkextractSetSymbolAttrib */
int
hkextractSetSymbolAttrib(
HkextractSymbol *pSymbol,
HkextractSymbolAttrib a,
...
)
{
  va_list valist;

  va_start(valist,a);

  if (pSymbol)
    switch (a) {
    case HkextractSymbolAttribName:
      {
	char *Name;
	Name = (char *) va_arg(valist,char *);
	va_end(valist);
	if (pSymbol->Name == NULL) {
	  pSymbol->Name = (char *) strdup(Name);
	  return 0;
	}
	else
	  return !0;
      }
      break;
    case HkextractSymbolAttribType:
      {
	HkextractSymbolType Type;
	Type = (HkextractSymbolType) va_arg(valist,HkextractSymbolType);
	va_end(valist);
	if (pSymbol->Value.Type != Type)
	  return 0;
	else
	  return !0;
      }
      break;
    case HkextractSymbolAttribValue:
      {
	switch(pSymbol->Value.Type) {
	  case HkextractSymbolTypeInteger:
	  {
	    INTEGER Integer = (INTEGER) va_arg(valist,INTEGER);
	    pSymbol->Value.hkextractSymbolValue_u.Integer = Integer;
	    va_end(valist);
	    return 0;
	  }
	  break;
	  case HkextractSymbolTypeReal:
	  {
	    REAL Real = (REAL) va_arg(valist,REAL);
	    pSymbol->Value.hkextractSymbolValue_u.Real = Real;
	    va_end(valist);
	    return 0;
	  }
	  break;
	  case HkextractSymbolTypeText:
	  {
	    char * Text = (char *) va_arg(valist,char *);
	    pSymbol->Value.hkextractSymbolValue_u.Text = Text;
	    va_end(valist);
	    return 0;
	  }
	  break;
	  case HkextractSymbolTypeTable:
	  {
	    HkextractTable *Table = (HkextractTable *) va_arg(valist,HkextractTable *);
	    pSymbol->Value.hkextractSymbolValue_u.Table = Table;
	    va_end(valist);
	    return 0;
	  }
	  break;
	default:
	  return !0;
	}
      }
    default:
      return 0;
    }
}

/* }}} */

static int maxTableSizeIndex = 10;
static int tableSizes[] = { 17,37,67,131,257,521,1031,2053,4099,8209,16411 };

/* {{{ hkextractAliasString */

void
hkextractAliasString(
char *result,
int index,
const char *str
)
{
  if (sprintf(result,
	      "%d_%s",
	      index,
	      str) < 0)
    strcpy(result,"");
}

/* }}} */
/* {{{ hkextractPrintTable */

FILE * hkextractPrintSymbol(FILE *,HkextractSymbol *);

FILE *
hkextractPrintTable(
FILE *os,
HkextractTable *pTABLE
)
{
  int index;
  fprintf(os,"\n<table");
  fprintf(os," size-index=\"%ld\"",pTABLE->tableSizeIndex);
  fprintf(os," size=\"%ld\"",pTABLE->tableSize);
  fprintf(os," next-location=\"%ld\"",pTABLE->nextLocation);
  fprintf(os,">");

  /*
   * fprintf(os,"\n<hash-table>");
   * for(index = 0; index < pTABLE->tableSize; index++)
   *   fprintf(os," %d",pTABLE->hashTable[index]);
   * fprintf(os,"</hash-table>");
   *
   */

  for(index = 1;index <= pTABLE->nextLocation - 1;index++)
    hkextractPrintSymbol(os,pTABLE->symbolTable[index]);

  fprintf(os,"\n</table>");
  return os;

}

/* }}} */
/* {{{ hkextractNewTable */

HkextractTable *
hkextractNewTable(
void
)
{
  HkextractTable *pTABLE = new(HkextractTable);
  if (! pTABLE)
    return NULL;

  pTABLE->tableSizeIndex = 0;
  pTABLE->tableSize = tableSizes[pTABLE->tableSizeIndex];
  pTABLE->hashTable = calloc(pTABLE->tableSize,sizeof(int));
  if (! pTABLE->hashTable) {
    free(pTABLE);
    return NULL;
  }
  {
    int ind;
    for(ind = 0; ind < pTABLE->tableSize; ind++)
      pTABLE->hashTable[ind] = 0;
  }

  pTABLE->symbolTable = (HkextractSymbol **) calloc(pTABLE->tableSize,sizeof(HkextractSymbol *));
  {
    int ind;
    for(ind = 0; ind < pTABLE->tableSize; ind++)
      pTABLE->symbolTable[ind] = NULL;
  }
  if (! pTABLE->symbolTable) {
    free(pTABLE->hashTable);
    free(pTABLE);
    return NULL;
  }
  pTABLE->nextLocation = 1;
  return pTABLE;
}

/* }}} */
/* {{{ hkextractTableHash */

int
hkextractTableHash(
HkextractTable *pTABLE,
char *s
)
{
  char* ss = s;
  unsigned int h = 0, g;

  if (pTABLE) {
    for (; *ss != '\0'; ss++) {
      h = (h << 4) + *ss;
      if (g = h & 0xf0000000) {
	h ^= g >> 24;	
	/* fold top 4 bits onto ------X- */
	h ^= g;		
	/* clear top 4 bits */
      }
    }
    return (h % pTABLE->tableSize);
  }
  else
    return -1;
}

/* }}} */
/* {{{ hkextractGrowTable */

HkextractStatus hkextractTableInsert(HkextractTable *,HkextractSymbol *,char *,char * (*sname) (HkextractSymbol *));

HkextractStatus
hkextractGrowTable(
HkextractTable *pTABLE,
char * (*sname)(HkextractSymbol *)
)
{
  int tableSizeIndex = -1;
  int tableSize = 0;
  HkextractSymbol **symbolTable = NULL;
  int *hashTable = NULL;
  int nextLocation = 0;

  int newTableSize = 0;
  int newTableSizeIndex = -1;
  HkextractSymbol **newSymbolTable = NULL;
  int *newHashTable = NULL;
  int newNextLocation = -1;

  if (pTABLE == NULL)
    return HkextractStatusGrowTableArgs;

  tableSizeIndex = pTABLE->tableSizeIndex;
  tableSize = pTABLE->tableSize;
  symbolTable = pTABLE->symbolTable;
  hashTable = pTABLE->hashTable;
  nextLocation = pTABLE->nextLocation;

  if (tableSizeIndex < maxTableSizeIndex)
    newTableSizeIndex = ++tableSizeIndex;
  else
    return HkextractStatusGrowTableLimit;

  newTableSize = tableSizes[newTableSizeIndex];
  if (newTableSize <= tableSize)
    return HkextractStatusGrowTableSize;

  newSymbolTable = (HkextractSymbol **) calloc(newTableSize,sizeof(HkextractSymbol *));
  if (newSymbolTable == NULL)
    return HkextractStatusGrowTable;
      
  newHashTable = (int *) calloc(newTableSize,sizeof(int));
  if (newHashTable == NULL) {
    free(newSymbolTable);
    return HkextractStatusGrowTable;
  }

  pTABLE->tableSize = newTableSize;
  pTABLE->tableSizeIndex = newTableSizeIndex;
  pTABLE->hashTable = newHashTable;
  pTABLE->symbolTable = newSymbolTable;
  pTABLE->nextLocation = 1;
  
  {
    int index;
    HkextractStatus status;
    HkextractSymbol *pSYMBOL = NULL;
    char *Name = NULL;
    
    for(index = 0; index < newTableSize; index++)
      newSymbolTable[index] = NULL;
    
    for (index = 0; index < newTableSize; index++)
      newHashTable = 0;
    
    for(index = 1; index < nextLocation; index++) {
      pSYMBOL = symbolTable[index];
      if (pSYMBOL == NULL)
	return HkextractStatusGrowTableDup;
 
      Name = (*sname)(pSYMBOL);
      if (Name == NULL)
	return HkextractStatusGrowTableDup;
      
      status = hkextractTableInsert(pTABLE,pSYMBOL,Name,sname);
      if (status != HkextractStatusOk) {
	hkextractPrintTable(stdout,pTABLE);
	return status;
      }
    }
    
    free(symbolTable);
    free(hashTable);
    return HkextractStatusOk;
  }
}

/* }}} */
/* {{{ hkextractTableInsert */

HkextractStatus
hkextractTableInsert(
HkextractTable *pTable,
HkextractSymbol *pSymbol,
char *pch,
char * (*sname) (HkextractSymbol *)
)
{
  int status;
  int try,origTry,hashTry;
  char *Name;
  int nl;

  if (pTable == NULL)
    return HkextractStatusTableInsertArgs;

  if (pSymbol == NULL)
    return HkextractStatusTableInsertArgs;

  if (sname == NULL)
    return HkextractStatusTableInsertArgs;

  if (pTable->nextLocation > ((pTable->tableSize * 2) / 3)) {
    status = hkextractGrowTable(pTable,sname);
    if (status != HkextractStatusOk)
      return HkextractStatusTableInsertGrow;
  }

  origTry = hkextractTableHash(pTable,pch);
  try = origTry;

  if (try >= 0) {
    hashTry = pTable->hashTable[try];
    if (hashTry != 0) {
      while (hashTry < pTable->nextLocation) {
	if (hashTry >= pTable->tableSize) {
	  return HkextractStatusTableInsertSize;
	}
	if (! strcmp((*sname)(pTable->symbolTable[hashTry]),pch)) {
	  return HkextractStatusTableInsertAlready;
	}
	hashTry++;
      }
      pTable->symbolTable[pTable->nextLocation] = pSymbol;
      pTable->nextLocation++;
      return HkextractStatusOk;
    }
    else {
      pTable->symbolTable[pTable->nextLocation] = pSymbol;
      pTable->hashTable[try] = pTable->nextLocation;
      pTable->nextLocation++;
      return HkextractStatusOk;
    }
  }

  return HkextractStatusTableInsertHash;
}

/* }}} */
/* {{{ hkextractTableSearch */

HkextractStatus hkextractSearchSymbol(HkextractSymbol **,HkextractSymbol *,char *);
HkextractStatus
hkextractTableSearch(
HkextractTable *pTable,
HkextractSymbol **ppSymbol,
char *Name,
char * (*sname)(HkextractSymbol *)
)
{
  int try;
  int origTry;
  int hashTry;
  HkextractSymbol *pSymbol;
  char *str = NULL;

  if (pTable == NULL)
    return HkextractStatusTableSearchArgs;

  if (ppSymbol == NULL)
    return HkextractStatusTableSearchArgs;

  if (Name == NULL)
    return HkextractStatusTableSearchArgs;

  str = strchr(Name,'.');
  if (str != NULL)
    *str = '\0';

  origTry = hkextractTableHash(pTable,Name);
  try     = origTry;
  hashTry = pTable->hashTable[try];


  while (hashTry != 0) {
    if (pTable->symbolTable[hashTry] != NULL) {
      if (strcmp((*sname)(pTable->symbolTable[hashTry]),Name) == 0) {
	pSymbol = pTable->symbolTable[hashTry];
	if (str != NULL) {
	  *str = '.';
	  if ((int)strlen(str + 1) > 0)
	    return hkextractSearchSymbol(ppSymbol,pSymbol,str + 1);
	}
	else {
	  *ppSymbol = pSymbol;
	  return HkextractStatusOk;
	}
      }
    }

    hashTry++;
    if (hashTry > pTable->tableSize - 1)
      hashTry = 0;
  }
  return HkextractStatusTableSearchNotFound;
}

/* }}} */
/* {{{ hkextractDeleteTable */

int
hkextractDeleteTable(
HkextractTable **ppTable
)
{
  if (ppTable != NULL) {
    HkextractTable *this = *ppTable;
    if (this != NULL) {
      int index;
      for(index = 1;index < this->nextLocation; index++)
	hkextractDeleteSymbol(&(this->symbolTable[index]));
      free(this->hashTable);
      free(this);
    }
    *ppTable = NULL;
    return !0;
  }
  return 0;
}

/* }}} */
/* {{{ hkextractDeleteSymbol */

int
hkextractDeleteSymbol(
HkextractSymbol **s
)
{
  if (! s)
    return 0;
  else {
    HkextractSymbol *this = *s;
    if (! this)
      return !0;
    else {
      switch (this->Value.Type) {
      case HkextractSymbolTypeInteger:
      case HkextractSymbolTypeReal:
	break;
      case HkextractSymbolTypeText:
	free(this->Value.hkextractSymbolValue_u.Text);
	break;
      case HkextractSymbolTypeTable:
	{
	  HkextractTable *pTABLE = this->Value.hkextractSymbolValue_u.Table;
	  hkextractDeleteTable(&pTABLE);
	}
	break;
      default:
	break;
      }
      free(this);
      *s = NULL;
      return !0;
    }
  }
}

/* }}} */
/* {{{ hkextractIsSymbol */

int
hkextractIsSymbol(
HkextractSymbol *pSYMBOL,
char Name[]
)
{
  if (pSYMBOL) {
    return strcmp(pSYMBOL->Name,Name);
  }
  else
    return !0;
}

/* }}} */
/* {{{ hkextractPrintSymbol */

FILE *
hkextractPrintSymbol(
FILE *os,
HkextractSymbol *pSYMBOL
)
{
  if (pSYMBOL != NULL)
  {
    fprintf(os,"\n<symbol");
    fprintf(os," name=\"%s\"",
	    hkextractSymbolName(pSYMBOL));
    fprintf(os," type=\"%s\"",
	    hkextractSymbolTypeString(pSYMBOL->Value.Type));
    fprintf(os,">");
    
    switch (pSYMBOL->Value.Type) {
    case HkextractSymbolTypeInteger:
      fprintf(os,"<value><integer>%ld</integer></value>",pSYMBOL->Value.hkextractSymbolValue_u.Integer);
      break;
    case HkextractSymbolTypeReal:
      fprintf(os,"<value><real>%f</real></value>",pSYMBOL->Value.hkextractSymbolValue_u.Real);
      break;
    case HkextractSymbolTypeText:
      fprintf(os,"<value><string>%s</string></value>",pSYMBOL->Value.hkextractSymbolValue_u.Text);
      break;
    case HkextractSymbolTypeTable:
         fprintf(os,"\n<value>");
	 hkextractPrintTable(os,
			     (HkextractTable *) pSYMBOL->Value.hkextractSymbolValue_u.Table);
         fprintf(os,"\n</value>\n");
      break;
    default:
      fprintf(os,"<value><undefined/></value>");
    }
    fprintf(os,"</symbol>");
  }
  return os;
}

/* }}} */
/* {{{ hkextractSearchSymbol */

HkextractStatus
hkextractSearchSymbol(
HkextractSymbol **ppSymbol,
HkextractSymbol *pSymbol,
char Name[]
)
{
  HkextractTable *this = NULL;
  HkextractSymbol *pLocal = NULL;
  int status;
  char *strIndex;


  if (pSymbol == NULL)
    return HkextractStatusOk;

  if (Name == NULL)
    return HkextractStatusOk;

  if (pSymbol->Value.Type != HkextractSymbolTypeTable)
    return HkextractStatusSearchSymbolNotATable;
  
  this = pSymbol->Value.hkextractSymbolValue_u.Table;
  if (this == NULL)
    return HkextractStatusSearchSymbolNotATable;
  
  return hkextractTableSearch(this,ppSymbol,Name,hkextractSymbolName);
}

/* }}} */
/* {{{ hkextractInsertSymbol */

HkextractStatus
hkextractInsertSymbol(
HkextractSymbol *this,
HkextractSymbol *pSYMBOL,
char Name[]
)
{
  int status;
  char *strIndex = NULL;
  HkextractSymbol *pLocal = NULL;
  char *MNEM = NULL;


  if (this == NULL) {
    return HkextractStatusInsertSymbolArgs;
  }

  if (pSYMBOL == NULL) {
    return HkextractStatusInsertSymbolArgs;
  }


  if (Name == NULL)
    Name = hkextractSymbolName(pSYMBOL);

  if (Name == NULL)
    return HkextractStatusInsertSymbolName;

  if ((int) strlen(Name) > 0) {
    strIndex = strrchr(Name,'.');
    if (strIndex != NULL) {
      if (strIndex != Name) {
	*strIndex = '\0';
	status = hkextractSearchSymbol(&pLocal,this,Name);
	if (status == HkextractStatusOk) {
	  this = pLocal;
	  MNEM = strIndex + 1;
	}
      }
      else {
	MNEM = Name + 1;
      }
    }
    else {
      MNEM = Name;
    }
    if (this->Value.Type != HkextractSymbolTypeTable) {
      return HkextractStatusInsertSymbolNotATable;
    }
    else {
      HkextractTable *table = NULL;
      table = this->Value.hkextractSymbolValue_u.Table;
      if (table != NULL) {
	status = hkextractTableInsert(table,pSYMBOL,MNEM,hkextractSymbolName);
	if (status == HkextractStatusOk)
	  return HkextractStatusOk;
      }
    }
  }

  return HkextractStatusInsertSymbolTable;
}

/* }}} */
/* {{{ hkextractNewSymbol */

HkextractSymbol *
hkextractNewSymbol(
char Name[],
HkextractSymbolType Type,
char Value[]
)
{
  HkextractSymbol *this = NULL;

  if (Name == NULL)
    return NULL;

  if ((int) strlen(Name) < 1)
    return NULL;

  switch(Type) {
  case HkextractSymbolTypeInteger:
  case HkextractSymbolTypeReal:
  case HkextractSymbolTypeText:
  case HkextractSymbolTypeTable:
    break;
  default:
    return NULL;
  }


  this = new(HkextractSymbol);
  if (this == NULL)
    return NULL;


  this->Name = (char *) strdup(Name);
  this->Value.Type = Type;

  switch(Type) {
  case HkextractSymbolTypeInteger:
    if (Value != NULL)
      if ((int) strlen(Value) > 0)
#ifdef CL_WEC_TED_150
	{
	  char *tmp = NULL;
	  unsigned long ul = 0;
	  ul = strtoul(Value,&tmp,10);
	  this->Value.hkextractSymbolValue_u.Integer = ul;
	}
#else
        {
	  unsigned long ul = 0;
	  sscanf(Value,"%i",&ul);
	  this->Value.hkextractSymbolValue_u.Integer = ul;
	}
#endif
    break;
  case HkextractSymbolTypeReal:
    if (Value != NULL)
      if ((int) strlen(Value) > 0)
	sscanf((char *) Value,
	       "%f",
	       &this->Value.hkextractSymbolValue_u.Real);
    break;
  case HkextractSymbolTypeText:
    if (Value != NULL)
      if ((int) strlen(Value) > 0)
	this->Value.hkextractSymbolValue_u.Text = (char *) strdup(Value);
      else
	this->Value.hkextractSymbolValue_u.Text = (char *) strdup("");
    break;
  case HkextractSymbolTypeTable:
    this->Value.hkextractSymbolValue_u.Table =
      (HkextractTable *) hkextractNewTable();
    break;
  default:
    break;
  }

  return this;
}

/* }}} */
/* {{{ hkextractUnpackSymbolText */

HkextractStatus
hkextractUnpackSymbolText(
HkextractSymbol *pSYMBOL,
char name[],
char **res
)
{

  HkextractSymbol *pPDE = NULL;
  int status;
    
  status = hkextractSearchSymbol((HkextractSymbol **)&pPDE,
		pSYMBOL,name);
  if (status != HkextractStatusOk) {
    return status;
  }

  if (hkextractSymbolType(pPDE) != HkextractSymbolTypeText) {
    return HkextractStatusUnpackSymbolTextType;
  }

  if (hkextractSymbolTextVal(pPDE,res) != HkextractStatusOk) {
    return HkextractStatusUnpackSymbolTextValue;
  }

  return HkextractStatusOk;
}

/* }}} */
/* {{{ ddspAccessFunctions */

const unsigned int hkextractDdspHeaderSize = 15;
unsigned int
hkextractDdspGetScetDay(
unsigned char *p
)
{
  return ( int ) (p[0] * 0x100) +  p[1];
}

void
hkextractDdspSetScetDay(
long d,
unsigned char *p
)
{
  p[0] = ( d / 0x100 ) % 0x100;
  p[1] =   d % 0x100;
}

unsigned long
hkextractDdspGetScetMs(
unsigned char *p
)
{
  unsigned long ms = 0;
  ms += (unsigned long) p[5];
  ms += (unsigned long) p[4] * 0x100;
  ms += (unsigned long) p[3] * 0x100 * 0x100;
  ms += (unsigned long) p[2] * 0x100 * 0x100 * 0x100;
  return ms;
}

void
hkextractDdspSetScetMs(
unsigned long m,
unsigned char *p
)
 
{
  p[2] = (m / (0x100 * 0x100 * 0x100)) % 0x100;
  p[3] = (m / (0x100 * 0x100)) % 0x100;
  p[4] = (m / 0x100) % 0x100;
  p[5] =  m % 0x100;
}

unsigned long
hkextractDdspGetScetUs(
unsigned char *p
)
{
  unsigned long us = 0;
  us += (unsigned long) p[7];
  us += (unsigned long) p[6] * 0x100;
  return us;
}

void
hkextractDdspSetScetUs(
unsigned long u,
unsigned char *p
)
{
  p[6] = (u/0x100) % 256;
  p[7] =  u % 0x100;
}


void
hkextractDdspGetScet(
HkextractTime *t,
unsigned char *p
)
{
  t->days = (unsigned int) hkextractDdspGetScetDay(p);
  t->ms   = (unsigned long) hkextractDdspGetScetMs(p);
  t->us   = (unsigned int) hkextractDdspGetScetUs(p);
}


void
hkextractDdspSetScet(
HkextractTime *t,
unsigned char *p
)
{
  hkextractDdspSetScetDay(t->days,p);
  hkextractDdspSetScetMs(t->ms,p);
  hkextractDdspSetScetUs(t->us,p);
}


unsigned int
hkextractDdspGetSource(
unsigned char *p
)
{
  return p[8];
}


void
hkextractDdspSetSource(
unsigned int a,
unsigned char *p
)
{
  p[8] = a % 0x100;
}


unsigned int
hkextractDdspGetAdid(
unsigned char *p
)
{
  return p[8];
}


void
hkextractDdspSetAdid(
unsigned int a,
unsigned char *p
)
{
  p[8] = a % 0x100;
}


unsigned long
hkextractDdspGetLen(
unsigned char *p
)
{
  unsigned long l = 0;
  l += (unsigned long) p[11];
  l += (unsigned long) p[10] * 0x100;
  l += (unsigned long) p[9]  * 0x100 * 0x100;
  return l;
}


hkextractDdspSetLen(
unsigned long l,
unsigned char *p
)
{
  p[9]  = (l / (0x100 * 0x100)) % 0x100;
  p[10] = (l / 0x100) % 0x100;
  p[11] = l % 0x100;
}

const unsigned int hkextractDdspGsidMask = 0x0f;

unsigned int
hkextractDdspGetGsid(
unsigned char *p
)
{
  return p[12] & hkextractDdspGsidMask;
}


void
hkextractDdspSetGsid(
unsigned int g,
unsigned char *p
)
{
  p[12] = (p[12] & ~hkextractDdspGsidMask) |
    (g & hkextractDdspGsidMask);
}

const unsigned int hkextractDdspScidMask = 0xf0;

unsigned int
hkextractDdspGetScid(
unsigned char *p
)
{
  return (p[12] & hkextractDdspScidMask) / 0x10;
}


void
hkextractDdspSetScid(
unsigned int s,
unsigned char *p
)
{
  p[12] = ((s * 0x10) & hkextractDdspScidMask) |
    (p[12] & ~hkextractDdspScidMask);
}


unsigned int
hkextractDdspGetStream(
unsigned char *p
)
{
  return p[13];
}

void
hkextractDdspSetStream(
unsigned int a,
unsigned char *p
)
{
  p[13] = a % 0x100;
}

const unsigned int hkextractDdspTcalMask = 0xf0;

unsigned int
hkextractDdspGetTcal(
unsigned char *p
)
{
  return (p[14] & hkextractDdspTcalMask) / 0x10;
}

void
hkextractDdspSetTcal(
unsigned int t,
unsigned char *p
)
{
  p[14] = ( (t * 0x10) & hkextractDdspTcalMask) |
    (p[14] & ~hkextractDdspTcalMask);
}

const unsigned int hkextractDdspTasiMask = 0x0f;

unsigned int
hkextractDdspGetTasi(
unsigned char *p
)
{
  return p[14] & hkextractDdspTasiMask;
}

void
hkextractDdspSetTasi(
unsigned int t,
unsigned char *p
)
{
  p[14] = ( p[14] & ~hkextractDdspTasiMask) |
    (t & hkextractDdspTasiMask);
}

unsigned char *
hkextractDdspGetData(
unsigned char *p
)
{
  return p + hkextractDdspHeaderSize;
}

void
hkextractDdspSetData(
unsigned char *d,
unsigned int l,
unsigned char *p
)
{
  memcpy(p + hkextractDdspHeaderSize,d,l);
  hkextractDdspSetLen(l,p);
}

/* }}} */
/* {{{ hkextractIsaHpdAdid */

HkextractStatus
hkextractIsaHpdAdid(
HkextractAdid adid
)
{
  switch (adid) {
  case HkextractAdidECLUP101:
  case HkextractAdidECLUP102:
  case HkextractAdidECLUP103:
  case HkextractAdidECLUP104:
  case HkextractAdidECLUP105:
  case HkextractAdidECLUP106:
  case HkextractAdidECLUP107:
  case HkextractAdidECLUP108:
  case HkextractAdidECLUP201:
  case HkextractAdidECLUP202:
  case HkextractAdidECLUP203:
  case HkextractAdidECLUP204:
  case HkextractAdidECLUP205:
  case HkextractAdidECLUP206:
  case HkextractAdidECLUP207:
  case HkextractAdidECLUP208:
  case HkextractAdidECLUP301:
  case HkextractAdidECLUP302:
  case HkextractAdidECLUP303:
  case HkextractAdidECLUP304:
  case HkextractAdidECLUP305:
  case HkextractAdidECLUP306:
  case HkextractAdidECLUP307:
  case HkextractAdidECLUP308:
  case HkextractAdidECLUP401:
  case HkextractAdidECLUP402:
  case HkextractAdidECLUP403:
  case HkextractAdidECLUP404:
  case HkextractAdidECLUP405:
  case HkextractAdidECLUP406:
  case HkextractAdidECLUP407:
  case HkextractAdidECLUP408:
    return HkextractStatusOk;
  default:
    return HkextractStatusCheckHpdAdid;
  }
}

/* }}} */
/* {{{ hkextractIsaHkdAdid */

HkextractStatus
hkextractIsaHkdAdid(
HkextractAdid adid
)
{
  switch (adid) {
  case HkextractAdidECLUH101:
  case HkextractAdidECLUH102:
  case HkextractAdidECLUH103:
  case HkextractAdidECLUH104:
  case HkextractAdidECLUH105:
  case HkextractAdidECLUH106:
  case HkextractAdidECLUH107:
  case HkextractAdidECLUH108:
  case HkextractAdidECLUH201:
  case HkextractAdidECLUH202:
  case HkextractAdidECLUH203:
  case HkextractAdidECLUH204:
  case HkextractAdidECLUH205:
  case HkextractAdidECLUH206:
  case HkextractAdidECLUH207:
  case HkextractAdidECLUH208:
  case HkextractAdidECLUH301:
  case HkextractAdidECLUH302:
  case HkextractAdidECLUH303:
  case HkextractAdidECLUH304:
  case HkextractAdidECLUH305:
  case HkextractAdidECLUH306:
  case HkextractAdidECLUH307:
  case HkextractAdidECLUH308:
  case HkextractAdidECLUH401:
  case HkextractAdidECLUH402:
  case HkextractAdidECLUH403:
  case HkextractAdidECLUH404:
  case HkextractAdidECLUH405:
  case HkextractAdidECLUH406:
  case HkextractAdidECLUH407:
  case HkextractAdidECLUH408:
    return HkextractStatusOk;
  default:
    return HkextractStatusCheckHkdAdid;
  }
}

/* }}} */
/* {{{ hkextractIsaDdspScid */

HkextractStatus
hkextractIsaDdspScid(
int scid
)
{
  switch (scid)
    {
    case HkextractScidCLUSTER_1:
    case HkextractScidCLUSTER_2:
    case HkextractScidCLUSTER_3:
    case HkextractScidCLUSTER_4:
      return HkextractStatusOk;
    }
  return HkextractStatusCheckScid;
}

/* }}} */
/* {{{ hkextractIsaHkdStream */

HkextractStatus
hkextractIsaHkdStream(
int stream
)
{
  switch (stream)
    {
    case HkextractStreamRT_VC0:
    case HkextractStreamPB_VC0:
    case HkextractStreamRE_VC0:
    case HkextractStreamRP_VC0:
      return HkextractStatusOk;
    default:
      return HkextractStatusCheckHkdStream;
    }
}

/* }}} */
/* {{{ hkextractIsaHpdStream */

HkextractStatus
hkextractIsaHpdStream (
int stream
)
{
  if (stream == HkextractStreamNA)
    return HkextractStatusOk;

  return HkextractStatusCheckHpdStream;
}

/* }}} */
/* {{{ hkextractIsaHkdGround */

HkextractStatus
hkextractIsaHkdGround(
int gsid
)
{
  switch (gsid)
    {
    case HkextractGsidODENWALD:
    case HkextractGsidREDU:
    case HkextractGsidKOUROU:
    case HkextractGsidPERTH:
    case HkextractGsidMALINDI:
    case HkextractGsidCANBERRA:
    case HkextractGsidGOLDSTONE:
	return HkextractStatusOk;
    default:
      return HkextractStatusCheckHkdGsid;
    }
}

/* }}} */
/* {{{ hkextractIsaHpdGround */

HkextractStatus
hkextractIsaHpdGround(
int gsid
)
{
  if (gsid == HkextractGsidNA)
    return HkextractStatusOk;
  return HkextractStatusCheckHpdGsid;
}

/* }}} */
/* {{{ hkextractDdspMatchScidAndAdid */

HkextractStatus
hkextractDdspMatchScidAndAdid(
HkextractScid scid,
HkextractAdid adid
)
{
  switch (scid) {
  case HkextractScidCLUSTER_1:
    switch (adid) {
    case HkextractAdidECLUP101:
    case HkextractAdidECLUP102:
    case HkextractAdidECLUP103:
    case HkextractAdidECLUP104:
    case HkextractAdidECLUP105:
    case HkextractAdidECLUP106:
    case HkextractAdidECLUP107:
    case HkextractAdidECLUP108:
    case HkextractAdidECLUN101:
    case HkextractAdidECLUN102:
    case HkextractAdidECLUN103:
    case HkextractAdidECLUN104:
    case HkextractAdidECLUN105:
    case HkextractAdidECLUN106:
    case HkextractAdidECLUB101:
    case HkextractAdidECLUB102:
    case HkextractAdidECLUB103:
    case HkextractAdidECLUB104:
    case HkextractAdidECLUB105:
    case HkextractAdidECLUB106:
    case HkextractAdidECLUH101:
    case HkextractAdidECLUH102:
    case HkextractAdidECLUH103:
    case HkextractAdidECLUH104:
    case HkextractAdidECLUH105:
    case HkextractAdidECLUH106:
    case HkextractAdidECLUH107:
    case HkextractAdidECLUH108:
      return HkextractStatusOk;
    default:
      return HkextractStatusCheckScidAdidMatch1;
    }
    break;
  case HkextractScidCLUSTER_2:
    switch (adid) {
    case HkextractAdidECLUP201:
    case HkextractAdidECLUP202:
    case HkextractAdidECLUP203:
    case HkextractAdidECLUP204:
    case HkextractAdidECLUP205:
    case HkextractAdidECLUP206:
    case HkextractAdidECLUP207:
    case HkextractAdidECLUP208:
    case HkextractAdidECLUN201:
    case HkextractAdidECLUN202:
    case HkextractAdidECLUN203:
    case HkextractAdidECLUN204:
    case HkextractAdidECLUN205:
    case HkextractAdidECLUN206:
    case HkextractAdidECLUB201:
    case HkextractAdidECLUB202:
    case HkextractAdidECLUB203:
    case HkextractAdidECLUB204:
    case HkextractAdidECLUB205:
    case HkextractAdidECLUB206:
    case HkextractAdidECLUH201:
    case HkextractAdidECLUH202:
    case HkextractAdidECLUH203:
    case HkextractAdidECLUH204:
    case HkextractAdidECLUH205:
    case HkextractAdidECLUH206:
    case HkextractAdidECLUH207:
    case HkextractAdidECLUH208:
      return HkextractStatusOk;
    default:
      return HkextractStatusCheckScidAdidMatch2;
    }
    break;
  case HkextractScidCLUSTER_3:
    switch (adid) {
    case HkextractAdidECLUP301:
    case HkextractAdidECLUP302:
    case HkextractAdidECLUP303:
    case HkextractAdidECLUP304:
    case HkextractAdidECLUP305:
    case HkextractAdidECLUP306:
    case HkextractAdidECLUP307:
    case HkextractAdidECLUP308:
    case HkextractAdidECLUN301:
    case HkextractAdidECLUN302:
    case HkextractAdidECLUN303:
    case HkextractAdidECLUN304:
    case HkextractAdidECLUN305:
    case HkextractAdidECLUN306:
    case HkextractAdidECLUB301:
    case HkextractAdidECLUB302:
    case HkextractAdidECLUB303:
    case HkextractAdidECLUB304:
    case HkextractAdidECLUB305:
    case HkextractAdidECLUB306:
    case HkextractAdidECLUH301:
    case HkextractAdidECLUH302:
    case HkextractAdidECLUH303:
    case HkextractAdidECLUH304:
    case HkextractAdidECLUH305:
    case HkextractAdidECLUH306:
    case HkextractAdidECLUH307:
    case HkextractAdidECLUH308:
      return HkextractStatusOk;
    default:
      return HkextractStatusCheckScidAdidMatch3;
    }
    break;
  case HkextractScidCLUSTER_4:
    switch (adid) {
    case HkextractAdidECLUP401:
    case HkextractAdidECLUP402:
    case HkextractAdidECLUP403:
    case HkextractAdidECLUP404:
    case HkextractAdidECLUP405:
    case HkextractAdidECLUP406:
    case HkextractAdidECLUP407:
    case HkextractAdidECLUP408:
    case HkextractAdidECLUN401:
    case HkextractAdidECLUN402:
    case HkextractAdidECLUN403:
    case HkextractAdidECLUN404:
    case HkextractAdidECLUN405:
    case HkextractAdidECLUN406:
    case HkextractAdidECLUB401:
    case HkextractAdidECLUB402:
    case HkextractAdidECLUB403:
    case HkextractAdidECLUB404:
    case HkextractAdidECLUB405:
    case HkextractAdidECLUB406:
    case HkextractAdidECLUH401:
    case HkextractAdidECLUH402:
    case HkextractAdidECLUH403:
    case HkextractAdidECLUH404:
    case HkextractAdidECLUH405:
    case HkextractAdidECLUH406:
    case HkextractAdidECLUH407:
    case HkextractAdidECLUH408:
      return HkextractStatusOk;
    default:
      return HkextractStatusCheckScidAdidMatch4;
    }
    break;
  default:
    return HkextractStatusCheckScidAdidMatchX;
  }
}

/* }}} */
/* {{{ hkextractDdspMatchStreamAndAdid */

HkextractStatus
hkextractDdspMatchStreamAndAdid(
HkextractStream stream,
HkextractAdid adid
)
{
  switch (stream) {
  case HkextractStreamRT_VC0:
  case HkextractStreamPB_VC0:
  case HkextractStreamRE_VC0:
  case HkextractStreamRP_VC0:
    switch (adid) {
    case HkextractAdidECLUH101:
    case HkextractAdidECLUH102:
    case HkextractAdidECLUH103:
    case HkextractAdidECLUH104:
    case HkextractAdidECLUH105:
    case HkextractAdidECLUH106:
    case HkextractAdidECLUH107:
    case HkextractAdidECLUH108:
    case HkextractAdidECLUH201:
    case HkextractAdidECLUH202:
    case HkextractAdidECLUH203:
    case HkextractAdidECLUH204:
    case HkextractAdidECLUH205:
    case HkextractAdidECLUH206:
    case HkextractAdidECLUH207:
    case HkextractAdidECLUH208:
    case HkextractAdidECLUH301:
    case HkextractAdidECLUH302:
    case HkextractAdidECLUH303:
    case HkextractAdidECLUH304:
    case HkextractAdidECLUH305:
    case HkextractAdidECLUH306:
    case HkextractAdidECLUH307:
    case HkextractAdidECLUH308:
    case HkextractAdidECLUH401:
    case HkextractAdidECLUH402:
    case HkextractAdidECLUH403:
    case HkextractAdidECLUH404:
    case HkextractAdidECLUH405:
    case HkextractAdidECLUH406:
    case HkextractAdidECLUH407:
    case HkextractAdidECLUH408:
      return HkextractStatusOk;
    default:
      return HkextractStatusCheckStreamAndAdidVc0;
    }
    break;
  case HkextractStreamRT_VC2:
  case HkextractStreamPB_VC2:
  case HkextractStreamRE_VC2:
  case HkextractStreamRP_VC2:
    switch (adid) {
    case HkextractAdidECLUN101:
    case HkextractAdidECLUN102:
    case HkextractAdidECLUN103:
    case HkextractAdidECLUN104:
    case HkextractAdidECLUN105:
    case HkextractAdidECLUN106:
    case HkextractAdidECLUN201:
    case HkextractAdidECLUN202:
    case HkextractAdidECLUN203:
    case HkextractAdidECLUN204:
    case HkextractAdidECLUN205:
    case HkextractAdidECLUN206:
    case HkextractAdidECLUN301:
    case HkextractAdidECLUN302:
    case HkextractAdidECLUN303:
    case HkextractAdidECLUN304:
    case HkextractAdidECLUN305:
    case HkextractAdidECLUN306:
    case HkextractAdidECLUN401:
    case HkextractAdidECLUN402:
    case HkextractAdidECLUN403:
    case HkextractAdidECLUN404:
    case HkextractAdidECLUN405:
    case HkextractAdidECLUN406:
      return HkextractStatusOk;
    default:
      return HkextractStatusCheckStreamAndAdidVc2;
    }
    break;
  case HkextractStreamRT_VC3:
  case HkextractStreamPB_VC3:
  case HkextractStreamRE_VC3:
  case HkextractStreamRP_VC3:
    switch (adid) {
    case HkextractAdidECLUB101:
    case HkextractAdidECLUB102:
    case HkextractAdidECLUB103:
    case HkextractAdidECLUB104:
    case HkextractAdidECLUB105:
    case HkextractAdidECLUB106:
    case HkextractAdidECLUB201:
    case HkextractAdidECLUB202:
    case HkextractAdidECLUB203:
    case HkextractAdidECLUB204:
    case HkextractAdidECLUB205:
    case HkextractAdidECLUB206:
    case HkextractAdidECLUB301:
    case HkextractAdidECLUB302:
    case HkextractAdidECLUB303:
    case HkextractAdidECLUB304:
    case HkextractAdidECLUB305:
    case HkextractAdidECLUB306:
    case HkextractAdidECLUB401:
    case HkextractAdidECLUB402:
    case HkextractAdidECLUB403:
    case HkextractAdidECLUB404:
    case HkextractAdidECLUB405:
    case HkextractAdidECLUB406:
      return HkextractStatusOk;
    default:
      return HkextractStatusCheckStreamAndAdidVc3;
    }
    break;
  case HkextractStreamNA:
    switch (adid) {
    case HkextractAdidECLUD001:
    case HkextractAdidECLUD002:
    case HkextractAdidECLUD003:
    case HkextractAdidECLUD004:
    case HkextractAdidECLUD005:
    case HkextractAdidECLUD006:
    case HkextractAdidECLUD007:
    case HkextractAdidECLUA001:
    case HkextractAdidECLUA002:
    case HkextractAdidECLUA003:
    case HkextractAdidECLUA004:
    case HkextractAdidECLUA005:
    case HkextractAdidECLUA006:
    case HkextractAdidECLUA007:
    case HkextractAdidECLUP101:
    case HkextractAdidECLUP102:
    case HkextractAdidECLUP103:
    case HkextractAdidECLUP104:
    case HkextractAdidECLUP105:
    case HkextractAdidECLUP106:
    case HkextractAdidECLUP107:
    case HkextractAdidECLUP108:
    case HkextractAdidECLUP201:
    case HkextractAdidECLUP202:
    case HkextractAdidECLUP203:
    case HkextractAdidECLUP204:
    case HkextractAdidECLUP205:
    case HkextractAdidECLUP206:
    case HkextractAdidECLUP207:
    case HkextractAdidECLUP208:
    case HkextractAdidECLUP301:
    case HkextractAdidECLUP302:
    case HkextractAdidECLUP303:
    case HkextractAdidECLUP304:
    case HkextractAdidECLUP305:
    case HkextractAdidECLUP306:
    case HkextractAdidECLUP307:
    case HkextractAdidECLUP308:
    case HkextractAdidECLUP401:
    case HkextractAdidECLUP402:
    case HkextractAdidECLUP403:
    case HkextractAdidECLUP404:
    case HkextractAdidECLUP405:
    case HkextractAdidECLUP406:
    case HkextractAdidECLUP407:
    case HkextractAdidECLUP408:
      return HkextractStatusOk;
    default:
      return HkextractStatusCheckStreamAndAdidNa;
    }
    break;
  default:
    return HkextractStatusCheckStreamAndAdidX;
  }
}

/* }}} */
/* {{{ hkextractIsaHkdTcal */

HkextractStatus
hkextractIsaHkdTcal(
HkextractTcal tcal
)
{
  switch (tcal)
    {
    case HkextractTcalACTUAL:
    case HkextractTcalEXTRAPOLATED:
    case HkextractTcalCONTINGENCY:
      return HkextractStatusOk;
    default:
      return HkextractStatusCheckTcal;
    }
}

/* }}} */
/* {{{ hkextractIsaHpdTcal */

HkextractStatus
hkextractIsaHpdTcal(
HkextractTcal tcal
)
{
  if (tcal == HkextractTcalACTUAL)
    return HkextractStatusOk;
  return HkextractStatusCheckTcalHpd;
}

/* }}} */
/* {{{ hkextractIsaHkdTasi */

HkextractStatus
hkextractIsaHkdTasi(
HkextractTasi tasi
)
{
  switch (tasi) {
  case HkextractTasiONE:
  case HkextractTasiTWO:
  case HkextractTasiTHREE:
  case HkextractTasiFOUR:
  case HkextractTasiFIVE:
  case HkextractTasiSIX:
  case HkextractTasiSEVEN:
  case HkextractTasiEIGHT:
  case HkextractTasiNINE:
  case HkextractTasiTEN:
  case HkextractTasiELEVEN:
  case HkextractTasiTWELVE:
  case HkextractTasiTHIRTEEN:
  case HkextractTasiFOURTEEN:
  case HkextractTasiFIFTEEN:
    return HkextractStatusOk;
  default:
    return HkextractStatusCheckTasiHkd;
  }
}

/* }}} */
/* {{{ hkextractIsaHpdTasi */

HkextractStatus
hkextractIsaHpdTasi(
HkextractTasi tasi
)
{
  if (tasi == HkextractTasiNA)
    return HkextractStatusOk;
    return HkextractStatusCheckTasiHpd;
}

/* }}} */
/* {{{ hkextractPacketTooLong */

HkextractStatus
hkextractDdspTooLong(
unsigned int len
)
{
  if (len >= HkextractDdspMaxLen)
    return HkextractStatusPacketLength;

  return HkextractStatusOk;
}

/* }}} */
/* {{{ hkextractHpdHkdTimeRule */

HkextractStatus
hkextractHkdHpdTimeRule(
TED_TIME *time1,
TED_TIME *time2
)    
{
  if (time1->day < time2->day)
    return HkextractStatusCheckScetDay;

  if (time1->day == time2->day)
    if (time1->ms < time2->ms)
      return HkextractStatusCheckScetMs;


  if (time1->day == time2->day)
    if (time1->ms == time2->ms)
      if (time1->us < time2->us)
	return HkextractStatusCheckScetUs;
  
  return HkextractStatusOk;
}

/* }}} */
/* {{{ hkextractIsaHpdHkdAdidMatch */

HkextractStatus
hkextractIsaHpdHkdAdidMatch(
HkextractAdid hpd,
HkextractAdid hkd
)
{
  if ((hpd == HkextractAdidECLUP101) && (hkd == HkextractAdidECLUH101)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP102) && (hkd == HkextractAdidECLUH102)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP103) && (hkd == HkextractAdidECLUH103)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP104) && (hkd == HkextractAdidECLUH104)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP105) && (hkd == HkextractAdidECLUH105)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP106) && (hkd == HkextractAdidECLUH106)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP107) && (hkd == HkextractAdidECLUH107)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP108) && (hkd == HkextractAdidECLUH108)) return HkextractStatusOk;


  if ((hpd == HkextractAdidECLUP201) && (hkd == HkextractAdidECLUH201)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP202) && (hkd == HkextractAdidECLUH202)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP203) && (hkd == HkextractAdidECLUH203)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP204) && (hkd == HkextractAdidECLUH204)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP205) && (hkd == HkextractAdidECLUH205)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP206) && (hkd == HkextractAdidECLUH206)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP207) && (hkd == HkextractAdidECLUH207)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP208) && (hkd == HkextractAdidECLUH208)) return HkextractStatusOk;


  if ((hpd == HkextractAdidECLUP301) && (hkd == HkextractAdidECLUH301)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP302) && (hkd == HkextractAdidECLUH302)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP303) && (hkd == HkextractAdidECLUH303)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP304) && (hkd == HkextractAdidECLUH304)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP305) && (hkd == HkextractAdidECLUH305)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP306) && (hkd == HkextractAdidECLUH306)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP307) && (hkd == HkextractAdidECLUH307)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP308) && (hkd == HkextractAdidECLUH308)) return HkextractStatusOk;


  if ((hpd == HkextractAdidECLUP401) && (hkd == HkextractAdidECLUH401)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP402) && (hkd == HkextractAdidECLUH402)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP403) && (hkd == HkextractAdidECLUH403)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP404) && (hkd == HkextractAdidECLUH404)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP405) && (hkd == HkextractAdidECLUH405)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP406) && (hkd == HkextractAdidECLUH406)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP407) && (hkd == HkextractAdidECLUH407)) return HkextractStatusOk;
  if ((hpd == HkextractAdidECLUP408) && (hkd == HkextractAdidECLUH408)) return HkextractStatusOk;

  return HkextractStatusHpdHkdAdidMatch;
} 

/* }}} */
/* {{{ hkextractValidatePacketAndTable */

HkextractStatus
hkextractValidatePacketAndTable(
unsigned char *pPacket,
TED_HPD_TABLE *pTABLE
)
{
  int status;
  TED_TIME packetTime;
  int padid,tadid;

  if (pPacket == NULL)
    return HkextractStatusValidatePacketAndTableArgs;

  if (pTABLE == NULL) {
    return HkextractStatusValidatePacketAndTableArgs;
  }

  padid = hkextractDdspGetSource(pPacket);
  tadid = pTABLE->source;

  status = hkextractIsaHpdHkdAdidMatch(tadid,padid);
  if (status != HkextractStatusOk) {
    return HkextractStatusValidatePacketAndTableAdid;
  }

  packetTime.day = hkextractDdspGetScetDay(pPacket);
  packetTime.ms   = hkextractDdspGetScetMs(pPacket);
  packetTime.us   = hkextractDdspGetScetUs(pPacket);
  
  status = hkextractHkdHpdTimeRule(&packetTime,&pTABLE->scet);
  if (status != HkextractStatusOk)
      return HkextractStatusValidatePacketAndTableTime;

  return HkextractStatusOk;
}

/* }}} */
/* {{{ hkextractPrintUtcTime */

FILE *
hkextractPrintUtcTime(
FILE *os,
time_t time
)
{
  struct tm *pTime = gmtime(&time);
  char *ascTime = asctime(pTime);

  fprintf(os,"\n<hkextract-utc-time time=\"%s\"/>",ascTime);
  return os;
}

/* }}} */
/* {{{ hkextractCalibrate */

#include "calinf.h"

HkextractStatus
hkextractCalibrate(
char name[],
char calinf[],
char unit[],
char categ[],
char descr[],
unsigned int raw,
TED_HKEXTRACT_CALIBRATED_VALUE *CalVal
)
{

  if (calinf == NULL)
    return HkextractStatusCalibrateArgs;

  CalVal->raw = raw;

  strcpy(CalVal->pMNEM,"");
  if (name != NULL)
    if ((int)strlen(name) > 0)
      strcpy(CalVal->pMNEM,name);

  strcpy(CalVal->pCATEG,"");
  if (categ != NULL)
    if ((int) strlen(categ) > 0)
      strcpy(CalVal->pCATEG,categ);
    
  strcpy(CalVal->pDESCR,"");
  if (descr != NULL)
    if ((int) strlen(descr) > 0)
      strcpy(CalVal->pDESCR,descr);

  strcpy(CalVal->pCALIB,"");

  if (calinf != NULL) {
    int len = (int) strlen(calinf);
    if (len > 0) {
      if (len < 10240)
	strcpy(CalVal->pCALIB,calinf);
      else
	strcpy(CalVal->pCALIB,"too long to fint into array");
    }
  }

  strcpy(CalVal->pUNIT,"");
  if (unit != NULL)
    if ((int) strlen(unit) > 0)
      strcpy(CalVal->pUNIT,unit);
  
  CalVal->wasCalibrated = TED_HKEXTRACT_CALIBRATED_NO;
  CalVal->Type = TED_HKEXTRACT_VALUE_TYPE_UNDEFINED;
  
  switch (categ[0]) {
  case 'S':
    calenum_yacc_init(raw,calinf);
    calenum_parse();
    if (calenum_res_get() == CALINF_STATUS_FOUND) {
      CalVal->wasCalibrated = TED_HKEXTRACT_CALIBRATED_YES;
      CalVal->Type = TED_HKEXTRACT_VALUE_TYPE_TEXT;
      strcpy(CalVal->HKEXTRACT_SYMBOL_VALUE_u.Text,(char *)calenum_status_get());
      return HkextractStatusOk;
    }
    break;
  case 'N':
    calpoint_yacc_init(raw,calinf);
    calpoint_parse();
    if (calpoint_res_get() == CALINF_COORD_FOUND) {
      CalVal->wasCalibrated = TED_HKEXTRACT_CALIBRATED_YES;
	CalVal->Type = TED_HKEXTRACT_VALUE_TYPE_REAL;
      CalVal->HKEXTRACT_SYMBOL_VALUE_u.Real = (double) calpoint_coord_get();
      return HkextractStatusOk;
    }
    break;
  case 'T':
    CalVal->wasCalibrated = TED_HKEXTRACT_CALIBRATED_YES;
    CalVal->Type = TED_HKEXTRACT_VALUE_TYPE_UNDEFINED;
    return HkextractStatusOk;
  default:
    return HkextractStatusCalibrateUndefined;
    break;
  }
}

/* }}} */
/* {{{ hkextractPdeFieldRead */

HkextractStatus
hkextractPdeFieldRead(
char **ppCh,
char *buf,
int width,
int packing
)
{
  char fmt[1024];
  char pac[1024];
  char *strIndex = NULL;
  int count;

  if (ppCh == NULL)
    return HkextractStatusPdeFieldReadArgs;
  if (*ppCh == NULL)
    return HkextractStatusPdeFieldReadArgs;
  if (buf == NULL)
    return HkextractStatusPdeFieldReadArgs;
  if (packing < 0)
    return HkextractStatusPdeFieldReadArgs;

  strcpy(buf,"");

  if (width < 1) {
    strIndex = strchr(*ppCh,'\n');
    if (strIndex != NULL) {
      width = strIndex - *ppCh;
    }
    else
      width = strlen(*ppCh);
  }

  if (width > 0) {
    sprintf(fmt,"%%%dc",width);
    count = sscanf((const char *)*ppCh,fmt,buf);
    if (count != 1)
      return HkextractStatusPdeFieldReadInput;
    else {
      buf[width] = '\0';
      *ppCh = (*ppCh) + width;
    }
  }
  if (packing > 0) {
    sprintf(fmt,"%%%dc",packing);
    count = sscanf((const char *)*ppCh,fmt,pac);
    if (count != 1)
      return HkextractStatusPdeFieldReadInput;

    *ppCh = (*ppCh) + packing;
  }

  return HkextractStatusOk;
}

/* }}} */
/* {{{ hkextractScanPde */

HkextractStatus
hkextractScanPde(
char **ppCh,
char   tasi[],
char   mnem[],
char  descr[],
char   unit[],
char  categ[],
char  codin[],
char  width[],
char  offby[],
char  offbi[],
char  nbocc[],
char  nbgrp[],
char  lgocc[],
char  lggrp[],
char calinf[]
)
{
  int status;
  char buf[10240];
  int i;

/* {{{ TASI */

  status = hkextractPdeFieldRead(ppCh,tasi,3,1);
  sscanf(tasi,"%d",&i);
  sprintf(tasi,"%d",i);
  if (status != HkextractStatusOk) return status;

/* }}} */
/* {{{ MNEM */

  status = hkextractPdeFieldRead(ppCh,mnem,6,1);
  if (status != HkextractStatusOk) return status;

/* }}} */
/* {{{ DESCR */

  status = hkextractPdeFieldRead(ppCh,descr,16,1);
  if (status != HkextractStatusOk) return status;

/* }}} */
/* {{{ UNIT */

  status = hkextractPdeFieldRead(ppCh,unit,4,1);
  if (status != HkextractStatusOk) return status;

/* }}} */
/* {{{ CATEG */

  status = hkextractPdeFieldRead(ppCh,categ,1,1);
  if (status != HkextractStatusOk) return status;

/* }}} */
/* {{{ CODIN */

  status = hkextractPdeFieldRead(ppCh,codin,1,1);
  if (status != HkextractStatusOk) return status;

/* }}} */
/* {{{ WIDTH */

  status = hkextractPdeFieldRead(ppCh,width,3,1);
  sscanf(width,"%d",&i);
  sprintf(width,"%d",i);
  if (status != HkextractStatusOk) return status;

/* }}} */
/* {{{ OFFBY */

  status = hkextractPdeFieldRead(ppCh,offby,5,1);
  if (status != HkextractStatusOk) return status;

/* }}} */
/* {{{ OFFBI */

  status = hkextractPdeFieldRead(ppCh,offbi,1,1);
  if (status != HkextractStatusOk) return status;

/* }}} */
/* {{{ NBOCC */

  status = hkextractPdeFieldRead(ppCh,nbocc,4,1);
  if (status != HkextractStatusOk) return status;

/* }}} */
/* {{{ NBGRP */

  status = hkextractPdeFieldRead(ppCh,nbgrp,4,1);
  if (status != HkextractStatusOk) return status;

/* }}} */
/* {{{ LGOCC */

  status = hkextractPdeFieldRead(ppCh,lgocc,5,1);
  if (status != HkextractStatusOk) return status;

/* }}} */
/* {{{ LGGRP */

  status = hkextractPdeFieldRead(ppCh,lggrp,5,1);
  if (status != HkextractStatusOk) return status;

/* }}} */
/* {{{ CALINF */

  status = hkextractPdeFieldRead(ppCh,calinf,-1,1);
  if (status != HkextractStatusOk) return status;

/* }}} */
  return HkextractStatusOk;
}

/* }}} */
/* {{{ hkextractParsePdeData */

HkextractStatus
hkextractParsePdeData(
HkextractSymbol *this,
char *pCh,
int len
)
{
  char *last = pCh + len;
  char *lastPch;
  char *firstPch = pCh;
  char buf[1024];

  int status;
  HkextractSymbol *pHpd, *Record, *pSymbol, *pTasi, *pField;

  char	tasi[20],	mnem[20],	descr[20],	unit[10],
	categ[10],	codin[10],	width[20],	offby[10],
	offbi[10],	nbocc[10],	nbgrp[10],	lgocc[10],
	lggrp[10],	calinf[10240];

  if (this == NULL)
    return HkextractStatusParsePdeDataArgs;

  if (pCh == NULL)
    return HkextractStatusParsePdeDataArgs;

  if (len < 1)
    return HkextractStatusParsePdeDataArgs;

  strcpy(tasi,"");   strcpy(mnem,"");   strcpy(descr,"");  strcpy(unit,"");
  strcpy(categ,"");  strcpy(codin,"");  strcpy(width,"");  strcpy(offby,"");
  strcpy(offbi,"");  strcpy(nbocc,"");  strcpy(nbgrp,"");  strcpy(lgocc,"");
  strcpy(lggrp,"");  strcpy(calinf,"");

  lastPch = pCh;
  while (lastPch < last) {
    status = hkextractScanPde((char **)&lastPch,
			      tasi,mnem,
			      descr,unit,
			      categ,codin,
			      width,
			      offby,offbi,
			      nbocc,nbgrp,
			      lgocc,lggrp,
			      calinf);
    if (status != HkextractStatusOk)
      return HkextractStatusParsePdeDataLexError;

    /* {{{ TASI */

    status = hkextractSearchSymbol(&pTasi,this,tasi);
    if (status != HkextractStatusOk) {
      pTasi = hkextractNewSymbol(tasi,HkextractSymbolTypeTable,NULL);
      if (pTasi == NULL) {
	return HkextractStatusMemory;
      }
      status = hkextractInsertSymbol(this,pTasi,NULL);
      if (status != HkextractStatusOk) {
	hkextractDeleteSymbol(&pTasi);
	return HkextractStatusParsePdeDataSymbol;
      }
    }

    /* }}} */
    /* {{{ MNEM */

    Record = hkextractNewSymbol(mnem,HkextractSymbolTypeTable,NULL);
    if (Record == NULL) {
      return HkextractStatusMemory;
    }
    status = hkextractInsertSymbol(pTasi,Record,mnem);

    if (status != HkextractStatusOk) {
      hkextractDeleteSymbol(&Record);
      return HkextractStatusParsePdeDataSymbol;
    }

    /* }}} */
    /* {{{ DESCR */

    pField = (HkextractSymbol *) hkextractNewSymbol("DESCR",
		    HkextractSymbolTypeText,
		    descr);
    if (pField == NULL) {
      return HkextractStatusMemory;
    }
    if (hkextractInsertSymbol(Record,pField,NULL) != HkextractStatusOk) {
      hkextractDeleteSymbol(&pField);
      return HkextractStatusParsePdeDataSymbol;
    }

    /* }}} */
    /* {{{ UNIT */

    pField = (HkextractSymbol *) hkextractNewSymbol("UNIT",
		HkextractSymbolTypeText,
		unit)    ;
    if (pField == NULL) {
      return HkextractStatusMemory;
    }
    if (hkextractInsertSymbol(Record,pField,NULL) != HkextractStatusOk) {
      hkextractDeleteSymbol(&pField);
      return HkextractStatusParsePdeDataSymbol;
    }

    /* }}} */
    /* {{{ CATEG */

    pField = (HkextractSymbol *) hkextractNewSymbol("CATEG",
		    HkextractSymbolTypeText,
		    categ);
    if (pField == NULL) {
      return HkextractStatusMemory;
    }
    if (hkextractInsertSymbol(Record,pField,NULL) != HkextractStatusOk) {
      hkextractDeleteSymbol(&pField);
      return HkextractStatusParsePdeDataSymbol;
    }

    /* }}} */
    /* {{{ CODIN */

    pField = (HkextractSymbol *) hkextractNewSymbol("CODIN",
		    HkextractSymbolTypeText,
		    codin);
    if (pField == NULL) {
      return HkextractStatusMemory;
    }
    if (hkextractInsertSymbol(Record,pField,NULL) != HkextractStatusOk) {
      hkextractDeleteSymbol(&pField);
      return HkextractStatusParsePdeDataSymbol;
    }

    /* }}} */
    /* {{{ WIDTH */

      pField = (HkextractSymbol *) hkextractNewSymbol("WIDTH",
			      HkextractSymbolTypeInteger,
			      width);
    if (pField == NULL) {
      return HkextractStatusMemory;
    }
    if (hkextractInsertSymbol(Record,pField,NULL) != HkextractStatusOk) {
      hkextractDeleteSymbol(&pField);
      return HkextractStatusParsePdeDataSymbol;
    }

/* }}} */
    /* {{{ OFFBY */

    pField = (HkextractSymbol *) hkextractNewSymbol("OFFBY",
		HkextractSymbolTypeInteger,
		offby);
    if (pField == NULL) {
      return HkextractStatusMemory;
    }
    if (hkextractInsertSymbol(Record,pField,NULL) != HkextractStatusOk) {
      hkextractDeleteSymbol(&pField);
      return HkextractStatusParsePdeDataSymbol;
    }

/* }}} */
    /* {{{ OFFBI */

    pField = (HkextractSymbol *) hkextractNewSymbol("OFFBI",
		HkextractSymbolTypeInteger,
		offbi);
    if (pField == NULL) {
      return HkextractStatusMemory;
    }
    if (hkextractInsertSymbol(Record,pField,NULL) != HkextractStatusOk) {
      hkextractDeleteSymbol(&pField);
      return HkextractStatusParsePdeDataSymbol;
    }

/* }}} */
    /* {{{ NBOCC */

    pField = (HkextractSymbol *) hkextractNewSymbol("NBOCC",
		     HkextractSymbolTypeInteger,
		     nbocc);
    if(pField == NULL) {
      return HkextractStatusMemory;
    }

    if (hkextractInsertSymbol(Record,pField,NULL) != HkextractStatusOk) {
     hkextractDeleteSymbol(&pField);
     return HkextractStatusParsePdeDataSymbol;
   }

/* }}} */
    /* {{{ NBGRP */

    pField = (HkextractSymbol *) hkextractNewSymbol("NBGRP",
		HkextractSymbolTypeInteger,
		nbgrp);
    if (pField == NULL) {
      return HkextractStatusMemory;
    }

    if (hkextractInsertSymbol(Record,pField,NULL) != HkextractStatusOk) {
      hkextractDeleteSymbol(&pField);
      return HkextractStatusParsePdeDataSymbol;
    }

/* }}} */
    /* {{{ LGOCC */

    pField = (HkextractSymbol *) hkextractNewSymbol("LGOCC",
		  HkextractSymbolTypeInteger,
		  lgocc);
    if (pField == NULL) {
      return HkextractStatusMemory;
    }
    if (hkextractInsertSymbol(Record,pField,NULL) != HkextractStatusOk) {
      hkextractDeleteSymbol(&pField);
      return HkextractStatusParsePdeDataSymbol;
    }

/* }}} */
    /* {{{ LGGRP */

    pField = (HkextractSymbol *) hkextractNewSymbol("LGGRP",
		    HkextractSymbolTypeInteger,
		    lggrp);
    if (pField == NULL) {
      return HkextractStatusMemory;
    }
    if (hkextractInsertSymbol(Record,pField,NULL) != HkextractStatusOk) {
      hkextractDeleteSymbol(&pField);
      return HkextractStatusParsePdeDataSymbol;
    }

/* }}} */
    /* {{{ CALINF */

    pField = (HkextractSymbol *) hkextractNewSymbol("CALINF",
		HkextractSymbolTypeText,
		calinf);
    if (pField == NULL) {
      return HkextractStatusMemory;
    }

    if (hkextractInsertSymbol(Record,pField,NULL) != HkextractStatusOk) {
      hkextractDeleteSymbol(&pField);
      return HkextractStatusParsePdeDataSymbol;
    }

/* }}} */
  }
  return HkextractStatusOk;
}

/* }}} */      
/* {{{ hkextractParseAliases */

#include "alias.h"
extern int alias_yacc_init(void *,char *);
extern int alias_parse(void);
extern ALIAS_STYPE alias_val;

HkextractStatus
hkextractParseAliases(
HkextractSymbol *this,
char *pCh
)
{
  int status;
  char *text;
  if (this == NULL)
    return HkextractStatusParseAliasesArgs;

  if (pCh == NULL)
    return HkextractStatusParseAliasesArgs;

  text = strtok(pCh,"\n");
  while (text != NULL) {
    status = alias_yacc_init(this,text);
    if (status != HkextractStatusOk)
      return HkextractStatusParseAliasesInit;
    alias_parse();
    status = hkextractInsertSymbol(this,alias_val.SYMBOL,NULL);
    text = strtok(NULL,"\n");
  }
  return HkextractStatusOk;
}

/* }}} */      

/* {{{ ted_hkextract_display_hpd_table */

FILE *
ted_hkextract_display_hpd_table(
FILE *os,
TED_HPD_TABLE *pTABLE
)
{
  fprintf(os,"\n<hpd-table");
  fprintf(os," scet-day=\"%ld\"",pTABLE->scet.day);
  fprintf(os," scet-ms=\"%ld\"",pTABLE->scet.ms);
  fprintf(os," scet-us=\"%ld\"",pTABLE->scet.us);
  fprintf(os," length=\"%d\"",pTABLE->length);
  fprintf(os," source=\"%d\"",pTABLE->source);
  fprintf(os," gsid=\"%d\"",pTABLE->gsid);
  fprintf(os," stream=\"%d\"",pTABLE->stream);
  fprintf(os," tcal=\"%d\"",pTABLE->tcal);
  fprintf(os," tasi=\"%d\"",pTABLE->tasi);
  fprintf(os,">");
  hkextractPrintSymbol(os,pTABLE->symbols);
  fprintf(os,"\n</hpd-table>");
  return os;
}

/* }}} */
/* {{{ ted_hkextract_print_calibrated_value */

FILE *
ted_hkextract_print_calibrated_value(
FILE *os,
TED_HKEXTRACT_CALIBRATED_VALUE *pCalVal
)
{
  if (os == NULL)      return NULL;
  if (pCalVal == NULL) return NULL;

  fprintf(os,"\n<ted-calibration>");
  fprintf(os,"\n\t<was-calibrated value=\"%s\"/>",(char *) tedHkextractCalibratedToString(pCalVal->wasCalibrated));

  if (strlen(pCalVal->pMNEM))  fprintf(os,"\n\t<mnem  value=\"%s\"/>",pCalVal->pMNEM);
  if (strlen(pCalVal->pUNIT))  fprintf(os,"\n\t<unit  value=\"%s\"/>",pCalVal->pUNIT);
  if (strlen(pCalVal->pCATEG)) fprintf(os,"\n\t<categ value=\"%s\"/>",pCalVal->pCATEG);
  if (strlen(pCalVal->pDESCR)) fprintf(os,"\n\t<descr value=\"%s\"/>",pCalVal->pDESCR);
  
  fprintf(os,"\n\t<raw hex=\"0x%x\" value=\"%u\">",pCalVal->raw,pCalVal->raw);
  fprintf(os,"\n\t<calibration>");

  switch(pCalVal->Type)
  {
  case TED_HKEXTRACT_VALUE_TYPE_REAL: fprintf(os,"\n\t\t<value><real>%f</real></value>",    pCalVal->HKEXTRACT_SYMBOL_VALUE_u.Real); break;
  case TED_HKEXTRACT_VALUE_TYPE_TEXT: fprintf(os,"\n\t\t<value><string>%s</string></value>",pCalVal->HKEXTRACT_SYMBOL_VALUE_u.Text); break;
  default:                            fprintf(os,"\n\t\t<value><undefined/></value>"); break;
  }
  fprintf(os,"\n\t</calibration>");
  fprintf(os,"\n</ted-calibration>");
  return os;
}

/* }}} */
/* {{{ ted_hkextract_validate_hpd_header */

TED_STATUS
ted_hkextract_validate_hpd_header(
unsigned char *this
)
{
  int status;

  if (this == NULL)
      return TED_HKEXTRACT_VALIDATE_HPD_HEADER_ARGS;

  status = hkextractIsaHpdAdid(hkextractDdspGetSource(this));
  if (status != HkextractStatusOk)
    return TED_HKEXTRACT_VALIDATE_HPD_HEADER_ADID;

  status = hkextractIsaDdspScid(hkextractDdspGetScid(this));
  if (status != HkextractStatusOk)
      return TED_HKEXTRACT_VALIDATE_HPD_HEADER_SCID;

  status = hkextractIsaHpdStream(hkextractDdspGetStream(this));
  if (status != HkextractStatusOk)
      return TED_HKEXTRACT_VALIDATE_HPD_HEADER_STREAM;

  status = hkextractIsaHpdGround(hkextractDdspGetGsid(this));
  if (status != HkextractStatusOk)
      return TED_HKEXTRACT_VALIDATE_HPD_HEADER_GSID;
  
  status = hkextractDdspMatchScidAndAdid(hkextractDdspGetScid(this),
					 hkextractDdspGetAdid(this));
  if (status != HkextractStatusOk)
      return TED_HKEXTRACT_VALIDATE_HPD_HEADER_SCID_ADID_MATCH;
  
  status = hkextractIsaHpdTcal(hkextractDdspGetTcal(this));
  if (status != HkextractStatusOk)
      return TED_HKEXTRACT_VALIDATE_HPD_HEADER_TCAL;
  
  status = hkextractIsaHpdTasi(hkextractDdspGetTasi(this));
  if (status != HkextractStatusOk)
      return TED_HKEXTRACT_VALIDATE_HPD_HEADER_TASI;

  return TED_OK;
}

/* }}} */
/* {{{ ted_hkextract_validate_hkd_header */

TED_STATUS
ted_hkextract_validate_hkd_header(
unsigned char *this
)
{
  int status;

  if (this == NULL)
    return TED_HKEXTRACT_VALIDATE_HKD_HEADER_ARGS;

  status = hkextractIsaHkdAdid(hkextractDdspGetAdid(this));
  if (status != HkextractStatusOk) {
    return TED_HKEXTRACT_VALIDATE_HKD_HEADER_ADID;
  }

  status = hkextractIsaHkdStream(hkextractDdspGetStream(this));
  if (status != HkextractStatusOk) {
    return TED_HKEXTRACT_VALIDATE_HKD_HEADER_STREAM;
  }

  status = hkextractIsaHkdGround(hkextractDdspGetGsid(this));
  if (status != HkextractStatusOk) {
    return TED_HKEXTRACT_VALIDATE_HKD_HEADER_GSID;
  }

  status = hkextractIsaHkdTcal(hkextractDdspGetTcal(this));
  if (status != HkextractStatusOk) {
    return TED_HKEXTRACT_VALIDATE_HKD_HEADER_TCAL;
  }

  status = hkextractIsaHkdTasi(hkextractDdspGetTasi(this));
  if (status != HkextractStatusOk) {
    return TED_HKEXTRACT_VALIDATE_HKD_HEADER_TASI;
  }

  status = hkextractIsaDdspScid(hkextractDdspGetScid(this));
  if (status != HkextractStatusOk) {
    return TED_HKEXTRACT_VALIDATE_HKD_HEADER_SCID;
  }

  status = hkextractDdspMatchScidAndAdid(hkextractDdspGetScid(this),
	hkextractDdspGetSource(this));
  if (status != HkextractStatusOk) {
    return TED_HKEXTRACT_VALIDATE_HKD_HEADER_SCID_ADID_MATCH;
  }

  status = hkextractDdspMatchStreamAndAdid(hkextractDdspGetStream(this),
	hkextractDdspGetSource(this));
  if (status != HkextractStatusOk) {
    return TED_HKEXTRACT_VALIDATE_HKD_HEADER_STREAM_ADID_MATCH;
  }

  return TED_OK;
}

/* }}} */
/* {{{ ted_hkextract_parse_hpd_data */

TED_STATUS
ted_hkextract_parse_hpd_data(
TED_HPD_TABLE *this,
unsigned char *pCh,
unsigned long len
)
{
  HkextractSymbol *pHpd = NULL;
  HkextractSymbol *pSymbol = NULL;
  int status;

  if (this == NULL)
      return TED_HKEXTRACT_PARSE_HPD_DATA_ARGS;

  if (pCh == NULL)
      return TED_HKEXTRACT_PARSE_HPD_DATA_ARGS;

  if (this->symbols == NULL)
    this->symbols = hkextractNewSymbol("HKEXTRACT",
			HkextractSymbolTypeTable,
			NULL);

  if (this->symbols == NULL)
    return TED_MEMORY;

  pSymbol = this->symbols;    
    
  pHpd = (HkextractSymbol *) hkextractNewSymbol("HPD",
			HkextractSymbolTypeTable,
			NULL);
  if (pHpd == NULL)
      return TED_MEMORY;

  status = hkextractParsePdeData(pHpd,
				 (char *)pCh,
				 len);
  if (status != HkextractStatusOk) {
      hkextractDeleteSymbol((HkextractSymbol **) &pHpd);
      return TED_HKEXTRACT_PARSE_HPD_DATA_LEX_ERROR;
  }

  status = hkextractInsertSymbol(pSymbol,pHpd,"HPD");
  if (status != HkextractStatusOk) {
      hkextractDeleteSymbol((HkextractSymbol **) &pHpd);
      return TED_HKEXTRACT_PARSE_HPD_DATA_SYMBOL;
  }

  return TED_OK;
}

/* }}} */
/* {{{ ted_hkextract_parse_hpd */

TED_STATUS
ted_hkextract_parse_hpd(
TED_HPD_TABLE *this,
unsigned char *pPacket
)
{
  int status;

  if (this == NULL)
    return TED_HKEXTRACT_PARSE_HPD_ARGS;

  if (pPacket == NULL)
    return TED_HKEXTRACT_PARSE_HPD_ARGS;

  status = ted_hkextract_validate_hpd_header(pPacket);
  if (status != TED_OK)
    return TED_HKEXTRACT_PARSE_HPD_HEADER;

  if (this->symbols == NULL)
    this->symbols = hkextractNewSymbol("HKEXTRACT",
			HkextractSymbolTypeTable,
			NULL);

  if (this->symbols == NULL)
    return TED_MEMORY;

  status = ted_hkextract_parse_hpd_data(this,
		(unsigned char *) hkextractDdspGetData(pPacket),
		hkextractDdspGetLen(pPacket));

  if (status != TED_OK) 
    return TED_HKEXTRACT_PARSE_HPD_DATA;

  return TED_OK;
}

/* }}} */
/* {{{ ted_hkextract_parse_aliases */

TED_STATUS
ted_hkextract_parse_aliases(
TED_HPD_TABLE *this,
char *aliases
)
{
  HkextractSymbol *pAliases = NULL;
  HkextractSymbol *pSymbol = NULL;

  int status;
  
  if (this == NULL)
      return TED_HKEXTRACT_PARSE_ALIASES_ARGS;
  
  if (aliases == NULL)
      return TED_HKEXTRACT_PARSE_ALIASES_ARGS;


  if ((int)strlen(aliases) < 1)
    return TED_OK;

  if (this->symbols == NULL)
    this->symbols = hkextractNewSymbol("HKEXTRACT",
			HkextractSymbolTypeTable,
			NULL);

  if (this->symbols == NULL)
    return TED_MEMORY;

  pSymbol = this->symbols;    

  if (pSymbol == NULL)
      return TED_HKEXTRACT_PARSE_ALIASES_TABLE;
  
  if ((int)strlen(aliases) < 1)
      return TED_HKEXTRACT_PARSE_ALIASES_STRING;

  pAliases = (HkextractSymbol *) hkextractNewSymbol("ALIASES",
		HkextractSymbolTypeTable,
		NULL);
  if (pAliases == NULL)
    return TED_MEMORY;

  if ((int)strlen(aliases) > 0) {
    status = hkextractParseAliases(pAliases,aliases);
    if (status != HkextractStatusOk)
      return TED_HKEXTRACT_PARSE_ALIASES_DATA;


    status = hkextractInsertSymbol(pSymbol,pAliases,NULL);
    if (status != HkextractStatusOk) {
      hkextractDeleteSymbol((HkextractSymbol **) &pAliases);
      return TED_HKEXTRACT_PARSE_ALIASES_SYMBOL;
    }
  }

  return TED_OK;
}

/* }}} */
/* {{{ ted_hkextract_build_hpd_table */

TED_STATUS
ted_hkextract_build_hpd_table(
TED_HPD_TABLE *this,
unsigned char *ddsph
)
{
  int status;

  if (this == NULL) {
    return TED_HKEXTRACT_BUILD_TABLE_ARGS;
  }

  if (ddsph == NULL) {
      return TED_HKEXTRACT_BUILD_TABLE_ARGS;
  }

  status = ted_hkextract_validate_hpd_header(ddsph);
  if (status != TED_OK)
      return TED_HKEXTRACT_BUILD_TABLE_HPD_HEADER;

  this->scet.day = hkextractDdspGetScetDay(ddsph);
  this->scet.ms  = hkextractDdspGetScetMs(ddsph);
  this->scet.us  = hkextractDdspGetScetUs(ddsph);
  this->length   = hkextractDdspGetLen(ddsph);
  this->source   = hkextractDdspGetSource(ddsph);
  this->scid     = hkextractDdspGetScid(ddsph);
  this->gsid     = hkextractDdspGetGsid(ddsph);
  this->stream   = hkextractDdspGetStream(ddsph);;
  this->tcal     = hkextractDdspGetTcal(ddsph);
  this->tasi     = hkextractDdspGetTasi(ddsph);
  
  return TED_OK;
}

/* }}} */
/* {{{ ted_hkextract_close_table */

void
ted_hkextract_close_table(
TED_HPD_TABLE *this
)
{
  if (this != NULL) {
    if (this->symbols != NULL)
      hkextractDeleteSymbol((HkextractSymbol **)&(this->symbols));
    this->scet.day = 0;
    this->scet.ms = 0;
    this->scet.us = 0;
    this->length = 0;
    this->source = -1;
    this->scid = 0;
    this->gsid = 0;
    this->stream = 0;
    this->tcal = 0;
    this->tasi = 0;
  }
}

/* }}} */
/* {{{ ted_hkextract_init_table */

void
ted_hkextract_init_table(
TED_HPD_TABLE *this
)
{
  if (this != NULL) {
    this->symbols = NULL;
    this->scet.day = 0;
    this->scet.ms = 0;
    this->scet.us = 0;
    this->length = 0;
    this->source = -1;
    this->scid = 0;
    this->gsid = 0;
    this->stream = 0;
    this->tcal = 0;
    this->tasi = 0;
  }
}

/* }}} */
/* {{{ ted_hkextract_validate_dds_header */

TED_STATUS
ted_hkextract_validate_dds_header(
unsigned char *this
)
{
  int status;

  if (this == NULL)
    return TED_HKEXTRACT_VALIDATE_DDS_HEADER_ARGS;

  status = ted_hkextract_validate_hkd_header(this);
  if (status == TED_OK)
    return TED_OK;

  status = ted_hkextract_validate_hpd_header(this);
  if (status == TED_OK)
    return TED_OK;

  return TED_HKEXTRACT_VALIDATE_DDS_HEADER;
}

/* }}} */
/* {{{ ted_hkextract_check_corrspondence */

TED_STATUS
ted_hkextract_check_corresponence(
unsigned char *hpdh,
unsigned char *hkdh
)
{
  int  hpdScid,hkdScid,hpdAdid,hkdAdid,hpdStream,hkdStream; 
  int status;

  if (hpdh == NULL)
      return TED_HKEXTRACT_CHECK_CORR_ARGS;

  if (hkdh == NULL)
      return TED_HKEXTRACT_CHECK_CORR_ARGS;

  status = ted_hkextract_validate_hpd_header(hpdh);
  if (status != TED_OK)
    return TED_HKEXTRACT_CHECK_CORR_HPD_HEADER;

  status = ted_hkextract_validate_hkd_header(hkdh);
  if (status != HkextractStatusOk)
      return TED_HKEXTRACT_CHECK_CORR_HKD_HEADER;

  hpdScid    = hkextractDdspGetScid(hpdh);
  hkdScid    = hkextractDdspGetScid(hkdh);
  hpdAdid    = hkextractDdspGetAdid(hpdh);
  hkdAdid    = hkextractDdspGetAdid(hkdh);
  hpdStream  = hkextractDdspGetStream(hpdh);
  hkdStream  = hkextractDdspGetStream(hkdh);
  
  if (hpdScid != hkdScid)
    return TED_HKEXTRACT_CHECK_CORR_SCID;

  status = hkextractIsaHpdHkdAdidMatch(hpdAdid,hkdAdid);
  if (status != HkextractStatusOk)
      return TED_HKEXTRACT_CHECK_CORR_ADID_MATCH;

  {
    TED_TIME hpdTime;
    TED_TIME hkdTime;
    hpdTime.day = hkextractDdspGetScetDay(hpdh);
    hkdTime.day = hkextractDdspGetScetDay(hkdh);
    hpdTime.ms  = hkextractDdspGetScetMs(hpdh);
    hkdTime.ms  = hkextractDdspGetScetMs(hkdh);
    hpdTime.us  = hkextractDdspGetScetUs(hpdh);
    hkdTime.us  = hkextractDdspGetScetUs(hkdh);

    status = hkextractHkdHpdTimeRule(&hkdTime,&hpdTime);
    if (status != HkextractStatusOk)
      return TED_HKEXTRACT_CHECK_SCET_TIME_RULE;
  }
  return TED_OK;
}

/* }}} */
/* {{{ ted_hkextract_lookup_parameter */

TED_STATUS
ted_hkextract_lookup_parameter(
TED_HKEXTRACT_HPD_ITEM *pItem,
TED_HPD_TABLE *pTable,
int tasi,
char *pMNEM
)
{
  char paramName[1024];
  int status;
  HkextractSymbol *pSymbol = NULL;
  HkextractSymbolAttribRes res;

  if (pItem == NULL)
    return TED_HKEXTRACT_LOOKUP_PARAM_ARGS;

  if (pTable == NULL)
    return TED_HKEXTRACT_LOOKUP_PARAM_ARGS;

  if ((int)strlen(pMNEM) < 1)
    return TED_HKEXTRACT_LOOKUP_PARAM_MNEM;

  if (hkextractIsaHkdTasi(tasi) != HkextractStatusOk)
    return TED_HKEXTRACT_LOOKUP_PARAM_TASI;

  pSymbol = NULL;
  sprintf(paramName,"HPD.%d.%s",tasi,pMNEM);
  if (hkextractSearchSymbol((HkextractSymbol **) &pSymbol,
			    (HkextractSymbol *) pTable->symbols,
			    paramName) == HkextractStatusOk) {
    *pItem = pSymbol;
    return TED_OK;
  }

  pSymbol = NULL;
  sprintf(paramName,"ALIASES.%s",pMNEM);
  status = hkextractSearchSymbol((HkextractSymbol **)&pSymbol,
				 pTable->symbols,
				 paramName);
  if (status == HkextractStatusOk) {
      if (hkextractSymbolType(pSymbol) == HkextractSymbolTypeText) {
	  status = hkextractSymbolAttrib(pSymbol,
					 HkextractSymbolAttribValue,
					 &res);
	  if (status == HkextractStatusOk) {
	    pSymbol = NULL;
	      sprintf(paramName,
		      "HPD.%d.%s",
		      tasi,
		      res.v.hkextractSymbolValue_u.Text);
	      status = hkextractSearchSymbol((HkextractSymbol **)&pSymbol,
					     pTable->symbols,
					     paramName);
	      if (status == HkextractStatusOk) {
		  *pItem = pSymbol;
		  return TED_OK;
	      }
	  }
      }
  }

  sprintf(paramName,
	  "WEC.%d.%s",
	  tasi,
	  pMNEM);
  status = hkextractSearchSymbol((HkextractSymbol **)&pSymbol,
				 pTable->symbols,
				 paramName);
  if (status == HkextractStatusOk) {
      *pItem = pSymbol;
      return TED_OK;
  }
  return TED_HKEXTRACT_LOOKUP_PARAM_NOT_FOUND;
}

/* }}} */
/* {{{ ted_hkextract_decode_parameter */

TED_STATUS
ted_hkextract_decode_parameter(
TED_HKEXTRACT_HPD_ITEM pVoid,
unsigned char *pUch,
unsigned long *pValue
)
{
  HkextractSymbol *pSymbol = (HkextractSymbol *) pVoid;

  if (pSymbol == NULL)
    return TED_HKEXTRACT_DECODE_PARAM_ARGS;

  if (pUch == NULL)
    return TED_HKEXTRACT_DECODE_PARAM_ARGS;

  {
    int status;
    long WIDTH;    HkextractSymbol *pWIDTH;
    long OFFBY;    HkextractSymbol *pOFFBY;
    long OFFBI;	   HkextractSymbol *pOFFBI;

    status = hkextractSearchSymbol(&pWIDTH,pSymbol,"WIDTH");
    if (status != HkextractStatusOk)
      return TED_HKEXTRACT_DECODE_PARAM_SYMBOL_WIDTH;

    status = hkextractSymbolIntVal(pWIDTH,&WIDTH);
    if (status != HkextractStatusOk)
      return TED_HKEXTRACT_DECODE_PARAM_VALUE_WIDTH;

    status = hkextractSearchSymbol(&pOFFBY,pSymbol,"OFFBY");
    if (status != HkextractStatusOk)
      return TED_HKEXTRACT_DECODE_PARAM_SYMBOL_OFFBY;

    status = hkextractSymbolIntVal(pOFFBY,&OFFBY);
    if (status != HkextractStatusOk)
      return TED_HKEXTRACT_DECODE_PARAM_VALUE_OFFBY;

    status = hkextractSearchSymbol(&pOFFBI,pSymbol,"OFFBI");
    if (status != HkextractStatusOk)
      return TED_HKEXTRACT_DECODE_PARAM_SYMBOL_OFFBI;

    status = hkextractSymbolIntVal(pOFFBI,&OFFBI);
    if (status != HkextractStatusOk)
      return TED_HKEXTRACT_DECODE_PARAM_VALUE_OFFBI;

    if (WIDTH < 1)
      return TED_HKEXTRACT_DECODE_PARAM_WIDTH_RANGE;

    if (OFFBY < 0)
      return TED_HKEXTRACT_DECODE_PARAM_OFFBY_RANGE;

    if ((OFFBI < 0) || (OFFBI > 7))
	return TED_HKEXTRACT_DECODE_PARAM_OFFBI_RANGE;

    {
      long mask = 2;
      int count;
      unsigned long value = 0;
      int offset = 0;
     
      /* the mask bits */
      count = WIDTH;
      while(--count)
	mask *= 2;
      mask--;
      
      /* mask offset */
      count = OFFBI;
      while(count--)
	mask *= 2;
      
      while (WIDTH > 0) {
	value = pUch[OFFBY + offset] + (value * offset * 0x100);
	WIDTH -= 8;
	offset++;
      }
      value &= mask;
      
      count = OFFBI;
      while (count--)
	value /= 2;
      
      *pValue = value;
    }
  }
  return TED_OK;
}

/* }}} */
/* {{{ ted_hkextract_calibrate_parameter */

TED_STATUS
ted_hkextract_calibrate_parameter(
void *pVoid,
unsigned long raw,
TED_HKEXTRACT_CALIBRATED_VALUE *pCalVal
)
{
  int status;
  char *name = NULL;
  char *calinf = NULL;
  char *categ = NULL;
  char *unit = NULL;
  char *descr = NULL;

  HkextractSymbol *pSymbol = (HkextractSymbol *) pVoid;

  if (pSymbol == NULL)      return TED_HKEXTRACT_CALIBRATE_ARGS;
  if (pCalVal == NULL)      return TED_HKEXTRACT_CALIBRATE_ARGS;

  name = (char *) hkextractSymbolName(pSymbol);

  status = hkextractUnpackSymbolText(pSymbol,"CALINF",&calinf);
  if (status != HkextractStatusOk) {
    return TED_HKEXTRACT_CALIBRATE_SYMBOL_CALINF;
  }

  status = hkextractUnpackSymbolText(pSymbol,"UNIT",&unit);
  if (status != HkextractStatusOk) {
    return TED_HKEXTRACT_CALIBRATE_SYMBOL_UNIT;
  }

  status = hkextractUnpackSymbolText(pSymbol,"CATEG",&categ);
  if (status != HkextractStatusOk) {
    return TED_HKEXTRACT_CALIBRATE_SYMBOL_CATEG;
  }

  status = hkextractUnpackSymbolText(pSymbol,"DESCR",&descr);
  if (status != HkextractStatusOk) {
    return TED_HKEXTRACT_CALIBRATE_SYMBOL_DESCR;
  }

  status = hkextractCalibrate(name,calinf,unit,categ,descr,raw,pCalVal);
  if (status != HkextractStatusOk) {
    return TED_HKEXTRACT_CALIBRATE_NO_MAPPING;
  }

  return TED_OK;
}

/* }}} */
/* {{{ ted_hkextract_extract */

TED_STATUS
ted_hkextract_extract(
unsigned char *pPacket,
char *mnem,
TED_HPD_TABLE *pTable,
TED_HKEXTRACT_CALIBRATED_VALUE *pValue
)
{
  int status;
  void *pSymbol = NULL;
  unsigned long rawValue;

  if (pPacket == NULL) return TED_HKEXTRACT_EXTRACT_ARGS;
  if (mnem == NULL)    return TED_HKEXTRACT_EXTRACT_ARGS;
  if (pTable == NULL)  return TED_HKEXTRACT_EXTRACT_ARGS;
  if (pValue == NULL)  return TED_HKEXTRACT_EXTRACT_ARGS;

  status = ted_hkextract_validate_hkd_header(pPacket);
  if (status != TED_OK)
    return TED_HKEXTRACT_EXTRACT_HKD_HEADER;
  
  status = hkextractValidatePacketAndTable(pPacket,pTable);
  if (status != HkextractStatusOk)
    return TED_HKEXTRACT_EXTRACT_TABLE_AND_PACKET;

  {
    int tasi = hkextractDdspGetTasi(pPacket);
    status = ted_hkextract_lookup_parameter((void **)&pSymbol,pTable,tasi,mnem);
    if (status != TED_OK)
      return TED_HKEXTRACT_EXTRACT_LOOKUP;
  }

  status = ted_hkextract_decode_parameter(pSymbol,
		  hkextractDdspGetData(pPacket),&rawValue);
  if (status != TED_OK)
    return TED_HKEXTRACT_EXTRACT_DECODE;

  status = ted_hkextract_calibrate_parameter(pSymbol,rawValue,pValue);
  if (status != TED_OK) {
    return TED_HKEXTRACT_EXTRACT_CALIBRATE;
  }

  return TED_OK;
}

/* }}} */
/* {{{ ted_hkextract_freetable */

void
ted_hkextract_freetable(
TED_HPD_TABLE **ppTable
)
{
  if (ppTable != NULL)
    if (*ppTable != NULL) {
      ted_hkextract_close_table(*ppTable);
      free(*ppTable);
      *ppTable = NULL;
    }
}

/* }}} */
/* {{{ ted_hkextract_parse_and_build */

TED_STATUS
ted_hkextract_parse_and_build(
TED_HPD_TABLE **ppTable,	
unsigned char *pHpd,
char *aliases
)
{
  int status;
  HkextractSymbol *pSymbol = NULL;

  if (ppTable == NULL)
      return TED_HKEXTRACT_PARSE_AND_BUILD_ARGS;

  if (pHpd == NULL)
      return TED_HKEXTRACT_PARSE_AND_BUILD_ARGS;

  if (aliases == NULL)
      return TED_HKEXTRACT_PARSE_AND_BUILD_ARGS;

  if (*ppTable != NULL)
      return TED_HKEXTRACT_PARSE_AND_BUILD_ARGS;


  *ppTable = (TED_HPD_TABLE *) malloc(sizeof(TED_HPD_TABLE));
  if (*ppTable == NULL)
      return TED_MEMORY;

  ted_hkextract_init_table(*ppTable);

  pSymbol = (HkextractSymbol *) hkextractNewSymbol("HKEXTRACT",
			HkextractSymbolTypeTable,
			NULL);
  if (pSymbol == NULL) {
    ted_hkextract_freetable(ppTable);
    return TED_MEMORY;
  }

  (*ppTable)->symbols = pSymbol;

  status = ted_hkextract_parse_hpd(*ppTable,pHpd);
  if (status != TED_OK) {
      ted_hkextract_freetable(ppTable);
      return TED_HKEXTRACT_PARSE_AND_BUILD_HPD;
  }

  if ((int) strlen(aliases) > 0) {
    status = ted_hkextract_parse_aliases(*ppTable,aliases);
    if (status != TED_OK) {
      ted_hkextract_freetable(ppTable);
      return TED_HKEXTRACT_PARSE_AND_BUILD_ALIASES;
    }
  }

  status = ted_hkextract_build_hpd_table(*ppTable,pHpd);
  if (status != TED_OK) {
      ted_hkextract_freetable(ppTable);
      return TED_HKEXTRACT_PARSE_AND_BUILD_TABLE;
  }

  return TED_OK;
}

/* }}} */
  
/* Local variables: */
/* mode: c */
/* folded-file: t */
/* end: */
