
/***
 * $Id: field.c,v 1.1 2001/09/26 14:06:50 simond Exp $
 */
#define  _field_c
#include <field.h>

/* {{{ FIELD_VALUE field_get(const char *,int,int) */

FIELD_VALUE
field_get(const unsigned char *p_char,
	      long p_start,
	      long p_len
	      )
{
  {
    if (p_start < 0)               return 0;
    if (p_len < 1)                 return 0;
    if (p_char == NULL)            return 0;
    if ((p_start + p_len - 1) < 0) return 0;
  }
    
  {
    long l_byte_start = p_start / 8;
    long l_bit_start  = p_start % 8;

    long l_byte_end = (p_start + p_len - 1) / 8;
    long l_bit_end =  (p_start + p_len - 1) % 8;
    long l_off = 0;
    unsigned long l_value = 0;
    long l_len = 0;
    long l_mask = 1;

    for(l_len = p_len;l_len > 0;l_len--) {
      l_mask *= 2;
    }
    l_mask--;
    
    for(l_len = 7 - l_bit_end;l_len > 0;l_len--) {
      l_mask *= 2;
    }
    
    l_value = 0;
    for(l_off = l_byte_start;l_off <= l_byte_end;l_off++) {
      l_value = (0x100 * l_value) + (p_char[l_off] & 0xff);
    }
    l_value = l_value & l_mask;

    for(;!(l_mask & 1);l_mask /= 2) l_value /= 2;

    return (l_value & l_mask);
 }

}

/* }}} */
/* {{{ void        field_set(const char *,int,int,FIELD_VALUE) */

int field_set(char *p_char,
	      int p_start,
	      int p_len,
	      FIELD_VALUE p_value
	      )
{
  {
    if (p_start < 0)               return -1;
    if (p_len < 1)                 return -1;
    if (p_char == NULL)            return -1;
    if ((p_start + p_len - 1) < 0) return -1;
  }
    
  {
    int l_byte_start = p_start / 8;
    int l_bit_start  = p_start % 8;

    int l_byte_end = (p_start + p_len - 1) / 8;
    int l_bit_end =  (p_start + p_len - 1) % 8;


    int l_value = p_value;
    int l_len;
    int l_off;
    int l_mask = 1;

    for(l_len = p_len;
	l_len > 0;
	l_len--
	) 
      l_mask *= 2;
    l_mask--;

    for(l_len = (7 - l_bit_end);
	l_len > 0;
	l_len--
	)
      l_mask *= 2;

    for(l_off = l_byte_end;
	l_off >= l_byte_start;
	l_off--
	)
      {
	p_char[l_off] = ((l_value & l_mask) % 0x100) | ((~l_mask & p_char[l_off]) % 0x100);
	l_value /= 0x100;
	l_mask  /= 0x100;
      }
  }
}

/* }}} */


/* Local variables: */
/* folded-file: t */
/* end: */
