 
/**
 * $Id: dsd.c,v 1.1 2001/09/26 14:06:50 simond Exp $
 */

#define _dsd_dsd_c
#include <tedsys.h>
#include <dsd.h>
#include <hkmacros.h>

/* CL-WEC-TED-148-SCR WBD optional header fields */
#define CL_WEC_TED_148

/* Maximum size of DSD header in words */
#define MAXDSDHEADER 32

/* Size of WEC HK block in bytes */
#define HKBLOCK_SIZE 192

static definition_set = TED_DSD_DEFINITION_SET_TED;

/* {{{ TED_STATUS ted_dsd_init(int the_definition_set) */

TED_STATUS ted_dsd_init(int the_definition_set)
{
  if (the_definition_set >= TED_DSD_DEFINITION_SET_TED && the_definition_set <= TED_DSD_DEFINITION_SET_DECOM)
    {
      definition_set = the_definition_set;
      return TED_OK;
    }
  else
    return TED_DSD_DEFINITIONSETINVALID;
}

/* }}} */
/* {{{ TED_STATUS ted_dsd_build(TED_DSD_ITEMS *,char *,char *,char **,int *,char **) */

TED_STATUS ted_dsd_build(TED_DSD_ITEMS *items, char *hkblock, char *sciencedata, char **dsdheaderp,int *headerlength, char **dsddata)
{
  static int initialised = FALSE;
  static WORD dsdheader[MAXDSDHEADER];
  static char zero_hkblock[HKBLOCK_SIZE];

  int swab_header;
  int swab_data;

  /* Zero our (otherwise garbage) block if we haven't already */
  if (!initialised)
    {
      memset(zero_hkblock, 0, HKBLOCK_SIZE);
      initialised = TRUE;
    }

  /* Use our zero HK block if NOHK=1 */
  if (items->dw & TED_DSD_DW_NOHK)
    {
      hkblock = zero_hkblock;
    }
  /* Zero the header so we don't have to bother doing bits later */
  memset(dsdheader, 0, MAXDSDHEADER * 2);
  
  if (definition_set == TED_DSD_DEFINITION_SET_TED)
    {
      /* {{{ fixed header */
      /* All headers in definition set "TED" are the same length */
      *headerlength = 32;
      
      /* All header/data pairs in definition set "TED" have same endianities */
      swab_header = FALSE;
      swab_data = FALSE;
      
      /* All headers in definition set "TED" have the same words 0-16 */
      dsdheader[ 0]  = items->version * 0x100 | items->revision;
      dsdheader[ 1]  = items->patch * 0x100 | items->userpatch;
      dsdheader[ 2]  = items->spacecraft;
      dsdheader[ 3]  = items->ground;
      dsdheader[ 4]  = items->source;
      dsdheader[ 5]  = items->dw;
      dsdheader[ 6]  = items->length;
      dsdheader[ 7]  = items->year;
      dsdheader[ 8]  = items->month;
      dsdheader[ 9]  = items->day;
      dsdheader[10]  = items->hour;
      dsdheader[11]  = items->min;
      dsdheader[12]  = items->sec;
      dsdheader[13]  = items->msec;
      dsdheader[14]  = items->usec;
      dsdheader[15]  = items->dwpcount | (items->obdhmod8 * 0x2000) /* << 13 */;
      dsdheader[16]  = items->udef0 | (items->udef1 * 0x2);
      /* }}} */
    }
  /* {{{ variant header */

  switch(items->source) {
  case TED_DSD_SOURCE_EFW:
    /* {{{  */

switch(definition_set) {
 case TED_DSD_DEFINITION_SET_TED:
   /* {{{  */

      dsdheader[17]  = hkblock_EW5MOTAG(hkblock);
      dsdheader[18]  = (WORD) hkblock[102] | (((WORD) hkblock[103]) * 0x100) & 0xFF00;
      dsdheader[19]  = (WORD) hkblock[104] | (((WORD) hkblock[105]) * 0x100) & 0xFF00;

/* }}} */
   break;
 case TED_DSD_DEFINITION_SET_DECOM:
   /* {{{  */

      *headerlength = 16;
      swab_header = TRUE;
      swab_data = TRUE;
      dsdheader[ 0]  = items->year;
      dsdheader[ 1]  = items->month;
      dsdheader[ 2]  = items->day;
      dsdheader[ 3]  = items->hour;
      dsdheader[ 4]  = items->min;
      dsdheader[ 5]  = items->sec;
      dsdheader[ 6]  = items->msec;
      dsdheader[ 7]  = items->udef0 | items->udef1 << 1;
      dsdheader[ 8]  = (WORD) hkblock[102] | (((WORD) hkblock[103]) * 0x100) & 0xFF00;
      dsdheader[ 9]  = (WORD) hkblock[104] | (((WORD) hkblock[105]) * 0x100) & 0xFF00;
      dsdheader[10]  = hkblock_EW5MOTAG(hkblock);
      dsdheader[11]  = items->length;
      dsdheader[12]  = items->usec;
      dsdheader[13]  = 0;
      dsdheader[14]  = 0;
      dsdheader[15]  = 0;

/* }}} */
   break;
}

/* }}} */
  break;
  case TED_DSD_SOURCE_STAFFSA:
    /* {{{  */

    switch(definition_set) {
    case TED_DSD_DEFINITION_SET_TED:
      /* {{{  */

      dsdheader[17]  = hkblock_EW5MOTAG(hkblock);
      dsdheader[18]  = hkblock_EW5ACQMD(hkblock);
      dsdheader[19]  = hkblock_EW1AMODE(hkblock) & 0x000F | ((hkblock_EW2CALMD(hkblock)) << 7) & 0x0080;
      dsdheader[20]  = hkblock_EW1VMON0(hkblock);
      dsdheader[21]  = hkblock_EW1VMON1(hkblock);
      dsdheader[22]  = hkblock_EW1VMON2(hkblock);
      dsdheader[23]  = hkblock_EW1TMON(hkblock);
      dsdheader[24]  = hkblock_EW2CALST(hkblock);

/* }}} */
      break;
    case TED_DSD_DEFINITION_SET_DECOM:
      /* {{{  */

      *headerlength = 23;
      swab_header = TRUE;
      swab_data = FALSE;
      dsdheader[ 0]  = 0x0082;
      dsdheader[ 1]  = hkblock_EW5MOTAG(hkblock);
      dsdheader[ 2]  = items->year;
      dsdheader[ 3]  = items->month;
      dsdheader[ 4]  = items->day;
      dsdheader[ 5]  = items->hour;
      dsdheader[ 6]  = items->min;
      dsdheader[ 7]  = items->sec;
      dsdheader[ 8]  = items->msec;
      dsdheader[ 9]  = items->length;
      dsdheader[10]  = items->dwpcount;
      dsdheader[11]  = hkblock_EW5ACQMD(hkblock);
      dsdheader[12]  = hkblock_EW1AMODE(hkblock);
      dsdheader[13]  = hkblock_EW1VMON0(hkblock);
      dsdheader[14]  = hkblock_EW1VMON1(hkblock);
      dsdheader[15]  = hkblock_EW1VMON2(hkblock);
      dsdheader[16]  = 0;
      dsdheader[17]  = items->usec;
      dsdheader[18]  = 0;
      dsdheader[19]  = hkblock_EW1TMON(hkblock);
      dsdheader[20]  = 0;
      dsdheader[21]  = hkblock_EW2CALST(hkblock);
      dsdheader[22]  = 0xFFFF;

/* }}} */
      break;
    }

/* }}} */
  break;
  case TED_DSD_SOURCE_STAFFMWF:
    /* {{{  */

    switch(definition_set) {
    case TED_DSD_DEFINITION_SET_TED:
      /* {{{  */

      dsdheader[17]  = hkblock_EW5MOTAG(hkblock);
      dsdheader[18]  = hkblock_EW5EMCST(hkblock);
      dsdheader[19]  = hkblock_EW2VMON0(hkblock);
      dsdheader[20]  = hkblock_EW2VMON1(hkblock);
      dsdheader[21]  = hkblock_EW2VMON2(hkblock);
      dsdheader[22]  = hkblock_EW2VMON3(hkblock);
      dsdheader[23]  = hkblock_EW5VMON(hkblock);
      dsdheader[24]  = hkblock_EW5RSCNT(hkblock);
      dsdheader[25]  = hkblock_EW2TMON0(hkblock);
      dsdheader[26]  = hkblock_EW2TMON1(hkblock);
      dsdheader[27]  = hkblock_EW2CALST(hkblock);
      dsdheader[28]  = hkblock_EW5SCFRQ(hkblock);

/* }}} */
      break;
    case TED_DSD_DEFINITION_SET_DECOM:
      /* {{{  */

      *headerlength = 23;
      swab_header = FALSE;
      swab_data = FALSE;
      dsdheader[ 0]  = 0x0081;
      dsdheader[ 1]  = hkblock_EW5MOTAG(hkblock);
      dsdheader[ 2]  = items->year;
      dsdheader[ 3]  = items->month;
      dsdheader[ 4]  = items->day;
      dsdheader[ 5]  = items->hour;
      dsdheader[ 6]  = items->min;
      dsdheader[ 7]  = items->sec;
      dsdheader[ 8]  = items->msec;
      dsdheader[ 9]  = items->length;
      dsdheader[10]  = items->dwpcount;
      dsdheader[11]  = hkblock_EW5SCFRQ(hkblock);
      dsdheader[12]  = (items->udef1 * 0x100) | (items->udef0 == 1 ? 0xF : 0x0);
      dsdheader[13]  = hkblock_EW2VMON0(hkblock);
      dsdheader[14]  = hkblock_EW2VMON1(hkblock);
      dsdheader[15]  = hkblock_EW2VMON2(hkblock);
      dsdheader[16]  = hkblock_EW2VMON3(hkblock);
      dsdheader[17]  = hkblock_EW5VMON(hkblock);
      dsdheader[18]  = items->obdhmod8;
      dsdheader[19]  = hkblock_EW2TMON0(hkblock);
      dsdheader[20]  = hkblock_EW2TMON1(hkblock);
      dsdheader[21]  = hkblock_EW2CALST(hkblock);
      dsdheader[22]  = items->usec;

/* }}} */
      break;
    }

/* }}} */
  break;
  case TED_DSD_SOURCE_WHISPER:
    /* {{{  */

    switch(definition_set) {
    case TED_DSD_DEFINITION_SET_TED:
      /* {{{  */

      dsdheader[17]  = hkblock_EW5MOTAG(hkblock);
      dsdheader[18]  = hkblock_EW5RSCNT(hkblock);

/* }}} */
      break;
    case TED_DSD_DEFINITION_SET_DECOM:
      /* {{{  */

      *headerlength = 18;
      swab_header = TRUE;
      swab_data = FALSE;
      dsdheader[ 0]  = items->year;
      dsdheader[ 1]  = items->month;
      dsdheader[ 2]  = items->day;
      dsdheader[ 3]  = items->hour;
      dsdheader[ 4]  = items->min;
      dsdheader[ 5]  = items->sec;
      dsdheader[ 6]  = items->msec;
      dsdheader[ 7]  = items->length;
      dsdheader[ 8]  = hkblock_EW5MOTAG(hkblock);
      dsdheader[ 9]  = items->obdhmod8;
      dsdheader[10]  = 0x5748;
      dsdheader[11]  = items->usec;
      dsdheader[12]  = 0;
      dsdheader[13]  = 0;
      dsdheader[14]  = 0;
      dsdheader[15]  = 0;
      dsdheader[16]  = items->udef0 << 9 | items->udef1 << 10;
      dsdheader[17]  = items->dwpcount;

/* }}} */
      break;
    }

/* }}} */
  break;
  case TED_DSD_SOURCE_WBD:
    /* {{{ */

switch(definition_set) {
 case TED_DSD_DEFINITION_SET_TED:
   /* {{{  */
#ifdef CL_WEC_TED_148
   dsdheader[17]  = hkblock_EW4PRCTL(hkblock);
   dsdheader[18]  = (hkblock_EW4VMON0(hkblock) * 0x100) | hkblock_EW4TMON(hkblock);
   dsdheader[19]  = (hkblock_EW4WBDHK(hkblock) * 0x100) | hkblock_EW4STSCN(hkblock);
   dsdheader[20]  = hkblock_EW4GAIN1(hkblock);
   dsdheader[21]  = hkblock_EW4GAIN2(hkblock);
   dsdheader[22]  = hkblock_EW4GAIN3(hkblock);
   dsdheader[23]  = hkblock_EW4GAIN4(hkblock);
   dsdheader[24]  = hkblock_EW4GAIN5(hkblock);
   dsdheader[25]  = hkblock_EW4GAIN6(hkblock);
   dsdheader[26]  = hkblock_EW4GAIN7(hkblock);
   dsdheader[27]  = hkblock_EW4GAIN8(hkblock);
   dsdheader[28]  = hkblock_EW4STAT1(hkblock);
   dsdheader[29]  = hkblock_EW4STAT0(hkblock);
   dsdheader[30]  = hkblock_EW4STAT2(hkblock);
   dsdheader[31]  = hkblock_EW5SSOFF(hkblock);
#endif
/* }}} */
   break;
 case TED_DSD_DEFINITION_SET_DECOM:
   /* {{{  */

      *headerlength = 17;
      swab_header = FALSE;
      swab_data = FALSE;
      dsdheader[ 0]  = hkblock_EW5MOTAG(hkblock);
      dsdheader[ 1]  = items->year;
      dsdheader[ 2]  = items->month;
      dsdheader[ 3]  = items->day;
      dsdheader[ 4]  = items->hour;
      dsdheader[ 5]  = items->min;
      dsdheader[ 6]  = items->sec;
      dsdheader[ 7]  = items->msec;
      dsdheader[ 8]  = items->length;
      dsdheader[ 9]  = 0;
      dsdheader[10]  = hkblock_EW3PCFBS(hkblock);
      dsdheader[11]  = hkblock_EW3SRPOF(hkblock);
      dsdheader[12]  = items->dwpcount;
      dsdheader[13]  = items->usec;
      dsdheader[14]  = 0;
      dsdheader[15]  = hkblock_EW5CORDS(hkblock);
      dsdheader[16]  = hkblock_EW5PRCTL(hkblock);

/* }}} */
   break;
}

/* }}} */
  break;
  case TED_DSD_SOURCE_DWP:
    /* {{{  */

    switch(definition_set) {
    case TED_DSD_DEFINITION_SET_TED:
      /* {{{  */

      dsdheader[17]  = hkblock_EW5MOTAG(hkblock);
      dsdheader[18]  = hkblock_EW3PCFBS(hkblock);
      dsdheader[19]  = hkblock_EW3SRPOF(hkblock);
      dsdheader[20]  = hkblock_EW5CORDS(hkblock);
      dsdheader[21]  = hkblock_EW5PRCTL(hkblock);

/* }}} */
      break;
    case TED_DSD_DEFINITION_SET_DECOM:
      /* {{{  */

      *headerlength = 17;
      swab_header = FALSE;
      swab_data = FALSE;
      dsdheader[ 0]  = hkblock_EW5MOTAG(hkblock);
      dsdheader[ 1]  = items->year;
      dsdheader[ 2]  = items->month;
      dsdheader[ 3]  = items->day;
      dsdheader[ 4]  = items->hour;
      dsdheader[ 5]  = items->min;
      dsdheader[ 6]  = items->sec;
      dsdheader[ 7]  = items->msec;
      dsdheader[ 8]  = items->length;
      dsdheader[ 9]  = 0;
      dsdheader[10]  = hkblock_EW3PCFBS(hkblock);
      dsdheader[11]  = hkblock_EW3SRPOF(hkblock);
      dsdheader[12]  = items->dwpcount;
      dsdheader[13]  = items->usec;
      dsdheader[14]  = 0;
      dsdheader[15]  = hkblock_EW5CORDS(hkblock);
      dsdheader[16]  = hkblock_EW5PRCTL(hkblock);

/* }}} */
      break;
    }

/* }}} */
  break;
  }

/* }}} */

  if (swab_header)
    swab((char *) dsdheader, (char *) dsdheader, *headerlength * 2);
  if (swab_data)
    swab((char *) sciencedata, (char *) sciencedata, items->length * 2);
  
  *dsdheaderp = (char *) &dsdheader;
  *dsddata = sciencedata;

  return TED_OK;
}

/* }}} */

/* Local variables: */
/* folded-file: t */
/* end: */
