
/****
 * $Id: ddsp.h,v 1.1 2001/09/26 14:06:48 simond Exp $
 */

 
#ifndef _ddsp_h
#define _ddsp_h

#include <generic.h>
#include <tedsys.h>
#include <field_info.h>
#include <field.h>
#include <dpb.h>

#define  DDSP_HEADER_SIZE 15
struct DDSP
{
unsigned char header[DDSP_HEADER_SIZE];
unsigned char * data;
int size;
int len;
int local;
int show_head;
int show_body;
int debug_head;
int debug_body;
};
typedef struct DDSP DDSP;

/* {{{ STATUS */
/* {{{ STATUS */

enum DDSP_STATUS {
DDSP_STATUS_OK,
DDSP_STATUS_READ,
DDSP_STATUS_WRITE,
DDSP_STATUS_MEMORY,
DDSP_STATUS_TYPE,
DDSP_STATUS_GROUND,
DDSP_STATUS_SOURCE,
DDSP_STATUS_QUALITY,
DDSP_STATUS_ADID,
DDSP_STATUS_INIT,
DDSP_STATUS_UNDEFINED = -1
};
typedef enum DDSP_STATUS DDSP_STATUS;

/* }}} */
#ifndef _ddsp_c
extern char *        ddsp_status_text (int);
extern int           ddsp_status_check(int);
#endif
/* }}} */
/* {{{ SCET */

#define SCET_SEC_PER_DAY (60 * 60 * 24)
#define SCET_MS_PER_DAY  (SCET_SEC_PER_DAY * 1000)

/* {{{ DAY */
typedef unsigned int DDSP_DAY;
#ifndef _ddsp_c
extern DDSP_DAY    ddsp_get_day(DDSP *);
extern void        ddsp_set_day(DDSP *,DDSP_DAY);
extern char *      ddsp_get_day_text(DDSP_DAY);
/* extern int   check_ddsp_day(DDSP_DAY); */
#endif
/* }}} */
/* {{{ MS */

typedef unsigned long DDSP_MS;
#ifndef _ddsp_c
  extern DDSP_MS     ddsp_get_ms(DDSP *);
  extern void        ddsp_set_ms(DDSP *,DDSP_MS);
  extern char *      ddsp_get_ms_text(DDSP_MS);
  extern int   check_ddsp_ms(DDSP_MS);
#endif
#define        put_ddsp_ms(p,v)  ddsp_set_ms(p,v)
#define            ddsp_ms(p)    ddsp_get_ms(p)

/* }}} */
/* {{{ US */

typedef unsigned int DDSP_US;
#ifndef _ddsp_c
  extern DDSP_US     ddsp_get_us(DDSP *);
  extern void        ddsp_set_us(DDSP *,DDSP_US);
  extern char *      ddsp_get_us_text(DDSP_US);
  extern int   check_ddsp_us(DDSP_US);
#endif
#define        put_ddsp_us(p,v)  ddsp_set_us(p,v)
#define            ddsp_us(p)    ddsp_get_us(p)

/* }}} */

struct SCET
{
  long day;	/* Number of days since 1 Jan 1958 */
  long ms;	/* Milliseconds of day */
  long us;	/* Microseconds of millisecond */
};
typedef struct SCET SCET;

#ifndef _ddsp_c
extern int         ddsp_compare  (DDSP * ,DDSP *);
extern int         ddsp_scet_read(SCET * ,DDSP*);
extern void        scet_set_day  (SCET * ,long);
extern long        scet_get_day  (SCET * );
extern void        scet_set_ms   (SCET * ,long);
extern long        scet_get_ms   (SCET * );
extern void        scet_set_us   (SCET * ,long);
extern long        scet_get_us   (SCET * );
extern long        scet_compare  (SCET * ,SCET *);
extern DDSP_STATUS scet_get_ddsp (SCET * ,DDSP *);
extern char *      ddsp_scet_text(SCET * );
extern void        scet_show     (SCET * ,FILE *);
extern DDSP_STATUS scet_cpy      (SCET * ,SCET *);
extern DDSP_STATUS scet_diff     (SCET * ,SCET *,SCET *);
extern DDSP_STATUS scet_add      (SCET * ,SCET *);
extern DDSP_STATUS scet_set_unix (SCET * ,time_t *   ,long *,long *);
extern DDSP_STATUS scet_get_unix (SCET * ,time_t     ,long  ,long  );
extern DDSP_STATUS scet_get_tm   (SCET * ,struct tm  ,long  ,long  );
extern DDSP_STATUS scet_set_tm   (SCET * ,struct tm *,long *,long *);
extern DDSP_STATUS scet_text     (SCET * ,char [50]);
extern DDSP_STATUS scet_init     (SCET **);
extern DDSP_STATUS scet_init_text(SCET **,const char *);
extern DDSP_STATUS scet_final    (SCET **);
extern DDSP_STATUS scet_clone    (SCET **,SCET *);
extern DDSP_STATUS scet_to_double(SCET *this,double *p_double);
#endif

/* }}} */

/* {{{ TRANSMISSION_MODE */

enum DDSP_TRANSMISSION_MODE
{
  DDSP_TRANSMISSION_REALTIME = 0,
  DDSP_TRANSMISSION_PLAYBACK = 1,
  DDSP_TRANSMISSION_RECALL = 2,
  DDSP_TRANSMISSION_RECALLPLAYBACK = 3
};
typedef enum DDSP_TRAMSMISSION_MODE DDSP_TRANSMISSION_MODE;

#ifndef _ddsp_c
extern char * ddsp_transmission_text(int);
extern  int   ddsp_transmission_check(int);
#endif

/* }}} */
/* {{{ VC */

enum DDSP_VIRTUAL_CHANNEL
{
  DDSP_VC0 = 0,
  DDSP_VC2 = 1,
  DDSP_VC3 = 2
};
typedef enum DDSP_VIRTUAL_CHANNEL DDSP_VIRTUAL_CHANNEL;
#ifndef _ddsp_c
extern char * ddsp_vc_text(int);
extern int    ddsp_vc_check(int);
#endif

/* }}} */
/* {{{ SOURCE */

/* {{{ DDSP_ADID */

enum DDSP_ADID
{
DDSP_ADID_ECLUD001 = 20,	 /* Cluster CD-ROM directory tree listing */
DDSP_ADID_ECLUD002 = 21,	 /* Cluster CD-ROM cumulative index file format */
DDSP_ADID_ECLUD003 = 22,	 /* Catalogue format for Cluster off-line delivery */
DDSP_ADID_ECLUD004 = 23,	 /* Catalogue format for Cluster on-line delivery */
DDSP_ADID_ECLUD005 = 24,	 /* Acknowledgement format for Cluster off-line delivery */
DDSP_ADID_ECLUD006 = 25,	 /* Volume production information format for Cluster off-line delivery */
DDSP_ADID_ECLUD007 = 0,	/* Mast catalogue of all Cluster data available */
DDSP_ADID_ECLUA001 = 1,	/* Long Term Orbit File */
DDSP_ADID_ECLUA002 = 2,	/* Long Term Event File */
DDSP_ADID_ECLUA003 = 3,	/* Short Term Orbit File */
DDSP_ADID_ECLUA004 = 4,	/* Short Term Event File */
DDSP_ADID_ECLUA005 = 5,	/* Spacecraft Altitude and Spin Rate Entry */
DDSP_ADID_ECLUA006 = 6,	/* Time Calibration File Entry */
DDSP_ADID_ECLUA007 = 7,	/* Command History File Entry */
DDSP_ADID_ECLUP101 = 200,	 /* Housekeeping Parameter Definition File for EDI on CLUSTER 1 */
DDSP_ADID_ECLUP102 = 201,	 /* Housekeeping Parameter Definition File for FGM on CLUSTER 1 */
DDSP_ADID_ECLUP103 = 202,	 /* Housekeeping Parameter Definition File for CIS on CLUSTER 1 */
DDSP_ADID_ECLUP104 = 203,	 /* Housekeeping Parameter Definition File for PEACE on CLUSTER 1 */
DDSP_ADID_ECLUP105 = 204,	 /* Housekeeping Parameter Definition File for RAPID on CLUSTER 1 */
DDSP_ADID_ECLUP106 = 205,	 /* Housekeeping Parameter Definition File for WEC on CLUSTER 1 */
DDSP_ADID_ECLUP107 = 206,	 /* Housekeeping Parameter Definition File for ASPOC on CLUSTER 1 */
DDSP_ADID_ECLUP108 = 207,	 /* Housekeeping Parameter Definition File for SC on CLUSTER 1 */
DDSP_ADID_ECLUP201 = 208,	 /* Housekeeping Parameter Definition File for EDI on CLUSTER 2 */
DDSP_ADID_ECLUP202 = 209,	 /* Housekeeping Parameter Definition File for FGM on CLUSTER 2 */
DDSP_ADID_ECLUP203 = 210,	 /* Housekeeping Parameter Definition File for CIS on CLUSTER 2 */
DDSP_ADID_ECLUP204 = 211,	 /* Housekeeping Parameter Definition File for PEACE on CLUSTER 2 */
DDSP_ADID_ECLUP205 = 212,	 /* Housekeeping Parameter Definition File for RAPID on CLUSTER 2 */
DDSP_ADID_ECLUP206 = 213,	 /* Housekeeping Parameter Definition File for WEC on CLUSTER 2 */
DDSP_ADID_ECLUP207 = 214,	 /* Housekeeping Parameter Definition File for ASPOC on CLUSTER 2 */
DDSP_ADID_ECLUP208 = 215,	 /* Housekeeping Parameter Definition File for SC on CLUSTER 2 */
DDSP_ADID_ECLUP301 = 216,	 /* Housekeeping Parameter Definition File for EDI on CLUSTER 3 */
DDSP_ADID_ECLUP302 = 217,	 /* Housekeeping Parameter Definition File for FGM on CLUSTER 3 */
DDSP_ADID_ECLUP303 = 218,	 /* Housekeeping Parameter Definition File for CIS on CLUSTER 3 */
DDSP_ADID_ECLUP304 = 219,	 /* Housekeeping Parameter Definition File for PEACE on CLUSTER 3 */
DDSP_ADID_ECLUP305 = 220,	 /* Housekeeping Parameter Definition File for RAPID on CLUSTER 3 */
DDSP_ADID_ECLUP306 = 221,	 /* Housekeeping Parameter Definition File for WEC on CLUSTER 3 */
DDSP_ADID_ECLUP307 = 222,	 /* Housekeeping Parameter Definition File for ASPOC on CLUSTER 3 */
DDSP_ADID_ECLUP308 = 223,	 /* Housekeeping Parameter Definition File for SC on CLUSTER 3 */
DDSP_ADID_ECLUP401 = 224,	 /* Housekeeping Parameter Definition File for EDI on CLUSTER 4 */
DDSP_ADID_ECLUP402 = 225,	 /* Housekeeping Parameter Definition File for FGM on CLUSTER 4 */
DDSP_ADID_ECLUP403 = 226,	 /* Housekeeping Parameter Definition File for CIS on CLUSTER 4 */
DDSP_ADID_ECLUP404 = 227,	 /* Housekeeping Parameter Definition File for PEACE on CLUSTER 4 */
DDSP_ADID_ECLUP405 = 228,	 /* Housekeeping Parameter Definition File for RAPID on CLUSTER 4 */
DDSP_ADID_ECLUP406 = 229,	 /* Housekeeping Parameter Definition File for WEC on CLUSTER 4 */
DDSP_ADID_ECLUP407 = 230,	 /* Housekeeping Parameter Definition File for ASPOC on CLUSTER 4 */
DDSP_ADID_ECLUP408 = 231,	 /* Housekeeping Parameter Definition File for SC on CLUSTER 4 */
DDSP_ADID_ECLUN101 = 30,	 /* Normal science data for EDI on Cluster 1 */
DDSP_ADID_ECLUN102 = 31,	 /* Normal science data for FGM on Cluster 1 */
DDSP_ADID_ECLUN103 = 32,	 /* Normal science data for CIS on Cluster 1 */
DDSP_ADID_ECLUN104 = 33,	 /* Normal science data for PEACE on Cluster 1 */
DDSP_ADID_ECLUN105 = 34,	 /* Normal science data for RAPID on Cluster 1 */
DDSP_ADID_ECLUN106 = 35,	 /* Normal science data for WEC on Cluster 1 */
DDSP_ADID_ECLUB101 = 37,	 /* Burst science data for EDI on Cluster 1 */
DDSP_ADID_ECLUB102 = 38,	 /* Burst science data for FGM on Cluster 1 */
DDSP_ADID_ECLUB103 = 39,	 /* Burst science data for CIS on Cluster 1 */
DDSP_ADID_ECLUB104 = 40,	 /* Burst science data for PEACE on Cluster 1 */
DDSP_ADID_ECLUB105 = 41,	 /* Burst science data for RAPID on Cluster 1 */
DDSP_ADID_ECLUB106 = 42,	 /* Burst science data for WEC on Cluster 1 */
DDSP_ADID_ECLUH101 = 44,	 /* Housekeeping data for EDI on Cluster 1 */
DDSP_ADID_ECLUH102 = 45,	 /* Housekeeping data for FGM on Cluster 1 */
DDSP_ADID_ECLUH103 = 46,	 /* Housekeeping data for CIS on Cluster 1 */
DDSP_ADID_ECLUH104 = 47,	 /* Housekeeping data for PEACE on Cluster 1 */
DDSP_ADID_ECLUH105 = 48,	 /* Housekeeping data for RAPID on Cluster 1 */
DDSP_ADID_ECLUH106 = 49,	 /* Housekeeping data for WEC on Cluster 1 */
DDSP_ADID_ECLUH107 = 50,	 /* Housekeeping data for ASPOC on Cluster 1 */
DDSP_ADID_ECLUH108 = 51,	 /* Housekeeping data for Cluster 1 Platform */
DDSP_ADID_ECLUN201 = 70,	 /* Normal science data for EDI on Cluster 2 */
DDSP_ADID_ECLUN202 = 71,	 /* Normal science data for FGM on Cluster 2 */
DDSP_ADID_ECLUN203 = 72,	 /* Normal science data for CIS on Cluster 2 */
DDSP_ADID_ECLUN204 = 73,	 /* Normal science data for PEACE on Cluster 2 */
DDSP_ADID_ECLUN205 = 74,	 /* Normal science data for RAPID on Cluster 2 */
DDSP_ADID_ECLUN206 = 75,	 /* Normal science data for WEC on Cluster 2 */
DDSP_ADID_ECLUB201 = 77,	 /* Burst science data for EDI on Cluster 2 */
DDSP_ADID_ECLUB202 = 78,	 /* Burst science data for FGM on Cluster 2 */
DDSP_ADID_ECLUB203 = 79,	 /* Burst science data for CIS on Cluster 2 */
DDSP_ADID_ECLUB204 = 80,	 /* Burst science data for PEACE on Cluster 2 */
DDSP_ADID_ECLUB205 = 81,	 /* Burst science data for RAPID on Cluster 2 */
DDSP_ADID_ECLUB206 = 82,	 /* Burst science data for WEC on Cluster 2 */
DDSP_ADID_ECLUH201 = 84,	 /* Housekeeping data for EDI on Cluster 2 */
DDSP_ADID_ECLUH202 = 85,	 /* Housekeeping data for FGM on Cluster 2 */
DDSP_ADID_ECLUH203 = 86,	 /* Housekeeping data for CIS on Cluster 2 */
DDSP_ADID_ECLUH204 = 87,	 /* Housekeeping data for PEACE on Cluster 2 */
DDSP_ADID_ECLUH205 = 88,	 /* Housekeeping data for RAPID on Cluster 2 */
DDSP_ADID_ECLUH206 = 89,	 /* Housekeeping data for WEC on Cluster 2 */
DDSP_ADID_ECLUH207 = 90,	 /* Housekeeping data for ASPOC on Cluster 2 */
DDSP_ADID_ECLUH208 = 91,	 /* Housekeeping data for Cluster 2 Platform */
DDSP_ADID_ECLUN301 = 110,	 /* Normal science data for EDI on Cluster 3 */
DDSP_ADID_ECLUN302 = 111,	 /* Normal science data for FGM on Cluster 3 */
DDSP_ADID_ECLUN303 = 112,	 /* Normal science data for CIS on Cluster 3 */
DDSP_ADID_ECLUN304 = 113,	 /* Normal science data for PEACE on Cluster 3 */
DDSP_ADID_ECLUN305 = 114,	 /* Normal science data for RAPID on Cluster 3 */
DDSP_ADID_ECLUN306 = 115,	 /* Normal science data for WEC on Cluster 3 */
DDSP_ADID_ECLUB301 = 117,	 /* Burst science data for EDI on Cluster 3 */
DDSP_ADID_ECLUB302 = 118,	 /* Burst science data for FGM on Cluster 3 */
DDSP_ADID_ECLUB303 = 119,	 /* Burst science data for CIS on Cluster 3 */
DDSP_ADID_ECLUB304 = 120,	 /* Burst science data for PEACE on Cluster 3 */
DDSP_ADID_ECLUB305 = 121,	 /* Burst science data for RAPID on Cluster 3 */
DDSP_ADID_ECLUB306 = 122,	 /* Burst science data for WEC on Cluster 3 */
DDSP_ADID_ECLUH301 = 124,	 /* Housekeeping data for EDI on Cluster 3 */
DDSP_ADID_ECLUH302 = 125,	 /* Housekeeping data for FGM on Cluster 3 */
DDSP_ADID_ECLUH303 = 126,	 /* Housekeeping data for CIS on Cluster 3 */
DDSP_ADID_ECLUH304 = 127,	 /* Housekeeping data for PEACE on Cluster 3 */
DDSP_ADID_ECLUH305 = 128,	 /* Housekeeping data for RAPID on Cluster 3 */
DDSP_ADID_ECLUH306 = 129,	 /* Housekeeping data for WEC on Cluster 3 */
DDSP_ADID_ECLUH307 = 130,	 /* Housekeeping data for ASPOC on Cluster 3 */
DDSP_ADID_ECLUH308 = 131,	 /* Housekeeping data for Cluster 3 Platform */
DDSP_ADID_ECLUN401 = 150,	 /* Normal science data for EDI on Cluster 4 */
DDSP_ADID_ECLUN402 = 151,	 /* Normal science data for FGM on Cluster 4 */
DDSP_ADID_ECLUN403 = 152,	 /* Normal science data for CIS on Cluster 4 */
DDSP_ADID_ECLUN404 = 153,	 /* Normal science data for PEACE on Cluster 4 */
DDSP_ADID_ECLUN405 = 154,	 /* Normal science data for RAPID on Cluster 4 */
DDSP_ADID_ECLUN406 = 155,	 /* Normal science data for WEC on Cluster 4 */
DDSP_ADID_ECLUB401 = 157,	 /* Burst science data for EDI on Cluster 4 */
DDSP_ADID_ECLUB402 = 158,	 /* Burst science data for FGM on Cluster 4 */
DDSP_ADID_ECLUB403 = 159,	 /* Burst science data for CIS on Cluster 4 */
DDSP_ADID_ECLUB404 = 160,	 /* Burst science data for PEACE on Cluster 4 */
DDSP_ADID_ECLUB405 = 161,	 /* Burst science data for RAPID on Cluster 4 */
DDSP_ADID_ECLUB406 = 162,	 /* Burst science data for WEC on Cluster 4 */
DDSP_ADID_ECLUH401 = 164,	 /* Housekeeping data for EDI on Cluster 4 */
DDSP_ADID_ECLUH402 = 165,	 /* Housekeeping data for FGM on Cluster 4 */
DDSP_ADID_ECLUH403 = 166,	 /* Housekeeping data for CIS on Cluster 4 */
DDSP_ADID_ECLUH404 = 167,	 /* Housekeeping data for PEACE on Cluster 4 */
DDSP_ADID_ECLUH405 = 168,	 /* Housekeeping data for RAPID on Cluster 4 */
DDSP_ADID_ECLUH406 = 169,	 /* Housekeeping data for WEC on Cluster 4 */
DDSP_ADID_ECLUH407 = 170,	 /* Housekeeping data for ASPOC on Cluster 4 */
DDSP_ADID_ECLUH408 = 171	 /* Housekeeping data for Cluster 4 Platform */
};
typedef enum DDSP_ADID DDSP_ADID;

/* }}} */

typedef unsigned int DDSP_SOURCE;
#ifndef _ddsp_c
extern unsigned int ddsp_get_source(DDSP *);
extern void         ddsp_set_source(DDSP *,DDSP_SOURCE);
extern char *       ddsp_source_text      (DDSP_SOURCE);
extern int          ddsp_source_check     (DDSP_SOURCE);
#endif

/* {{{ ddsp_source_enum */

enum ddsp_source_enum
{
ddsp_source_hkwecdes = 13,
ddsp_source_wecnsd1  = 35,
ddsp_source_wecbsd1  = 42,
ddsp_source_wechkd1  = 49,
ddsp_source_wecnsd2  = 75,
ddsp_source_wecbsd2  = 82,
ddsp_source_wechkd2  = 89,
ddsp_source_wecnsd3  = 115,
ddsp_source_wecbsd3  = 122,
ddsp_source_wechkd3  = 129,
ddsp_source_wecnsd4  = 155,
ddsp_source_wecbsd4  = 162,
ddsp_source_wechkd4  = 169
};


/* }}} */

/* }}} */
/* {{{ TYPE */

enum DDSP_TYPE {
  DDSP_TYPE_NSD,
  DDSP_TYPE_BSD,
  DDSP_TYPE_HKD,
  DDSP_TYPE_UNK 
};
typedef enum DDSP_TYPE DDSP_TYPE;

#ifndef _ddsp_c
extern char * ddsp_type_text(int);
extern int    ddsp_type_check(int);
extern DDSP_TYPE ddsp_get_type(DDSP *);
#endif

/* }}} */
/* {{{ LENGTH */

typedef unsigned long DDSP_LENGTH;
#ifndef _ddsp_c
extern char *          ddsp_length_text(DDSP_LENGTH);
extern int             ddsp_length_check(DDSP_LENGTH);
extern DDSP_LENGTH     ddsp_get_length(DDSP *);
extern void            ddsp_set_length(DDSP *,DDSP_LENGTH);
#endif
/*
#define            put_ddsp_length(p,v)  ddsp_set_length(p,v)
#define                ddsp_length(p)    ddsp_get_length(p)
#define           text_ddsp_length(val)  ddsp_length_text(val)
#define          check_ddsp_length(val)  ddsp_length_check(val)
*/
/* }}} */
/* {{{ SPACECRAFT */

/* {{{ DDSP_SCID */

enum DDSP_SCID
{
  DDSP_SCID_CLUSTER_1 = 1,/* Cluster Spacecraft One */
  DDSP_SCID_CLUSTER_2 = 2,/* Cluster Spacecraft Two */
  DDSP_SCID_CLUSTER_3 = 3,/* Cluster Spacecraft Three */
  DDSP_SCID_CLUSTER_4 = 4 /* Cluster Spacecraft Four */
};
typedef enum DDSP_SCID DDSP_SCID;

/* }}} */
/* {{{ ddsp_spacecraft_enum */

/*
 * enum ddsp_spacecraft_enum
 * {
 * ddsp_spacecraft_x        = 0 ,
 * ddsp_spacecraft_cluster1 = 1 ,
 * ddsp_spacecraft_cluster2 = 2 ,
 * ddsp_spacecraft_cluster3 = 3 ,
 * ddsp_spacecraft_cluster4 = 4 
 * };
 * typedef enum ddsp_spacecraft_enum ddsp_spacecraft_enum;
 */

/* }}} */

typedef unsigned int DDSP_SPACECRAFT;
#ifndef _ddsp_c
extern char *          ddsp_spacecraft_text(int);
extern int             ddsp_spacecraft_check(int);
extern unsigned int    ddsp_get_spacecraft(DDSP *);
extern void            ddsp_set_spacecraft(DDSP *,DDSP_SPACECRAFT);
#endif
/*
 * #define            put_ddsp_spacecraft(p,v)  ddsp_set_spacecraft(p,v)
 * #define                ddsp_spacecraft(p)    ddsp_get_spacecraft(p)
 * #define           text_ddsp_spacecraft(val) ddsp_spacecraft_text(val)
 * #define          check_ddsp_spacecraft(val) ddsp_spacecraft_check(val)
*/
/* }}} */
/* {{{ GROUND */

/*
 * enum ddsp_ground_enum
 * {
 * ddsp_ground_odenwald	= 1,
 * ddsp_ground_redu	= 2,
 * ddsp_ground_kourou	= 3,
 * ddsp_ground_perth	= 4,
 * ddsp_ground_malindi	= 5,
 * ddsp_ground_canberra	= 6,
 * ddsp_ground_goldstone	= 7,
 * ddsp_ground_na	= 15
 * };
 * typedef enum ddsp_ground_enum ddsp_ground_enum;
 */
typedef unsigned int DDSP_GROUND;
#ifndef _ddsp_c
extern char *          ddsp_ground_text(int);
extern int             ddsp_ground_check(int);
extern DDSP_GROUND     ddsp_get_ground(DDSP *);
extern void            ddsp_set_ground(DDSP *,DDSP_GROUND);
#endif
/*
 * #define            put_ddsp_ground(p,v)  ddsp_set_ground(p,v)
 * #define                ddsp_ground(p)    ddsp_get_ground(p)
 * #define           text_ddsp_ground(val)  ddsp_ground_text(val)
 * #define          check_ddsp_ground(val)  ddsp_ground_check(val)
 */
/* }}} */
/* {{{ STREAM */

enum DDSP_STREAM
{
DDSP_STREAM_RTVC0 = 0,
DDSP_STREAM_RTVC2 = 2,
DDSP_STREAM_RTVC3 = 3,
DDSP_STREAM_PBVC0 = 64,
DDSP_STREAM_PBVC2 = 66,
DDSP_STREAM_PBVC3 = 67,
DDSP_STREAM_REVC0 = 240,
DDSP_STREAM_REVC2 = 242,
DDSP_STREAM_REVC3 = 243,
DDSP_STREAM_RPVC0 = 79,
DDSP_STREAM_RPVC2 = 226,
DDSP_STREAM_RPVC3 = 227,
DDSP_STREAM_NA	  = 255
};
typedef enum DDSP_STREAM DDSP_STREAM;


/*
 * enum ddsp_stream_enum {
 * ddsp_stream_rtvc0	= 0,
 * ddsp_stream_rtvc2	= 2,
 * ddsp_stream_rtvc3	= 3,
 * ddsp_stream_pbvc0	= 64,
 * ddsp_stream_pbvc2	= 66,
 * ddsp_stream_pbvc3	= 67,
 * ddsp_stream_revc0	= 240,
 * ddsp_stream_revc2	= 242,
 * ddsp_stream_revc3	= 243,
 * ddsp_stream_rpvc0	= 79,
 * ddsp_stream_rpvc2	= 226,
 * ddsp_stream_rpvc3	= 227,
 * ddsp_stream_na	= 255
 * };
 * typedef enum ddsp_stream_enum ddsp_stream_enum
 */
/* typedef unsigned int DDSP_STREAM; */
#ifndef _ddsp_c
extern char *          ddsp_stream_text(DDSP_STREAM);
extern int             ddsp_stream_check(int);
extern DDSP_STREAM     ddsp_get_stream(DDSP *);
extern void            ddsp_set_stream(DDSP *,DDSP_STREAM);
extern int             ddsp_stream_mode_channel(int,int*,int*);
#endif
/*
 * #define            put_ddsp_stream(p,v)  ddsp_set_stream(p,v)
 * #define                ddsp_stream(p)    ddsp_get_stream(p)
 * #define           text_ddsp_stream(val) ddsp_stream_text(val)
 * #define          check_ddsp_stream(val) ddsp_stream_check(val)
 */
/* }}} */
/* {{{ QUALITY */

/*
 * enum ddsp_quality_enum
 * {
 * ddsp_quality_actual		= 0,
 * ddsp_quality_extrapolated	= 1,
 * ddsp_quality_contingency	= 2
 * };
 * typedef enum ddsp_quality_enum ddsp_quality_enum;
 */
typedef unsigned int DDSP_QUALITY;
#ifndef _ddsp_c
extern char *          ddsp_quality_text (DDSP_QUALITY);
extern int             ddsp_quality_check(int);
extern unsigned int    ddsp_get_quality  (DDSP *);
extern void            ddsp_set_quality  (DDSP *,DDSP_QUALITY);
#endif
/*
 * #define            put_ddsp_quality(p,v)  ddsp_set_quality(p,v)
 * #define                ddsp_quality(p)    ddsp_get_quality(p)
 * #define           text_ddsp_quality(val)  ddsp_quality_text(val)
 * #define          check_ddsp_quality(val)  ddsp_quality_check(val)
 */
/* }}} */
/* {{{ SEQUENCE */

enum DDSP_ASID
{
DDSP_ASID_NA =  0,
DDSP_ASID_1  =  1,
DDSP_ASID_2  =  2,
DDSP_ASID_3  =  3,
DDSP_ASID_4  =  4,
DDSP_ASID_5  =  5,
DDSP_ASID_6  =  6,
DDSP_ASID_7  =  7,
DDSP_ASID_8  =  8,
DDSP_ASID_9  =  9,
DDSP_ASID_10 = 10,
DDSP_ASID_11 = 11,
DDSP_ASID_12 = 12,
DDSP_ASID_13 = 13,
DDSP_ASID_14 = 14,
DDSP_ASID_15 = 15
};
typedef enum DDSP_ASID DDSP_ASID;

/*
 * enum ddsp_sequence
 * {
 * ddsp_sequence_hk1 = 1,
 * ddsp_sequence_nm1 = 1,
 * ddsp_sequence_nm2 = 2,
 * ddsp_sequence_nm3 = 3,
 * ddsp_sequence_bm1 = 1,
 * ddsp_sequence_bm2 = 2,
 * ddsp_sequence_bm3 = 3
 * };
 * typedef enum ddsp_sequence ddsp_sequence;
 */

typedef unsigned int DDSP_SEQUENCE;
#ifndef _ddsp_c
extern char *          ddsp_sequence_text(DDSP_SEQUENCE);
extern int             ddsp_sequence_check(DDSP_SEQUENCE);
extern unsigned int    ddsp_get_sequence(DDSP *);
extern void            ddsp_set_sequence(DDSP *,DDSP_SEQUENCE);
#endif
/*
 * #define            put_ddsp_sequence(p,v)  ddsp_set_sequence(p,v)
 * #define                ddsp_sequence(p)    ddsp_get_sequence(p)
 */
/* }}} */
/* {{{ SHOW */

#ifndef _ddsp_c
extern int             ddsp_get_show     (DDSP *,int *,int *);
extern int             ddsp_set_show     (DDSP *,int  ,int  );
#endif

/* }}} */
/* {{{ DEBUG */

#ifndef _ddsp_c
extern int             ddsp_get_debug    (DDSP *,int *,int *);
extern int             ddsp_set_debug    (DDSP *,int  ,int  );
#endif

/* }}} */
/* {{{ DATA */

/* DATA */
typedef unsigned char *DDSP_DATA;
#ifndef _ddsp_c
extern unsigned char * ddsp_get_data     (DDSP *);
extern void            ddsp_set_data     (DDSP *,unsigned char *,DDSP_LENGTH);
#endif

/* }}} */

#ifndef _ddsp_c
extern int             ddsp_init         (DDSP **,int);
extern int             ddsp_init_mem     (DDSP **,unsigned char *);
extern int             ddsp_final        (DDSP **);
extern unsigned char * ddsp_get_header   (DDSP *);
extern int             ddsp_read         (DDSP *,FILE *);
extern int             ddsp_write        (DDSP *,FILE*); 
extern int             ddsp_read_mem     (DDSP *,unsigned char *);
extern int             ddsp_write_mem    (DDSP *,unsigned char *);
extern void            ddsp_show         (DDSP *,FILE *);
extern DDSP_STATUS     ddsp_cpy          (DDSP *,DDSP *);
#endif
#endif

/* Local variables: */
/* folded-file: t */
/* end: */
